<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:ns1="http://org.apache.axis2/xsd"
                exclude-result-prefixes="ns1">
    <xsl:output method="html"/>    

    <xsl:template match="ns1:getAllLoggerDataResponse">
        <xsl:choose>
            <xsl:when test="return">
                <table cellspacing="1" class="styled">
                    <thead>
                        <tr>
                            <th>Logger</th>
                            <th>Parent Logger</th>
                            <th>Effective&#160;Level</th>
                            <th>Additivity</th>
                        </tr>
                    </thead>
                    <tbody>
                        <xsl:apply-templates select="return"/>
                    </tbody>
                </table>
            </xsl:when>
            <xsl:otherwise>
                <strong>Loggers are not available.</strong>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="return">
        <xsl:variable name="commonId" select="generate-id()"/>
        <tr>
            <xsl:if test="position() mod 2 = 1">
                <xsl:attribute name="bgcolor">#EEEFFB</xsl:attribute>
            </xsl:if>
            <td>
                <xsl:variable name="name" select="name"/>
                <xsl:variable name="nameLength"
                              select="string-length($name)"/>
                <xsl:choose>
                    <xsl:when test="$nameLength > 36">
                        <a title="{$name}">
                            <xsl:value-of
                                    select="concat(substring($name, 1, 36),'&#160;&#160;...')"/>
                        </a>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="name"/>
                    </xsl:otherwise>
                </xsl:choose>
                <!--<xsl:value-of select="name"/>-->
            </td>
            <td>
                <xsl:variable name="parentName" select="parentName"/>
                <xsl:variable name="parentNameLength"
                              select="string-length($parentName)"/>
                <xsl:choose>
                    <xsl:when test="$parentNameLength > 28">
                        <a title="{$parentName}">
                            <xsl:value-of
                                    select="concat(substring($parentName, 1, 28),'&#160;&#160;...')"/>
                        </a>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="$parentName"/>
                    </xsl:otherwise>
                </xsl:choose>
                <!--<xsl:value-of select="parentName"/>-->
            </td>
            <td>
                <xsl:variable name="effectiveLevel" select="level"/>
                <select>
                    <xsl:attribute name="id"><xsl:value-of select="$commonId"/>EffLevel</xsl:attribute>
                    <xsl:attribute name="onchange">
                        javascript:updateLogParams('<xsl:value-of select="name"/>', this[this.selectedIndex].value,document.getElementById('<xsl:value-of select="$commonId"/>Addi')[document.getElementById('<xsl:value-of select="$commonId"/>Addi').selectedIndex].value,document.getElementById('persistLogId').checked,1);return false;
                    </xsl:attribute>
                    <option>
                        <xsl:attribute name="value">TRACE</xsl:attribute>
                        <xsl:if test="$effectiveLevel='TRACE'">
                            <xsl:attribute name="selected">true
                            </xsl:attribute>
                        </xsl:if>
                        TRACE
                    </option>
                    <option>
                        <xsl:attribute name="value">DEBUG</xsl:attribute>
                        <xsl:if test="$effectiveLevel='DEBUG'">
                            <xsl:attribute name="selected">true
                            </xsl:attribute>
                        </xsl:if>
                        DEBUG
                    </option>
                    <option>
                        <xsl:attribute name="value">INFO</xsl:attribute>
                        <xsl:if test="$effectiveLevel='INFO'">
                            <xsl:attribute name="selected">true
                            </xsl:attribute>
                        </xsl:if>
                        INFO
                    </option>
                    <option>
                        <xsl:attribute name="value">WARN</xsl:attribute>
                        <xsl:if test="$effectiveLevel='WARN'">
                            <xsl:attribute name="selected">true
                            </xsl:attribute>
                        </xsl:if>
                        WARN
                    </option>
                    <option>
                        <xsl:attribute name="value">ERROR</xsl:attribute>
                        <xsl:if test="$effectiveLevel='ERROR'">
                            <xsl:attribute name="selected">true
                            </xsl:attribute>
                        </xsl:if>
                        ERROR
                    </option>
                    <option>
                        <xsl:attribute name="value">FATAL</xsl:attribute>
                        <xsl:if test="$effectiveLevel='FATAL'">
                            <xsl:attribute name="selected">true
                            </xsl:attribute>
                        </xsl:if>
                        FATAL
                    </option>
                    <option>
                        <xsl:attribute name="value">OFF</xsl:attribute>
                        <xsl:if test="$effectiveLevel='OFF'">
                            <xsl:attribute name="selected">true
                            </xsl:attribute>
                        </xsl:if>
                        OFF
                    </option>
                    <!--&#160;&#160;&#160;&#160;&#160;-->
                </select>
            </td>
            <td>
                <xsl:variable name="additivity" select="additivity"/>
                <select>
                    <xsl:attribute name="id"><xsl:value-of select="$commonId"/>Addi</xsl:attribute>
                    <xsl:attribute name="onchange">
                        javascript:updateLogParams('<xsl:value-of select="name"/>', document.getElementById('<xsl:value-of select="$commonId"/>EffLevel')[document.getElementById('<xsl:value-of select="$commonId"/>EffLevel').selectedIndex].value ,this[this.selectedIndex].value,document.getElementById('persistLogId').checked,2);return false;
                    </xsl:attribute>
                    <option>
                        <xsl:attribute name="value">true</xsl:attribute>
                        <xsl:if test="$additivity='true'">
                            <xsl:attribute name="selected">true
                            </xsl:attribute>
                        </xsl:if>
                        True
                    </option>
                    <option>
                        <xsl:attribute name="value">false</xsl:attribute>
                        <xsl:if test="$additivity='false'">
                            <xsl:attribute name="selected">false
                            </xsl:attribute>
                        </xsl:if>
                        False
                    </option>
                </select>
            </td>
        </tr>
    </xsl:template>
</xsl:stylesheet>