<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="html"/>

    <xsl:template match="ns1:listTransportsResponse" xmlns:ns1="http://org.apache.axis2/xsd">
        <fieldset style="border:none;">
        <div>
            <xsl:attribute name="id">breadcumbsgetExposedTransportsHeader</xsl:attribute>
        </div>
        <h2 id="listTransport">Transport Management</h2>
        <div id='formset'>
                <form>
                    <fieldset>
                        <legend>Available Transports</legend>
                        <xsl:choose>
                                <xsl:when test="return">
                                    <h4>Protocols</h4>
                                    <xsl:for-each select="return">
                                        <div style="overflow: visible;">
                                            <xsl:attribute name="id"><xsl:value-of select="protocol"/>_main_div</xsl:attribute>
                                            <span class="treeSpan">
                                                <xsl:attribute name="id"><xsl:value-of select="protocol"/>_span</xsl:attribute>
                                                <xsl:attribute name="onclick">avascript:showTreeBranch(document.getElementById('<xsl:value-of select="protocol"/>_main_div'),document.getElementById('<xsl:value-of select="protocol"/>_img'),'<xsl:value-of select="protocol"/>');return false;</xsl:attribute>
                                                <img src="extensions/core/images/tree_closed.gif">
                                                 <xsl:attribute name="id"><xsl:value-of select="protocol"/>_img</xsl:attribute>
                                                </img>
                                                <a href="#"><xsl:value-of select="protocol"/></a>
                                                <br/>
                                            </span>
                                        </div>
                                    </xsl:for-each>
                               </xsl:when>
                            <xsl:otherwise>
                                <p>Error occurred while listing available transports</p>
                            </xsl:otherwise>
                        </xsl:choose>
                    </fieldset>
                </form>
            </div>
		</fieldset>
    </xsl:template>

    <!-- following template will be uesed in Services/Exposed Transport -->

    <xsl:template match="ns1:getExposedTransportsResponse" xmlns:ns1="http://org.apache.axis2/xsd">
        <fieldset style="border:none;">
        <div>
            <xsl:attribute name="id">breadcumbsgetExposedTransportsHeader</xsl:attribute>
        </div>
        <h2 id="listTransport">Transport Management</h2>
            <div id='formset'>
             
                <form>
                    <fieldset>
                        <legend>Add Transports</legend>
                        <div>
                            <label>Protocol</label><select id="transportSelectionCombo"/>
                        </div>
                        <div class="buttonrow">
                            <input type='button'>
                                <xsl:attribute name="value">Add&#160;</xsl:attribute>
                                <xsl:attribute name="onclick">javascript:addNewTransportForService(document.getElementById('transportSelectionCombo'));return false;</xsl:attribute>
                            </input>
                        </div>
                    </fieldset>
                </form>
            </div>

            <div id='formset'>
			   <form>
                    <fieldset>
                        <legend>Exposed Transports</legend>
                        <xsl:choose>
                                <xsl:when test="return">
                                    <table class="styled">
                                        <thead>
                                        <tr>
                                            <th>Protocol</th>
                                            <th>Action</th>
                                        </tr>
                                        </thead>
                                        <tbody>

                                        <xsl:for-each select="return">
                                            <tr>
                                                <td>
                                                    <xsl:value-of select="."/>
                                                </td>
                                                <td>
                                                    <nobr>
                                                    &#160;&#160;
                                                    <a href="#" id="cancel_link">
                                                        <xsl:attribute name="onclick">javascript:removeTransportBinding('<xsl:value-of select="."/>');return false;</xsl:attribute>
                                                        <xsl:attribute name="title">Remove <xsl:value-of select="."/> </xsl:attribute>
                                                        <xsl:attribute name="alt">Remove</xsl:attribute>
                                                        &#160;&#160;&#160;&#160;
                                                    </a>
                                                    </nobr>
                                                </td>
                                            </tr>
                                         </xsl:for-each>

                                    </tbody>
                                    </table>
                               </xsl:when>
                            <xsl:otherwise>
                                <p>Error occurred while listing available transports</p>
                            </xsl:otherwise>
                        </xsl:choose>
                    </fieldset>
                </form>
            </div>
        </fieldset>
    </xsl:template>
 </xsl:stylesheet>

