<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="html"/>
    <xsl:template match="*">
        <!--  Link header to be populated by java script -->
        <div id="listServiceParamEditHeader"></div>
        <!-- custom header for message display -->
        <div id="serviceConfigUpdate"></div>
        <xsl:choose>
            <xsl:when test="return">
				<br/>
				<div id="formset">
					<form>
						<fieldset>
							<legend>Edit EJB Service</legend>
								<div style="display:none">
									<script language="javascript">								
										var arrayOfParamNames=new Array();
										var arrayOfParamValues=new Array();										
										<xsl:for-each select="return">
											arrayOfParamNames[<xsl:value-of select="position()-1"/>] = '<xsl:value-of select="parameter/@name"/>';
											arrayOfParamValues[<xsl:value-of select="position()-1"/>] = '<xsl:value-of select="normalize-space(parameter)"/>';
										</xsl:for-each>
											arrangeEJBServiceParams(arrayOfParamNames, arrayOfParamValues);
										</script>
								</div>
								<div id="param_div">
								</div>
							<div class="buttonrowejb">
								<!-- update button -->
								<input type="button" value="update">
									<xsl:attribute name="onClick">javascript:
										var arrayOfNames=new Array();
										var arrayOfValues=new Array();
										<xsl:for-each select="return">
											arrayOfNames[<xsl:value-of select="position()-1"/>] = '<xsl:value-of select="parameter/@name"/>';
											arrayOfValues[<xsl:value-of select="position()-1"/>] = (document.getElementById('<xsl:value-of select="parameter/@name"/>').value);
										</xsl:for-each>
										processServiceOperationParameterConfigUpdateEJB(arrayOfNames,arrayOfValues);
										return false;
									</xsl:attribute>
								</input>
								<!-- add button 
								<input type="button" value="add">
									<xsl:attribute name="onClick">javascript:addServiceSpecificParameters();return false;</xsl:attribute>
								</input>
								-->
							</div>
						</fieldset>
					</form>
				</div>
            </xsl:when>
            <xsl:otherwise>
				<table>
					 <tr>
						 <td>No parameters found.</td>
					 </tr>
					<tr>
						<td>
							<!-- add button -->
							<input type="button" value="add">
								<xsl:attribute name="onClick">javascript:addServiceSpecificParameters();return false;</xsl:attribute>
							</input>
						</td>
					</tr>
				</table>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
</xsl:stylesheet>


