<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="html"/>

    <xsl:template match="*">

        <!-- Operation statistics -->
        <div>
            <xsl:attribute name="id">listOperationStatistics</xsl:attribute>
        </div>

        <xsl:choose>
            <xsl:when test="return">
                <table class="styled">
                    <thead>
                         <tr>
                             <th>Parameter Name</th>
                             <th>Parameter Value</th>
                         </tr>
                    </thead>
                    <tbody>
                    <xsl:for-each select="return">
                        <tr><td><strong><xsl:value-of select="parameter/@name"/></strong></td>
                            <td><xsl:value-of select="parameter"/></td>
                        </tr>
                     </xsl:for-each>
                    </tbody>
                 </table>
            </xsl:when>
            <xsl:otherwise>
                <p>No Operation specific parameters present.</p>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
</xsl:stylesheet>


