<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

    <xsl:template match="*">
        <h4><a href="#" onClick="javascript:showServiceInitializer(); return false;">Services</a>&#160;&gt;&#160;<xsl:value-of select="return/name"/></h4>
        <h2>Service Management</h2>

        <xsl:variable name="active"><xsl:value-of select="return/active"/></xsl:variable>
        <xsl:variable name="serviceName"><xsl:value-of select="return/name"/></xsl:variable>
        <xsl:variable name="webResourcesFound"><xsl:value-of select="return/foundWebResources"/></xsl:variable>
        <xsl:variable name="serviceType"><xsl:value-of select="return/serviceType"/></xsl:variable>
        <xsl:variable name="enableMTOM" select="return/enableMTOM" />
        <fieldset style="border:none;">
    	<div id="formset">
            <xsl:for-each select="return">
            <table class="styledLeft">
                <thead><tr><th colspan="2">General</th></tr></thead>
				<tr>
					<td><strong>Service Name</strong></td>
                	<td><xsl:value-of select="name"/></td>
            	</tr>
				<tr>
					<td><strong>Service Description</strong></td>
                	<td><xsl:value-of select="description"/></td>
            	</tr>
                <tr>
					<td><strong>Service Group Name</strong></td>
                	<td><xsl:value-of select="serviceGroupName"/></td>
            	</tr>
                <tr>
					<td><strong>Deployment Scope</strong></td>
                	<td><xsl:value-of select="scope"/></td>
            	</tr>
                <tr>
                    <td><strong>Service Type</strong></td>
                    <td><xsl:value-of select = "serviceType"/></td>
                </tr>
                <tr>
					<td><strong>Service Status</strong></td>
                	<td>
						<xsl:comment><xsl:value-of select="$active"/></xsl:comment>
						<xsl:if test="$active='true'">
							Active&#160;&#160;[<a style="cursor:pointer;" onclick="javascript:activationOfService(false);">Deactivate</a>]
						</xsl:if>
						<xsl:if test="$active='false'">
							Inactive&#160;&#160;[<a style="cursor:pointer;" onclick="javascript:activationOfService(true);">Activate</a>]
						</xsl:if>
					</td>
            	</tr>
                <tr>
                    <td>
                        <strong>MTOM</strong>
                    </td>
                    <td>
                        <select>
                            <xsl:attribute name="id">serviceLevelMOTOMHandlingId</xsl:attribute>
                            <xsl:attribute name="onchange">javascript:configServiceMTOM(this[this.selectedIndex].value,'<xsl:value-of select="$serviceName"/>');return false;</xsl:attribute>
                            <option>
                                <xsl:attribute name="value">true</xsl:attribute>
                                <xsl:if test="$enableMTOM='true'">
                                    <xsl:attribute name="selected">true</xsl:attribute>
                                </xsl:if>
                                True
                            </option>
                            <option>
                                <xsl:attribute name="value">false</xsl:attribute>
                                <xsl:if test="$enableMTOM='false'">
                                    <xsl:attribute name="selected">true</xsl:attribute>
                                </xsl:if>
                                False
                            </option>
                            <option>
                                <xsl:attribute name="value">optional</xsl:attribute>
                                <xsl:if test="$enableMTOM='optional'">
                                    <xsl:attribute name="selected">true</xsl:attribute>
                                </xsl:if>
                                Optional
                            </option>
                        </select>
                    </td>
                </tr>
                
                <thead><tr><th colspan="2">Statistics</th></tr></thead>
				<tr>
					<td><strong>Request Count</strong></td>
                	<td><xsl:value-of select="serviceRequestCount"></xsl:value-of></td>
            	</tr>
                <tr>
                    <td><strong>Response Count</strong></td>
                    <td><xsl:value-of select="serviceResponseCount"></xsl:value-of></td>
                </tr>

                 <tr>
                    <td><strong>Fault Count</strong></td>
                    <td><xsl:value-of select="serviceFaultCount"></xsl:value-of></td>
                </tr>
                <tr>
                    <td><strong>Maximum Response Time</strong></td>
                    <td><xsl:value-of select = "format-number(maxResponseTime,'0.00')" />  ms</td>
                </tr>
                <tr>
                    <td><strong>Minimum Response Time</strong></td>
                    <td>
                        <xsl:choose>
                            <xsl:when test="minResponseTime=0">
                                &lt; 1.00 ms
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:value-of select="format-number(minResponseTime,'0.00')"/> ms
                            </xsl:otherwise>
                        </xsl:choose>
                    </td>
				</tr>
                <tr>
                    <td><strong>Average Response Time</strong></td>
                    <td><xsl:value-of select = "format-number(avgResponseTime,'#.##')" />  ms</td>
                </tr>
                <thead><tr><th colspan="2">End Points</th></tr></thead>
                <tr>
                    <td>
                        <xsl:attribute name="rowspan"><xsl:value-of select = "count(eprs) + 1" /></xsl:attribute>
	                     <strong>Endpoint References </strong>
	               </td>
                    <td/>
                </tr>
                    <xsl:for-each select="eprs">
                      <tr>
                          <td>
                                <xsl:value-of select="."/>
                          </td>
                      </tr>
                    </xsl:for-each>
            </table>
            </xsl:for-each>
            <br/><br/>
			<xsl:choose>
				<xsl:when test="$active='true'">
					<table>

                        <xsl:if test="$serviceName='wso2wsas-sts'">
                            <tr>
                                <td>
                                    <a id="shield_link">
                                    <xsl:attribute name="href">#</xsl:attribute>
                                    <xsl:attribute name="onClick">javascript:getTrustedServices(); return false;</xsl:attribute>
                                    <xsl:text>&#160;&#160;&#160;&#160;&#160;STS Configuration</xsl:text>
                                    </a>
                                </td>
                            </tr>
                        </xsl:if>

                        <tr>
							<td>
								<a id="operations_link">
									<xsl:attribute name="href">#</xsl:attribute>
									<xsl:attribute name="onClick">javascript:listAllOperations('<xsl:value-of select="return/name"/>'); return false;</xsl:attribute>
									<xsl:text>&#160;&#160;&#160;&#160;&#160;Manage Service Operations</xsl:text>
								</a>
							</td>
						</tr>
						<tr>
							<td>
		
                                <a id="module_view_link">
                                    <xsl:attribute name="href">#</xsl:attribute>
                                    <xsl:attribute name="onClick">javascript:engageModulePerService('<xsl:value-of select="return/name"/>'); return false;</xsl:attribute>
                                    <xsl:text>&#160;&#160;&#160;&#160;&#160;Manage Module Engagements</xsl:text>
                                </a>
							</td>
						</tr>
                        
                        <tr>
							<td>
                                <a id="transport_link">
                                    <xsl:attribute name="href">#</xsl:attribute>
                                    <xsl:attribute name="onClick">javascript:getExposedTransports('<xsl:value-of select="return/name"/>'); return false;</xsl:attribute>
                                    <xsl:text>&#160;&#160;&#160;&#160;&#160;Manage Transports</xsl:text>
                                </a>
							</td>
						</tr>

                        <tr>
							<td>
                                <a id="shield_link">
                                    <xsl:attribute name="href">#</xsl:attribute>
                                    <xsl:attribute name="onClick">javascript:showSecurityConfigurationInfo(); return false;</xsl:attribute>
                                    <xsl:text>&#160;&#160;&#160;&#160;&#160;Manage Security Configuration</xsl:text>
                                </a>
							</td>
						</tr>
                        <tr>
							<td>
                            	<xsl:choose>
	                                <xsl:when test="$serviceType = 'ejb_service'">
		                                <a id="edit_link">
        		                            <xsl:attribute name="href">#</xsl:attribute>
                		                    <xsl:attribute name="onClick">javascript:getServiceSpecficParametersForConfig('<xsl:value-of select="return/name"/>','<xsl:value-of select="$serviceType"/>'); return false;</xsl:attribute>
                        		            <xsl:text>&#160;&#160;&#160;&#160;&#160;Edit EJB Service</xsl:text>
                                		</a>
    	                            </xsl:when>
        	                        <xsl:otherwise>
		                                <a id="edit_link">
        		                            <xsl:attribute name="href">#</xsl:attribute>
                		                    <xsl:attribute name="onClick">javascript:getServiceSpecficParametersForConfig('<xsl:value-of select="return/name"/>','<xsl:value-of select="$serviceType"/>'); return false;</xsl:attribute>
                        		            <xsl:text>&#160;&#160;&#160;&#160;&#160;Edit Service Parameters</xsl:text>
                                		</a>
                	                </xsl:otherwise>
                    	        </xsl:choose>
							</td>
						</tr>
                        <tr>
							<td>
                                <a id="edit_link">
                                    <xsl:attribute name="href">#</xsl:attribute>
                                    <xsl:attribute name="onClick">javascript:getServiceSpecificPoliciesForConfig('<xsl:value-of select="return/name"/>', ''); return false;</xsl:attribute>
                                    <xsl:text>&#160;&#160;&#160;&#160;&#160;Edit Service Policies</xsl:text>
                                </a>
							</td>
						</tr>
			
						<tr>
							<td>
                                  <a id="create_link">
                                        <xsl:attribute name="href">#</xsl:attribute>
                                        <xsl:attribute name="onClick">javascript:stubGenerationMetaInfo(); return false;</xsl:attribute>
                                        <xsl:text>&#160;&#160;&#160;&#160;&#160;Generate Client</xsl:text>
                                  </a>
							</td>
						</tr>
                        <tr>
							<td>
                                  <a id="try_it_link">
                                        <xsl:attribute name="href">#</xsl:attribute>
                                        <xsl:attribute name="onClick">javascript:dynamicClientGeneration(); return false;</xsl:attribute>
                                        <xsl:text>&#160;&#160;&#160;&#160;&#160;Try It</xsl:text>
                                 </a>
							</td>
						</tr>
                        <xsl:if test="$webResourcesFound='true'">
                            <tr>
                                <td>
                                     <a id="plugin__ui_link">
                                            <xsl:attribute name="href">#</xsl:attribute>
                                            <xsl:attribute name="onClick">javascript:openExtraWindowHTTPForWebResources('wservices','<xsl:value-of select="$serviceName"/>');return false;</xsl:attribute>
                                            <xsl:text>&#160;&#160;&#160;&#160;&#160;Application GUI</xsl:text>
                                      </a>
                                </td>
                            </tr>
                        </xsl:if>
                        <xsl:if test="$serviceType='data_service'">
                            <tr>
                                <td>
                                     <a id="dataservice__ui_link">
                                            <xsl:attribute name="href">#</xsl:attribute>
                                            <xsl:attribute name="onClick">javascript:configureDataservice('<xsl:value-of select="$serviceName"/>');return false;</xsl:attribute>
                                            <xsl:text>&#160;&#160;&#160;&#160;&#160;Configure DataService</xsl:text>
                                      </a>
                                </td>
                            </tr>
                        </xsl:if>                        
                    </table>
				</xsl:when>
				<xsl:otherwise>	
					<table>
						<tr><td>
								<b>This service is inactive</b>
						</td></tr>
					</table>
				</xsl:otherwise>
			</xsl:choose>
		</div>
        </fieldset>
    </xsl:template>
</xsl:stylesheet>
