<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

    <xsl:output method="html"/>

    <xsl:template match="ns1:getScenariosResponse" xmlns:ns1="http://org.apache.axis2/xsd">

        <fieldset style="border:none;">
            <div id="headerListSecurity"></div>
            <xsl:choose>
                <xsl:when test="return">
                    <div id="formset">
                        <form>
                            <fieldset>
                                <legend>Configuration Scenario</legend>
                                    <table class="styled">
                                        <thead>
                                            <tr>
                                                <th colspan="2">Option</th>
                                                <th>Summary</th>
                                                <th>Description</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <xsl:for-each select="return">
                                                <xsl:variable name="currentScenario"><xsl:value-of select="isCurrentScenario" /></xsl:variable>
                                                <xsl:variable name="normalize-space-summary"><xsl:value-of select="normalize-space(summary)"/></xsl:variable>
                                                <tr>
                                                    <td><xsl:value-of select="position()"/>.&#160;&#160;&#160;</td>
                                                    <td>
                                                        <input>
                                                            <xsl:attribute name="type">radio</xsl:attribute>
                                                            <xsl:attribute name="name">configurationScenarioGroup</xsl:attribute>
                                                            <xsl:attribute name="value"><xsl:value-of select="scenarioId" /></xsl:attribute>
													        <xsl:attribute name="tabindex">
													             <xsl:value-of select="position()"/>
													        </xsl:attribute>
                                                            <xsl:if test="$currentScenario='true'">
                                                                <xsl:attribute name="checked">true</xsl:attribute>
                                                            </xsl:if>
                                                            <!-- Executor method name -->
                                                            <xsl:attribute name="onclick">javascript:setCheckboxExecutor('<xsl:value-of select="category" />','<xsl:value-of select="scenarioId" />','<xsl:value-of select="$normalize-space-summary" />');return true;</xsl:attribute>
                                                        </input>
                                                        &#160;
                                                    </td>
                                                    <td>
                                                        <xsl:value-of select="summary" />
                                                    </td>
                                                    <td>
                                                        <xsl:value-of select="description" />
                                                    </td>
                                                </tr>

                                            </xsl:for-each>
                                        </tbody>
                                    </table>
                                <div>
                                    <xsl:call-template name="wizardButtonRaw"/>
                                </div>
                            </fieldset>
                        </form>
                    </div>

                </xsl:when>

                <xsl:otherwise>
                    <div id="formset">
                        <form>
                            <fieldset>
                                <legend>Configuration Scenario</legend>
                                <div>Problem encountered while displaying rampart senarios</div>
                            </fieldset>
                        </form>
                    </div>
                </xsl:otherwise>
            </xsl:choose>

        </fieldset>

    </xsl:template>

    <xsl:template name="wizardButtonRaw">

        <xsl:for-each select="//return">
            <xsl:variable name="currentScenario"><xsl:value-of select="isCurrentScenario" /></xsl:variable>
            <xsl:variable name="normalize-space-summary"><xsl:value-of select="normalize-space(summary)"/></xsl:variable>
            <xsl:if test="$currentScenario='true'">
                <div>
                    <input>
                        <xsl:attribute name="type">button</xsl:attribute>
                        <xsl:attribute name="value">Continue &gt;</xsl:attribute>
                        <xsl:attribute name="onclick">javascript:validateRS('<xsl:value-of select="category" />','<xsl:value-of select="scenarioId" />','<xsl:value-of select="$normalize-space-summary" />');return false;</xsl:attribute>
                    </input>
                </div>
            </xsl:if>
        </xsl:for-each>
    </xsl:template>
</xsl:stylesheet>
