<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">


    <xsl:output method="html"/>

    <xsl:template match="ns:getOutgoingSequenceDataResponse" xmlns:ns="http://org.apache.axis2/xsd">

        <div id="sandesha2SequenceHeader"></div>
		<xsl:variable name="inFlowCount" select="count(return/flow)"/>
        <xsl:variable name="outFlowCount" select="count(return/flow)"/>
        <xsl:choose>
            <xsl:when test="$inFlowCount > 0">
                <div>
                    <h2>Incoming Sequences</h2>
                </div>
                <table class="styled" cellspacing="0" cellpadding="0">
                    <thead>
                        <tr>
                            <th>Sequence</th>
                            <th>internal Sequence ID</th>
                            <th>Secure</th>
                            <th>Status</th>
                        </tr>
                    </thead>
                    <xsl:for-each select="return">
                        <xsl:if test="flow='1'">
                            <tr>
                                <td>
                                    <xsl:value-of select="sequenceID"/>
                                </td>
                                <td>
                                    <xsl:value-of select="sequenceReport/internalSequenceID"/>
                                </td>
                                <td>
                                    <xsl:value-of select="sequenceReport/secureSequence"/>
                                </td>
                                <td>
                                    <xsl:value-of select="sequenceReport/sequenceStatus"/>
                                </td>
                            </tr>
                        </xsl:if>
                    </xsl:for-each>
                </table>
            </xsl:when>
            <xsl:otherwise>
                <div>
                    <h2>Incoming sequences are not available.</h2>
                </div>
            </xsl:otherwise>
        </xsl:choose>


        <xsl:choose>
            <xsl:when test="$outFlowCount > 0">
                <div>
                    <h2>Outgoing Sequences</h2>
                </div>
                <table class="styled" cellspacing="0" cellpadding="0">
                    <thead>
                        <tr>
                            <th>Sequence</th>
                            <th>internal Sequence ID</th>
                            <th>Secure</th>
                            <th>Status</th>
                        </tr>
                    </thead>
                    <xsl:for-each select="return">
                        <xsl:if test="flow='2'">
                            <tr>
                                <td>
                                    <xsl:value-of select="sequenceID"/>
                                </td>
                                <td>
                                    <xsl:value-of select="sequenceReport/internalSequenceID"/>
                                </td>
                                <td>
                                    <xsl:value-of select="sequenceReport/secureSequence"/>
                                </td>
                                <td>
                                    <xsl:value-of select="sequenceReport/sequenceStatus"/>
                                </td>
                            </tr>
                        </xsl:if>
                    </xsl:for-each>
                </table>
            </xsl:when>
            <xsl:otherwise>
                <div>
                    <h2>Outgoing sequences are not available.</h2>
                </div>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

</xsl:stylesheet>