<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:ns1="http://org.apache.axis2/xsd"
                exclude-result-prefixes="ns1">

    <xsl:template match="ns1:getServiceDataResponse">
        <xsl:variable name="active"><xsl:value-of select="return/active"/></xsl:variable>
        <xsl:variable name="serviceName"><xsl:value-of select="return/name"/></xsl:variable>
        <xsl:variable name="enableMTOM" select="return/enableMTOM" />
        <h4><a href="#" onClick="javascript:readOnlyServices(); return false;">Services</a>&#160;&gt;&#160;<xsl:value-of select="$serviceName"/></h4>
        <h2>Service Information</h2>
        <fieldset style="border:none;">
    	<div id="formset">
            <xsl:for-each select="return">
            <table class="styledLeft">
                <thead><tr><th colspan="2">General</th></tr></thead>
				<tr>
					<td><strong>Service Name</strong></td>
                	<td><xsl:value-of select="name"/></td>
            	</tr>
				<tr>
					<td><strong>Service Description</strong></td>
                	<td><xsl:value-of select="description"/></td>
            	</tr>
                <tr>
					<td><strong>Service Group Name</strong></td>
                	<td><xsl:value-of select="serviceGroupName"/></td>
            	</tr>
                <tr>
					<td><strong>Deployment Scope</strong></td>
                	<td><xsl:value-of select="scope"/></td>
            	</tr>
                <tr>
                    <td><strong>Service Type</strong></td>
                    <td><xsl:value-of select = "serviceType"/></td>
                </tr>
                <tr>
					<td><strong>Service Status</strong></td>
                	<td>
						<xsl:comment><xsl:value-of select="$active"/></xsl:comment>
						<xsl:if test="$active='true'">
							Active
						</xsl:if>
						<xsl:if test="$active='false'">
							Inactive
						</xsl:if>
					</td>
            	</tr>
                <tr>
                    <td>
                        <strong>MTOM</strong>
                    </td>
                    <td>
                        <xsl:choose>
                            <xsl:when test="$enableMTOM='true'">
                                True
                            </xsl:when>
                            <xsl:when test="$enableMTOM='false'">
                                False
                            </xsl:when>
                            <xsl:when test="$enableMTOM='optional'">
                                Optional
                            </xsl:when>
                        </xsl:choose>
                    </td>
                </tr>
                <thead><tr><th colspan="2">End Points</th></tr></thead>
                <tr>
                    <td>
                        <xsl:attribute name="rowspan"><xsl:value-of select = "count(eprs) + 1" /></xsl:attribute>
	                     <strong>Endpoint References </strong>
	               </td>
                    <td/>
                </tr>
                    <xsl:for-each select="eprs">
                      <tr>
                          <td>
                                <xsl:value-of select="."/>
                          </td>
                      </tr>
                    </xsl:for-each>
            </table>
            </xsl:for-each>
		</div>
        </fieldset>
    </xsl:template>
</xsl:stylesheet>
