<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

    <xsl:template match="*">
		<h3>Home</h3>
		<table id="homeT">
			<tr>
				<th id="th1">Name</th>
				<th id="th2">Value</th>
			</tr>
			<xsl:for-each select="return">

				<tr>
					<th>Axis2 Location</th>
					<td>
						<xsl:value-of select="axis2Location"/>
					</td>
				</tr>
				<tr>
					<th>Free Memory</th>
					<td>
						<xsl:value-of select="freeMemory"/>
					</td>
				</tr>
				<tr>
					<th>Java Home</th>
					<td>
						<xsl:value-of select="javaHome"/>
					</td>
				</tr>

				<tr>
					<th>Java Runtime Name</th>
					<td>
						<xsl:value-of select="javaRuntimeName"/>
					</td>
				</tr>
				<tr>
					<th>Java Version</th>
					<td>
						<xsl:value-of select="javaVersion"/>
					</td>
				</tr>
				<tr>
					<th>Java Vendor</th>
					<td>
						<xsl:value-of select="javaVMVendor"/>
					</td>
				</tr>
				<tr>
					<th>Java VM Version</th>
					<td>
						<xsl:value-of select="javaVMVersion"/>
					</td>
				</tr>
				<tr>
					<th>OS Name</th>
					<td>
						<xsl:value-of select="osName"/>
					</td>
				</tr>
				<tr>
					<th>OS Version</th>
					<td>
						<xsl:value-of select="osVersion"/>
					</td>
				</tr>
				<tr>
					<th>Server Name</th>
					<td>
						<xsl:value-of select="serverName"/>
					</td>
				</tr>

				<tr>
					<th>Server Start Time</th>
					<td>
						<xsl:value-of select="serverStartTime"/>
					</td>
				</tr>
				<tr>
					<th>Total Memory</th>
					<td>
						<xsl:value-of select="totalMemory/value"/>
						<xsl:value-of select="totalMemory/unit"/>
					</td>
				</tr>
				<tr>
					<th>User Country</th>
					<td>
						<xsl:value-of select="userCountry"/>
					</td>
				</tr>

				<tr>
					<th>User Home</th>
					<td>
						<xsl:value-of select="userHome"/>
					</td>
				</tr>
				<tr>
					<th>User Name</th>
					<td>
						<xsl:value-of select="userName"/>
					</td>
				</tr>
				<tr>
					<th>User Timezone</th>
					<td>
						<xsl:value-of select="userTimezone"/>
					</td>
				</tr>
			</xsl:for-each>
		</table>
    </xsl:template>
</xsl:stylesheet>
