<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="html"/>
    <xsl:template match="*">
                <div id="wizardUpdate"></div>
				<!-- end of link header block -->
                <!-- Div handling starts from here-->
        <fieldset style="border:none;">
        <xsl:choose>
            <xsl:when test="return">
				<div id="formset">
				<form>
					<fieldset>
							<legend>Select EJB Remote Interfaces to be exposed as Web services</legend>
   				                            <table class="styled">
				                                <thead>
                                				    <tr>
				                                        <th>Class Name</th>
				                                        <th>Include</th>
				                                    </tr>
				                                </thead>
				                                <tbody>
				                                    <xsl:for-each select="return">
                                				        <tr>
				                                            <td>
				                                                <xsl:value-of select="."/>
				                                            </td>
				                                            <td>
                                				                <input type="checkbox">
										<xsl:attribute name="name">chkClasses</xsl:attribute>
				                                                <xsl:attribute name="value"><xsl:value-of select="."/></xsl:attribute>
				                                                </input>
                                				            </td>
                                				        </tr>
				                                    </xsl:for-each>
                                				</tbody>
				                            </table>
					        </fieldset>


						<fieldset>
							<legend>Application Server Details</legend>
							    <table>
							        <tbody>
								    <tr><td colspan="2"></td></tr>
								    <tr>
									    <td colspan="2">
				   					    <div>
										<label>Server Type</label>
										<select id="serverType" name="serverType">
											<xsl:attribute name="onchange">javascript:setDefaultServerValues(this,document);return false;</xsl:attribute>
										</select>
									        <!--<script><![CDATA[loadAppServersComboBox();]]></script>-->
									    </div>
							                    <div>
							                        <label for="providerUrl">Provider URL<font color='red'>*</font></label><input type="text" id="providerUrl" tabindex="2" size="40" maxlength="100"/>
							                    </div>
                    						            <div>
							                        <label for="jndiContextClass">JNDI Context Class<font color='red'>*</font></label><input 	type="text" id="jndiContextClass" tabindex="3" size="70" maxlength="100"/>
							                    </div>
                    							    <div>
							                        <label for="userName">User Name</label><input type="text" id="userName" tabindex="4" size="15" maxlength="20"/>
							                    </div>
                    							    <div>
							                        <label for="password">Password</label><input type="text" id="password" tabindex="5" size="15" maxlength="20"/>
							                    </div>
									    </td>
					 			   </tr>
							    </tbody>
							</table>
						</fieldset>

						<fieldset>
						   <legend>EJB Details</legend>
							<table>
							 <tbody>
							  <tr>
							    <td colspan="2">
		    <div>
                        <label for="beanJNDIName">Bean JNDI Name<font color='red'>*</font></label><input type="text" id="beanJNDIName" tabindex="6" size="70" maxlength="100"/>
                    </div>
                    <div>
                        <label for="homeInterface">Home Interface<font color='red'>*</font></label><input type="text" id="homeInterface" tabindex="7" size="70" maxlength="100"/>
                    </div>
                    <div>
                        <label for="remoteInterface">Remote Interface<font color='red'>*</font></label><input type="text" id="remoteInterface" tabindex="8" size="70" maxlength="100"/>
                    </div>

							    </td>
							  </tr>
                		                        </tbody>
			                            </table>
                        			</fieldset>

						<fieldset>
						   <legend>Service Group Details</legend>
							<table>
							 <tbody>
							  <tr>
							    <td colspan="2">
		    <div><label for="existing-service-groups"><b>Use existing</b></label></div>
		    <div>
                        <label for="existing-service-groups">Service Group</label>
				<select id="serviceGroupSelectBox" name="serviceGroupSelectBox" onchange="javascript:setServiceGroupId(this,document);return false;" tabindex="9"></select>	
                    </div>
		    <div>
                        <label for="existing-service-groups"><b>Or add new </b></label>
                    </div>
		    <div>
                        <label for="existing-service-groups">Name</label><input type="text" id="newServiceGroupId" name="newServiceGroupId" onfocus="javascript:setServiceGroupId(this,document)" tabindex="10" size="20" maxlength="20"/>
			<input type="hidden" id="serviceGroupId"/>
			<input type="hidden" id="addNewServiceGroup"/>
                    </div>
								 <!--<script><![CDATA[loadServiceGroupsComboBox();]]></script>-->

							    </td>
							  </tr>
                		                        </tbody>
			                            </table>
				                    <iframe src="_blank.html" onload="javascript:loadServiceGroupsComboBox();"
                        				scrolling="no" style="visibility:hidden"
				                        width="0" height="0"/>
                        			</fieldset>

                        <br/>
                        <div class="buttonrowBottom">
							<input type="button" onClick="javascript:history.back(); return false;" value="Cancel"/>
                            <input type="button" onclick="generateAARForSelectedEJBRemoteInterface();" value="Deploy Service" tabindex="9"/>
							<input type="button" onClick="javascript:startServices(this,1); return false;" value="Cancel"/>
     	                </div>
					</form>
				</div>
            </xsl:when>
            <xsl:otherwise>
				<table>
					 <tr>
						 <td>No classes available in the uploaded archive.</td>
					 </tr>
				</table>
            </xsl:otherwise>
        </xsl:choose>
            <iframe src="_blank.html" onload="javascript:showWizardUpdate(document.getElementById('wizardUpdate'));"
                        scrolling="no" style="visibility:hidden"
                        width="0" height="0"/>
	    <iframe src="_blank.html" onload="javascript:loadAppServersComboBox();"
			scrolling="no" style="visibility:hidden"
			width="0" height="0"/>
        </fieldset>
    </xsl:template>
</xsl:stylesheet>


