<?xml version="1.0"?>
<!--
  Extracted from : Author:  Jonathan Marsh (jonathan@wso2.com)
-->
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:output method="html"/>

  <xsl:template match="node()"/>

    <xsl:template match="/">
        <xsl:apply-templates/>
    </xsl:template>

  <!-- Template for normal attributes -->
  <xsl:template match="@*">
    <span class="fx-atnm">
      <xsl:text> </xsl:text>
      <xsl:value-of select="name()"/>
    </span>
    <xsl:text>="</xsl:text>
    <span class="fx-att"><xsl:value-of select="."/></span>
    <xsl:text>"</xsl:text>
  </xsl:template>

  <!-- Template for src and href attributes (assume the content is a link)-->
  <xsl:template match="@src | @href">
    <span class="fx-atnm">
      <xsl:text> </xsl:text>
      <xsl:value-of select="name()"/>
    </span>
    <xsl:text>="</xsl:text>
    <span class="fx-att"><a href="{.}"><xsl:value-of select="."/></a></span>
    <xsl:text>"</xsl:text>
  </xsl:template>

  <!-- Template for text nodes -->
  <xsl:template match="text()">
    <div class="fx-block" style="overflow:hidden">
      <span class="fx-text">
        <xsl:value-of select="."/>
      </span>
    </div>
  </xsl:template>

  <!-- Template for comment nodes -->
  <xsl:template match="comment()">
    <div class="fx-cmk">
      <xsl:text>&lt;!--</xsl:text>
      <span class="fx-com"><xsl:value-of select="."/></span>
      <xsl:text>--&gt;</xsl:text>
    </div>
  </xsl:template>

  <!-- Template for elements not handled elsewhere (leaf nodes) -->
  <xsl:template match="*">
    <div class="fx-block" style="overflow:hidden">
        <xsl:text>&lt;</xsl:text>
        <xsl:call-template name="element-name"/>
        <xsl:call-template name="attributes"/>
        <xsl:text> /&gt;</xsl:text>
    </div>
  </xsl:template>

  <!-- Template for elements with comment, pi and/or text children -->
  <xsl:template match="*[node()]">
    <div class="fx-block" style="overflow:hidden">
      <xsl:text>&lt;</xsl:text>
      <xsl:call-template name="element-name"/>
      <xsl:call-template name="attributes"/>
      <xsl:text>&gt;</xsl:text>
        <xsl:apply-templates/>
          <xsl:text>&lt;/</xsl:text>
          <xsl:call-template name="element-name"/>
          <xsl:text>&gt;</xsl:text>
    </div>
  </xsl:template>

  <!-- Template for elements with only text children -->
  <xsl:template match="*[text() and not(comment() or processing-instruction() )]">
    <div class="fx-block" style="overflow:hidden">
      <div style="margin-left:1em;text-indent:1em;">
        <xsl:text>&lt;</xsl:text>
        <xsl:call-template name="element-name"/>
        <xsl:call-template name="attributes"/>
        <xsl:text>&gt;</xsl:text>
        <xsl:choose>
          <xsl:when test="contains(text(), '&#xA;') or contains(text(), '&#xD;')">
            <pre class="fx-text">
              <xsl:value-of select="text()"/>
            </pre>
          </xsl:when>
          <xsl:otherwise>
            <span class="fx-text">
              <xsl:value-of select="text()"/>
            </span>
          </xsl:otherwise>
        </xsl:choose>
        <xsl:text>&lt;/</xsl:text>
        <xsl:call-template name="element-name"/>
        <xsl:text>&gt;</xsl:text>
      </div>
    </div>
  </xsl:template>

  <!-- Template for elements with element children -->
  <xsl:template match="*[*]">
    <div class="fx-block" style="overflow:hidden">
      <xsl:text>&lt;</xsl:text>
      <xsl:call-template name="element-name"/>
      <xsl:call-template name="attributes"/>
      <xsl:text>&gt;</xsl:text>
        <xsl:apply-templates select="node()"/>
          <xsl:text>&lt;/</xsl:text>
          <xsl:call-template name="element-name"/>
          <xsl:text>&gt;</xsl:text>
    </div>
  </xsl:template>

  <xsl:template name="element-name">
    <span class="fx-elnm"><xsl:value-of select="name()"/></span>
  </xsl:template>

  <xsl:template name="attributes">
    <xsl:apply-templates select="@*"/>
    <xsl:variable name="current" select="current()"/>
    <xsl:for-each select="namespace::*">
      <xsl:if test="not($current/parent::*[namespace::*[. = current()]])">
        <span class="fx-ns">
          <xsl:text> xmlns</xsl:text>
          <xsl:if test="name() != ''">:</xsl:if>
          <xsl:value-of select="name()"/>
          <xsl:text>="</xsl:text>
          <span class="fx-nsval"><a href="{.}"><xsl:value-of select="."/></a></span>
          <xsl:text>"</xsl:text>
        </span>
      </xsl:if>
    </xsl:for-each>
  </xsl:template>

</xsl:stylesheet>
