<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="html"/>

    <!-- If there is a value for query id, then it is a existing entity-->
    <xsl:param name="queryId" />

    <!--single point of entry or main -->
    <xsl:template match="/">
        <xsl:apply-templates select="dataWrapper"/>
    </xsl:template>

    <xsl:template match="dataWrapper">
        <div style="overflow-y:hidden;">
            <xsl:variable name="dataSourceType" select="@dataSourceType"/>
            <xsl:variable name="queries" select="data/query"/>
            <div style="height:430px;overflow-y:auto;">
            <h4><div id="dataServiceAddQueryHeader" /></h4>

            <fieldset style="border:none;">
                <div id="formset">
                    <form name="dataServiceAddQueryForm">
                        <fieldset style="width: 520px;">
                            <legend>
                                <xsl:choose>
                                    <xsl:when test="$dataSourceType='RDBMS' or $dataSourceType='JNDIDataSource'">
                                        SQL Query/Stored procedure configuration
                                    </xsl:when>
                                    <xsl:when test="$dataSourceType='EXCEL'">
                                        Data extraction parameters for Excel
                                    </xsl:when>
                                    <xsl:when test="$dataSourceType='CSV'">
                                        Data extraction parameters for CSV
                                    </xsl:when>
                                </xsl:choose>
                            </legend>
                            <div>
                                <label>Query ID<font color='red'>*</font></label>
                                <input type="text">
                                    <xsl:attribute name="size">30</xsl:attribute>
                                    <xsl:attribute name="id">txtDataServiceQueryId</xsl:attribute>
                                    <xsl:attribute name="value">
                                        <xsl:value-of select="$queries[@id=$queryId]/@id"/>
                                    </xsl:attribute>
                                    <xsl:if test="$queryId">
                                        <xsl:attribute name="disabled">true</xsl:attribute>
                                        <!--<xsl:attribute name="style">background-color:#E4E8F5;</xsl:attribute>-->
                                    </xsl:if>
                                    <xsl:attribute name="onChange">javascript:validateQueryTextValue(this); return false;</xsl:attribute>
                                </input>
                            </div>

                            <xsl:if test="$dataSourceType='RDBMS' or $dataSourceType='JNDIDataSource'">
                                <div>
                                    <fieldset style="width:500px;">
                                        <legend>SQL</legend>
                                        <div>
                                            <label>SQL Statement<font color='red'>*</font>
                                            </label>
                                            <textarea>
                                                <!--<xsl:attribute name="style">height:60px;width:350px</xsl:attribute>-->
                                                <xsl:attribute name="cols">40</xsl:attribute>
                                                <xsl:attribute name="rows">5</xsl:attribute>
                                                <xsl:attribute name="wrap">virtual</xsl:attribute> 
                                                <xsl:attribute name="id">txtDataServiceSQL</xsl:attribute>
                                                <xsl:attribute name="value"><xsl:value-of select="$queries[@id=$queryId]/sql"/></xsl:attribute>
                                                <xsl:value-of select="$queries[@id=$queryId]/sql"/>
                                            </textarea>
                                        </div>
                                        <div id="divInputMappingTable">
                                            <xsl:choose>
                                                <xsl:when test="count($queries[@id=$queryId]/param)=0">
                                                    <strong>Currently there are no input mappings present for this query</strong>
                                                </xsl:when>
                                                <xsl:otherwise>
                                                    <div>Input Mappings</div>
                                                    <table width="460px;" class="styled" style="margin-left:20px;">
                                                        <thead>
                                                            <tr>
                                                                <th>Name</th>
                                                                <th>SQL Type</th>
                                                                <th>Action</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <xsl:apply-templates select="$queries[@id=$queryId]/param"/>
                                                        </tbody>
                                                    </table>
                                                </xsl:otherwise>
                                            </xsl:choose>
                                            <input type="button" onClick="addNewInputParam(document.getElementById('txtDataServiceQueryId').value, document.getElementById('txtDataServiceSQL').value ); return false;" value="Add New Input Mapping"/>

                                        </div>
                                    </fieldset>

                                </div>

                            </xsl:if>

                            <xsl:if test="$dataSourceType='EXCEL'">
                                <xsl:call-template name="dsExcelQuery">
                                    <xsl:with-param name="workBookName" select="$queries[@id=$queryId]/excel/workbookname"/>
                                    <xsl:with-param name="startingRow" select="$queries[@id=$queryId]/excel/startingrow"/>
                                    <xsl:with-param name="hasHeader" select="$queries[@id=$queryId]/excel/hasheader"/>
                                    <xsl:with-param name="maxRowCount" select="$queries[@id=$queryId]/excel/maxrowcount"/>
                                </xsl:call-template>
                            </xsl:if>
                    </fieldset>
                    </form>

                    <form>
                        <fieldset style="width: 520px;">
                            <xsl:variable name="groupByEle" select="$queries[@id=$queryId]/result/@element"/>
                            <xsl:variable name="rowName" select="$queries[@id=$queryId]/result/@rowName"/>
                            <xsl:variable name="defaultNamespace" select="$queries[@id=$queryId]/result/@defaultNamespace"/>
                            <legend>Result (Output Mapping)</legend>
                            <div>
                                <div>
                                    <label style="width:150px;">Grouped by element</label>
                                    <input type="text">
                                        <xsl:attribute name="size">30</xsl:attribute>
                                        <xsl:attribute name="id">txtDataServiceWrapElement</xsl:attribute>
                                        <!--<xsl:if test="$groupByEle">
                                            <xsl:attribute name="disabled">true</xsl:attribute>
                                        </xsl:if>-->
                                        <xsl:attribute name="value">
                                            <xsl:value-of select="$groupByEle"/>
                                        </xsl:attribute>
                                        <xsl:if test="$groupByEle">
                                            <xsl:attribute name="style">background-color:#E4E8F5;</xsl:attribute>
                                        </xsl:if>
                                    </input>
                                </div>
                                <div>
                                    <label style="width:150px;">Row name</label>
                                    <input type="text">
                                        <xsl:attribute name="size">30</xsl:attribute>
                                        <xsl:attribute name="id">txtDataServiceRowName</xsl:attribute>
                                        <!--<xsl:if test="$rowName">
                                            <xsl:attribute name="disabled">true</xsl:attribute>
                                        </xsl:if>-->
                                        <xsl:attribute name="value">
                                            <xsl:value-of select="$rowName"/>
                                        </xsl:attribute>
                                        <xsl:if test="$rowName">
                                            <xsl:attribute name="style">background-color:#E4E8F5;</xsl:attribute>
                                        </xsl:if>
                                    </input>
                                </div>
                                <div>
                                    <label style="width:150px;">Row namespace</label>
                                    <input type="text">
                                        <xsl:attribute name="size">30</xsl:attribute>
                                        <xsl:attribute name="id">txtDataServiceRowNamespace</xsl:attribute>
                                        <!--<xsl:if test="$rowName">
                                            <xsl:attribute name="disabled">true</xsl:attribute>
                                        </xsl:if>-->
                                        <xsl:attribute name="value">
                                            <xsl:value-of select="$defaultNamespace"/>
                                        </xsl:attribute>
                                        <xsl:if test="$defaultNamespace">
                                            <xsl:attribute name="style">background-color:#E4E8F5;</xsl:attribute>
                                        </xsl:if>
                                    </input>
                                </div>                               
                                <div>
                                    <xsl:choose>
                                        <xsl:when test="not($queries[@id=$queryId]/result)">
                                             <strong>Currently there are no output mappings present for this query</strong>
                                        </xsl:when>
                                        <xsl:otherwise>
                                            <xsl:choose>
                                                <xsl:when test="$queries[@id=$queryId]/result/element or $queries[@id=$queryId]/result/attribute or $queries[@id=$queryId]/result/call-query">
                                                    <div>Output Mappings</div>
                                                    <div>
                                                        <table class="styled" width="460px;" style="margin-left:20px;">
                                                            <thead>
                                                                <tr>
                                                                    <th>Mapping type</th>
                                                                    <th>Output Field Name</th>
                                                                    <th>Result column</th>
                                                                    <th>Actions</th>
                                                                </tr>
                                                            </thead>
                                                            <tbody>
                                                                <xsl:apply-templates select="$queries[@id=$queryId]/result"/>
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                </xsl:when>
                                                <xsl:otherwise>
                                                     <strong>Currently there are no output mappings present for this query</strong>
                                                </xsl:otherwise>
                                            </xsl:choose>
                                        </xsl:otherwise>
                                    </xsl:choose>
                                    <div>
                                        <input type="button" onClick="addNewOutPutMappingForQuery(document.getElementById('txtDataServiceQueryId').value, document.getElementById('txtDataServiceSQL') != null ? document.getElementById('txtDataServiceSQL').value : '{$dataSourceType}','{$dataSourceType}'); return false;" value="Add New Output Mapping"/>
                                        <xsl:if test="$groupByEle">
                                            <input type="button" onClick="removeResultElement(document.getElementById('txtDataServiceQueryId').value,document.getElementById('txtDataServiceWrapElement').value); return false;" value="Clear Result"/>
                                        </xsl:if>
                                    </div>
                                </div>

                            </div>
                        </fieldset>
                    </form>
                </div>
            </fieldset>
        </div>
            <div>
                <xsl:choose>
                    <xsl:when test="$dataSourceType='RDBMS' or $dataSourceType='JNDIDataSource'">
                        <xsl:choose>
                            <xsl:when test="$queryId">
                                <input type="button" onClick="editSpecificQuery(document.getElementById('txtDataServiceQueryId').value, document.getElementById('txtDataServiceSQL').value,'{$dataSourceType}'); return false;" value="OK"/>
                                <!--<input type="button" onClick="removeTransientElements(); closeContainer('divDSAddQuery'); return false;" value="Cancel"/>-->
                            </xsl:when>
                            <xsl:otherwise>
                                <input type="button" onClick="addNewQueryOK(document.getElementById('txtDataServiceQueryId').value);" value="OK"/>
                                <input type="button" onClick="removeTransientElements(); removeTransientQuery(document.getElementById('txtDataServiceQueryId').value); closeContainer('divDSAddQuery'); return false;" value="Cancel"/>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:when>
                    <xsl:when test="$dataSourceType='EXCEL'">
                        <xsl:choose>
                            <xsl:when test="$queryId">
                                 <input type="button" onClick="editSpecificQuery(document.getElementById('txtDataServiceQueryId').value, '','{$dataSourceType}'); return false;" value="OK"/>
                            </xsl:when>
                            <xsl:otherwise>
                                 <input type="button" value="OK" onClick="addNewQueryOK(document.getElementById('txtDataServiceQueryId').value);return false;"/>
                                <input type="button" onClick="removeTransientElements(); removeTransientQuery(document.getElementById('txtDataServiceQueryId').value); closeContainer('divDSAddQuery'); return false;" value="Cancel"/>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:when>
                    <xsl:when test="$dataSourceType='CSV'">
                        <xsl:choose>
                            <xsl:when test="$queryId">
                                  <input type="button" onClick="editSpecificQuery(document.getElementById('txtDataServiceQueryId').value, '','{$dataSourceType}'); return false;" value="OK"/>
                            </xsl:when>
                            <xsl:otherwise>
                                  <input type="button" onClick="addNewQueryOK(document.getElementById('txtDataServiceQueryId').value);return false;" value="OK"/>
                                  <input type="button" onClick="removeTransientElements(); removeTransientQuery(document.getElementById('txtDataServiceQueryId').value);closeContainer('divDSAddQuery'); return false;" value="Cancel"/>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:when>
                </xsl:choose>
            </div>
        </div>

    </xsl:template>

    <xsl:template match="result">
        <xsl:apply-templates select="call-query"/>
        <xsl:apply-templates select="element"/>
        <xsl:apply-templates select="attribute"/>
    </xsl:template>

    <xsl:template match="call-query">
        <tr>
            <td>Query</td>
            <td colspan="2">
                <xsl:value-of select="@href"/>
            </td>
            <td style="width:50px;">
                <a alt="Delete">
                    <xsl:attribute name="title">Delete</xsl:attribute>
                    <xsl:attribute name="onclick">javascript:removeQueryOutputMapping('<xsl:value-of select="$queryId"/>','Query' ,'<xsl:value-of select="@href"/>');return false;</xsl:attribute>
                    <xsl:attribute name="id">cancel_link</xsl:attribute>
                    <xsl:attribute name="href">#</xsl:attribute>
                    <xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;</xsl:text>
                </a>
                <a alt="Edit">
                    <xsl:attribute name="title">Edit</xsl:attribute>
                    <xsl:attribute name="onclick">javascript:editQueryOutputMappingCallQuery('<xsl:value-of select="$queryId"/>','<xsl:value-of select="@href"/>');return false;</xsl:attribute>
                    <xsl:attribute name="id">edit_link</xsl:attribute>
                    <xsl:attribute name="href">#</xsl:attribute>
                    <xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;</xsl:text>
                </a>
            </td>
        </tr>
    </xsl:template>

    <xsl:template match="element">
        <tr>
            <td>Element</td>
            <td>
                <xsl:value-of select="@name"/>
            </td>
            <td>
                <xsl:value-of select="@column"/>
            </td>
            <td style="width:50px;">
                <a alt="Delete">
                    <xsl:attribute name="title">Delete</xsl:attribute>
                    <xsl:attribute name="onclick">javascript:removeQueryOutputMapping('<xsl:value-of select="$queryId"/>','Element','<xsl:value-of select="@name"/>');return false;</xsl:attribute>
                    <xsl:attribute name="id">cancel_link</xsl:attribute>
                    <xsl:attribute name="href">#</xsl:attribute>
                    <xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;</xsl:text>
                </a>
                <a alt="Edit">
                    <xsl:attribute name="title">Edit</xsl:attribute>
                    <xsl:attribute name="onclick">javascript:editQueryOutputMappingElement('<xsl:value-of select="$queryId"/>','<xsl:value-of select="@name"/>', '<xsl:value-of select="@column"/>');return false;</xsl:attribute>
                    <xsl:attribute name="id">edit_link</xsl:attribute>
                    <xsl:attribute name="href">#</xsl:attribute>
                    <xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;</xsl:text>
                </a>
            </td>
        </tr>
    </xsl:template>

    <xsl:template match="attribute">
        <tr>
            <td>Attribute</td>
            <td>
                <xsl:value-of select="@name"/>
            </td>
            <td>
                <xsl:value-of select="@column"/>
            </td>
            <td style="width:50px;">
                <a alt="Delete">
                    <xsl:attribute name="title">Delete</xsl:attribute>
                    <xsl:attribute name="onclick">javascript:removeQueryOutputMapping('<xsl:value-of select="$queryId"/>','Attribute','<xsl:value-of select="@name"/>');return false;</xsl:attribute>
                    <xsl:attribute name="id">cancel_link</xsl:attribute>
                    <xsl:attribute name="href">#</xsl:attribute>
                    <xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;</xsl:text>
                </a>
                <a alt="Edit">
                    <xsl:attribute name="title">Edit</xsl:attribute>
                    <xsl:attribute name="onclick">javascript:editQueryOutputMappingAttribute('<xsl:value-of select="$queryId"/>','<xsl:value-of select="@name"/>', '<xsl:value-of select="@column"/>');return false;</xsl:attribute>
                    <xsl:attribute name="id">edit_link</xsl:attribute>
                    <xsl:attribute name="href">#</xsl:attribute>
                    <xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;</xsl:text>
                </a>
            </td>
        </tr>
    </xsl:template>

    <xsl:template match="param">
        <tr>
            <td>
                <xsl:value-of select="@name"/>
            </td>
            <td>
                <xsl:value-of select="@sqlType"/>
            </td>
            <td style="width:50px;">
                <a alt="Delete">
                    <xsl:attribute name="title">Delete</xsl:attribute>
                    <xsl:attribute name="onclick">javascript:removeDSInputMapping('<xsl:value-of select="$queryId"/>','<xsl:value-of select="@name"/>');return false;</xsl:attribute>
                    <xsl:attribute name="id">cancel_link</xsl:attribute>
                    <xsl:attribute name="href">#</xsl:attribute>
                    <xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;</xsl:text>
                </a>
                <a alt="Edit">
                    <xsl:attribute name="title">Edit</xsl:attribute>
                    <xsl:attribute name="onclick">javascript:editDSInputMapping('<xsl:value-of select="$queryId"/>', '<xsl:value-of select="@name"/>', '<xsl:value-of select="@sqlType"/>','<xsl:value-of select="@type"/>', '<xsl:value-of select="@ordinal"/>');return false;</xsl:attribute>
                    <xsl:attribute name="id">edit_link</xsl:attribute>
                    <xsl:attribute name="href">#</xsl:attribute>
                    <xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;</xsl:text>
                </a>
            </td>
        </tr>
    </xsl:template>

    <xsl:template name="dsExcelQuery">
        <xsl:param name="workBookName"/>
        <xsl:param name="startingRow"/>
        <xsl:param name="maxRowCount"/>
        <xsl:param name="hasHeader"/>
        <div>
    		<label>Workbook Name<font color='red'>*</font></label>
    		<input type="text">
    			<xsl:attribute name="size">30</xsl:attribute>
    			<xsl:attribute name="id">txtExcelWorkbookName</xsl:attribute>
    			<xsl:attribute name="value"><xsl:value-of select="$workBookName"/></xsl:attribute>
    		</input>
    	</div>
	
    	<div>
    		<label>Start reading from<font color='red'>*</font></label>
    		<input type="text">
    			<xsl:attribute name="size">30</xsl:attribute>
    			<xsl:attribute name="id">txtExcelStartingRow</xsl:attribute>
    			<xsl:attribute name="value"><xsl:value-of select="$startingRow"/></xsl:attribute>
    		</input>
    	</div>
    	<div>
    		<label>Rows to read<font color='red'>*</font>
    		</label>
    		<input type="text">
    			<xsl:attribute name="size">30</xsl:attribute>
    			<xsl:attribute name="id">txtExcelMaxRowCount</xsl:attribute>
    			<xsl:attribute name="value"><xsl:value-of select="$maxRowCount"/></xsl:attribute>
    		</input>
    	</div>
    	<div>
    		<label>Headers available<font color='red'>*</font>
    		</label>  			
			<select>
	            <xsl:attribute name="id">txtExcelHeaderColumns</xsl:attribute>
                <option>
                	<xsl:attribute name="value" />
                	--SELECT--
                </option>	            
                <option>
                	<xsl:attribute name="value">true</xsl:attribute>
                	<xsl:if test="$hasHeader='true'">
                		<xsl:attribute name="selected">true</xsl:attribute>
                	</xsl:if>
                	TRUE
                </option>
             	<option>
             		<xsl:attribute name="value">false</xsl:attribute>
             		<xsl:if test="$hasHeader='false'">
             			<xsl:attribute name="selected">true</xsl:attribute>
             		</xsl:if>
             		FALSE
             	</option>
            </select>
    	</div>
		
    </xsl:template>

</xsl:stylesheet>
