<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

    <xsl:param name="queryId"/>
    <xsl:param name="eleName"/>
    <xsl:param name="atName"/>
    <xsl:param name="colName"/>
    <xsl:param name="queryHref"/>

    <!--single point of entry or main -->
    <xsl:template match="/">
        <xsl:apply-templates select="dataWrapper"/>
    </xsl:template>

    <xsl:template match="dataWrapper">
        <xsl:variable name="queries" select="data/query"/>
        <xsl:variable name="dataSourceType" select="@dataSourceType"/>
        <xsl:variable name="mappingType">
            <xsl:choose>
                <xsl:when test="$queries[@id=$queryId]">
                    <xsl:choose>
                        <xsl:when test="$queries[@id=$queryId]/result/element[@name=$eleName]">
                              <xsl:text>Element</xsl:text>
                        </xsl:when>
                        <xsl:when test="$queries[@id=$queryId]/result/attribute[@name=$atName]">
                              <xsl:text>Attribute</xsl:text>
                        </xsl:when>
                        <xsl:when test="$queries[@id=$queryId]/result/call-query[@href=$queryHref]">
                              <xsl:text>Query</xsl:text>
                        </xsl:when>
                        <xsl:otherwise>
                             <xsl:text>Element</xsl:text>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:when>
                <xsl:otherwise>
                     <xsl:text>Element</xsl:text>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>

        <xsl:call-template name="addEditOutputMappingTable">
            <xsl:with-param name="dataSourceType" select="$dataSourceType"/>
            <xsl:with-param name="mappingType" select="$mappingType"/>
            <xsl:with-param name="queries" select="$queries"/>
        </xsl:call-template>


    </xsl:template>

    <xsl:template name="addEditOutputMappingTable">
        <xsl:param name="mappingType"/><!--Type either Element or Query-->
        <xsl:param name="dataSourceType"/>
        <xsl:param name="queries"/>
        <div id="formset">
            <form name="dataServiceAddEditOutputMappingForm">
                <fieldset style="width: 520px;">
                    <legend>Add/Edit Output Mapping</legend>
                    <div>
                        <label>Mapping Type</label>
                        <select>
                            <xsl:attribute name="id">cmbDataServiceOMType</xsl:attribute>
                            <xsl:attribute name="onchange">changeToNextMapping('<xsl:value-of select="$queryId"/>', this);return false;</xsl:attribute>
                            <xsl:if test="$eleName or $atName or $colName or $queryHref">
                                <xsl:attribute name="disabled">true</xsl:attribute>
                            </xsl:if>
                            <option>
                                <xsl:attribute name="value">Element</xsl:attribute>
                                <xsl:if test="$mappingType='Element'">
                                     <xsl:attribute name="selected">true</xsl:attribute>
                                </xsl:if>
                                Element
                            </option>
                            <option>
                                <xsl:attribute name="value">Attribute</xsl:attribute>
                                <xsl:if test="$mappingType='Attribute'">
                                     <xsl:attribute name="selected">true</xsl:attribute>
                                </xsl:if>
                                Attribute
                            </option>
                            <xsl:if test="$dataSourceType!='CSV' and count($queries)&gt;1">
                                <option>
                                    <xsl:attribute name="value">Query</xsl:attribute>
                                    <xsl:if test="$mappingType='Query'">
                                        <xsl:attribute name="selected">true</xsl:attribute>
                                    </xsl:if>
                                    Query
                                </option>
                            </xsl:if>
                        </select>
                    </div>
                    <div id="divOMQuery">
                        <xsl:if test="$mappingType='Query'">
                            <xsl:attribute name="style">display: inline;</xsl:attribute>
                        </xsl:if>
                        <xsl:if test="$mappingType='Element' or $mappingType='Attribute'">
                            <xsl:attribute name="style">display: none;</xsl:attribute>
                        </xsl:if>
                        <div>
                            <label>Select Query</label>
                            <select>
                                <xsl:attribute name="id">cmbDataServiceQueryId</xsl:attribute>
                                <xsl:variable name="arrayOfName">
                                    [
                                    <xsl:for-each select="$queries">
                                        "<xsl:value-of select="@id"/>"
                                        <xsl:if test="position()!=last()">
                                            ,
                                        </xsl:if>
                                    </xsl:for-each>
                                    ]
                                </xsl:variable>
                                <xsl:attribute name="onchange">showInnerQueryExplorer(this, <xsl:value-of select="$arrayOfName"/>);return false;</xsl:attribute>
                                <xsl:for-each select="$queries">
                                    <xsl:if test="@id!=$queryId">
                                        <option>
                                            <xsl:attribute name="value"><xsl:value-of select="@id"/></xsl:attribute>
                                            <xsl:if test="@id=$queryHref">
                                                <xsl:attribute name="selected">true</xsl:attribute>
                                            </xsl:if>
                                            <xsl:value-of select="@id"/>
                                        </option>
                                    </xsl:if>
                                </xsl:for-each>
                            </select>
                        </div>
                        <div>
                            <fieldset style="width: 500px;">
                                <legend>Query Parameter Mapping</legend>
                                <xsl:call-template name="queryExplorer">
                                    <xsl:with-param name="queries" select="$queries"/>
                                </xsl:call-template>

                            </fieldset>
                        </div>
                    </div>
                    <div id="divOMElement">
                        <xsl:if test="$mappingType='Query'">
                            <xsl:attribute name="style">display: none;</xsl:attribute>
                        </xsl:if>
                        <xsl:if test="$mappingType='Element' or $mappingType='Attribute'">
                            <xsl:attribute name="style">display: inline;</xsl:attribute>
                        </xsl:if>
                        <div>
                            <label>Output field name</label>
                            <input type="text">
                                <xsl:attribute name="size">30</xsl:attribute>
                                <xsl:attribute name="id">txtDataServiceOMElementName</xsl:attribute>
                                <xsl:attribute name="value">
                                    <xsl:choose>
                                        <xsl:when test="$eleName">
                                             <xsl:value-of select="$eleName"/>
                                        </xsl:when>
                                        <xsl:when test="$atName">
                                             <xsl:value-of select="$atName"/>
                                        </xsl:when>
                                    </xsl:choose>
                                </xsl:attribute>
                                <xsl:if test="$eleName or $atName">
                                    <xsl:attribute name="style">background-color:#E4E8F5;</xsl:attribute>
                                </xsl:if>
                            </input>
                        </div>
                        <div>
                            <label>
                                <xsl:choose>
                                    <xsl:when test="$dataSourceType='RDBMS' or $dataSourceType='JNDIDataSource'">
                                        SQL column Name
                                    </xsl:when>
                                    <xsl:when test="$dataSourceType='CSV'">
                                        CSV column ordinal
                                    </xsl:when>
                                    <xsl:when test="$dataSourceType='EXCEL'">
                                        Excel column name
                                    </xsl:when>
                                </xsl:choose>
                            </label>

                            <input type="text">
                                <xsl:attribute name="size">30</xsl:attribute>
                                <xsl:attribute name="id">txtDataServiceOMColumnName</xsl:attribute>
                                <xsl:attribute name="value"><xsl:value-of select="$colName"/></xsl:attribute>
                            </input>
                        </div>

                    </div>
                    <div>
                        <input type="button">
                            <xsl:attribute name="value">OK</xsl:attribute>
                            <xsl:attribute name="onclick">
                                var cqmObj = new Object();
                                <xsl:for-each select="$queries">
                                    <xsl:variable name="forEachQueryId" select="@id"/>
                                    cqmObj["<xsl:value-of select="$forEachQueryId"/>"] = new Object();
                                    <xsl:variable name="callQuery" select="$queries[@id=$queryId]/result/call-query[@href=$queryHref]"/>
                                    <xsl:choose>
                                        <xsl:when test="$callQuery/with-param">
                                            <xsl:for-each select="$callQuery/with-param">
                                                cqmObj["<xsl:value-of select="$forEachQueryId"/>"]["<xsl:value-of select="@name"/>"] = document.getElementById('inputInnerQPCQ_<xsl:value-of select="generate-id($queries)"/>').value;
                                            </xsl:for-each>
                                        </xsl:when>
                                        <xsl:otherwise>
                                            <xsl:for-each select="param">
                                                cqmObj["<xsl:value-of select="$forEachQueryId"/>"]["<xsl:value-of select="@name"/>"] = document.getElementById('inputInnerQP_<xsl:value-of select="generate-id($queries)"/>').value;
                                            </xsl:for-each>
                                        </xsl:otherwise>
                                    </xsl:choose>
                                </xsl:for-each>
                                <xsl:variable name="oldOutputFieldName">
                                    <xsl:choose>
                                        <xsl:when test="$eleName">
                                             <xsl:value-of select="$eleName"/>
                                        </xsl:when>
                                        <xsl:when test="$atName">
                                             <xsl:value-of select="$atName"/>
                                        </xsl:when>
                                    </xsl:choose>
                                </xsl:variable>
                                addEditSpecificOutputMapping('<xsl:value-of select="$queryId"/>', document.getElementById('cmbDataServiceOMType'),'<xsl:value-of select="$oldOutputFieldName"/>', cqmObj);return false;
                            </xsl:attribute>
                        </input>
                        <input type="button" onclick="closeContainer('divADDEditOutputMapping'); refreshParentQueryContainer('{$queryId}', 'data_service_add_query.xsl', 'divDSAddQuery', 'Add New Query'); return false;" value="Cancel"/>
                    </div>
                </fieldset>
            </form>
        </div>
    </xsl:template>

    <xsl:template name="queryExplorer">
        <xsl:param name="queries"/>
        <xsl:variable name="thisQuery" select="$queries[@id=$queryId]"/>
        <xsl:for-each select="$queries">
            <div id="divInnerQueryExplorler_{@id}">
                <xsl:attribute name="style">
                    <xsl:choose>
                        <xsl:when test="$queryHref">
                            <xsl:choose>
                                <xsl:when test="@id=$queryHref">
                                    display: inline;
                                </xsl:when>
                                <xsl:otherwise>
                                    display: none;
                                </xsl:otherwise>
                            </xsl:choose>
                        </xsl:when>
                        <xsl:otherwise>
                              display: none;
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:attribute>
                <xsl:choose>
                    <xsl:when test="not(param)">
                        <strong>Query params are not available</strong>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:variable name="callQuery" select="$thisQuery/result/call-query[@href=$queryHref]"/>
                        <xsl:choose>
                            <xsl:when test="$callQuery/with-param">
                                <xsl:for-each select="$callQuery/with-param">
                                    <div>
                                        <label>
                                            <xsl:value-of select="@query-param"/>
                                        </label>
                                        <input type="text">
                                            <xsl:attribute name="id">inputInnerQPCQ_<xsl:value-of select="generate-id($queries)"/></xsl:attribute>
                                            <xsl:attribute name="size">30</xsl:attribute>
                                            <xsl:attribute name="value"><xsl:value-of select="@name"/></xsl:attribute>
                                            <xsl:attribute name="style">background-color:#E4E8F5;</xsl:attribute>
                                        </input>
                                    </div>
                                </xsl:for-each>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:for-each select="param">
                                    <div>
                                        <label>
                                            <xsl:value-of select="@name"/>
                                        </label>
                                        <input type="text">
                                            <xsl:attribute name="id">inputInnerQP_<xsl:value-of select="generate-id($queries)"/></xsl:attribute>
                                            <xsl:attribute name="size">30</xsl:attribute>
                                        </input>
                                    </div>
                                </xsl:for-each>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:otherwise>
                </xsl:choose>
            </div>
        </xsl:for-each>
    </xsl:template>

</xsl:stylesheet>