<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:param name="operationName"/>

    <!--single point of entry or main -->
    <xsl:template match="/">
        <xsl:apply-templates select="dataWrapper"/>
    </xsl:template>

    <xsl:template match="dataWrapper">
        <xsl:variable name="operation" select="data/operation[@name=$operationName]"/>
        <xsl:variable name="callQuery" select="$operation/call-query"/>
        <div id="formset">
        <form name="dataServicesAddEditOperations">
            <fieldset style="width: 520px;">
                <legend>Add/Edit Operations</legend>
                <div>
                    <label>Operation Name</label>
                    <input type="text">
                        <xsl:attribute name="size">30</xsl:attribute>
                        <xsl:attribute name="id">operationNameTextId</xsl:attribute>
                        <xsl:if test="$operationName">
                            <!--<xsl:attribute name="disabled">true</xsl:attribute>-->
                            <xsl:attribute name="style">background-color:#E4E8F5;</xsl:attribute>
                        </xsl:if>
                        <xsl:attribute name="value">
                            <xsl:value-of select="$operation/@name"/>
                        </xsl:attribute>
                        <xsl:attribute name="onChange">javascript:validateOperationNameValue(this); return false;</xsl:attribute>
                    </input>
                </div>
                <div>
                    <label>Query</label>
                    <select>
                        <xsl:attribute name="id">operationQuerySelectId</xsl:attribute>
                        <xsl:attribute name="onchange">javascript:showOnlyRequiredDSOp(this[this.selectedIndex].value, document.getElementById('operationNameTextId').value);return false;</xsl:attribute>
                        <xsl:choose>
                            <xsl:when test="data/query">
                                <xsl:for-each select="data/query">
                                    <option>
                                        <xsl:attribute name="value">
                                            <xsl:value-of select="@id"/>
                                        </xsl:attribute>
                                        <xsl:if test="$callQuery/@href=@id">
                                            <xsl:attribute name="selected">true</xsl:attribute>
                                        </xsl:if>
                                        <xsl:value-of select="@id"/>
                                    </option>
                                </xsl:for-each>
                            </xsl:when>
                            <xsl:otherwise>
                                <strong>No queries are available</strong>
                            </xsl:otherwise>
                        </xsl:choose>
                    </select>
                </div>

                <div id="showOperationParameterMappingDivId" />

            </fieldset>
        </form>
        </div>
    </xsl:template>

</xsl:stylesheet>