<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

   <xsl:template match="ns:getModuleInfoResponse" xmlns:ns="http://org.apache.axis2/xsd">
        <h4><a href="#" onClick="javascript:listModules(); return false;">Modules</a>&#160;&gt;&#160;<xsl:value-of select="return/modulename"/></h4>
        <h2>Module Information</h2>

        <fieldset style="border:none;">
    	<div id="formset">
           <xsl:for-each select="return">
                <table class="semi">
                    <tr>
                        <td><strong>Module ID</strong></td>
                        <td><xsl:value-of select="moduleId"/></td>
                    </tr>
                    <tr>
                        <td><strong>Version</strong></td>
                        <td><xsl:value-of select="moduleVersion"/></td>
                    </tr>
                    <tr>
                        <td><strong>Description</strong></td>
                        <td><xsl:value-of select="description"></xsl:value-of></td>
                    </tr>
                    <tr>
                        <td><strong>Globally Engaged?</strong></td>
                        <td>
                           <xsl:choose>
                               <xsl:when test="engaged='true'">
                                    Yes
                               </xsl:when>
                               <xsl:otherwise>
                                    No
                               </xsl:otherwise>
                           </xsl:choose>
                        </td>
                    </tr>
                </table>
            </xsl:for-each>
            <br/><br/>

            <table>
                <tr>
                    <td>
                        <a id="edit_link">
                            <xsl:attribute name="href">#</xsl:attribute>
                            <xsl:attribute name="onClick">javascript:getModuleParametersForConfig('<xsl:value-of select="return/moduleId"/>','<xsl:value-of select="return/moduleVersion"/>'); return false;</xsl:attribute>
                            <xsl:text>&#160;&#160;&#160;&#160;&#160;Configure Parameters</xsl:text>
                        </a>
                    </td>
                </tr>
                <tr>
                    <td>
                        <a id="edit_link">
                            <xsl:attribute name="href">#</xsl:attribute>
                            <xsl:attribute name="onClick">javascript:getModulePolicies('<xsl:value-of select="return/moduleId"/>','<xsl:value-of select="return/moduleVersion"/>'); return false;</xsl:attribute>
                            <xsl:text>&#160;&#160;&#160;&#160;&#160;Configure Policies</xsl:text>
                        </a>
                    </td>
                </tr>
                <xsl:apply-templates select="return"/>
            </table>
        </div>
        </fieldset>
    </xsl:template>

    <!-- TODO need to make the following open for extension. It's been tighly
         TODO bounnd to Sandesha2 at this point -->
    <xsl:template match="return">
        <xsl:if test="moduleId='sandesha2' or moduleId='Sandesha2'">
            <tr>
                <td>
                    <a id="edit_link">
                        <xsl:attribute name="href">#</xsl:attribute>
                        <xsl:attribute name="onClick">javascript:getSequenceInfo('<xsl:value-of select="moduleId"/>','<xsl:value-of select="moduleVersion"/>'); return false;</xsl:attribute>
                        <xsl:text>&#160;&#160;&#160;&#160;&#160;Show Sandesha2 Information</xsl:text>
                    </a>
                </td>
            </tr>
        </xsl:if>
    </xsl:template>

</xsl:stylesheet>
