<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="html"/>
    <xsl:template match="*">
        <fieldset style="border:none;">
        <h4><a href='#' onClick='javascript:showServiceInitializer(); return false;'>Services</a>&#160;&gt;&#160;Service Archive Generation</h4>
        <xsl:choose>
            <xsl:when test="return">
				<div id="formset">
					<form>
						<fieldset>
							<legend>Select POJOs to be exposed as Web services</legend>
                            <div class="buttonrowTop">
                                <input type="button" onclick="javascript:pojoArcStepOne(); return false;" value="Next &gt;" tabindex="1"/>
                                &#160;&#160;&#160;&#160;&#160;
                                <input type="button" onclick="selectAll(document.getElementsByName('chkClasses'), true);"
                                       value="Select All" tabindex="2"/>&#160;&#160;&#160;&#160;&#160;
                                <input type="button" onclick="selectAll(document.getElementsByName('chkClasses'), false);"
                                       value="Select None" tabindex="3"/>
					        </div>
                            <br/>
                            <table class="styled">
                                <thead>
                                    <tr>
                                        <th>Class Name</th>
                                        <th>Include</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <xsl:for-each select="return">
                                        <tr>
                                            <td>
                                                <xsl:value-of select="."/>
                                            </td>
                                            <td>
                                                <input type="checkbox">
										        <xsl:attribute name="name">chkClasses</xsl:attribute>
                                                <xsl:attribute name="value"><xsl:value-of select="."/></xsl:attribute>
                                                </input>
                                            </td>
                                        </tr>

                                    </xsl:for-each>
                                </tbody>
                            </table>
                            <br/>
                            <div class="buttonrowBottom">
								<input type="button" onclick="javascript:pojoArcStepOne(); return false;" value="Next &gt;"/>
                                &#160;&#160;&#160;&#160;&#160;
                                <input type="button" onclick="selectAll(document.getElementsByName('chkClasses'), true);"
                                       value="Select All" tabindex="4"/>&#160;&#160;&#160;&#160;&#160;
                                <input type="button" onclick="selectAll(document.getElementsByName('chkClasses'), false);"
                                       value="Select None" tabindex="5"/>
					        </div>
                        </fieldset>
					</form>
				</div>
            </xsl:when>
            <xsl:otherwise>
				<table>
					 <tr>
						 <td>No classes available in the uploaded archive.</td>
					 </tr>
				</table>
            </xsl:otherwise>
        </xsl:choose>
            <!--<iframe src="_blank.html" onload="javascript:showWizardUpdate(document.getElementById('wizardUpdate'));"
                        scrolling="no" style="visibility:hidden"
                        width="0" height="0"/>-->
        </fieldset>
    </xsl:template>
</xsl:stylesheet>


