<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

    <xsl:template match="serviceUploadTemplate" xmlns="http://www.w3.org/1999/xhtml">
        <h4>
            <a>
                <xsl:attribute name="href">#</xsl:attribute>
                <xsl:attribute name="onClick">javascript:showServiceInitializer(); return false;</xsl:attribute>
                Services
            </a>
            &#160;&gt;&#160;POJO Service
        </h4>
        <div id="formset">
            <form method="post" name="pojoUpload" action="fileupload/pojo"
                  enctype="multipart/form-data" target="globalIFrame">
                <br/>
                <fieldset>
                    <legend>Upload Jar or Class File</legend>
                    <div>
                        <label>Annotated .jar or .class</label>
                        <input type="file" id="filename" name="filename" size="50"/>
                    </div>
                    <br/>
                    <div>
                        <xsl:attribute name="id">jarLibDivId</xsl:attribute>
                        <label>Resource(s) (.jar)</label>
                        <input type="file" name="jarResource" size="50"/>
                        <input type="button" value="+">
                            <xsl:attribute name="onClick">
                                javascript:addLibraryFileuplod(document.getElementById("jarLibDivId")); return false;
                            </xsl:attribute>
                        </input>
                    </div>
                    <div class="buttonrow">
                        <input name="upload" type="submit" value=" Upload ">
                            <xsl:attribute name="onclick">
                                javascript: var fileName = document.pojoUpload.filename.value;
                                var boolPass = false;
                                if (fileName == '') {
                                    wso2.wsf.Util.alertWarning('Please select a .jar or .class file.');
                                    return false;
                                } else if (fileName.lastIndexOf(".jar") &gt; 0 || fileName.lastIndexOf(".class") &gt; 0) {
                                    stoppingRefreshingMethodsHook();
                                    return true;
                                } else {
                                    wso2.wsf.Util.alertWarning('Please select a .jar or .class file.');
                                    return false;
                                }
                            </xsl:attribute>
                        </input>
						<input type="button" onClick="javascript:startServices(this,1); return false;" value="Cancel"/>
                    </div>
                </fieldset>
            </form>
        </div>
    </xsl:template>
</xsl:stylesheet>
