<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

    <xsl:template match="wsddUploadTemplate" xmlns="http://www.w3.org/1999/xhtml">
        <h4>
            <a>
                <xsl:attribute name="href">#</xsl:attribute>
                <xsl:attribute name="onClick">javascript:showServiceInitializer(); return false;</xsl:attribute>
                Services
            </a>
            &#160;&gt;&#160;New Axis1 Service
        </h4>
        <div id="formset">
			<form method="post" name="wsddUpload" action="fileupload/wsdd"
                  enctype="multipart/form-data" target="globalIFrame">
                <br/>
                <fieldset>
                    <legend>Upload WSDD file and Jar resources</legend>
                    <div>
                        <label>Descriptor (.wsdd)</label>
                        <input type="file" name="wsddFilename" size="50"/>
                    </div>
                    <div>
                        <xsl:attribute name="id">wsddLibDivId</xsl:attribute>
                        <label>Resource(s) (.jar)</label>
                        <input type="file" name="jarResource" size="50"/>
                        <input type="button" value="+">
                            <xsl:attribute name="onClick">
                                javascript:addLibraryFileuplod(document.getElementById("wsddLibDivId")); return false;
                            </xsl:attribute>
                        </input>
                    </div>

                    <div class="buttonrow">
                        <input name="upload" type="submit" value=" Upload ">
                            <xsl:attribute name="onclick">
                                javascript: var fileName = document.wsddUpload.wsddFilename.value;
                                if (fileName == '') {
                                    wso2.wsf.Util.alertWarning('Please select a wsdd file.');
                                    return false;
                                } else if (fileName.lastIndexOf(".wsdd") &lt; 0) {
                                    wso2.wsf.Util.alertWarning('Please select a wsdd file.');
                                    return false;
                                } else {
                                    stoppingRefreshingMethodsHook();
                                    return true;
                                }
                            </xsl:attribute>
                        </input>
						<input type="button" onClick="javascript:startServices(this,1); return false;" value="Cancel"/>
                    </div>
                </fieldset>
            </form>
        </div>
    </xsl:template>


</xsl:stylesheet>
