/*
tracer.js handles script related to tracing SOAP messages at server side.
*/

/* For Monitoring Status */

function setMonitoring(obj) {


    var value = obj[obj.selectedIndex].value;

    var body_xml = '<req:setMonitoring xmlns:req="http://org.apache.axis2/xsd">\n' +
                   '<flag>' + value + '</flag>\n' +
                   ' </req:setMonitoring>\n';

    var callURL = serverURL + "/" + "wso2tracer" ;
    new wso2.wsf.WSRequest(callURL, "setMonitoring", body_xml, viewTracerCallback);
}

function viewTracer(thisObj, index) {

    if (thisObj && index) {
        renderSelectedMenuItem(thisObj, index);
        gatherHistoryObject(thisObj.id, index);
    }

    var body_xml = '<req:getMessages xmlns:req="http://org.apache.axis2/xsd">\n' +
                   '<numberOfMessages>250</numberOfMessages>\n' +
                   '<filter></filter>\n' +
                   '</req:getMessages>\n';

    var callURL = serverURL + "/" + "wso2tracer" ;
    new wso2.wsf.WSRequest(callURL, "getLastMessages", body_xml, viewTracerCallback);
}

function viewTracerCallback() {

    wso2.wsf.Util.callbackhelper(this.req.responseXML, "tracer.xsl", document.getElementById("divTracer"));
}


// this is a call through tracer.xslt
function traceMessage(valueObject) {

    var value = valueObject[valueObject.selectedIndex].value;

    var splitValues = value.split("-");

    var body_xml = '<req:getMessageRequest xmlns:req="http://org.apache.axis2/xsd">\n' +
                   '<serviceId>' + splitValues[0] + '</serviceId>\n' +
                   '<operationName>' + splitValues[1] + '</operationName>\n' +
                   '<messageSequence>' + splitValues[2] + '</messageSequence>\n' +
                   '</req:getMessageRequest>\n';

    var callURL = serverURL + "/" + "wso2tracer" ;
    new wso2.wsf.WSRequest(callURL, "getMessage", body_xml, loadTracerTextBoxes);
}

function loadTracerTextBoxes() {
    transformationWithoutHistoryShowingAllDivs(this.req.responseXML, "tracer.xsl", document.getElementById("informationMainTableDivId"));
}

function transformationWithoutHistoryShowingAllDivs(data, xslFile, objDiv) {
    wso2.wsf.Util.processXML(data, xslFile, objDiv);
}

function shrinkRequestTextBox() {

    var txtAreaSend = document.getElementById('txtAreaSend');
    var txtAreaRecieve = document.getElementById('txtAreaReceive');

    var tracerZoomLink2 = document.getElementById('tracer_zoom_out_link_2');
    var tracerZoomLink1 = document.getElementById('tracer_zoom_out_link_1');


    var tRows = txtAreaRecieve.rows;

    if (tRows == "1") {
        tracerZoomLink1.className = ".cornerCollapse";
        tracerZoomLink1.src = "extensions/core/images/collapse.gif";
        tracerZoomLink1.title = "Reduce observable space";

    }

    if (tRows == '15') {

        tracerZoomLink1.className = ".cornerExpand";
        tracerZoomLink1.src = "extensions/core/images/expand.gif";
        tracerZoomLink1.title = "Expand observable space";
        txtAreaSend.rows = '30';
        txtAreaRecieve.rows = '1';

    } else {

        tracerZoomLink2.className = ".cornerCollapse";
        tracerZoomLink2.src = "extensions/core/images/collapse.gif";
        tracerZoomLink2.title = "Reduce observable space";

        txtAreaRecieve.rows = '15';
        txtAreaSend.rows = '15';

    }
}

function shrinkResponseTextBox() {
    var txtAreaSend = document.getElementById('txtAreaSend');
    var txtAreaRecieve = document.getElementById('txtAreaReceive');

    var tracerZoomLink2 = document.getElementById('tracer_zoom_out_link_2');
    var tracerZoomLink1 = document.getElementById('tracer_zoom_out_link_1');

    var tRows = txtAreaSend.rows;

    if (tRows == "1") {
        tracerZoomLink2.className = ".cornerCollapse";
        tracerZoomLink2.src = "extensions/core/images/collapse.gif";
        tracerZoomLink2.title = "Reduce observable space";

    }

    if (tRows == '15') {
        tracerZoomLink2.className = ".cornerExpand";
        tracerZoomLink2.src = "extensions/core/images/expand.gif";
        tracerZoomLink2.title = "Expand observable space";

        txtAreaSend.rows = '1';
        txtAreaRecieve.rows = '30';

    } else {
        tracerZoomLink1.className = ".cornerCollapse";
        tracerZoomLink1.src = "extensions/core/images/collapse.gif";
        tracerZoomLink1.title = "Reduce observable space";

        txtAreaSend.rows = '15';
        txtAreaRecieve.rows = '15';

    }
}

function findMaskedObjects(findValue) {

    if (findValue != null && findValue.length == 0) {
        wso2.wsf.Util.alertMessage("Please use a string to filter");
        return false;
    }
    var body_xml = '<req:getMessagesRequest xmlns:req="http://org.apache.axis2/xsd">\n' +
                   '<numberOfMessages>30</numberOfMessages>\n' +
                   '<filter>' + findValue + '</filter>\n' +
                   '</req:getMessagesRequest>\n';

    var callURL = serverURL + "/" + "wso2tracer" ;
    new wso2.wsf.WSRequest(callURL, "getMessages", body_xml, findMaskedObjectsCallback);
}

function findMaskedObjectsCallback() {

    transformationWithoutHistoryShowingAllDivs(this.req.responseXML, "tracer.xsl", document.getElementById("divTracer"));

}




