var ejbProviderConfigObject = '';
var existingAppServerConfigs = 0;

function addApplicationServer(){
	var serverType = document.getElementById('serverType').value;
	var providerURL = document.getElementById('providerUrl').value;
	var jndiContextClass = document.getElementById('jndiContextClass').value;
	var jndiUserName = document.getElementById('userName').value;
	var password = document.getElementById('password').value;
	var confirmPassword = document.getElementById('confirmPassword').value;
		
	if(checkForExistingAppServerConfigurations(providerURL)){
		if(serverType == null || wso2.wsf.Util.trim(serverType) == ""){
	        wso2.wsf.Util.alertWarning("Please select an Application Server type.");
    	    return false;
    	}
	
		if(providerURL == null || wso2.wsf.Util.trim(providerURL) == ""){
	        wso2.wsf.Util.alertWarning("Please enter a valid provider url.");
        	return false;
    	}
		if(jndiContextClass == null || wso2.wsf.Util.trim(jndiContextClass) == ""){
	        wso2.wsf.Util.alertWarning("Please enter a valid JNDI Context class.");
    	    return false;
    	}
		if(password != null && wso2.wsf.Util.trim(password) != ""){
			if(jndiUserName == null || wso2.wsf.Util.trim(jndiUserName) == ""){
		        wso2.wsf.Util.alertWarning("Please enter username for the password provided.");
    	    	return false;			
			}		
			if(password != confirmPassword){
		        wso2.wsf.Util.alertWarning("Password and re-entered password do not match.");
    	    	return false;
			}
    	}	
	
		var ejbAppServer_xml = '';
    	ejbAppServer_xml +=
    		' <req:providerUrl>' + providerURL + '</req:providerUrl>\n';
    	ejbAppServer_xml +=
    		' <req:jndiContextClass>' + jndiContextClass +
    		'</req:jndiContextClass>\n';
    	ejbAppServer_xml +=
    		' <req:userName>' + jndiUserName + '</req:userName>\n';
    	ejbAppServer_xml +=
    		' <req:password>' + password + '</req:password>\n';
    	ejbAppServer_xml +=
    		' <req:appServerType>' + serverType + '</req:appServerType>\n';
	
		var body_xml = '<req:addApplicationServerRequest xmlns:req="http://org.apache.axis2/xsd">\n' +
   				  ejbAppServer_xml +
                  ' </req:addApplicationServerRequest>\n';

    	var callURL = serverURL + "/" + "EJBProviderAdmin" + "/" ;	
	    new wso2.wsf.WSRequest(callURL,"addApplicationServer",body_xml,ejbProviderConfigCallback);	
	}
}

function checkForExistingAppServerConfigurations(providerURL){
    var combo = document.getElementById('existingAppServerConfigurations');
    var count;
    for (count = 0; count < combo.length; count++) {
		if(providerURL == combo.options[count].value){
			wso2.wsf.Util.alertWarning("Configuration exists for provider URL "+combo.options[count].value +
			". Please select it from existing configuration section.");
			combo.selectedIndex = count;
			document.getElementById('existingAppServerConfigurations').disabled = false;
			//document.getElementById('appServerConfiguration1').checked = true;
			//document.getElementById('appServerConfiguration2').checked = false;			
			return false;
		}         
    }
	return true;
}

function addApplicationServerElement(){
    var combo = document.getElementById('existingAppServerConfigurations');
	if(combo.length == 0){
		wso2.wsf.Util.alertWarning("No existing configurations found.Please add Application " +
			"Server before continuing.");
		return false;
	}
	
	//This is the first reference to this variable.
	//Reinitialize
    ejbProviderConfigObject = '';
	var obj = document.getElementById('existingAppServerConfigurations');
    ejbProviderConfigObject +=
    ' <req:providerUrl>' + obj[obj.selectedIndex].value + '</req:providerUrl>\n';
	
    showEJBServiceWizardStep1();
}

function addEJBDetailsElement(){
    //var classes = document.getElementsByName("chkClasses");
    var selectedClasses = '';
    //var isClassSelected = false;
    //for (var i = 0; i < classes.length; i++) {
    //    if (classes[i].checked) {
    //        isClassSelected = true;
    //        selectedClasses += ' <req:serviceClasses>' + classes[i].value + '</req:serviceClasses>\n';
    //    }
    //}
	
	var remoteInterfaceClass = '';
	var homeInterfaceClass = '';
	var beanJNDIName = document.getElementById('beanJNDIName').value;
	
    var remoteInterfaces = document.getElementsByName("chkRemoteInterface");
	for (var a = 0; a < remoteInterfaces.length; a++){
		if(remoteInterfaces[a].checked){
			remoteInterfaceClass = remoteInterfaces[a].value;
		}
	}
	selectedClasses += ' <req:serviceClasses>' + remoteInterfaceClass + '</req:serviceClasses>\n';

    var homeInterfaces = document.getElementsByName("chkHomeInterface");
	for (var a = 0; a < homeInterfaces.length; a++){
		if(homeInterfaces[a].checked){
			homeInterfaceClass = homeInterfaces[a].value;
		}
	}

	//validation
	if(homeInterfaceClass == null || wso2.wsf.Util.trim(homeInterfaceClass) == ""){
        wso2.wsf.Util.alertWarning("Please enter Home Interface class.");
   	    return false;
   	}
	if(remoteInterfaceClass == null || wso2.wsf.Util.trim(remoteInterfaceClass) == ""){
        wso2.wsf.Util.alertWarning("Please enter Remote Interface class.");
   	    return false;
   	} 	
	if(beanJNDIName == null || wso2.wsf.Util.trim(beanJNDIName) == ""){
        wso2.wsf.Util.alertWarning("Please enter JNDI name of EJB.");
   	    return false;
   	}
	
	//selected classes should come first	
	ejbProviderConfigObject = selectedClasses + ejbProviderConfigObject;
    ejbProviderConfigObject +=
    ' <req:beanJNDIName>' + beanJNDIName + '</req:beanJNDIName>\n';
    ejbProviderConfigObject += ' <req:homeInterface>' + document.getElementById('homeInterface').value +
                        '</req:homeInterface>\n';
    ejbProviderConfigObject +=
    ' <req:remoteInterface>' + document.getElementById('remoteInterface').value +
    '</req:remoteInterface>\n';
	
	generateAARForSelectedEJBRemoteInterface();
    //showEJBServiceWizardStep3();
}

//function addServiceGroupDetailsElementAndDeploy(){
//    ejbProviderConfigObject += ' <req:serviceGroupId>' + document.getElementById('serviceGroupId').value +
//                        '</req:serviceGroupId>\n';
//    ejbProviderConfigObject +=
//    ' <req:addNewServiceGroup>' + document.getElementById('addNewServiceGroup').value +
//    '</req:addNewServiceGroup>\n';
//    generateAARForSelectedEJBRemoteInterface();
//}



//functions for ejb provider archive reader
function generateAARForSelectedEJBRemoteInterface() {
    var body_xml = '<req:createAndDeployEJBServiceRequest xmlns:req="http://org.apache.axis2/xsd">\n' +
                   '<req:archiveId>' + genFileKey + '</req:archiveId>\n' +
                   ejbProviderConfigObject +
                   '</req:createAndDeployEJBServiceRequest>\n';

    var callURL = serverURL + "/" + "ServiceAdmin" ;
    new wso2.wsf.WSRequest(callURL,"createAndDeployEJBService",body_xml,completeAARGenerationCB);
}



function deleteEJBConfiguration(beanJNDIName, jnpProviderUrl) {
    beanJNDIName = beanJNDIName.replace(/\xA7/g,"'");
    jnpProviderUrl = jnpProviderUrl.replace(/\xA7/g,"'");

    var deleteIt= confirm("Do you really want to delete EJB configuration for "+ beanJNDIName +"@" + jnpProviderUrl +"?");
    if (deleteIt) {
        var body_xml = '<req:deleteEJBConfigurationRequest xmlns:req="http://org.apache.axis2/xsd">\n' +
                       '<req:beanJNDIName>' + beanJNDIName + '</req:beanJNDIName>\n'+
                       '<req:jnpProviderUrl>' + jnpProviderUrl + '</req:jnpProviderUrl>\n'+
                       '</req:deleteEJBConfigurationRequest>\n';
	
	var xsltFileName = "ejb_provider_service.xsl";

        var callURL = serverURL + "/" + "EJBProviderAdmin" + "/" ;
        new wso2.wsf.WSRequest(callURL,"deleteEJBConfiguration",body_xml,ejbProviderConfigCallback);
    }
}


function ejbProviderConfigCallback() {
    ejbProviderConfig();
}


// loading service groups for combo
function loadServiceGroupsComboBox() {
    var body_xml = '<ns1:listServiceGroups  xmlns:ns1="http://org.apache.axis2/xsd">\n' +
                   ' </ns1:listServiceGroups>\n';

    var callURL = serverURL + "/" + SERVICE_GROUP_ADMIN_STRING + "/" + "listServiceGroups";
    new wso2.wsf.WSRequest(callURL,"listServiceGroups",body_xml,loadServiceGroupListCallback);

}



//load service group list callback.
function loadServiceGroupListCallback() {
    var comboToLoad = document.getElementById('serviceGroupSelectBox');
    var data = this.req.responseXML;
    var rets = data.getElementsByTagName("return");
    var len = rets.length;
    var count;

    for (count = 0; count < len; count++) {
        comboToLoad.options[count] = new Option(rets[count].getElementsByTagName("group_id").item(0).firstChild.nodeValue);
        comboToLoad.options[count].value = rets[count].getElementsByTagName("group_id").item(0).firstChild.nodeValue;
    }
    comboToLoad.options[count] = new Option('');
    comboToLoad.options[count].value = '';
    comboToLoad.selectedIndex = count;
}



function loadAppServersComboBox() {
    var body_xml = '<ns1:loadAppServersComboBox  xmlns:ns1="http://org.apache.axis2/xsd">\n' +
                   ' </ns1:loadAppServersComboBox>\n';

    var callURL = serverURL + "/" + "EJBProviderAdmin" + "/" ;
    new wso2.wsf.WSRequest(callURL,"getAppServerNameList",body_xml,loadAppServerListCallback);
}

function loadExistingAppServerConfigComboBox() {
    var body_xml = '<ns1:getEJBAppServerConfigurationsRequest  xmlns:ns1="http://org.apache.axis2/xsd">\n' +
                   ' </ns1:getEJBAppServerConfigurationsRequest>\n';

    var callURL = serverURL + "/" + "EJBProviderAdmin" + "/" ;
    //new wso2.wsf.WSRequest(callURL,"getEJBAppServerConfigurations",body_xml,loadAppServerConfigurationListCallback);
	new wso2.wsf.WSRequest(callURL,"getEJBAppServerConfigurations",body_xml,loadAppServerConfigurationListCallback);
}


function loadAppServerConfigurationListCallback() {
    var comboToLoad = document.getElementById('existingAppServerConfigurations');
    var data = this.req.responseXML;
    var rets = data.getElementsByTagName("return");
    var len = rets.length;
    var count;
    for (count = 0; count < len; count++) {
        comboToLoad.options[count] = new Option(rets[count].getElementsByTagName("appServerType").item(0).firstChild.nodeValue + ' - '+
													rets[count].getElementsByTagName("providerURL").item(0).firstChild.nodeValue);
													
        comboToLoad.options[count].value = rets[count].getElementsByTagName("providerURL").item(0).firstChild.nodeValue;
    }
    existingAppServerConfigs = comboToLoad.length;
    ejbProviderStep1DisableFields();
}




//load ejb application server list callback.
function loadAppServerListCallback() {
    var comboToLoad = document.getElementById('serverType');
    var data = this.req.responseXML;
    var rets = data.getElementsByTagName("return");
    var len = rets.length;
    var count;

    for (count = 0; count < len; count++) {
        comboToLoad.options[count] = new Option(rets[count].getElementsByTagName("serverName").item(0).firstChild.nodeValue);
        comboToLoad.options[count].value = rets[count].getElementsByTagName("serverId").item(0).firstChild.nodeValue;
    }
    comboToLoad.options[count] = new Option('--Application Server--');
    comboToLoad.options[count].value = '';
    comboToLoad.selectedIndex = count;
}



function setServiceGroupId(obj,document){
	var serviceGroupId = '';
	if( obj.name == 'serviceGroupSelectBox'){
		if(obj[obj.selectedIndex].value != ''){
			serviceGroupId = obj[obj.selectedIndex].value;
		}
	}else if( obj.name == 'newServiceGroupId'){
		serviceGroupId = obj.value;
		document.getElementById('serviceGroupSelectBox').value = '';
		document.getElementById('addNewServiceGroup').value = 'true';
	}
	document.getElementById('serviceGroupId').value = serviceGroupId;
}


function ejbProviderConfig() {
    var body_xml = '<req:getEJBConfigurationsRequest xmlns:req="http://org.apache.axis2/xsd">\n' +
                   ' </req:getEJBConfigurationsRequest>\n';

    var callURL = serverURL + "/" + "EJBProviderAdmin" + "/" ;
    new wso2.wsf.WSRequest(callURL,"getEJBConfigurations",body_xml,function(){
        wso2.wsf.Util.callbackhelper(this.req.responseXML,"ejb_provider_service.xsl",document.getElementById("divEJBProvider"));
    });
}

function showEJBServiceWizardStep1() {
    var tmpTransformationNode;
    if (window.XMLHttpRequest && !wso2.wsf.Util.isIE()) {
        tmpTransformationNode =
        document.implementation.createDocument("", "ejbDetailsTemplate", null);
    } else if (window.ActiveXObject) {
        tmpTransformationNode = new ActiveXObject("Microsoft.XmlDom");
        var sXml = "<ejbDetailsTemplate></ejbDetailsTemplate>";
        tmpTransformationNode.loadXML(sXml);
    }
    var objDiv = document.getElementById("divEJBProvider_step1");
    wso2.wsf.Util.processXML(tmpTransformationNode, "ejb_provider_wizard_step1.xsl", objDiv);
    wso2.wsf.Util.showOnlyOneMain(objDiv);
}


function showEJBServiceWizardStep2() {
    var tmpTransformationNode;
    if (window.XMLHttpRequest && !wso2.wsf.Util.isIE()) {
        tmpTransformationNode =
        document.implementation.createDocument("", "ejbDetailsTemplate", null);
    } else if (window.ActiveXObject) {
        tmpTransformationNode = new ActiveXObject("Microsoft.XmlDom");
        var sXml = "<ejbDetailsTemplate></ejbDetailsTemplate>";
        tmpTransformationNode.loadXML(sXml);
    }
    var objDiv = document.getElementById("divEJBProvider_step2");
    wso2.wsf.Util.processXML(tmpTransformationNode, "ejb_provider_wizard_step2.xsl", objDiv);
    wso2.wsf.Util.showOnlyOneMain(objDiv);
}

function showEJBServiceWizardStep3() {
    var tmpTransformationNode;
    if (window.XMLHttpRequest && !wso2.wsf.Util.isIE()) {
        tmpTransformationNode =
        document.implementation.createDocument("", "serviceGroupTemplate", null);
    } else if (window.ActiveXObject) {
        tmpTransformationNode = new ActiveXObject("Microsoft.XmlDom");
        var sXml = "<serviceGroupTemplate></serviceGroupTemplate>";
        tmpTransformationNode.loadXML(sXml);
    }
    var objDiv = document.getElementById("divEJBProvider_step3");
    wso2.wsf.Util.processXML(tmpTransformationNode, "ejb_provider_wizard_step3.xsl", objDiv);
    wso2.wsf.Util.showOnlyOneMain(objDiv);
}




function setDefaultServerValues(obj,document){
    	var selectedValue = obj[obj.selectedIndex].value;
	if(selectedValue == 'jboss'){
	    document.getElementById('providerUrl').value = 'jnp://localhost:1099';
	    document.getElementById('jndiContextClass').value = 'org.jnp.interfaces.NamingContextFactory';
	}else if (selectedValue == 'geronimo'){
	    document.getElementById('providerUrl').value = 'localhost:4201';
	    document.getElementById('jndiContextClass').value = 'org.openejb.client.JNDIContext';
	}else if (selectedValue == 'weblogic'){
	    document.getElementById('providerUrl').value = 't3://localhost:7001';
	    document.getElementById('jndiContextClass').value = 'weblogic.jndi.WLInitialContextFactory';
	}else{
	    document.getElementById('providerUrl').value = '';
	    document.getElementById('jndiContextClass').value = '';
	}
}

function toggleEJBAppServerConfigurationEditScreen(value){
	if(value == 'addNewEJBServer'){
		//disable existing
		document.getElementById('existingAppServerConfigurations').disabled = true;
		//enable add new
		document.getElementById('serverType').disabled = false;
		document.getElementById('providerUrl').disabled = false;
		document.getElementById('jndiContextClass').disabled = false;
		document.getElementById('userName').disabled = false;
		document.getElementById('password').disabled = false;
		document.getElementById('confirmPassword').disabled = false;
		document.getElementById('addApplicationServerButton').disabled = false;
		document.addEJBApplicationServerForm.appServerConfiguration1.checked = false;
		document.addEJBApplicationServerForm.appServerConfiguration2.checked = true;
		document.getElementById('ejbStep0NextButton').disabled = true;
	}else if (value == 'existingEJBServer'){
		//enable existing
		document.getElementById('existingAppServerConfigurations').disabled = false;
		//disable add new
		document.getElementById('serverType').disabled = true;
		document.getElementById('providerUrl').disabled = true;
		document.getElementById('jndiContextClass').disabled = true;
		document.getElementById('userName').disabled = true;
		document.getElementById('password').disabled = true;
		document.getElementById('confirmPassword').disabled = true;
		document.getElementById('addApplicationServerButton').disabled = true;
		document.addEJBApplicationServerForm.appServerConfiguration1.checked = true;
		document.addEJBApplicationServerForm.appServerConfiguration2.checked = false;
		if (existingAppServerConfigs > 0) {
			document.getElementById('ejbStep0NextButton').disabled = false;
		}
	}
}

function ejbProviderStep1DisableFields(){
	//disable all text/combo boxes at the screen load
	var radio2 = document.getElementById('appServerConfiguration2');
	if(existingAppServerConfigs != 0 && radio2.checked == false) {
		document.getElementById('serverType').disabled = true;
		document.getElementById('providerUrl').disabled = true;
		document.getElementById('jndiContextClass').disabled = true;
		document.getElementById('userName').disabled = true;
		document.getElementById('password').disabled = true;
		document.getElementById('confirmPassword').disabled = true;
		document.getElementById('addApplicationServerButton').disabled = true;
	
	} else if (existingAppServerConfigs != 0 && radio2.checked == true) {
		toggleEJBAppServerConfigurationEditScreen('existingEJBServer');
	} else if (existingAppServerConfigs == 0) {
		var radio = document.getElementById('appServerConfiguration1');
		radio.disabled=true;
		document.getElementById('existingAppServerConfigurations').disabled = true;
		if (existingAppServerConfigs == 0) {
			document.getElementById('ejbStep0NextButton').disabled = true;
		}
	} else if (radio2.checked == true) {
		document.getElementById('existingAppServerConfigurations').disabled = true;
	}
	
}

function setRemoteInterfaceClass(value){
	document.getElementById('remoteInterface').value = value;
}

function setHomeInterfaceClass(value){
	document.getElementById('homeInterface').value = value;
}