//This js deals with Data Services
var editDataSourceType;

var dataServiceObj = null;

var dataServiceQueryObj = null;

var curDataServiceName = null;

var dataServiceCurOpObj = null;

var curDataServiceOutputMappingType = null;

var newDataService = false;
var rootDocument;
var xslToReload;

var ds_collectdata = new Array();

var serviceSpecificName = null;

var newDataObject;

var csvSelectedColumnOrder = 0;

function addNewDataService() {
    stoppingRefreshingMethodsHook();
    newDataService = true;
    var browser = wso2.wsf.Util.getBrowser();
    //var newDataObject;

    switch (browser) {
        case "ie":
        case "ie7": {
            rootDocument = new ActiveXObject("Microsoft.XMLDOM");
            rootDocument.async = false;
            rootDocument.loadXML("<foo><return></return></foo>");
            newDataObject = rootDocument.getElementsByTagName("return")[0];
            break;
        }
        case "gecko":
        case "opera":
        case "safari": {
            rootDocument = document.implementation.createDocument("", "", null);
            newDataObject = rootDocument.createElement("return");
            break;
        }
        default: {
            wso2.wsf.Util.alertWarning("DOM document can not be created");
            return;
        }
    }

    var dataRowObj = rootDocument.createElement("data");
    var configObj = rootDocument.createElement("config");

    dataRowObj.appendChild(configObj);

    newDataObject.appendChild(dataRowObj);

    var tempDataServiceObj = rootDocument.createElement("temp");
    tempDataServiceObj.appendChild(newDataObject);
    xslToReload = "data_service.xsl";
    serviceSpecificName = null;
    addNewDataServiceEchoDataElement(tempDataServiceObj);
}

// TODO: note: this method will aquire meta info needed for DS from the server. 
function addNewDataServiceEchoDataElement(/*tempDataServiceObj*/) {
//    var dataServiceContents = prettyPrintDOMNode(tempDataServiceObj.getElementsByTagName("data").item(0), "", "    ", true);
    var body_xml = '<req:getDSMetaData xmlns:req="http://org.apache.axis2/xsd">\n' +
                   ' <arg0></arg0>\n' +
                   ' </req:getDSMetaData>\n';

    var callURL = serverURL + "/" + "DataServiceAdmin" ;

    new wso2.wsf.WSRequest(callURL, "getDSMetaData", body_xml, addNewDataServiceEchoDataElementCallback);
}

function addNewDataServiceEchoDataElementCallback() {

    /*TODO - First ds_step is 0 */
    dataServiceObj = this.req.responseXML.getElementsByTagName("dataWrapper")[0];
    //<dataWrapper><data>...</dataWrapper>
    var dbServerDataArray = this.req.responseXML.getElementsByTagName("dbServerData");
    for (var i = 0; i < dbServerDataArray.length; i++) {
        dataServiceObj.appendChild(dbServerDataArray[i]);
    }
    dataServiceObj.setAttribute("ds_step", 0);
    newDataService = true;
    refreshDataServiceScreen.call(this, false);
}


//TODO note: configure an existing DS
function configureDataservice(serviceName) {
    curDataServiceName = serviceName;
    newDataService = false;

    var browser = wso2.wsf.Util.getBrowser();

    switch (browser) {
        case "ie":
        case "ie7": {
            rootDocument = new ActiveXObject("Microsoft.XMLDOM");
            rootDocument.async = false;
            rootDocument.loadXML("<foo><return></return></foo>");
            break;
        }
        case "gecko":
        case "opera":
        case "safari": {
            rootDocument = document.implementation.createDocument("", "", null);
            break;
        }
        default: {
            wso2.wsf.Util.alertWarning("DOM document can not be created");
            return;
        }
    }

    getDataServiceContents(serviceName);
}

//TODO Note: get info for an existing DS
function getDataServiceContents(serviceName) {

    var body_xml = '<req:getDSMetaData xmlns:req="http://org.apache.axis2/xsd">\n' +
                   ' <arg0>' + serviceName + '</arg0>\n' +
                   ' </req:getDSMetaData>\n';

    var callURL = serverURL + "/" + "DataServiceAdmin";
    new wso2.wsf.WSRequest(callURL, "urn:getDSMetaData", body_xml, getDataServiceContentsCallback);
}

function getDataServiceContentsCallback() {

    dataServiceObj = this.req.responseXML.getElementsByTagName("dataWrapper")[0];
    //<dataWrapper><data>...</dataWrapper>
    var dbServerDataArray = this.req.responseXML.getElementsByTagName("dbServerData");
    for (var i = 0; i < dbServerDataArray.length; i++) {
        dataServiceObj.appendChild(dbServerDataArray[i]);
    }
    dataServiceObj.setAttribute("ds_step", 0);
    dataServiceObj.setAttribute("disable_name", true);
    xslToReload = "data_service.xsl";
    /*serviceSpecificName
            = this.req.responseXML.getElementsByTagName("data")[0].getAttribute("name");*/
    refreshDataServiceScreen.call(this);

}

//TODO Just a marker
function refreshDataServiceScreen(boolValue) {

    var objDiv = document.getElementById("divDataServiceDetails")
    var xsltHelperObj = new wso2.wsf.XSLTHelper();
    xsltHelperObj.transform(objDiv, dataServiceObj, "data_service.xsl", false, false, [["dsHeader",parseInt(dataServiceObj.getAttribute("ds_step")) +
                                                                                                   1]]);
    wso2.wsf.Util.showOnlyOneMain(objDiv);

    /*if (boolValue) {
        loadDatabaseUrlDriverComboBox();
    }*/
    _refreshDataServiceScreenHelper(boolValue);
}

//TODO
function configStepOne() {
    //Validation of the inputs
    var stat = ds_collectdata["stepOneValidation"]();
    if (!stat) {
        return;
    }
    refreshDataServiceScreen();
}

//TODO : note edit date source type
function editStepOne(dataSourceType) {
    if (!editDataSourceType) {
        if (!dataSourceType) {
            wso2.wsf.Util.alertWarning("Select Data Source first before editing");
            return;
        }
    }
    if (dataSourceType.length == 0) {
        wso2.wsf.Util.alertWarning("Select Data Source first before editing");
        return;
    }
    if (dataSourceType != null && dataSourceType != 0) {
        editDataSourceType = dataSourceType;
        dataServiceObj.setAttribute("dataSourceType", editDataSourceType);
    }
    var editPanelName = "Edit : " + editDataSourceType;
    showYUIPanel(editPanelName, yuiTransformer(dataServiceObj, "data_service_yui.xsl"), "500px", "step1PanelEdit", "divYUIPaneHolder");
    /*if (editDataSourceType == 'RDBMS') {
        loadDatabaseUrlDriverComboBox();
    }*/
}

//TODO note: test jdbc connection
function testJDBCConnection(driveClass, jdbcURL, username, password) {
    var body_xml = '<req:getDSMetaData xmlns:req="http://org.apache.axis2/xsd">\n' +
                   ' <driverClass>' + driveClass + '</driverClass>\n' +
                   ' <jdbcURL><![CDATA[' + jdbcURL + ']]></jdbcURL>\n' +
                   ' <username>' + username + '</username>\n' +
                   ' <password>' + password + '</password>\n' +
                   ' </req:getDSMetaData>\n';

    var callURL = serverURL + "/" + "DataServiceAdmin";
    new wso2.wsf.WSRequest(callURL, "urn:testJDBCConnection", body_xml, function() {
        var retNodeValue = this.req.responseXML.getElementsByTagName("return")[0].firstChild.nodeValue;
        wso2.wsf.Util.alertMessage(retNodeValue);
    });

}

//TODO: edit result element
function removeResultElement(queryId, eleName) {
    if ((eleName == null && eleName.length == 0)) {
        wso2.wsf.Util.alertWarning("Group by element or Row name is missing");
        return;
    }
    if (queryId == null || queryId.length == 0) {
        wso2.wsf.Util.alertWarning("Query id is required");
        return;
    }
    var qArray = dataServiceObj.getElementsByTagName('query');
    var qEle = null;
    for (var i = 0; i < qArray.length; i++) {
        if (queryId == qArray[i].getAttribute("id")) {
            qEle = qArray[i];
            break;
        }
    }
    if (!qEle) {
        wso2.wsf.Util.alertWarning("Query " + queryId +
                                   "is not pesisted. Thus, <result/> element would not be removed.");
        return;
    } else {
        var reArray = qEle.getElementsByTagName('result');
        var resultEle = null;
        for (i = 0; i < reArray.length; i++) {
            resultEle = reArray[i];
            break;
        }
        if (!resultEle) {
            wso2.wsf.Util.alertWarning("<result/> element is not available.");
            return;
        } else {
            qEle.removeChild(resultEle);
        }
    }
    var currentDiv = document.getElementById("divADDEditOutputMapping");
    currentDiv.style.display = "none";
    currentDiv.innerHTML = "";
    var divInnerHtml = yuiTransformer(dataServiceObj, "data_service_add_query.xsl", false, [["queryId",queryId]]);
    showYUIPanel("Add/Edit Query", divInnerHtml, "600px", "step2Inner13", "divDSAddQuery");

}

// TODO add a new query
function addNewQuery() {
    var divInnerHtml = yuiTransformer(dataServiceObj, "data_service_add_query.xsl");
    showYUIPanel("Add New Query", divInnerHtml, "600px", "step2Inner0", "divDSAddQuery");
}

//TODO addd new query param
//TODO : Note This object will be presisted iff query element is presit.
var transitParamEle = null;
var parentOfTransientParamEle = null;
var transitQueryEle = null;

function removeTransientElements() {
    try {
        if (transitQueryEle) {
            dataServiceObj.getElementsByTagName("data").item(0).removeChild(transitQueryEle);
            transitQueryEle = null;
        } else if (parentOfTransientParamEle && transitParamEle) {
            parentOfTransientParamEle.removeChild(transitParamEle);
            parentOfTransientParamEle = null;
            transitParamEle = null;
        }
    } catch(e) {
        // if the transient element is not available remove it.
    }
}

function addNewInputParam(queryId, sql) {
    if (queryId == null || queryId.length == 0) {
        wso2.wsf.Util.alertWarning("Query id is required prior adding an input mapping");
        return;
    }
    var qArray = dataServiceObj.getElementsByTagName('query');
    var qEle = null;
    for (var i = 0; i < qArray.length; i++) {
        if (qArray[i].getAttribute("id") == queryId) {
            qEle = qArray[i];
            break;
        }
    }
    if (!qEle) {
        qEle = rootDocument.createElement('query');
        qEle.setAttribute("id", queryId);
        dataServiceObj.getElementsByTagName("data").item(0).appendChild(qEle);
        transitQueryEle = qEle;
    }
    var sqlArray = qEle.getElementsByTagName('sql');
    var sqlEle = null;
    for (i = 0; i < sqlArray.length; i++) {
        sqlEle = sqlArray[i];
        break;
    }
    if (!sqlEle) {
        sqlEle = rootDocument.createElement("sql");
        sqlEle.appendChild(rootDocument.createTextNode(sql));
        qEle.appendChild(sqlEle);
    } else {
        sqlEle.removeChild(sqlEle.childNodes.item(0));
        sqlEle.appendChild(rootDocument.createTextNode(sql));
    }
    var divInnerHtml = yuiTransformer(dataServiceObj, "data_service_add_edit_input_mapping.xsl", false, [["queryId",queryId]]);
    showYUIPanel("Add New Input Param", divInnerHtml, "600px", "step2Inner3", "divADDEditInputMapping");
}

function addNewSpecificInputParam(queryId, paramName, obj,ordinalValue,inOutObj, oldInputParamName) {

    if (paramName == null || paramName.length == 0) {
        wso2.wsf.Util.alertWarning("Param name is required.");
        return;
    }

    var qArray = dataServiceObj.getElementsByTagName('query');
    var qEle = null;
    for (var i = 0; i < qArray.length; i++) {
        if (qArray[i].getAttribute("id") == queryId) {
            qEle = qArray[i];
            break;
        }
    }

    //TODO validation for param objects
    var paramArray = qEle.getElementsByTagName('param');
    var paramEle = null;

    if (paramName == oldInputParamName) {
        //Param is existing and its the old one
        for (i = 0; i < paramArray.length; i++) {
            if (paramName == paramArray[i].getAttribute('name')) {
                paramEle = paramArray[i];
                break;
            }
        }
        paramEle.removeAttribute('name');
        paramEle.removeAttribute('sqlType');
        paramEle.removeAttribute('type');
        paramEle.removeAttribute('ordinal');
        paramEle.setAttribute("name", paramName);
        paramEle.setAttribute("sqlType", obj[obj.selectedIndex].value);
        paramEle.setAttribute("type", inOutObj[inOutObj.selectedIndex].value);
        paramEle.setAttribute("ordinal", ordinalValue);
    } else {
        // not existing one or change one
        if (oldInputParamName == null || oldInputParamName.length == 0) {
            //new one;
            paramEle = rootDocument.createElement("param");
            paramEle.setAttribute("name", paramName);
            paramEle.setAttribute("sqlType", obj[obj.selectedIndex].value);
            paramEle.setAttribute("type", inOutObj[inOutObj.selectedIndex].value);
            paramEle.setAttribute("ordinal", ordinalValue);
            qEle.appendChild(paramEle);
        } else {
            // exsiting one
            for (i = 0; i < paramArray.length; i++) {
                if (paramName == paramArray[i].getAttribute('name')) {
                    paramEle = paramArray[i];
                    break;
                }
            }
            if (paramEle) {
                wso2.wsf.Util.alertWarning("Param already exist with the name " + paramName);
                return;
            } else {
                for (i = 0; i < paramArray.length; i++) {
                    if (oldInputParamName == paramArray[i].getAttribute('name')) {
                        paramEle = paramArray[i];
                        break;
                    }
                }
                qEle.removeChild(paramEle);
                paramEle = rootDocument.createElement("param");
                paramEle.setAttribute("name", paramName);
                paramEle.setAttribute("sqlType", obj[obj.selectedIndex].value);
                paramEle.setAttribute("type", inOutObj[inOutObj.selectedIndex].value);
                paramEle.setAttribute("ordinal", ordinalValue);
                qEle.appendChild(paramEle);
            }

        }
    }

    var currentDiv = document.getElementById("divADDEditInputMapping");
    currentDiv.style.display = "none";
    currentDiv.innerHTML = "";
    var divInnerHtml = yuiTransformer(dataServiceObj, "data_service_add_query.xsl", false, [["queryId",queryId]]);
    showYUIPanel("Add New Query", divInnerHtml, "600px", "step2Inner0", "divDSAddQuery");
}

// TODO edit an existing query 
function editExistingQuery(query) {
    var divInnerHtml = yuiTransformer(dataServiceObj, "data_service_add_query.xsl", false, [["queryId", query]]);
    showYUIPanel("Edit Query", divInnerHtml, "600px", "step2Inner1", "divDSAddQuery");
}

//TODO: note edit query
function editSpecificQuery(query, sql, type) {
    if (query == null || query.length == 0) {
        wso2.wsf.Util.alertWarning("Query id is required.");
        return;
    }

    var qArray = dataServiceObj.getElementsByTagName("query");
    var qEle;
    for (var i = 0; i < qArray.length; i++) {
        if (qArray[i].getAttribute("id") == query) {
            qEle = qArray[i];
            break;
        }
    }
    if (type == 'RDBMS' || type == 'JNDIDataSource') {
        if (sql == null || sql.length == 0) {
            wso2.wsf.Util.alertWarning("Sql statement is required.");
            return;
        }
        var eSql;
        var sqlArray = qEle.getElementsByTagName("sql");
        for (i = 0; i < sqlArray.length; i++) {
            eSql = sqlArray[i];
            break;
        }
        if (eSql) {
            eSql.removeChild(eSql.childNodes.item(0));
            eSql.appendChild(rootDocument.createCDATASection(sql));
        } else {
            eSql = rootDocument.createElement('sql');
            eSql.appendChild(rootDocument.createCDATASection(sql));
            qEle.appendChild(eSql);
        }
    } else if (type == 'EXCEL') {
        var eExcel;
        var excelArray = qEle.getElementsByTagName('excel');
        for (i = 0; i < excelArray.length; i++) {
            eExcel = excelArray[i];
            break;
        }
        if (eExcel) {
            qEle.removeChild(eExcel);
        }

        eExcel = rootDocument.createElement("excel");
        var workBookNameElement = rootDocument.createElement("workbookname");
        var startingRowElement = rootDocument.createElement("startingrow");
        var maxRowCountElement = rootDocument.createElement("maxrowcount");
        var hasHeaderElement = rootDocument.createElement("hasheader");

        var excelWBName = document.getElementById('txtExcelWorkbookName').value;
        var excelStartingRow = document.getElementById('txtExcelStartingRow').value;
        var excelMaxRowCount = document.getElementById('txtExcelMaxRowCount').value;
        if (excelWBName == null || excelWBName.length == 0) {
            wso2.wsf.Util.alertWarning("Workbook name is required");
            return;
        }
        if (excelStartingRow == null || excelStartingRow.length == 0) {
            wso2.wsf.Util.alertWarning("Strart reading from is required.");
            return;
        }
        if (excelMaxRowCount == null || excelMaxRowCount.length == 0) {
            wso2.wsf.Util.alertWarning("Rows to read is required.");
            return;
        }
        var obj = document.getElementById('txtExcelHeaderColumns');
        var hasHeaderValue = obj[obj.selectedIndex].value;
        if (hasHeaderValue == null || hasHeaderValue.length == 0) {
            wso2.wsf.Util.alertWarning("Status of the headers available is required.");
            return;
        }
        workBookNameElement.appendChild(rootDocument.createTextNode(excelWBName));
        startingRowElement.appendChild(rootDocument.createTextNode(excelStartingRow));
        maxRowCountElement.appendChild(rootDocument.createTextNode(excelMaxRowCount));
        hasHeaderElement.appendChild(rootDocument.createTextNode(hasHeaderValue));
       //add as children to excel element
        eExcel.appendChild(workBookNameElement);
        eExcel.appendChild(startingRowElement);
        eExcel.appendChild(maxRowCountElement);
        eExcel.appendChild(hasHeaderElement);

        qEle.appendChild(eExcel);
    } else if (type == 'CSV') {
        //do not do anything
    } else {
        wso2.wsf.Util.alertWarning("Data Source type : " + type + " is undefined.");
        return;
    }

    var rArray = qEle.getElementsByTagName('result');
    var rEle = null;
    for (i = 0; i < rArray.length; i++) {
        rEle = rArray[i];
        break;
    }
    var rgName = document.getElementById('txtDataServiceWrapElement').value;
    var rowName = document.getElementById('txtDataServiceRowName').value;
    var rowNamespace = document.getElementById('txtDataServiceRowNamespace').value;
    
    
    if (!rEle) {
        rEle = rootDocument.createElement("result");       
        if (!(rgName == null || rgName.length == 0)) {
           rEle.setAttribute("element", rgName);
        }
        if (!(rowName == null || rowName.length == 0)) {
           rEle.setAttribute("rowName", rowName);
        }                
        if (!(rowNamespace == null || rowNamespace.length == 0)) {
           rEle.setAttribute("defaultNamespace", rowNamespace);
        }else{
           rEle.removeAttribute("defaultNamespace");
        }
        //if rowname & row group name is null, do not set result element
        if(!(rEle.getAttribute("element") == null && rEle.getAttribute("rowName") == null)){
          qEle.appendChild(rEle);        
        }
    } else {
        rEle.removeAttribute("element");
        rEle.removeAttribute("rowName");
        rEle.removeAttribute("defaultNamespace");
        if (!(rgName == null || rgName.length == 0)) {
           rEle.setAttribute("element", rgName);
        }
        if (!(rowName == null || rowName.length == 0)) {
           rEle.setAttribute("rowName", rowName);
        }                        
        if (!(rowNamespace == null || rowNamespace.length == 0)) {
          rEle.setAttribute("defaultNamespace", rowNamespace);
        }        
        //if rowname & row group name is null, do not set result element
        if(rEle.getAttribute("element") == null || rEle.getAttribute("rowName") == null){
          qEle.removeChild(rEle);    
        }        
    }
    refreshDataServiceScreen();
}

//TODO : note: this will show the inner query explorer
//divInnerQueryExplorler_
function showInnerQueryExplorer(obj,idArray) {
    var divId;
    var divObj;
    for (var i = 0; i < idArray.length; i++) {
        divId = idArray[i];
        divObj = document.getElementById("divInnerQueryExplorler_"+divId);
        if (divObj) {
            divObj.style.display = "none";
        }
    }
    divId = obj[obj.selectedIndex].value;
    divObj = document.getElementById("divInnerQueryExplorler_" + divId);
    if (divObj) {
        divObj.style.display = "inline";
    }

}

//TODO : note : this will refresh the preview. 
function _refreshDataServiceScreenHelper(boolValue) {
    /*if (serviceSpecificName == null || serviceSpecificName == "") {
        var dsHDiv = document.getElementById('dataServiceHeader');
        showNewDataServiceHeader(dsHDiv, dataServiceObj.getAttribute("ds_step"));
    } else {
        showDataServiceHeader(document.getElementById('dataServiceHeader'), dataServiceObj.getAttribute("ds_step"));
    }*/

    /*if (dataServiceObj.getAttribute("ds_step") == "2") {
        displayAddDataServiceOperation();
        displayOperationWithParams();
    }*/

    if (!boolValue) {
        var sdPrevObj = document.getElementById("dsPreviewDiv");
        if (sdPrevObj) {
            var formattedObj = yuiTransformer(dataServiceObj.getElementsByTagName('data')[0], "data_service_preview_formatter.xsl");
            sdPrevObj.innerHTML = "";
            sdPrevObj.innerHTML = formattedObj;
            /*sdPrevObj.appendChild(document.createTextNode(
                    prettyPrintDOMNode(dataServiceObj.getElementsByTagName("data").item(0), "", "    ", true)));*/
        }
    }

}

function addEditDataServiceQueryDone() {
    var dataServiceSQL = document.getElementById('txtDataServiceSQL').value;
    var dataServiceWrapElement = document.getElementById('txtDataServiceWrapElement').value;
    var dataServiceRowName = document.getElementById('txtDataServiceRowName').value;

    var sqlObj = dataServiceQueryObj.getElementsByTagName("sql").item(0);
    sqlObj.removeChild(sqlObj.childNodes.item(0));
    sqlObj.appendChild(rootDocument.createTextNode(dataServiceSQL));

    var resultObj = dataServiceQueryObj.getElementsByTagName("result").item(0);
    resultObj.setAttribute("element", dataServiceWrapElement);
    resultObj.setAttribute("rowName", dataServiceRowName);


    // TODO fill this; get the info from server
    xslToReload = 'data_service.xsl';
    addNewDataServiceEchoDataElement(dataServiceObj);
    //refreshDataServiceScreen();
    //showGeneratedConfigFile();
}

function addConfigParameter() {
    var newParam = wso2.wsf.Util.getUserInput();
    if (newParam != null) {
        dataServiceObj.getElementsByTagName("config").item(0).appendChild(createPropelement(newParam[0], newParam[1]));
    }
    refreshDataServiceScreen();
}

function addNewConfigParameter() {
    var quDivObj = document.getElementById("divDSAddParam");
    wso2.wsf.Util.processXML(dataServiceObj, "data_service_add_config_param.xsl", quDivObj);
}

function add_param(validate) {
    if (document.getElementById("txtDataServiceParamName") != null)
    {
        var paramName = document.getElementById("txtDataServiceParamName").value;
        var paramValue = document.getElementById("txtDataServiceParamValue").value;
        if (paramName != "") {
            var isvalid = true;
            var paramset = dataServiceObj.getElementsByTagName("property");
            for (var i = 0; i < paramset.length; i++) {
                if (paramset[i].getAttribute("name") == paramName) {
                    if (!validate) {
                        wso2.wsf.Util.alertWarning("Parameter with the name \"" + paramName +
                                                   "\" already exists");
                        return false;
                    } else {
                        isvalid = false;
                    }
                }
            }
            if (isvalid) {
                dataServiceObj.getElementsByTagName("config")[0].appendChild(createPropelement(paramName, paramValue));
            }
        } else if (!validate) {
            wso2.wsf.Util.alertWarning("Parameter name is required in order to add a configuration parameter");
            return false;
        }
    }
    return true;
}

function add_ds_param() {

    ds_collectdata["ds_step0"](true);
    if (!add_param()) {
        return;
    }
    refreshDataServiceScreen();
}

function remove_ds_param(paramName) {

    var properties = dataServiceObj.getElementsByTagName("config")[0].getElementsByTagName("property");
    for (var i = 0; i < properties.length; i++) {
        if (properties[i].getAttribute("name") == paramName) {
            dataServiceObj.getElementsByTagName("config")[0].removeChild(properties[i]);
        }
    }
    refreshDataServiceScreen();
}

function addNewInputMapping() {
    var newParam = wso2.wsf.Util.getUserInputCustum("Please enter the Input Mapping name", "Please enter the SQL Type", false);
    if (newParam != null) {
        dataServiceQueryObj.appendChild(createInputMappingElement(newParam[0], newParam[1]));
    }
    refresEditDataServiceQueryScreen();
}


function addDataServiceOMElementDone() {

    var dataServiceOMElementName = document.getElementById("txtDataServiceOMElementName").value;
    var dataServiceOMColumnName = document.getElementById("txtDataServiceOMColumnName").value;

    if (dataServiceOMElementName == "") {
        wso2.wsf.Util.alertWarning("Name for an output mapping is required");
        return;
    }

//    if(editingOPMapping != "") {
    var mappings = dataServiceQueryObj.getElementsByTagName("element");
    for (var i = 0; i < mappings.length; i++) {
        if (mappings[i].getAttribute("column") == editingOPMapping && editingOPMapping != "") {
            mappings[i].parentNode.removeChild(mappings[i]);
        } else {
            if (mappings[i].getAttribute("column") == dataServiceOMColumnName) {
                wso2.wsf.Util.alertWarning("Output mapping for the specified column already exists");
                return false;
            }
        }
    }
//    }

    dataServiceQueryObj.getElementsByTagName("result").item(0).appendChild(createOutputMappingElement(dataServiceOMElementName, dataServiceOMColumnName));
    refresEditDataServiceQueryScreen();
//	refreshWizardScreen('divDataServiceAddOutput','data_service_add_query_output_mapping.xsl',dataServiceQueryObj,'dataServiceOutputMappingHeader');
}

function addDataServiceOMQueryDone() {

    var dsQueries = document.getElementById("cmbDataServiceQueryId");
    var dataServiceQueryId = dsQueries.options[dsQueries.selectedIndex].value;

//    if(editingOPMapping != "") {
    var mappings = dataServiceQueryObj.getElementsByTagName("call-query");
    for (var i = 0; i < mappings.length; i++) {
        if (mappings[i].getAttribute("href") == editingOPMapping && editingOPMapping != "") {
            mappings[i].parentNode.removeChild(mappings[i]);
        } else {
            if (mappings[i].getAttribute("href") == dataServiceQueryId) {
                wso2.wsf.Util.alertWarning("Output mapping for the query id \"" +
                                           dataServiceQueryId + "\" already present");
                return false;
            }
        }
    }

    var callQuery = createOutputMappingQuery(dataServiceQueryId);
    var dsqueries = dataServiceObj.getElementsByTagName("query");
    for (var j = 0; j < dsqueries.length; j++) {
        if (dsqueries[j].getAttribute("id") == dataServiceQueryId) {
            var queryparams = dsqueries[j].getElementsByTagName("param");
            for (var k = 0; k < queryparams.length; k++) {
                var qparaname = queryparams[k].getAttribute("name");
                callQuery.appendChild(createWithParamElement(qparaname, document.getElementById("mapping_for_" +
                                                                                                qparaname).value));
            }
        }
    }
//    }
    //    alert(dsQueries.selectedIndex + " " + dataServiceQueryId)
    //    var mappings = dataServiceQueryObj.getElementsByTagName("call-query");
    //    for(var i=0; i<mappings.length; i++) {
    //        if(mappings[i].getAttribute("href") == dataServiceQueryId) {
    //            wso2.wsf.Util.alertWarning("Output mapping for the query id \"" + dataServiceQueryId + "\" already present");
    //            return false;
    //        }
    //    }

    dataServiceQueryObj.getElementsByTagName("result").item(0).appendChild(callQuery);
//    dataServiceQueryObj.getElementsByTagName("result").item(0).appendChild(createOutputMappingQuery(dataServiceQueryId));
    refresEditDataServiceQueryScreen();
//	refreshWizardScreen('divDataServiceAddOutput','data_service_add_query_output_mapping.xsl',dataServiceQueryObj,'dataServiceOutputMappingHeader');
}

function dataserviceOMTypeSelected(outputType) {
    if (outputType == 'OutputElement') {
        document.getElementById('divOMElement').style.display = "inline";
        document.getElementById('divOMQuery').style.display = "none";
    } else if (outputType == 'Query') {
        document.getElementById('divOMElement').style.display = "none";
        document.getElementById('divOMQuery').style.display = "inline";
        displayOperationWithParams();
    }
    curDataServiceOutputMappingType = outputType;
}

function displayAddDataServiceOperation() {
    //	dataServiceCurOpObj = null;
    var opDivObj = document.getElementById("divDSAddOperation");
    wso2.wsf.Util.processXML(dataServiceObj, "data_service_add_operation.xsl", opDivObj);
//    wso2.wsf.Util.showOnlyOneMain(opDivObj);
    //    showDataServiceOperationsHeader(document.getElementById('dataServiceAddOperationHeader'));
}

function displayOperationWithParams() {
    //	dataServiceCurOpObj = null;
    dataServiceObj.setAttribute("ds_op_query_id", document.getElementById("cmbDataServiceQueryId").value);
    var opDivObj = document.getElementById("divDSOperationParams");
    wso2.wsf.Util.processXML(dataServiceObj, "data_service_operation_params.xsl", opDivObj);
//    wso2.wsf.Util.showOnlyOneMain(opDivObj);
    //    showDataServiceOperationsHeader(document.getElementById('dataServiceAddOperationHeader'));
}


function addDataServiceOperation() {
    var opName = document.getElementById("txtDataServiceOpName").value;
    var queryName = document.getElementById("cmbDataServiceQueryId").value;

    if (opName != "") {

        if (dataServiceCurOpObj == null) {
            var dsops = dataServiceObj.getElementsByTagName("operation");
            for (var i = 0; i < dsops.length; i++) {
                if (dsops[i].getAttribute("name") == opName) {
                    wso2.wsf.Util.alertWarning("Operation with the name \"" + opName +
                                               "\" already present");
                    return false;
                }
            }
            var opObj = createOpElement(opName, queryName);
            var dsqueries = dataServiceObj.getElementsByTagName("query");
            for (var j = 0; j < dsqueries.length; j++) {
                if (dsqueries[j].getAttribute("id") == queryName) {
                    var queryparams = dsqueries[j].getElementsByTagName("param");
                    for (var k = 0; k < queryparams.length; k++) {
                        var qparaname = queryparams[k].getAttribute("name");
                        opObj.getElementsByTagName("call-query")[0].appendChild(createWithParamElement(qparaname, document.getElementById("mapping_for_" +
                                                                                                                                          qparaname).value));
                    }
                }
            }
            dataServiceObj.getElementsByTagName("data").item(0).appendChild(opObj);
        } else {
            var callQueryObj = dataServiceCurOpObj.getElementsByTagName("call-query").item(0);
            callQueryObj.setAttribute("href", queryName);
            dataServiceCurOpObj.setAttribute("name", opName);
            var withparams = callQueryObj.getElementsByTagName("with-param");
            var k = 0;
            while (withparams.length != 0) {
                callQueryObj.removeChild(withparams[k]);
                k++;
            }

            var dsqueries = dataServiceObj.getElementsByTagName("query");
            for (var j = 0; j < dsqueries.length; j++) {
                if (dsqueries[j].getAttribute("id") == queryName) {
                    var queryparams = dsqueries[j].getElementsByTagName("param");
                    for (var k = 0; k < queryparams.length; k++) {
                        var qparaname = queryparams[k].getAttribute("name");
                        callQueryObj.appendChild(createWithParamElement(qparaname, document.getElementById("mapping_for_" +
                                                                                                           qparaname).value));
                    }
                }
            }
        }
    } else {
        wso2.wsf.Util.alertWarning("Name of an operation is required");
        return false;
    }
//	addNewDataServiceEchoDataElement(dataServiceObj);
    refreshDataServiceScreen();
    dataServiceCurOpObj = null;
}


//TODO : note edit operation params
function editDataServiceOperation(operationName) {
    var divInnerHtml = yuiTransformer(dataServiceObj, "data_service_add_edit_operations.xsl", false, [["operationName", operationName]]);
    showYUIPanel("Edit Operation", divInnerHtml, "600px", "step2Inner10", "divDSAddEditOperations");

    divInnerHtml =
    yuiTransformerObj(dataServiceObj, "data_service_add_edit_operatoin_query.xsl", false, [["operationName", operationName]]);
    var obj = document.getElementById("showOperationParameterMappingDivId");
    obj.innerHTML = "";
    obj.appendChild(divInnerHtml);
}

// TODO note deleting a operation
function dataServiceRemoveOperation(operationName) {

    var msgStat = confirm("Do you want to delete the operation : " + operationName);
    if (!msgStat) {
        return;
    }

    var opArray = dataServiceObj.getElementsByTagName('operation');
    var opEle = null;
    for (var i = 0; i < opArray.length; i++) {
        if (operationName == opArray[i].getAttribute('name')) {
            opEle = opArray[i];
            break;
        }
    }
    dataServiceObj.getElementsByTagName('data')[0].removeChild(opEle);
    refreshDataServiceScreen();
}

//TODO : note showOnlyRequiredDSOp
function showOnlyRequiredDSOp(queryId, operationName) {
    if (operationName == null || operationName.length == 0) {
        wso2.wsf.Util.alertWarning("Operation name is required before selecting \n" +
                                   "the quaries to be applied.");
        return;
    }
    var divInnerHtml = yuiTransformerObj(dataServiceObj, "data_service_add_edit_operatoin_query.xsl", false, [["queryId", queryId],["editOperationName",operationName]]);
    var obj = document.getElementById("showOperationParameterMappingDivId");
    obj.innerHTML = "";
    obj.appendChild(divInnerHtml);
}


function deployDataService() {
    var dataServiceContents = wso2.wsf.Util.xmlSerializerToString(dataServiceObj.getElementsByTagName("data")[0]);
//    alert('XML == > ' + wso2.wsf.Util.xmlSerializerToString(dataServiceObj.getElementsByTagName("data")[0]));
//    var dataServiceName = dataServiceObj.getElementsByTagName('data')[0].getAttribute('name');
    var body_xml = '<req:saveDataServiceContents xmlns:req="http://org.apache.axis2/xsd">\n' +
//                   ' <arg0>' + dataServiceName + '</arg0>\n' +
                   ' <dataWrapper>' + dataServiceContents + '</dataWrapper>\n' +
                   ' </req:saveDataServiceContents>\n';
//    alert(body_xml);
    var callURL = serverURL + "/" + "DataServiceAdmin";
    new wso2.wsf.WSRequest(callURL, "urn:saveDataServiceContents", body_xml, deployDataServiceCallback);
}


function deployDataServiceCallback() {
    showServiceInitializer();
}

function createOpElement(opName, queryName) {
    var opObj = rootDocument.createElement("operation");
    opObj.setAttribute("name", opName);
    var queryObj = rootDocument.createElement("call-query")
    queryObj.setAttribute("href", queryName);
    opObj.appendChild(queryObj);
    return opObj;
}

function createWithParamElement(queryParamName, paramName) {
    var opObj = rootDocument.createElement("with-param");
    if (paramName != null && paramName != "") {
        opObj.setAttribute("name", paramName);
    } else {
        opObj.setAttribute("name", queryParamName);
    }
    opObj.setAttribute("query-param", queryParamName);
    return opObj;
}


function createPropelement(propName, propValue) {
    var propObj = rootDocument.createElement("property");
    propObj.appendChild(rootDocument.createTextNode(propValue));
    propObj.setAttribute("name", propName);
    return propObj;
}

function createInputMappingElement(elementName, sqlType) {
    var imElement = rootDocument.createElement("param");
    imElement.setAttribute("name", elementName);
    imElement.setAttribute("sqlType", sqlType);
    return imElement;
}


function createOutputMappingElement(elementName, dataColumn) {
    var imElement = rootDocument.createElement("element");
    imElement.setAttribute("name", elementName);
    imElement.setAttribute("column", dataColumn);
    return imElement;
}

function createOutputMappingQuery(queryName) {
    var imElement = rootDocument.createElement("call-query");
    imElement.setAttribute("href", queryName);
    return imElement;
}

function querySQLOnChange(sqlStatement, form) {
    var sqlObj = dataServiceQueryObj.getElementsByTagName("sql").item(0);
    sqlObj.removeChild(sqlObj.childNodes.item(0));
    sqlObj.appendChild(rootDocument.createTextNode(sqlStatement));

    if (sqlStatement.length > 0) {
        changeOutputMappingFieldStatus(false);
     	//if sql contains ?, then need to enable input parameter entry box
        if (sqlStatement.indexOf('?') > -1) {
            document.getElementById('name').disabled = false;
            document.getElementById('sqlType').disabled = false;
            document.getElementById('addInputParamMappingButton').disabled = false;
        }
    } else {
        changeOutputMappingFieldStatus(true);
    }
}

function disableInputMappingFields() {
    if (dataServiceObj.getAttribute("dataSourceType") == "RDBMS"
            || dataServiceObj.getAttribute("dataSourceType") == "JNDIDataSource") {
        var sqlStatement = document.getElementById("txtDataServiceSQL").value;
    	 //if sql contains ?, then need to enable input parameter entry box
        if (sqlStatement.indexOf('?') == -1) {
            document.getElementById('name').disabled = true;
            document.getElementById('sqlType').disabled = true;
            document.getElementById('addInputParamMappingButton').disabled = true;
        }
    }
}

function disableOutputMappingFields() {
    var disableFields = false;
    if ("RDBMS" == dataServiceObj.getAttribute("dataSourceType")
            || "JNDIDataSource" == dataServiceObj.getAttribute("dataSourceType")) {
        var sqlStatement = document.getElementById("txtDataServiceSQL").value;
  	   //if sql field contains something, output mappings should be enabled 
        if (sqlStatement.length == 0) {
            disableFields = true;
        }
    } else if ("CSV" == dataServiceObj.getAttribute("dataSourceType")
            || "EXCEL" == dataServiceObj.getAttribute("dataSourceType")) {
        //for CSV & EXCEL only queryId field is visible
        var queryId = document.getElementById("txtDataServiceQueryId").value;
        if (queryId.length == 0) {
            disableFields = true;
        }
    }
    changeOutputMappingFieldStatus(disableFields);
}

function changeOutputMappingFieldStatus(disabled) {
    document.getElementById('txtDataServiceWrapElement').disabled = disabled;
    document.getElementById('txtDataServiceRowName').disabled = disabled;
    document.getElementById('cmbDataServiceOMType').disabled = disabled;
     //default selection is Element,following fields are shown for element
    document.getElementById('txtDataServiceOMElementName').disabled = disabled;
    document.getElementById('txtDataServiceOMColumnName').disabled = disabled;
    document.getElementById('addOutputParamMappingButton').disabled = disabled;
    document.getElementById('addQueryButton').disabled = disabled;
    document.getElementById('addQueryRestButton').disabled = disabled;
}


function queryWENOnChange(WEN) {
    var resultObj = dataServiceQueryObj.getElementsByTagName("result").item(0);
    resultObj.setAttribute("element", WEN);
}

function queryRNOnChange(RN) {
    var resultObj = dataServiceQueryObj.getElementsByTagName("result").item(0);
    resultObj.setAttribute("rowName", RN);
}

function newQueryIdOnChange(queryId) {
    var queryIdTrimmed = queryId.replace(/^\s+|\s+$/g, '') ;
    if (queryIdTrimmed.length == 0) {
        //user has emptied the queryId
        changeOutputMappingFieldStatus(true);
    } else {
        if ("CSV" == dataServiceObj.getAttribute("dataSourceType")) {
            changeOutputMappingFieldStatus(false);
        }
    }
    dataServiceQueryObj.setAttribute("id", queryId);
}

/*function showGeneratedConfigFile() {
    var finalScreenHTML = '<h4><div id="divGeneratedConfigHeader"></div></h4>' +
                          '<div><label>Review and Deploy Dataservice</label></div>' +
                          '<div id="formset">' +
                          '<form>' +
                          '<fieldset style="border:none;">' +
                          '<div>' +
                          '<textarea rows="30" cols="80" id="txtDataServiceReviewBox"></textarea>' +
                          '</div><p>&nbsp;</p>' +
                          '<div>' +
                          '<input type="button" value="Deploy" onclick="javascript:deployDataService();return false;"/>' +
                          '</div>' +
                          '</fieldset>' +
                          '</form>' +
                          '</div>' +
                          '</fieldset>';
    var dataServiceConfigDiv = document.getElementById("divDataServiceDisplayConfig");
    dataServiceConfigDiv.innerHTML = finalScreenHTML;
    document.getElementById("txtDataServiceReviewBox").value =
    prettyPrintDOMNode(dataServiceObj.getElementsByTagName("data").item(0), "", "    ", true);
    showNewDataServiceHeader(document.getElementById('divGeneratedConfigHeader'));
    wso2.wsf.Util.showOnlyOneMain(dataServiceConfigDiv);
}*/

// TODO : note: toggling

function changeToNextMapping(queryId, mappingObj) {
    var mappingValue = mappingObj[mappingObj.selectedIndex].value;
    if (mappingValue == 'Element') {
        document.getElementById('divOMElement').style.display = "inline";
        document.getElementById('divOMQuery').style.display = "none";
    } else if (mappingValue == 'Query') {
        document.getElementById('divOMElement').style.display = "none";
        document.getElementById('divOMQuery').style.display = "inline";
        //First time showing for new services
        var objCmb = document.getElementById('cmbDataServiceQueryId');
        var cmbValue = objCmb[objCmb.selectedIndex].value;
        var divObj = document.getElementById('divInnerQueryExplorler_'+cmbValue);
        if (divObj) {
            divObj.style.display = "inline";
        }
    }
}

//TODO : refresh parent query container
/*
*  data_service_add_query.xsl
*  divDSAddQuery
*  Add New Query
*
*/
function refreshParentQueryContainer(/*must*/queryId, /*must*/xslName, /*must*/parentDivId, /*must*/title) {
    var divInnerHtml = yuiTransformer(dataServiceObj, xslName, false, [["queryId",queryId]]);
    showYUIPanel(title, divInnerHtml, "600px", "step2Inner13", parentDivId);

}

//TODO : note: adding and editing for output params
function addEditSpecificOutputMapping(queryId, mappingObj, oldOutputFieldName, cqmObj) {
    var qArray = dataServiceObj.getElementsByTagName('query');
    var queryEle = null;
    for (var i = 0; i < qArray.length; i++) {
        if (queryId == qArray[i].getAttribute('id')) {
            queryEle = qArray[i];
            break;
        }
    }
    var resultArray = queryEle.getElementsByTagName('result');
    var resultEle = null;
    for (i = 0; i < resultArray.length; i++) {
        resultEle = resultArray[i];
        break;
    }
    var mappingValue = mappingObj[mappingObj.selectedIndex].value;
    if (mappingValue == 'Element' || mappingValue == 'Attribute') {
        var name = document.getElementById('txtDataServiceOMElementName').value;
        var column = document.getElementById('txtDataServiceOMColumnName').value;
        if (name == null || name.length == 0) {
            wso2.wsf.Util.alertWarning("Output field name is required");
            return;
        }
        if (column == null || column.length == 0) {
            wso2.wsf.Util.alertWarning("SQL column name is required");
            return;
        }
        var eEleArray = null;
        if (mappingValue == 'Element') {
            eEleArray = resultEle.getElementsByTagName('element');
        } else if (mappingValue == 'Attribute') {
            eEleArray = resultEle.getElementsByTagName('attribute');
        } else {
            wso2.wsf.Util.alertWarning("Mapping Type is not available");
            return;
        }
        var eEle1 = null;
        if (name == oldOutputFieldName) {
            //same elements and in the editing stage
            for (i = 0; i < eEleArray.length; i++) {
                if (eEleArray[i].getAttribute('name') == name) {
                    eEle1 = eEleArray[i];
                    break;
                }
            }
            eEle1.removeAttribute("name");
            eEle1.removeAttribute("column");
            eEle1.setAttribute("name", name);
            eEle1.setAttribute("column", column);
        } else {
            //different element; thus this could be a new element or old one
            if (oldOutputFieldName == null || oldOutputFieldName.length == 0) {
                // aha new element
                for (i = 0; i < eEleArray.length; i++) {
                    if (eEleArray[i].getAttribute('name') == name) {
                        eEle1 = eEleArray[i];
                        break;
                    }
                }
                if (eEle1) {
                    wso2.wsf.Util.alertWarning("Element already exist with the name " + name);
                    return;
                }
                if (mappingValue == 'Element') {
                   eEle1 = rootDocument.createElement("element");
                } else {
                   eEle1 = rootDocument.createElement("attribute");
                }
                eEle1.setAttribute("name", name);
                eEle1.setAttribute("column", column);
                resultEle.appendChild(eEle1);
            } else {
                for (i = 0; i < eEleArray.length; i++) {
                    if (eEleArray[i].getAttribute('name') == name) {
                        eEle1 = eEleArray[i];
                        break;
                    }
                }
                if (eEle1) {
                    wso2.wsf.Util.alertWarning("Element already exist with the name " + name);
                    return;
                } else {
                    for (i = 0; i < eEleArray.length; i++) {
                        if (eEleArray[i].getAttribute('name') == oldOutputFieldName) {
                            eEle1 = eEleArray[i];
                            break;
                        }
                    }
                    resultEle.removeChild(eEle1);
                    if (mappingValue == 'Element') {
                        eEle1 = rootDocument.createElement("element");
                    } else {
                        eEle1 = rootDocument.createElement("attribute");
                    }
                    eEle1.setAttribute("name", name);
                    eEle1.setAttribute("column", column);
                    resultEle.appendChild(eEle1);
                }

            }

        }
    } else if (mappingValue == 'Query') {
        var obj = document.getElementById('cmbDataServiceQueryId');
        var objValue = obj[obj.selectedIndex].value;
        var cqArray = resultEle.getElementsByTagName("call-query");
        var tEle = null;
        for (i = 0; i < cqArray.length; i++) {
            if (cqArray[i].getAttribute("href") == objValue) {
                tEle = cqArray[i];
                break;
            }
        }
        if (!tEle) {
            tEle = rootDocument.createElement("call-query");
            tEle.setAttribute("href", objValue);
            resultEle.appendChild(tEle);
        } else {
            resultEle.removeChild(tEle);
            tEle = rootDocument.createElement("call-query");
            tEle.setAttribute("href", objValue);
            resultEle.appendChild(tEle);
        }
        var withParamObj = cqmObj[objValue];
        for(var o in withParamObj) {
            var n = o;
            var v = withParamObj[n];
            var withParamEle = rootDocument.createElement("with-param");
            tEle.appendChild(withParamEle);
            if (v && v.length != 0) {
                withParamEle.setAttribute("name", v);
            } else {
                withParamEle.setAttribute("name", n);
            }
            withParamEle.setAttribute("query-param", n);
        }

    }
    var currentDiv = document.getElementById("divADDEditOutputMapping");
    currentDiv.style.display = "none";
    currentDiv.innerHTML = "";
    var divInnerHtml = yuiTransformer(dataServiceObj, "data_service_add_query.xsl", false, [["queryId",queryId]]);
    showYUIPanel("Add/Edit Query", divInnerHtml, "600px", "step2Inner13", "divDSAddQuery");
}

//TODO : note : add new output mapping. 
function addNewOutPutMappingForQuery(queryId, sql, type) {
    if (!queryId) {
        wso2.wsf.Util.alertWarning("Required queryId before adding output mapping.");
        return;
    }
    var qArray = dataServiceObj.getElementsByTagName('query');
    var queryEle = null;
    for (var i = 0; i < qArray.length; i++) {
        if (queryId == qArray[i].getAttribute('id')) {
            queryEle = qArray[i];
            break;
        }
    }
    if (!queryEle) {
        queryEle = rootDocument.createElement("query");
        queryEle.setAttribute("id", queryId);
        dataServiceObj.getElementsByTagName("data").item(0).appendChild(queryEle);
    }

    if (type == "RDBMS" || type == "JNDIDataSource") {
        var sqlArray = queryEle.getElementsByTagName('sql');
        var sqlEle = null;
        for (i = 0; i < sqlArray.length; i++) {
            sqlEle = sqlArray[i];
            break;
        }
        if (!sqlEle) {
            sqlEle = rootDocument.createElement("sql");
            sqlEle.appendChild(rootDocument.createTextNode(sql));
            queryEle.appendChild(sqlEle);
        } else {
            sqlEle.removeChild(sqlEle.childNodes.item(0));
            sqlEle.appendChild(rootDocument.createTextNode(sql));
        }
    } else if (type == "EXCEL") {
        //filling the missing pieces
        var eExcel;
        var excelArray = queryEle.getElementsByTagName('excel');
        for (i = 0; i < excelArray.length; i++) {
            eExcel = excelArray[i];
            break;
        }
        if (eExcel) {
            queryEle.removeChild(eExcel);
        }

        eExcel = rootDocument.createElement("excel");
        var workBookNameElement = rootDocument.createElement("workbookname");
        var startingRowElement = rootDocument.createElement("startingrow");
        var maxRowCountElement = rootDocument.createElement("maxrowcount");
        var hasHeaderElement = rootDocument.createElement("hasheader");

        var excelWBName = document.getElementById('txtExcelWorkbookName').value;
        var excelStartingRow = document.getElementById('txtExcelStartingRow').value;
        var excelMaxRowCount = document.getElementById('txtExcelMaxRowCount').value;

        var obj = document.getElementById('txtExcelHeaderColumns');
        var hasHeaderValue = obj[obj.selectedIndex].value;
        if (hasHeaderValue == null || hasHeaderValue.length == 0) {
            wso2.wsf.Util.alertWarning("Status of the headers available is required.");
            return;
        }
        workBookNameElement.appendChild(rootDocument.createTextNode(excelWBName));
        startingRowElement.appendChild(rootDocument.createTextNode(excelStartingRow));
        maxRowCountElement.appendChild(rootDocument.createTextNode(excelMaxRowCount));
        hasHeaderElement.appendChild(rootDocument.createTextNode(hasHeaderValue));
       //add as children to excel element
        eExcel.appendChild(workBookNameElement);
        eExcel.appendChild(startingRowElement);
        eExcel.appendChild(maxRowCountElement);
        eExcel.appendChild(hasHeaderElement);

        queryEle.appendChild(eExcel);
    }

    var resultArray = queryEle.getElementsByTagName('result');
    var resultEle = null;
    for (i = 0; i < resultArray.length; i++) {
        resultEle = resultArray[i];
        break;
    }
    if (!resultEle) {
        resultEle = rootDocument.createElement("result");
        queryEle.appendChild(resultEle);
    }
    var elementName = document.getElementById("txtDataServiceWrapElement").value;
    var rowName = document.getElementById("txtDataServiceRowName").value;
    var rowNamespace = document.getElementById("txtDataServiceRowNamespace").value;
    //eg. INSERT,UPDATE,SELECT,etc
    //Only interested in INSERT & UPDATE
    var firstPart = sql.substring(0,6); 
    if(firstPart.toLowerCase() == "insert" || firstPart.toLowerCase() == "update"){
     //grouped by element & row name are not needed here
    }else{
      if (elementName == null || elementName.length == 0) {
        wso2.wsf.Util.alertMessage("Grouped by element is required");
        return;
      }
      if (rowName == null || rowName.length == 0) {
        wso2.wsf.Util.alertMessage("Row name is required");
        return;
      }    
    }
    resultEle.setAttribute("element", elementName);
    resultEle.setAttribute("rowName", rowName);
    resultEle.setAttribute("defaultNamespace", rowNamespace);
    //TODO : fix this
    var divInnerHtml = yuiTransformer(dataServiceObj, "data_service_add_edit_result_mapping.xsl", false, [["queryId",queryId]]);
    showYUIPanel("Add New Output Mapping ", divInnerHtml, "600px", "step2Inner10", "divADDEditOutputMapping");


}

//TODO : note edit query output mapping
function editQueryOutputMappingElement(queryId, eleName, colName) {
    var divInnerHtml = yuiTransformer(dataServiceObj, "data_service_add_edit_result_mapping.xsl", false, [["queryId",queryId],["eleName",eleName],["colName", colName]]);
    showYUIPanel("Edit Output Mapping ", divInnerHtml, "600px", "step2Inner10", "divADDEditOutputMapping");
}

//TODO: note edit query output mapping attribute
function editQueryOutputMappingAttribute(queryId, atName, colName) {
    var divInnerHtml = yuiTransformer(dataServiceObj, "data_service_add_edit_result_mapping.xsl", false, [["queryId",queryId],["atName",atName],["colName", colName]]);
    showYUIPanel("Edit Output Mapping ", divInnerHtml, "600px", "step2Inner10", "divADDEditOutputMapping");

}

function editQueryOutputMappingCallQuery(queryId, queryHref) {
    var divInnerHtml = yuiTransformer(dataServiceObj, "data_service_add_edit_result_mapping.xsl", false, [["queryId",queryId],["queryHref", queryHref]]);
    showYUIPanel("Add New Output Mapping ", divInnerHtml, "600px", "step2Inner10", "divADDEditOutputMapping");
}

// TODO: note; To final step 
function stepTwoToSetpFinal() {
    dataServiceObj.setAttribute("ds_step", parseInt(dataServiceObj.getAttribute("ds_step")) + 1);
    refreshDataServiceScreen();
}

// TODO : note add new operaiton. 
function addNewOperationForDataService() {
    var divInnerHtml = yuiTransformer(dataServiceObj, "data_service_add_edit_operations.xsl");
    showYUIPanel("Add New Operation", divInnerHtml, "600px", "step2Inner10", "divDSAddEditOperations");

    divInnerHtml = yuiTransformerObj(dataServiceObj, "data_service_add_edit_operatoin_query.xsl");
    var obj = document.getElementById("showOperationParameterMappingDivId");
    obj.innerHTML = "";
    obj.appendChild(divInnerHtml);
}

//TODO : note add new operation
function addNewOperationForDataServiceOK(paramObj, status, oldOperationName) {
    var queryName = null;
    var params = new Object();
    for (var param in paramObj) {
        if (param == "queryNameForOperation1234UUURRX") {
            queryName = paramObj[param];
            continue;
        }
        params[param] = paramObj[param];
    }
    var operationName = document.getElementById('operationNameTextId').value;
    if (operationName == null || operationName.length == 0) {
        wso2.wsf.Util.alertMessage("Operation name is required");
        return;
    }
    //TODO validation for existing operaiton
    var opArray = dataServiceObj.getElementsByTagName('operation');
    var tmpOpEle = null;
    if (operationName == oldOperationName) {
        //This is an exiting operation and going to change its @
        for (var i = 0; i < opArray.length; i++) {
            if (operationName == opArray[i].getAttribute('name')) {
                tmpOpEle = opArray[i];
                break;
            }
        }
        if (tmpOpEle) {
            dataServiceObj.getElementsByTagName('data')[0].removeChild(tmpOpEle);
        }
    } else {
        if (oldOperationName == null || oldOperationName.length == 0) {
            //new operation do not do anything just let it go
        } else {
            //existing operation
            for (var i = 0; i < opArray.length; i++) {
                if (operationName == opArray[i].getAttribute('name')) {
                    tmpOpEle = opArray[i];
                    break;
                }
            }
            if (tmpOpEle) {
                wso2.wsf.Util.alertWarning("There already exist an operation named " + operationName + ".\n" +
                                           "The given operation name will cause a conflict.");
                return;
            } else {
                //removeing the old one
                for (var i = 0; i < opArray.length; i++) {
                    if (oldOperationName == opArray[i].getAttribute('name')) {
                        tmpOpEle = opArray[i];
                        break;
                    }
                }
                dataServiceObj.getElementsByTagName('data')[0].removeChild(tmpOpEle);
                tmpOpEle = rootDocument.createElement("operation");
            }

        }
    }

    if (status == "FALSE") {
        var opEle = rootDocument.createElement("operation");
        opEle.setAttribute("name", operationName);
        var cqEle = rootDocument.createElement("call-query");
        cqEle.setAttribute("href", queryName);
        opEle.appendChild(cqEle);
        dataServiceObj.getElementsByTagName("data").item(0).appendChild(opEle);
    }
    if (status == "TRUE") {
        opEle = rootDocument.createElement("operation");
        opEle.setAttribute("name", operationName);
        cqEle = rootDocument.createElement("call-query");
        cqEle.setAttribute("href", queryName);
        opEle.appendChild(cqEle);
        dataServiceObj.getElementsByTagName("data").item(0).appendChild(opEle);
        for (var k in params) {
            var n = k;
            var v = params[k];
            var wpEle = rootDocument.createElement("with-param");
            if (v == null || v.length == 0) {
                wpEle.setAttribute("name", n);
                wpEle.setAttribute("query-param", n);
            } else {
                wpEle.setAttribute("name", v);
                wpEle.setAttribute("query-param", n);
            }
            cqEle.appendChild(wpEle);
        }

    }
    refreshDataServiceScreen();
}

//TODO : note remove query output mapping
function removeQueryOutputMapping(queryId, mappingType, commonName) {

    var msgStat = confirm("Do you want to delete the output mapping : " + commonName);
    if (!msgStat) {
        return;
    }

    var qArray = dataServiceObj.getElementsByTagName('query');
    var queryEle = null;
    for (var i = 0; i < qArray.length; i++) {
        if (queryId == qArray[i].getAttribute('id')) {
            queryEle = qArray[i];
            break;
        }
    }

    var resultArray = queryEle.getElementsByTagName('result');
    var resultEle = null;
    for (i = 0; i < resultArray.length; i++) {
        resultEle = resultArray[i];
        break;
    }

    if (mappingType == "Element") {
        var eArray = resultEle.getElementsByTagName('element');
        var eEle = null;
        for (i = 0; i < eArray.length; i++) {
            if (eArray[i].getAttribute('name') == commonName) {
                eEle = eArray[i];
                break;
            }
        }
        resultEle.removeChild(eEle);
    } else if (mappingType == "Query") {
        var cqArray = resultEle.getElementsByTagName('call-query');
        var cqEle = null;
        for (i = 0; i < cqArray.length; i++) {
            if (cqArray[i].getAttribute('href') == commonName) {
                cqEle = cqArray[i];
                break;
            }
        }
        resultEle.removeChild(cqEle);
    } else if (mappingType == "Attribute") {
       var atArray = resultEle.getElementsByTagName('attribute');
        var atEle = null;
        for (i = 0; i < eArray.length; i++) {
            if (atArray[i].getAttribute('name') == commonName) {
                atEle = atArray[i];
                break;
            }
        }
        resultEle.removeChild(atEle);
    }
    var currentDiv = document.getElementById("divADDEditOutputMapping");
    currentDiv.style.display = "none";
    currentDiv.innerHTML = "";
    var divInnerHtml = yuiTransformer(dataServiceObj, "data_service_add_query.xsl", false, [["queryId",queryId]]);
    showYUIPanel("Add New Query", divInnerHtml, "600px", "step2Inner13", "divDSAddQuery");

}

//TODO : note: validate query string value. 
function validateQueryTextValue(obj) {
    var queries = dataServiceObj.getElementsByTagName("query");
    for (var i = 0; i < queries.length; i++) {
        if (obj.value == queries[i].getAttribute("id")) {
            wso2.wsf.Util.alertWarning("Query by the name : " + obj.value + " already exist. \n" +
                                       "Type different value for query id");
            obj.value = "";
            break;
        }
    }
}

//TODO : note: removing the transient querty
function removeTransientQuery(queryId) {
    if (queryId) {
        var qArray = dataServiceObj.getElementsByTagName('query');
        var queryEle = null;
        for (var i = 0; i < qArray.length; i++) {
            if (queryId == qArray[i].getAttribute('id')) {
                queryEle = qArray[i];
                break;
            }
        }
        if (queryEle) {
            dataServiceObj.removeChild(queryEle);
        }
    }

}

//TOdO : note: validate all operation names
function validateOperationNameValue(obj) {
    var operations = dataServiceObj.getElementsByTagName("operation");
    for (var i = 0; i < operations.length; i++) {
        if (obj.value == operations[i].getAttribute("name")) {
            wso2.wsf.Util.alertWarning("Operation by the name : " + obj.value + " already exist. \n" +
                                       "Type different value for operation name.");
            obj.value = "";
            break;
        }
    }

}

//TODO note: add a new query with the ok button 
function addNewQueryOK(queryId) {

    if (queryId == null || queryId.length == 0) {
        wso2.wsf.Util.alertWarning("Query id is required.");
        return;
    }

    var qArray = dataServiceObj.getElementsByTagName('query');
    var queryEle;
    for (var i = 0; i < qArray.length; i++) {
        if (queryId == qArray[i].getAttribute('id')) {
            wso2.wsf.Util.alertWarning("A query already exist with the id : " + queryId);
            return;
        }
    }
    queryEle = rootDocument.createElement("query");
    queryEle.setAttribute("id", queryId);

    //TODO: reslut
    var rArray = queryEle.getElementsByTagName('result');
    var rEle = null;
    for (i = 0; i < rArray.length; i++) {
        rEle = rArray[i];
        break;
    }
    var rgName = document.getElementById('txtDataServiceWrapElement').value;
    var rowName = document.getElementById('txtDataServiceRowName').value;
    var rowNamespace = document.getElementById('txtDataServiceRowNamespace').value;

    if (!rEle) {
        rEle = rootDocument.createElement("result");       
        if (!(rgName == null || rgName.length == 0)) {
           rEle.setAttribute("element", rgName);
        }
        if (!(rowName == null || rowName.length == 0)) {
           rEle.setAttribute("rowName", rowName);
        }                
        if (!(rowNamespace == null || rowNamespace.length == 0)) {
           rEle.setAttribute("defaultNamespace", rowNamespace);
        }else{
           rEle.removeAttribute("defaultNamespace");
        }
        //if rowname & row group name is null, do not set result element
        if(!(rEle.getAttribute("element") == null && rEle.getAttribute("rowName") == null)){
          qEle.appendChild(rEle);        
        }
    } else {
        rEle.removeAttribute("element");
        rEle.removeAttribute("rowName");
        rEle.removeAttribute("defaultNamespace");
        if (!(rgName == null || rgName.length == 0)) {
           rEle.setAttribute("element", rgName);
        }
        if (!(rowName == null || rowName.length == 0)) {
           rEle.setAttribute("rowName", rowName);
        }                        
        if (!(rowNamespace == null || rowNamespace.length == 0)) {
          rEle.setAttribute("defaultNamespace", rowNamespace);
        }        
        //if rowname & row group name is null, do not set result element
        if(rEle.getAttribute("element") == null || rEle.getAttribute("rowName") == null){
          qEle.removeChild(rEle);    
        }        
    }
    

    if ("EXCEL" == dataServiceObj.getAttribute("dataSourceType")) {
        if (rgName == null || rgName.length == 0) {
          wso2.wsf.Util.alertWarning("Group by element is required");
          return;
        }
        if (rowName == null || rowName.length == 0) {
          wso2.wsf.Util.alertWarning("Row name element is required");
          return;
        }
    
        //sqlEle.appendChild(rootDocument.createTextNode("UseSheet=0:StartReadingFromRow=1"));
        //create excel elements
        var excelElement = rootDocument.createElement("excel");
        var workBookNameElement = rootDocument.createElement("workbookname");
        var startingRowElement = rootDocument.createElement("startingrow");
        var maxRowCountElement = rootDocument.createElement("maxrowcount");
        var hasHeaderElement = rootDocument.createElement("hasheader");

       //append text box values
        //TODO validation for inputs.

        var excelWBName = document.getElementById('txtExcelWorkbookName').value;
        var excelStartingRow = document.getElementById('txtExcelStartingRow').value;
        var excelMaxRowCount = document.getElementById('txtExcelMaxRowCount').value;
        if (excelWBName == null || excelWBName.length == 0) {
            wso2.wsf.Util.alertWarning("Workbook name is required");
            return;
        }
        if (excelStartingRow == null || excelStartingRow.length == 0) {
            wso2.wsf.Util.alertWarning("Strart reading from is required.");
            return;
        }
        if (excelMaxRowCount == null || excelMaxRowCount.length == 0) {
            wso2.wsf.Util.alertWarning("Rows to read is required.");
            return;
        }
        var obj = document.getElementById('txtExcelHeaderColumns');
        var hasHeaderValue = obj[obj.selectedIndex].value;
        if (hasHeaderValue == null || hasHeaderValue.length == 0) {
            wso2.wsf.Util.alertWarning("Status of the headers available is required.");
            return;
        }

        workBookNameElement.appendChild(rootDocument.createTextNode(excelWBName));
        startingRowElement.appendChild(rootDocument.createTextNode(excelStartingRow));
        maxRowCountElement.appendChild(rootDocument.createTextNode(excelMaxRowCount));
        hasHeaderElement.appendChild(rootDocument.createTextNode(hasHeaderValue));
       //add as children to excel element
        excelElement.appendChild(workBookNameElement);
        excelElement.appendChild(startingRowElement);
        excelElement.appendChild(maxRowCountElement);
        excelElement.appendChild(hasHeaderElement);

        queryEle.appendChild(excelElement);


    } else if ("RDBMS" == dataServiceObj.getAttribute("dataSourceType")
            || "JNDIDataSource" == dataServiceObj.getAttribute("dataSourceType")) {
        var sqlEle = rootDocument.createElement("sql");
        var sqlEleTextNode = rootDocument.createCDATASection((document.getElementById('txtDataServiceSQL').value));
        sqlEle.appendChild(sqlEleTextNode);
        queryEle.appendChild(sqlEle);
    } else if ("CSV" == dataServiceObj.getAttribute("dataSourceType")) {
        if (rgName == null || rgName.length == 0) {
          wso2.wsf.Util.alertWarning("Group by element is required");
          return;
        }
        if (rowName == null || rowName.length == 0) {
          wso2.wsf.Util.alertWarning("Row name element is required");
          return;
        }    
    }

    /*var resultEle = rootDocument.createElement("result");
    resultEle.setAttribute("element", "");
    resultEle.setAttribute("rowName", "");
    queryEle.appendChild(resultEle);*/
    dataServiceObj.getElementsByTagName("data").item(0).appendChild(queryEle);

    refreshDataServiceScreen();
}
var dataServiceNewQuery = false;

function addDataServiceQuery() {
    dataServiceNewQuery = true;

    var queryEle = rootDocument.createElement("query");


    if ("EXCEL" == dataServiceObj.getAttribute("dataSourceType")) {
        queryEle.setAttribute("id", "");
	   //sqlEle.appendChild(rootDocument.createTextNode("UseSheet=0:StartReadingFromRow=1"));
        //create excel elements
        var excelElement = rootDocument.createElement("excel");
        var workBookNameElement = rootDocument.createElement("workbookname");
        var hasHeaderElement = rootDocument.createElement("hasheader");
        var startingRowElement = rootDocument.createElement("startingrow");
        var maxRowCountElement = rootDocument.createElement("maxrowcount");

       //append text box values
        workBookNameElement.appendChild(rootDocument.createTextNode(""));
        maxRowCountElement.appendChild(rootDocument.createTextNode(""));
        hasHeaderElement.appendChild(rootDocument.createTextNode(""));
        startingRowElement.appendChild(rootDocument.createTextNode(""));

       //add as children to excel element
        excelElement.appendChild(workBookNameElement);
        excelElement.appendChild(hasHeaderElement);
        excelElement.appendChild(startingRowElement);
        excelElement.appendChild(maxRowCountElement);

        queryEle.appendChild(excelElement);


    } else if ("RDBMS" == dataServiceObj.getAttribute("dataSourceType")
            || "JNDIDataSource" == dataServiceObj.getAttribute("dataSourceType")) {
        var sqlEle = rootDocument.createElement("sql");
        queryEle.setAttribute("id", "");
        sqlEle.appendChild(rootDocument.createTextNode(""));
        queryEle.appendChild(sqlEle);
    } else if ("CSV" == dataServiceObj.getAttribute("dataSourceType")) {
        queryEle.setAttribute("id", "");
    }

    var resultEle = rootDocument.createElement("result");
    resultEle.setAttribute("element", "");
    resultEle.setAttribute("rowName", "");
    queryEle.appendChild(resultEle);
    dataServiceObj.getElementsByTagName("data").item(0).appendChild(queryEle);
    dataServiceQueryObj = queryEle;
    refresEditDataServiceQueryScreen();
}

/*function editDataServiceQuery(queryName) {
    dataServiceQueryObj =
    getNodeWithPropertyFromCollection(dataServiceObj.getElementsByTagName("query"), "id", queryName);
    refresEditDataServiceQueryScreen();
}*/


function refresEditDataServiceQueryScreen() {
    editingIPMapping = "";
    editingOPMapping = "";
    //removeEmptyQueries();
    // TODO this is a inner div from data_service.xsl.
    var quDivObj = document.getElementById("divDSAddQuery");
    //TODO allow this from YUI 
    //    wso2.wsf.Util.processXML(dataServiceQueryObj, "data_service_add_query.xsl", quDivObj);

    //    showDataServiceQueryHeader(document.getElementById('dataServiceAddQueryHeader'));
    //	wso2.wsf.Util.showOnlyOneMain(document.getElementById('divDataServiceAddQuery'));
}

var editingIPMapping = "";

/*function edit_ds_ip_mapping(mappingName, mappingValue) {

    document.dataServiceAddQueryForm.name.value = mappingName;
    document.dataServiceAddQueryForm.sqlType.value = mappingValue;
    editingIPMapping = mappingName;
}*/

//TODO : Note: This method will remove an assinged query from tree iff it is not referenced.
// TODO : Thus, first reference need to be removed.
function removeDSQuery(queryId) {
    var msgStat = confirm("Do you want to delete the query : " + queryId);
    if (!msgStat) {
        return;
    }
    //    add_query(true);
    var queries = dataServiceObj.getElementsByTagName("query");
    var references = dataServiceObj.getElementsByTagName("call-query");

    for (var i = 0; i < references.length; i++) {
        if (references[i].getAttribute("href") == queryId) {
            wso2.wsf.Util.alertMessage("Can not delete the query with id \"" + queryId +
                                       "\". There are operations refering to this query");
            return;
        }
    }

    for (i = 0; i < queries.length; i++) {
        if (queries[i].getAttribute("id") == queryId) {
            dataServiceObj.getElementsByTagName("data")[0].removeChild(queries[i]);
        }
    }
    refreshDataServiceScreen();

}

function getNodeWithPropertyFromCollection(objCollection, propName, propValue) {
    for (var i = 0; i < objCollection.length; i++) {
        var curr = objCollection.item(i);
        var currPropValue = getAttbute(propName, curr);
        if (currPropValue == propValue) {
            return curr;
        }
    }
	// Return null if no node is found with the given attribute.
    return null;
}

function stepTwoToStepOne() {
    dataServiceObj.setAttribute("ds_step", parseInt(dataServiceObj.getAttribute("ds_step")) - 1);
    refreshDataServiceScreen();
}

function setpFinalToSetpTwo() {
    dataServiceObj.setAttribute("ds_step", parseInt(dataServiceObj.getAttribute("ds_step")) - 1);
    refreshDataServiceScreen();
}


// TODO This is the first "Next >"
function stepOneToStepTwo() {
    var dst = dataServiceObj.getAttribute("dataSourceType");
    var dsn = dataServiceObj.getAttribute("disable_name");
    if (!(dsn =='true')) {
        if (newDataService && !dst) {
            wso2.wsf.Util.alertWarning("Data Source must be provided in order to proceed");
            return;
        }
    }
    //This will first validate the inputs before stepping to the next section of the wizard
    if (!ds_collectdata["ds_step" + dataServiceObj.getAttribute("ds_step")]()) {
        return;
    }

    if (dataServiceObj.getAttribute("ds_step") == "0") {
        //var ds_dataSourceType = document.getElementById("databaseSourceType").value;
        add_param(true);
    }

    dataServiceObj.setAttribute("ds_step", parseInt(dataServiceObj.getAttribute("ds_step")) + 1);
    setDataSourceType();
    //TODO following will add an empty Query
    refreshDataServiceScreen();
}

function ds_back() {
    ds_collectdata["ds_step" + dataServiceObj.getAttribute("ds_step")](true);
//        refreshDataServiceScreen();
    //        return;
    //    }
    dataServiceObj.setAttribute("ds_step", parseInt(dataServiceObj.getAttribute("ds_step")) - 1);
    refreshDataServiceScreen();
}

//TODO add quary
function add_ds_query() {
    add_query();
    refreshDataServiceScreen();
}

/*
function remove_query_op_mapping(href) {

    var mappings = dataServiceQueryObj.getElementsByTagName("call-query");
    for (var i = 0; i < mappings.length; i++) {
        if (mappings[i].getAttribute("href") == href) {
            mappings[i].parentNode.removeChild(mappings[i]);
        }
    }

    refresEditDataServiceQueryScreen();
}
*/

function remove_element_op_mapping(column) {

    var mappings = dataServiceQueryObj.getElementsByTagName("element");
    for (var i = 0; i < mappings.length; i++) {
        if (mappings[i].getAttribute("column") == column) {
            mappings[i].parentNode.removeChild(mappings[i]);
        }
    }

    refresEditDataServiceQueryScreen();
}

var editingOPMapping = "";

/*function edit_query_op_mapping(href) {

    editingOPMapping = href;
    document.getElementById("cmbDataServiceOMType").options[1].selected = true;
    dataserviceOMTypeSelected("Query");
    var optionset = document.getElementById("cmbDataServiceQueryId").options;
    for (var i = 0; i < optionset.length; i++) {
        if (optionset[i].value == href) {
            optionset[i].selected = true;
        }
    }

    var dsqueries = dataServiceObj.getElementsByTagName("query");
    for (var i = 0; i < dsqueries.length; i++) {
        if (dsqueries[i].getAttribute("id") == href) {
            var withparams = dataServiceQueryObj.getElementsByTagName("with-param");
            for (var j = 0; j < withparams.length; j++) {
                document.getElementById("mapping_for_" +
                                        withparams[j].getAttribute("query-param")).value =
                withparams[j].getAttribute("name");
            }
        }
    }
}

function edit_element_op_mapping(name, column) {

    editingOPMapping = column;
    document.getElementById("cmbDataServiceOMType").options[0].selected = true;
    dataserviceOMTypeSelected("OutputElement");
    document.getElementById("txtDataServiceOMElementName").setAttribute("value", name);
    document.getElementById("txtDataServiceOMColumnName").setAttribute("value", column);
}*/


//TODO
//TODO
//TODO Step one validation
ds_collectdata["stepOneValidation"] = function () {
    if (newDataService) {
        //validate data source type
        var databaseSourceTypeObj = document.getElementById("databaseSourceType");
        var ds_dataSourceType = databaseSourceTypeObj[databaseSourceTypeObj.selectedIndex].value;
        var valid;
        if ("RDBMS" == ds_dataSourceType) {
            var databaseServerType = document.getElementById("databaseServerType").value;
            var driver = document.getElementById("org.wso2.ws.dataservice.driver").value;
            var protocol = document.getElementById("org.wso2.ws.dataservice.protocol").value;

            if (databaseServerType == " # ") {
                //TODO no value in returning here 
                //                wso2.wsf.Util.alertWarning("Please select a Database type.");
                //                return false;
            }
            if (driver == null || driver.replace(/^\s+|\s+$/g, "") == "") {
                wso2.wsf.Util.alertWarning("Please enter a correct driver class.");
                return false;
            }
            if (protocol == null || protocol.replace(/^\s+|\s+$/g, "") == "") {
                wso2.wsf.Util.alertWarning("Please enter a correct JDBC Url.");
                return false;
            }
        } else if ("CSV" == ds_dataSourceType) {
            valid = validateCSVConfigurationScreen();
            if (! valid) {
                return false;
            }
        } else if ("EXCEL" == ds_dataSourceType) {
            var val = document.getElementById("excel_datasource").value;
            if (val == null || val.replace(/^\s+|\s+$/g, "") == "") {
                wso2.wsf.Util.alertWarning("Please select a correct MS Excel file location.");
                return false;
            }
        } else if ("JNDIDataSource" == ds_dataSourceType) {
            valid = validateJNDIConfigurationScreen();
            if (! valid) {
                return false;
            }
        }
    }
    var properties = dataServiceObj.getElementsByTagName("property");
    for (var i = 0; i < properties.length; i++) {
        if (document.getElementById(properties[i].getAttribute("name")) != null) {
            if (properties[i].childNodes.length) {
                properties[i].removeChild(properties[i].childNodes[0]);
            }
            properties[i].appendChild(rootDocument.createTextNode(//"<![CDATA["
                    document.getElementById(properties[i].getAttribute("name")).value));//+ "]]>"));
        }
    }
    return true;
}

// TODO javascript functios for validation. This should follow Java naming conventions.
//TODO
//TODO
//TODO
ds_collectdata["ds_step0"] = function (validate) {
    if (newDataService) {
        //validate service name
        var ds_name = document.getElementById("dataServiceName").value;
        if (ds_name != null && ds_name.length != 0) {
            dataServiceObj.getElementsByTagName("data")[0].setAttribute("name", ds_name);
        } else if (!validate) {
            wso2.wsf.Util.alertWarning("Name of the data service must be provided in order to proceed");
            return false;
        }
    }
    return true;
}

function validateJNDIConfigurationScreen() {
    var contextClass = document.getElementById('jndi_context_class').value;
    contextClass = contextClass.replace(/^\s+|\s+$/g, '');

    var providerUrl = document.getElementById('jndi_provider_url').value;
    providerUrl = providerUrl.replace(/^\s+|\s+$/g, '');

    var resourceName = document.getElementById('jndi_resource_name').value;
    resourceName = resourceName.replace(/^\s+|\s+$/g, '');


    if (contextClass == '') {
        wso2.wsf.Util.alertWarning("Please enter JNDI Context Class.");
        return false;
    }
    if (providerUrl == '') {
        wso2.wsf.Util.alertWarning("Please enter provider url.");
        return false;
    }
    if (resourceName == '') {
        wso2.wsf.Util.alertWarning("Please JNDI resource name.");
        return false;
    }
    return true;
}

function validateCSVConfigurationScreen() {
    var resourcePath = document.getElementById('csv_datasource').value;
    resourcePath = resourcePath.replace(/^\s+|\s+$/g, '');

    var hasHeader = document.getElementById('csv_hasheader').value;
    hasHeader = hasHeader.replace(/^\s+|\s+$/g, '');

    var startingrow = document.getElementById('csv_startingrow').value;
    startingrow = startingrow.replace(/^\s+|\s+$/g, '');

    var maxRowCount = document.getElementById('csv_maxrowcount').value;
    maxRowCount = startingrow.replace(/^\s+|\s+$/g, '');

    if (resourcePath == '') {
        wso2.wsf.Util.alertWarning("Please enter CSV File Location.");
        return false;
    }
    if (hasHeader == '') {
        wso2.wsf.Util.alertWarning("Please select value for Header Available field.");
        return false;
    }
    if (startingrow == '') {
        wso2.wsf.Util.alertWarning("Please enter numeric value for starting Row.");
        return false;
    }
    if (maxRowCount == '') {
        wso2.wsf.Util.alertWarning("Please enter numeric value for Max Row Count.");
        return false;
    }

    return true;
}


ds_collectdata["ds_step1"] = function collect_ds_query_data(validate) {

    var retval = add_query(true);

    if (dataServiceObj.getElementsByTagName("query").length == 0 && !validate) {
        wso2.wsf.Util.alertWarning("Data service needs at least one Query to proceed");
        return false;
    }

    return retval;
}

function add_query(validate) {
    var queryId = document.getElementById("txtDataServiceQueryId").value;
    var isValidQuery = true;
    if (queryId != "") {
        dataServiceQueryObj.setAttribute("id", queryId);
    } else if (!validate) {
        wso2.wsf.Util.alertWarning("Missing value for required field Query ID");
        return false;
    } else {
        isValidQuery = false;
    }

    //removes query elements with id=""
    removeEmptyQueries();

    var dataSourceType = dataServiceObj.getAttribute("dataSourceType");
    if ("RDBMS" == dataSourceType || "JNDIDataSource" == dataSourceType) {
        var sql = document.getElementById("txtDataServiceSQL").value;
        if (isValidQuery) {
            dataServiceObj.getElementsByTagName("data")[0].appendChild(dataServiceQueryObj);
        } else if (!validate) {
            return false;
        }
    } else if ("EXCEL" == dataSourceType) {
    }
    return true;
}

/*
 *  removes query elements with id=""
 */
function removeEmptyQueries() {
    var queries = dataServiceObj.getElementsByTagName("query");
    for (var i = 0; i < queries.length; i++) {
        if (queries[i].getAttribute("id") == "") {
            dataServiceObj.getElementsByTagName("data")[0].removeChild(queries[i]);
        }
    }
}

ds_collectdata["ds_step2"] = function collect_ds_operation_data() {

    return true;
}

//TODO : note remove a mapping.
function removeDSInputMapping(queryId, paramName) {

    var msgStat = confirm("Do you want to delete the parameter : " + paramName);
    if (!msgStat) {
        return;
    }

    var qArray = dataServiceObj.getElementsByTagName('query');
    var qEle = null;
    for (var i = 0; i < qArray.length; i++) {
        if (qArray[i].getAttribute("id") == queryId) {
            qEle = qArray[i];
            break;
        }
    }

    var paramArray = qEle.getElementsByTagName('param');
    var paramEle = null;
    for (i = 0; i < paramArray.length; i++) {
        if (paramName == paramArray[i].getAttribute('name')) {
            paramEle = paramArray[i];
            break;
        }
    }
    qEle.removeChild(paramEle);
    var divInnerHtml = yuiTransformer(dataServiceObj, "data_service_add_query.xsl", false, [["queryId",queryId]]);
    showYUIPanel("Add New Query", divInnerHtml, "600px", "step2Inner0", "divDSAddQuery");

}

function editDSInputMapping(queryId, paramName, sqlType,inOutType,ordinal) {
    var divInnerHtml = yuiTransformer(dataServiceObj, "data_service_add_edit_input_mapping.xsl", false, [["queryId",queryId],["paramName",paramName],["paramSqlType",sqlType],["paramInOutType",inOutType],["paramOrdinal",ordinal],["edit","true"]]);
    showYUIPanel("Edit Input Param", divInnerHtml, "600px", "step2Inner4", "divADDEditInputMapping");
}


/*
function remove_ds_ip_mapping(mappingName) {

    remove_ip_mapping(mappingName);
    refresEditDataServiceQueryScreen();
}
*/

function remove_ip_mapping(mappingName) {

    var mappings = dataServiceObj.getElementsByTagName("param");
    for (var i = 0; i < mappings.length; i++) {
        if (mappings[i].getAttribute("name") == mappingName) {
            mappings[i].parentNode.removeChild(mappings[i]);
        }
    }
}

function remove_ds_op_mapping(mappingName) {

    remove_op_mapping(mappingName);
    refresEditDataServiceQueryScreen();
}

function remove_op_mapping(mappingName) {

    var mappings = dataServiceObj.getElementsByTagName("param");
    for (var i = 0; i < mappings.length; i++) {
        if (mappings[i].getAttribute("name") == mappingName) {
            mappings[i].parentNode.removeChild(mappings[i]);
        }
    }
}

function addQueryElementToDS() {
    dataServiceNewQuery = true;

    var queryEle = rootDocument.createElement("query");
    queryEle.setAttribute("id", "");

    var sqlEle = rootDocument.createElement("sql");
    sqlEle.appendChild(rootDocument.createTextNode(""));

    var resultEle = rootDocument.createElement("result");
    resultEle.setAttribute("element", "element");
    resultEle.setAttribute("rowName", "rowName");

    queryEle.appendChild(sqlEle);

    dataServiceQueryObj = queryEle;
	//addInputParamToQuery();
    //addNewInputParamMapping("","");

    dataServiceQueryObj.appendChild(resultEle);


    dataServiceObj.getElementsByTagName("data").item(0).appendChild(dataServiceQueryObj);
    refresEditDataServiceQueryScreen();
}

function addInputParamToQuery(queryId) {
    //alert(queryId);
    var paramEle = rootDocument.createElement("param");
    paramEle.setAttribute("name", "");
    paramEle.setAttribute("sqlType", "");
    dataServiceQueryObj.appendChild(paramEle);

    var tmp = dataServiceObj.getElementsByTagName("data").item(0).getElementsByTagName("query");
    for (i = 0; i < tmp.length; i += 1) {
        //alert(tmp[i].getAttribute("id"));

    }
    if (tmp.length > 0) {
        //alert(wso2.wsf.Util.xmlSerializerToString(tmp));
    }
}


function updateDSWithNewQuery() {
    var dataServiceSQL = document.getElementById('txtDataServiceSQL').value;
	//var dataServiceWrapElement = document.getElementById('txtDataServiceWrapElement').value;
    //var dataServiceRowName = document.getElementById('txtDataServiceRowName').value;

    var sqlObj = dataServiceQueryObj.getElementsByTagName("sql").item(0);
    sqlObj.removeChild(sqlObj.childNodes.item(0));
    sqlObj.appendChild(rootDocument.createTextNode(dataServiceSQL));

	//var resultObj = dataServiceQueryObj.getElementsByTagName("result").item(0);
    //resultObj.setAttribute("element", dataServiceWrapElement);
    //resultObj.setAttribute("rowName", dataServiceRowName);

    xslToReload = 'data_service_add_query.xsl';
    addNewDataServiceEchoDataElement(dataServiceObj);
}

function addNewInputParamMapping(param, sqlType) {
    if (param != "" && sqlType != "- select the type -") {
        var params = dataServiceQueryObj.getElementsByTagName("param");
        for (var i = 0; i < params.length; i++) {
            if (editingIPMapping != "" && params[i].getAttribute("name") == editingIPMapping) {
                params[i].parentNode.removeChild(params[i]);
            } else {
                if (params[i].getAttribute("name") == param) {
                    wso2.wsf.Util.alertWarning("Input mapping with the name \"" + param +
                                               "\" already present");
                    return false;
                }
            }
        }
        dataServiceQueryObj.appendChild(createInputMappingElement(param, sqlType));
    } else {
        wso2.wsf.Util.alertWarning("Both Name & SQL Type are mandatory for a parameter");
        return false;
    }
    refresEditDataServiceQueryScreen();
}

function refreshWizardScreen(divId, xslFile, domObject) {
    var quDivObj = document.getElementById(divId);
    wso2.wsf.Util.processXML(domObject, xslFile, quDivObj);
}


function showDSQueryOutputMappingsScreen() {
    ds_collectdata["ds_step1"]();
    refreshWizardScreen('divAddDSQueryOPMapping', 'data_service_add_query_output_mapping.xsl', dataServiceObj);
}


function loadDatabaseUrlDriverComboBox() {
    var body_xml = '<ns1:getDatabaseUrlDriverList  xmlns:ns1="http://org.apache.axis2/xsd">\n' +
                   ' </ns1:getDatabaseUrlDriverList>\n';

    var callURL = serverURL + "/" + "DataServiceAdmin" + "/" ;
    new wso2.wsf.WSRequest(callURL, "getDatabaseUrlDriverList", body_xml, loadDatabaseServerListCallback);
}

function loadDatabaseServerListCallback() {
    var comboToLoad = document.getElementById('databaseServerType');
    var data = this.req.responseXML;
    var rets = data.getElementsByTagName("return");
    var len = rets.length;
    var count;
    for (count = 0; count < len; count++) {
        comboToLoad.options[count] =
        new Option(rets[count].getElementsByTagName("serverId").item(0).firstChild.nodeValue);
        comboToLoad.options[count].text =
        rets[count].getElementsByTagName("serverId").item(0).firstChild.nodeValue;
        comboToLoad.options[count].value =
        rets[count].getElementsByTagName("jdbcUrl").item(0).firstChild.nodeValue + "#" +
        rets[count].getElementsByTagName("driverClass").item(0).firstChild.nodeValue;
    }
    comboToLoad.options[count] = new Option('--SELECT--');
    comboToLoad.options[count].value = ' # ';
    comboToLoad.selectedIndex = count;
    _refreshDataServiceScreenHelper();
}

function setJDBCValues(obj, document) {
    var selectedValue = obj[obj.selectedIndex].value;
    var jdbcUrl = selectedValue.substring(0, selectedValue.indexOf("#"));
    var driverClass = selectedValue.substring(selectedValue.indexOf("#") + 1, selectedValue.length);
    document.getElementById('org.wso2.ws.dataservice.protocol').value = jdbcUrl;
    document.getElementById('org.wso2.ws.dataservice.driver').value = driverClass;
}

/*TODO call from data_service.xsl*/
function setConfigurationScreen(dataSourceType) {
    editDataSourceType = dataSourceType;
    //remove all properties
    /*var propArray = dataServiceObj.getElementsByTagName("config").item(0).getElementsByTagName("property");
    var configObj = dataServiceObj.getElementsByTagName("config").item(0);
    for (var i = 0; i < propArray.length; i++) {
        configObj.removeChild(propArray[i]);
    }*/
    var configLObj = dataServiceObj.getElementsByTagName("config")[0];
    dataServiceObj.getElementsByTagName('data')[0].removeChild(configLObj);
    dataServiceObj.getElementsByTagName('data')[0].appendChild(rootDocument.createElement("config"));
    //preserve data service name
    var dataServiceName = document.getElementById("dataServiceName").value;
    if (dataServiceName != null && dataServiceName.length != 0) {
        if (dataServiceObj.getElementsByTagName("data")[0].getAttribute("name")) {
            dataServiceObj.getElementsByTagName("data")[0].removeAttribute("name");
        }
        dataServiceObj.getElementsByTagName("data")[0].setAttribute("name", dataServiceName);
    }

    var hdDataSource = "Data Source Type : " + dataSourceType;

    if (dataSourceType == 'EXCEL') {
        dataServiceObj.getElementsByTagName("config").item(0).appendChild(createPropelement('excel_datasource', 'path-to-your-excel-file'));
        dataServiceObj.setAttribute("dataSourceType", "EXCEL");
//       refreshDataServiceScreen.call(this,false);
        showYUIPanel(hdDataSource, yuiTransformer(dataServiceObj, "data_service_yui.xsl"), "550px", "step10PanelID", "divYUIPaneHolder");
    } else if (dataSourceType == 'CSV') {

        dataServiceObj.getElementsByTagName("config").item(0).appendChild(createPropelement('csv_datasource', 'path-to-your-csv-file'));
        dataServiceObj.getElementsByTagName("config").item(0).appendChild(createPropelement('csv_columnseperator', ','));
        dataServiceObj.getElementsByTagName("config").item(0).appendChild(createPropelement('csv_columns', ''));
        dataServiceObj.getElementsByTagName("config").item(0).appendChild(createPropelement('csv_columnordinal', ''));
        dataServiceObj.getElementsByTagName("config").item(0).appendChild(createPropelement('csv_startingrow', ''));
        dataServiceObj.getElementsByTagName("config").item(0).appendChild(createPropelement('csv_maxrowcount', '-1'));
        dataServiceObj.getElementsByTagName("config").item(0).appendChild(createPropelement('csv_hasheader', ''));
        dataServiceObj.setAttribute("dataSourceType", "CSV");
//       refreshDataServiceScreen.call(this,false);
        showYUIPanel(hdDataSource, yuiTransformer(dataServiceObj, "data_service_yui.xsl"), "550px", "step11PanelID", "divYUIPaneHolder");
    } else if (dataSourceType == 'RDBMS') {

        dataServiceObj.getElementsByTagName("config").item(0).appendChild(createPropelement("org.wso2.ws.dataservice.driver", ""));
        dataServiceObj.getElementsByTagName("config").item(0).appendChild(createPropelement("org.wso2.ws.dataservice.protocol", ""));
        dataServiceObj.getElementsByTagName("config").item(0).appendChild(createPropelement("org.wso2.ws.dataservice.user", ""));
        dataServiceObj.getElementsByTagName("config").item(0).appendChild(createPropelement("org.wso2.ws.dataservice.password", ""));
        dataServiceObj.getElementsByTagName("config").item(0).appendChild(createPropelement("org.wso2.ws.dataservice.minpoolsize", ""));
        dataServiceObj.getElementsByTagName("config").item(0).appendChild(createPropelement("org.wso2.ws.dataservice.maxpoolsize", ""));        
        dataServiceObj.setAttribute("dataSourceType", "RDBMS");
//       refreshDataServiceScreen.call(this,true);
        showYUIPanel(hdDataSource, yuiTransformer(dataServiceObj, "data_service_yui.xsl"), "550px", "step1PanelID", "divYUIPaneHolder");
//        loadDatabaseUrlDriverComboBox();
    } else if (dataSourceType == 'JNDIDataSource') {
        dataServiceObj.getElementsByTagName("config").item(0).appendChild(createPropelement("jndi_context_class", ""));
        dataServiceObj.getElementsByTagName("config").item(0).appendChild(createPropelement("jndi_provider_url", ""));
        dataServiceObj.getElementsByTagName("config").item(0).appendChild(createPropelement("jndi_resource_name", ""));
        dataServiceObj.getElementsByTagName("config").item(0).appendChild(createPropelement("jndi_username", ""));
        dataServiceObj.getElementsByTagName("config").item(0).appendChild(createPropelement("jndi_password", ""));
        dataServiceObj.setAttribute("dataSourceType", "JNDIDataSource");
//       refreshDataServiceScreen.call(this,false);
        showYUIPanel(hdDataSource, yuiTransformer(dataServiceObj, "data_service_yui.xsl"), "550px", "step12PanelID", "divYUIPaneHolder");
    }
    //set the selected value
    //    document.getElementById("databaseSourceType").value = dataSourceType;
    //    document.getElementById("dataServiceName").value = dataServiceName;
    //dataServiceObj.getElementsByTagName("data")[0].setAttribute("name", dataServiceName);
}

function setDataSourceType() {
    var properties = dataServiceObj.getElementsByTagName("config").item(0).getElementsByTagName("property");
    for (var a = 0; a < properties.length; a++) {
        var property = properties[a];
        if (property.getAttribute("name") == "org.wso2.ws.dataservice.driver") {
            dataServiceObj.setAttribute("dataSourceType", "RDBMS");
        } else if (property.getAttribute("name") == "csv_datasource") {
            dataServiceObj.setAttribute("dataSourceType", "CSV");
        } else if (property.getAttribute("name") == "excel_datasource") {
            dataServiceObj.setAttribute("dataSourceType", "EXCEL");
        } else if (property.getAttribute("name") == "jndi_datasource") {
            dataServiceObj.setAttribute("dataSourceType", "JNDIDataSource");
        } else if (property.getAttribute("name") == "jndi_datasource") {
            dataServiceObj.setAttribute("dataSourceType", "JNDIDataSource");
        }
    }

}


function addAdditionalParameters() {
    if (document.getElementById('addAdditionalParamaters').checked) {
        document.getElementById('divDSAddParam').style.display = "inline";

        document.getElementById('addAdditionalParamaters').checked = true;
    } else {
        document.getElementById('divDSAddParam').style.display = "none";
     //document.getElementById('addAdditionalParamaters').checked = false;
    }
}


function excelWorkbookNameOnChange(workBookName, form) {
    var excelObj = dataServiceQueryObj.getElementsByTagName("excel").item(0);
    var workBookObj = excelObj.getElementsByTagName("workbookname").item(0);
    workBookObj.removeChild(workBookObj.childNodes.item(0));
    workBookObj.appendChild(rootDocument.createTextNode(workBookName));
    checkValidValuesForExcelQuery();
}

function excelHeaderColumnsOnChange(headerColumns, form) {
    var excelObj = dataServiceQueryObj.getElementsByTagName("excel").item(0);
    var hasHeaderObj = excelObj.getElementsByTagName("hasheader").item(0);
    hasHeaderObj.removeChild(hasHeaderObj.childNodes.item(0));
    hasHeaderObj.appendChild(rootDocument.createTextNode(headerColumns));
    checkValidValuesForExcelQuery();
}

function excelStartingRowOnChange(startingRow, form) {
    var excelObj = dataServiceQueryObj.getElementsByTagName("excel").item(0);
    var startingRowObj = excelObj.getElementsByTagName("startingrow").item(0);
    startingRowObj.removeChild(startingRowObj.childNodes.item(0));
    startingRowObj.appendChild(rootDocument.createTextNode(startingRow));
    checkValidValuesForExcelQuery();
}

function excelMaxRowCountOnChange(maxRowCount, form) {
    var excelObj = dataServiceQueryObj.getElementsByTagName("excel").item(0);
    var maxRowCountObj = excelObj.getElementsByTagName("maxrowcount").item(0);
    maxRowCountObj.removeChild(maxRowCountObj.childNodes.item(0));
    maxRowCountObj.appendChild(rootDocument.createTextNode(maxRowCount));
    checkValidValuesForExcelQuery();
}

/*
 * Checks if all excel query fields are filled with proper values
 * and enables output mapping section
 */
function checkValidValuesForExcelQuery() {
    var enableFields = true;

    var excelQueryIdValue = document.getElementById('txtDataServiceQueryId').value;
    excelQueryIdValue = excelQueryIdValue.replace(/^\s+|\s+$/g, '');

    var workBookObjValue = document.getElementById('txtExcelWorkbookName').value;
    workBookObjValue = workBookObjValue.replace(/^\s+|\s+$/g, '');

    var hasHeaderObjValue = document.getElementById('txtExcelHeaderColumns').value;
    hasHeaderObjValue = hasHeaderObjValue.replace(/^\s+|\s+$/g, '');

    var startingRowObjValue = document.getElementById('txtExcelStartingRow').value;
    startingRowObjValue = startingRowObjValue.replace(/^\s+|\s+$/g, '');

    var maxRowCountObjValue = document.getElementById('txtExcelMaxRowCount').value;
    maxRowCountObjValue = maxRowCountObjValue.replace(/^\s+|\s+$/g, '');

    if (excelQueryIdValue != ''
            && workBookObjValue != ''
            && hasHeaderObjValue != ''
            && startingRowObjValue != ''
            && maxRowCountObjValue != '') {
        //if all fields have non empty values enable,
        //output mappings section
        enableFields = false;
    }
    changeOutputMappingFieldStatus(enableFields);
}


function getCSVHeaderColumnNames(document) {
    var resourcePath = document.getElementById('csv_datasource').value;
    resourcePath = resourcePath.replace(/^\s+|\s+$/g, '');

    var hasHeader = document.getElementById('csv_hasheader').value;
    hasHeader = hasHeader.replace(/^\s+|\s+$/g, '');

    var dataSourceType = 'csv';
    var okToProceed = validateCSVConfigurationScreen();
    if (! okToProceed) {
        return false;
    }
   
   //Rest seleted column ordering, user has to start selecting from beginning 
    csvSelectedColumnOrder = 0;

    var body_xml = '<ns1:getHeaderColumnNames  xmlns:ns1="http://org.apache.axis2/xsd">\n' +
                   ' <arg0>' + resourcePath + '</arg0>\n' +
                   ' <arg1><![CDATA[' + hasHeader + ']]></arg1>\n' +
                   ' <arg2>' + dataSourceType + '</arg2>\n' +
                   ' </ns1:getHeaderColumnNames>\n';

    var callURL = serverURL + "/" + "DataServiceAdmin" + "/" ;
    new wso2.wsf.WSRequest(callURL, "getHeaderColumnNames", body_xml, getCSVHeaderColumnNamesCallback);
}

function getCSVHeaderColumnNamesCallback() {
    var comboToLoad = document.getElementById('csvColumnSelection');
    try {
        var data = this.req.responseXML;
        var rets = data.getElementsByTagName("return");
        var len = rets.length;
        var count;
        for (count = 0; count < len; count++) {
            comboToLoad.options[count] = new Option(rets[count].firstChild.nodeValue);
            comboToLoad.options[count].text = rets[count].firstChild.nodeValue;
            comboToLoad.options[count].value = rets[count].firstChild.nodeValue;
        }
        document.getElementById('divCSVColumnSelection').style.display = "inline";
    } catch(e) {
        wso2.wsf.Util.alertWarning("Processing error occurred. Does CSV File location points to a correct file path?");
    }
}

function showValue() {
    var csvColumns = document.getElementById('mycolumns');
    var selectedArray = new Array();
    var count = 0;
    for (i = 0; i < csvColumns.options.length; i++) {
        if (csvColumns.options[i].selected) {
            selectedArray[count] = csvColumns.options[i].value;
            count++;
        }
    }
    document.getElementById('csv_columns').value = selectedArray;
    document.getElementById('csv_columnordinal').value = selectedArray;
}


function setCSVColumnSelection() {
    var csvColumns = document.getElementById('csvColumnSelection');
    if (csvSelectedColumnOrder == csvColumns.options.length) {
        var message = "You have aleady selected all columns.This will reset all column selections done so far. Do you want to continue?";
        if (confirm(message)) {
            csvSelectedColumnOrder = 0;
            getCSVHeaderColumnNames(document);
        }
        return false;
    }

    for (i = 0; i < csvColumns.options.length; i++) {
        if (csvColumns.options[i].selected) {
            if (csvColumns.options[i].text.indexOf('as column no') == -1) {
                csvSelectedColumnOrder++;
                if (csvSelectedColumnOrder > 1) {
                    document.getElementById('csv_columns').value =
                    document.getElementById('csv_columns').value + ',' + csvColumns.options[i].text;
                    document.getElementById('csv_columnordinal').value =
                    document.getElementById('csv_columnordinal').value + ',' +
                    csvSelectedColumnOrder;
                } else {
                    document.getElementById('csv_columns').value = csvColumns.options[i].text;
                    document.getElementById('csv_columnordinal').value = csvSelectedColumnOrder;
                }
                csvColumns.options[i].text =
                csvColumns.options[i].text + " as column no : " + csvSelectedColumnOrder;
                csvColumns.options[i].value =
                csvColumns.options[i].value + ":" + csvSelectedColumnOrder;

            }
        }
    }
}
