/* This js will initialze wsas specific namespaces */
// This will have all the functionality for data services.
if (typeof (wso2) == "undefined") {
    wso2 = {};
}
if (typeof (wso2.wsas) == "undefined") {
    wso2.wsas = {};
}
/* This js will initialze wsas specific namespaces */
// This will have all the functionality for data services.
if (typeof (wso2) == "undefined") {
    wso2 = {};
}
if (typeof (wso2.wsas) == "undefined") {
    wso2.wsas = {};
}
var wsdlObj;
var req;

var wsdl_file_not_found_error = "<p>WSDL View could not continue.</p><p>Either user has not dropped the WSDL file into the META-INF directory or the operations use message receivers other than RPC.</p>";
var definition_prefix;

function parseURL() {

    try {
		var hash=window.location.hash;
		var wsdl_file_name = hash.split('#')[1];
        if (wsdl_file_name == null){
			alert("WSDL File Could not be loaded.");
		}
        return wsdl_file_name;
    } catch (e){}

}

function initWSDLView(){
    
    // branch for native XMLHttpRequest object
    if (window.XMLHttpRequest) {
        req = new XMLHttpRequest();
        req.onreadystatechange = processReqChangeXMLHttpRequest;
        var url = parseURL();
        req.open("GET", url, true);
        req.send(null);
    // branch for IE/Windows ActiveX version
    } else if (window.ActiveXObject) {
        req = new ActiveXObject("Microsoft.XMLHTTP");
        if (req) {
            req.onreadystatechange = processReqChangeActiveXObject;
            var url = parseURL();
            url = url + "?wsdl";
            req.open("GET", url, true);
            req.send();
        }
    }
}




function processReqChangeXMLHttpRequest() {
    // only if req shows "complete"
    if (req.readyState == 4) {
        // only if "OK"
        if (req.status == 200) {
            // ...processing statements go here...
            wsdlObj=req.responseXML;
			if (wsdlObj.firstChild.nodeName.indexOf("definitions") < 0){
				document.getElementById("wsdlViewDiv").innerHTML = wsdl_file_not_found_error;
			} else {
				document.getElementById("wsdlViewDiv").innerHTML = generateServieTable() + "<br/><br/>" + generateMessageTable() + "<br/><br/>" + generateTypes() + "<br/><br/>";
			}
        } else {
            alert("There was a problem retrieving the XML data:\n" + req.statusText);
        }
    }

}

function processReqChangeActiveXObject()
{
    // only if req shows "complete"
    if (req.readyState == 4) {
        // only if "OK"
        if (req.status == 200) {
            // ...processing statements go here...
            // create the XML object

            objXmlDoc = new ActiveXObject("Msxml2.DOMDocument");

            var szResponse = req.responseText;

            objXmlDoc.loadXML(szResponse);

            if (objXmlDoc.parseError.errorCode != 0) {
                var xmlErr = objXmlDoc.parseError;
                alert("You have error " + xmlErr.reason);
            }

            wsdlObj=objXmlDoc.documentElement;

            // getting the definitions prefix
            definition_prefix = wsdlObj.prefix;

			if (wsdlObj.nodeName.indexOf("definitions") < 0){
				document.getElementById("wsdlViewDiv").innerHTML = wsdl_file_not_found_error;
			} else {
				document.getElementById("wsdlViewDiv").innerHTML = generateServieTable() + "<br/><br/>" + generateMessageTable() + "<br/><br/>" + generateTypes();
			}
//			alert(document.getElementById("wsdlViewDiv").innerHTML);
            colorRows();
        } else {
            alert("There was a problem retrieving the XML data:\n" + req.statusText);
        }
    }
}

function browserSpecificGetElementsByTagName(tagObject, tagName, prifix) {
    // branch for native XMLHttpRequest object
	if (window.XMLHttpRequest) {
		return tagObject.getElementsByTagName(tagName);

	// branch for IE/Windows ActiveX version
	} else if (window.ActiveXObject) {

		return tagObject.getElementsByTagName(prifix +':' + tagName);

	}
}

function generateServieTable(){
	var disHTML = "<h2>Services</h2><table id='top_level'>\n";
//	var services = wsdlObj.getElementsByTagName("service");
	var services = browserSpecificGetElementsByTagName(wsdlObj,"service",definition_prefix);
    for (var i=0;i<services.length;i++)
	{

		var itemElm = services[i];
		if (itemElm.attributes.getNamedItem("name") != null){
			var divNameToUse = getDivName("port" + itemElm.attributes.getNamedItem("name").value);
			disHTML += "<tr><td>" +
				"<h3><a href='#' onclick=\"javascript:divShowAndHide(getElementById('" + divNameToUse + "')); return false;\">" + itemElm.attributes.getNamedItem("name").value + "</a></h3><div id='" + divNameToUse + "' style='display:inline;'>" + generatePorts(itemElm) + "</div></td></tr>\n";
		}
	}
	disHTML += "</table>\n";
    return disHTML;
}


function generatePorts(objService) {
	var disHTML = "<table width='100%'><tr><th colspan='2'>Ports</th></tr>";
	disHTML += "<tr><th>Port Name</th><th>Binding</th></tr>";
//	var ports = objService.getElementsByTagName("port");
	var ports = browserSpecificGetElementsByTagName(objService,"port",definition_prefix);
	for (var i=0;i<ports.length;i++)
	{
		var portElm = ports[i];
		if (portElm.attributes.getNamedItem("binding") != null){
			var portBinding = portElm.attributes.getNamedItem("binding").value;
			var portName = portElm.attributes.getNamedItem("name").value;
			var divNameToUse;
			if(browserSpecificGetElementsByTagName(portElm,"address","soap12")[0] != null && browserSpecificGetElementsByTagName(portElm,"address","soap12")[0].tagName.indexOf("soap12") >= 0) {
				disHTML += "<tr><td valign='top'>" + portName + "</td>";
				divNameToUse = getDivName(portName);
				disHTML += "<td valign='top'><a href='#' onclick=\"javascript:divShowAndHide(getElementById('" + divNameToUse + "')); return false;\">" + portBinding + "</a><div id='" + divNameToUse + "' style='display:inline;'>";
				disHTML += "<br/>" + browserSpecificGetElementsByTagName(portElm,"address","soap12")[0].nodeName + " location = " + browserSpecificGetElementsByTagName(portElm,"address","soap12")[0].attributes.getNamedItem("location").value;
				disHTML +=  generateBindingtable(portBinding, browserSpecificGetElementsByTagName(portElm,"address","soap12")[0].nodeName) + "</div></td></tr>";
			}

			if (browserSpecificGetElementsByTagName(portElm,"address","soap")[0] != null && (browserSpecificGetElementsByTagName(portElm,"address","soap")[0].tagName.indexOf("soap12") < 0)){
				disHTML += "<tr><td valign='top'>" + portName + "</td>";
				divNameToUse = getDivName(portName);
				disHTML += "<td valign='top'><a href='#' onclick=\"javascript:divShowAndHide(getElementById('" + divNameToUse + "')); return false;\">" + portBinding + "</a><div id='" + divNameToUse + "' style='display:inline;'>";
				disHTML += "<br/>" + browserSpecificGetElementsByTagName(portElm,"address","soap")[0].nodeName + " location = " + browserSpecificGetElementsByTagName(portElm,"address","soap")[0].attributes.getNamedItem("location").value;
				disHTML +=  generateBindingtable(portBinding, browserSpecificGetElementsByTagName(portElm,"address","soap")[0].nodeName) + "</div></td></tr>";
			}

			if (browserSpecificGetElementsByTagName(portElm,"address","soap")[0] == null && browserSpecificGetElementsByTagName(portElm,"address","soap12")[0] == null){
				disHTML += "<tr><td valign='top'>" + portName + "</td>";
				divNameToUse = getDivName(portName);
				disHTML += "<td valign='top'><a href='#' onclick=\"javascript:divShowAndHide(getElementById('" + divNameToUse + "')); return false;\">" + portBinding + "</a><div id='" + divNameToUse + "' style='display:inline;'>";
				disHTML += "<br/>" + browserSpecificGetElementsByTagName(portElm,"address","http")[0].nodeName + " location = " + browserSpecificGetElementsByTagName(portElm,"address","http")[0].attributes.getNamedItem("location").value;
				disHTML +=  generateBindingtable(portBinding, browserSpecificGetElementsByTagName(portElm,"address","http")[0].nodeName) + "</div></td></tr>";
			}
		}
//		disHTML +=  generateBindingtable(portBinding, portElm.getElementsByTagName("address")[0].nodeName) + "</div></td></tr>";
	}
	disHTML += "</table>";
	return disHTML;
}

function generateBindingtable(bindingName, bindingType){
	var disHTML = "";
	disHTML += "<ul>\n";
//	var bindings = wsdlObj.getElementsByTagName("binding");
	var bindings = browserSpecificGetElementsByTagName(wsdlObj,"binding",definition_prefix);
	//portElm.appendChild(bindings[0]);
	for (var k=0;k<bindings.length;k++){
		if (bindings[k].attributes.getNamedItem("name") != null){
            //
            var newBindingName = bindings[k].attributes.getNamedItem("name").value;
//			var newBindingType = bindings[k].getElementsByTagName("binding")[0].nodeName;
            var newBindingType;
            if (browserSpecificGetElementsByTagName(bindings[k],"binding","soap")[0] != null) {
              newBindingType = browserSpecificGetElementsByTagName(bindings[k],"binding","soap")[0].nodeName;
            }
            if(browserSpecificGetElementsByTagName(bindings[k],"binding","soap12")[0] != null) {
               newBindingType = browserSpecificGetElementsByTagName(bindings[k],"binding","soap12")[0].nodeName;
            }

            if(browserSpecificGetElementsByTagName(bindings[k],"binding","soap12")[0] == null && browserSpecificGetElementsByTagName(bindings[k],"binding","soap12")[0] == null && browserSpecificGetElementsByTagName(bindings[k],"binding","http")[0] != null) {
               newBindingType = browserSpecificGetElementsByTagName(bindings[k],"binding","http")[0].nodeName;
            }

            if (compWONS(newBindingName, bindingName) && compNS(bindingType, newBindingType)){
				bindingType = bindings[k].attributes.getNamedItem("type").value;
				var divNameToUse = getDivName(bindingType);
				disHTML += "<li>" +
								"<a href='#' onclick=\"javascript:divShowAndHide(getElementById('" + divNameToUse + "')); return false;\">portType</a>" +
								"<div id='" + divNameToUse + "' style='display:none;'>" + generateBindingTypeTable(bindingType) + "</div>";
				disHTML += "</li>\n";
				var soap_binding = browserSpecificGetElementsByTagName(bindings[k],"binding","soap")[0];
                if (soap_binding == null) {
                    soap_binding = browserSpecificGetElementsByTagName(bindings[k],"binding","soap12")[0];
                    if (soap_binding == null){
                    	soap_binding = browserSpecificGetElementsByTagName(bindings[k],"binding","http")[0];
                    }
                }
				divNameToUse = getDivName("soap:binding");
				disHTML += "<li>" +
								"<a href='#' onclick=\"javascript:divShowAndHide(getElementById('" + divNameToUse + "')); return false;\">" + soap_binding.nodeName + "</a>" +
								"<div id='" + divNameToUse + "' style='display:none;'>" +
									"<table>";
				disHTML += 			"<tr><th>type</th><th>style</th><th>transport</th></tr>";
                if (soap_binding.attributes.getNamedItem("style") == null) {
                	disHTML += 			"<tr><td>" + getNS(soap_binding.nodeName) + "</td><td>" + soap_binding.attributes.getNamedItem("verb").value + "</td><td>&nbsp;</td></tr>";
                } else {
                	disHTML += 			"<tr><td>" + getNS(soap_binding.nodeName) + "</td><td>" + soap_binding.attributes.getNamedItem("style").value + "</td><td>" + soap_binding.attributes.getNamedItem("transport").value +"</td></tr>";
                }
				disHTML += 			"</table></div>";
				disHTML += "</li>\n";

				divNameToUse = getDivName(bindingName);
				disHTML += "<li>" +
								"<a href='#' onclick=\"javascript:divShowAndHide(getElementById('" + divNameToUse + "')); return false;\">wsdl:operation</a>" +
								"<div id='" + divNameToUse + "' style='display:none;'>" + getSWDLOperationTable(bindings[k]) + "</div>" +
						   "</li>\n" ;
			}

        }

    }
    disHTML += "</ul>";
    return disHTML;
}

function generateBindingTypeTable(portName){
	var disHTML = "";
	disHTML += "<ul>\n";
//	var portTypes = wsdlObj.getElementsByTagName("portType");
	var portTypes = browserSpecificGetElementsByTagName(wsdlObj,"portType",definition_prefix);
	for (var k=0;k<portTypes.length;k++){
		if (compWONS(portName, portTypes[k].attributes.getNamedItem("name").value)){
			disHTML += "<li>Name = " + portTypes[k].attributes.getNamedItem("name").value + "</li>\n";
			disHTML += "<li>" ;
			disHTML += 		"<ul>\n";
			disHTML += 			"<li>operation</li>\n";
//			var port_type_operations = portTypes[k].getElementsByTagName("operation");
			var port_type_operations = browserSpecificGetElementsByTagName(portTypes[k],"operation",definition_prefix);
			for (var l=0;l<port_type_operations.length;l++){
				var divNameToUse = getDivName(port_type_operations[l].attributes.getNamedItem("name").value);
				disHTML += "<li>" +
				"<a href='#' onclick=\"javascript:divShowAndHide(getElementById('" + divNameToUse + "')); return false;\">" + port_type_operations[l].attributes.getNamedItem("name").value + "</a><div id='" + divNameToUse + "' style='display:none;'>" + generatePortTypeoperationTable(port_type_operations[l]) + "</div>" +
				"</li>\n" ;
//				disHTML += "<tr><td>" + port_type_operations[l].attributes.getNamedItem("name").value + generatePortTypeoperationTable(port_type_operations[l]) + "</td></tr>";
			}
			disHTML += "</ul>\n";
		}
	}

	disHTML += "</ul>\n";
	return disHTML;
}


function generatePortTypeoperationTable(port_type_operation){
	var disHTML = "";
	disHTML += "<ul>";
	var input_obj = browserSpecificGetElementsByTagName(port_type_operation,"input",definition_prefix)[0];
	var output_obj = browserSpecificGetElementsByTagName(port_type_operation,"output",definition_prefix)[0];

	var divNameToUse = getDivName(port_type_operation.attributes.getNamedItem("name").value + "input");
	if (input_obj != null){
		disHTML += "<li>" +
		"<a href='#' onclick=\"javascript:divShowAndHide(getElementById('" + divNameToUse + "')); return false;\">Input(Request)</a><div id='" + divNameToUse + "' style='display:none;'>" + getReqResPTTable(input_obj) + "</div>" +
		"</li>" ;
	}
	if (output_obj != null){
		divNameToUse = getDivName(port_type_operation.attributes.getNamedItem("name").value + "output");
		disHTML += "<li>" +
		"<a href='#' onclick=\"javascript:divShowAndHide(getElementById('" + divNameToUse + "')); return false;\">Output(Response)</a><div id='" + divNameToUse + "' style='display:none;'>" + getReqResPTTable(output_obj) + "</div>" +
		"</li>";
	}
	disHTML += "</ul>";
	return disHTML;
}

function getReqResPTTable(obj){
	var disHTML = "<ul>" +
			"<li><strong>Message</strong></li>" +
			"<li>" + obj.attributes.getNamedItem("message").value + "</li>" +
			"</ul>";
	return disHTML;
}

function generateMessageTable(){
	var disHTML = "";
	disHTML += "<h2>Messages</h2><table id='top_level' width='100%'>";
//	var messages = wsdlObj.getElementsByTagName("message");
	var messages = browserSpecificGetElementsByTagName(wsdlObj,"message",definition_prefix);
	for (var i=0;i<messages.length;i++) {
		var msgElm = messages[i];
		disHTML += "<tr><td>" + msgElm.attributes.getNamedItem("name").value + "<table  width='100%' border='1'  style='border: 1px solid #000000'>";
		disHTML += "<tr><th colspan='2'> Part </th></tr>";
		disHTML += "<tr><th width='60%'>Element</th><th width='40%'>Name</th></tr>";
//		var partElms = msgElm.getElementsByTagName("part");
		var partElms = browserSpecificGetElementsByTagName(msgElm,"part",definition_prefix);
		for (var j=0;j<partElms.length;j++){
			disHTML += "<tr><td>" + partElms[j].attributes.getNamedItem("element").value + "</td><td>" + partElms[j].attributes.getNamedItem("name").value + "</td></tr>";
		}
		disHTML += "</table></td></tr>";
	}
	disHTML += "</table>";
	return disHTML;
}

function getSWDLOperationTable(binding){
	var disHTML = "<table>";
//	var wsdl_operations = binding.getElementsByTagName("operation");
	var wsdl_operations = browserSpecificGetElementsByTagName(binding,"operation",definition_prefix);
	disHTML += "<tr><td>Name : " + binding.attributes.getNamedItem("name").value + "</td></tr>";
	for (var r=0; r<wsdl_operations.length;r++){
		if (wsdl_operations[r].attributes.getNamedItem("name") != null){
			var divNameToUse = getDivName("wsdl_operatons" + wsdl_operations[r].attributes.getNamedItem("name").value);
			disHTML += "<tr><td>" +
						"<a href='#' onclick=\"javascript:divShowAndHide(getElementById('" + divNameToUse + "')); return false;\">soap:operation</a>";
			disHTML += "<ul><li>" +
						"<div id='" + divNameToUse + "' style='display:none;'>" +
							getSOAPOperationTable(wsdl_operations[r]) +
						"</div></li>";

			var input_obj;
			if (browserSpecificGetElementsByTagName(wsdl_operations[r],"input",definition_prefix)[0] != null){
	            divNameToUse = getDivName(wsdl_operations[r].attributes.getNamedItem("name").value + "input");
				input_obj = browserSpecificGetElementsByTagName(browserSpecificGetElementsByTagName(wsdl_operations[r],"input",definition_prefix)[0],"body","soap")[0];
				if (input_obj == null) {
					input_obj = browserSpecificGetElementsByTagName(browserSpecificGetElementsByTagName(wsdl_operations[r],"input",definition_prefix)[0],"body","soap12")[0];
					if (input_obj == null) {
						input_obj = browserSpecificGetElementsByTagName(browserSpecificGetElementsByTagName(wsdl_operations[r],"input",definition_prefix)[0],"content","mime")[0];
					}
				}
	//			if (input_obj == null){
//					alert(serializingTypesObjects(browserSpecificGetElementsByTagName(wsdl_operations[r],"input",definition_prefix)[0]));
		//		}
				disHTML += "<li>" +
					"<a href='#' onclick=\"javascript:divShowAndHide(getElementById('" + divNameToUse + "')); return false;\">Input(Request)</a><div id='" + divNameToUse + "' style='display:none;'>" + getReqResTable(input_obj) + "</div>" +
					"</li>" ;
            }

			var output_obj;
			if (browserSpecificGetElementsByTagName(wsdl_operations[r],"output",definition_prefix)[0] != null){
				output_obj = browserSpecificGetElementsByTagName(browserSpecificGetElementsByTagName(wsdl_operations[r],"output",definition_prefix)[0],"body","soap")[0];
				if (output_obj == null) {
					output_obj = browserSpecificGetElementsByTagName(browserSpecificGetElementsByTagName(wsdl_operations[r],"output",definition_prefix)[0],"body","soap12")[0];
					if (output_obj == null) {
						output_obj = browserSpecificGetElementsByTagName(browserSpecificGetElementsByTagName(wsdl_operations[r],"output",definition_prefix)[0],"content","mime")[0];
					}
				}
				//alert(output_obj);
				divNameToUse = getDivName(wsdl_operations[r].attributes.getNamedItem("name").value + "output");
				disHTML += "<li>" +
					"<a href='#' onclick=\"javascript:divShowAndHide(getElementById('" + divNameToUse + "')); return false;\">Output(Response)</a><div id='" + divNameToUse + "' style='display:none;'>" + getReqResTable(output_obj) + "</div>" +
					"</li>" ;
			}
			disHTML += "</ul></td></tr>";

		}
	}
	disHTML += "</table>";
	return disHTML;
}

function getReqResTable(obj){
    var disHTML = "<table>";
			if (obj.attributes.getNamedItem("use") != null){
				disHTML += "<tr><th>use</th></tr>" +
							"<tr><td>" + obj.attributes.getNamedItem("use").value + "</td></tr>";
			} else {
				disHTML += "<tr><th>Type</th></tr>" +
							"<tr><td>" + obj.attributes.getNamedItem("type").value + "</td></tr>";
			}

			disHTML += "</table>";
	return disHTML;
}


function getSOAPOperationTable(wsdl_operation){
	var disHTML = "<table>" +
		"<tr><th>name</th><th>style</th><th>soapAction</th></tr>";
//	var soap_operations = wsdl_operation.getElementsByTagName("operation");
	var soap_operations = browserSpecificGetElementsByTagName(wsdl_operation, "operation", "soap");
	if (soap_operations.length == 0){
		soap_operations = browserSpecificGetElementsByTagName(wsdl_operation, "operation", "soap12");
	}

	if (soap_operations.length == 0){
		soap_operations = browserSpecificGetElementsByTagName(wsdl_operation, "operation", "http");
	}

	for (var d=0;d<soap_operations.length;d++){
		if (soap_operations[d].attributes.getNamedItem("style") == null){
			disHTML += "<tr><td>" + wsdl_operation.attributes.getNamedItem("name").value + "</td><td>N/A</td><td>N/A</td></tr>";
		} else {
			disHTML += "<tr><td>" + wsdl_operation.attributes.getNamedItem("name").value + "</td><td>" + soap_operations[d].attributes.getNamedItem("style").value +"</td><td>" + soap_operations[d].attributes.getNamedItem("soapAction").value +"</td></tr>";
		}
	}
	disHTML += "</table>";
	return disHTML;
}



var num = 1;
function getNewNum(){
	num++;
	return num;
}

function getDivName(name){
	return "div" + name + getNewNum();
}

function generateTypes(){
	var disHTML = "<h2>Types</h2><form action='#'><div>";
//	var types = wsdlObj.getElementsByTagName("wsdl:types");
	var types = browserSpecificGetElementsByTagName(wsdlObj,"types",definition_prefix);
	for (var i=0;i<types.length;i++) {
		disHTML += "<textarea cols='90' rows='10'>" + serializingTypesObjects(types[i]) + "</textarea>";
	}
	disHTML += "</div>";
	return disHTML;
}

function serializingTypesObjects(obj) {
    // branch for native XMLHttpRequest object
    if (window.XMLHttpRequest) {

        return (new XMLSerializer()).serializeToString(obj);

    // branch for IE/Windows ActiveX version
    } else if (window.ActiveXObject) {
        return obj.xml;

    }

}

function compWONS(item1, item2) {
	var newItem1 = removeNS(item1);
	var newItem2 = removeNS(item2);
	return (newItem1 == newItem2);
}

function removeNS(text){
	var colonPos = text.lastIndexOf(":");
	var newStr = text;
	if (colonPos > 0){
		newStr = text.substring(colonPos+1, text.length);
	}
	return newStr;
}

function compNS(item1, item2) {
	var newItem1 = getNS(item1);
	var newItem2 = getNS(item2);
	return (newItem1 == newItem2);
}

function getNS(text){
	var colonPos = text.lastIndexOf(":");
	var newStr = "";
	if (colonPos > 0){
		newStr = text.substring(0, colonPos);
	}
	return newStr;
}

function divShowAndHide(objDiv){
	if (objDiv.style.display == "none"){
		objDiv.style.display = "inline";
	} else {
		objDiv.style.display = "none";
	}
}

function colorRows() {
	if (!document.getElementsByTagName) return;
	var myTR = document.getElementsByTagName('tr');
	for (var i=0;i<myTR.length;i++) {
		if (i%2) {
			myTR[i].className = 'rowTint';
		}
	}
}
    
    
//This js deals with Data Services
var editDataSourceType;

var dataServiceObj = null;

var dataServiceQueryObj = null;

var curDataServiceName = null;

var dataServiceCurOpObj = null;

var curDataServiceOutputMappingType = null;

var newDataService = false;
var rootDocument;
var xslToReload;

var ds_collectdata = new Array();

var serviceSpecificName = null;

var newDataObject;

var csvSelectedColumnOrder = 0;

function addNewDataService() {
    stoppingRefreshingMethodsHook();
    newDataService = true;
    var browser = wso2.wsf.Util.getBrowser();
    //var newDataObject;

    switch (browser) {
        case "ie":
        case "ie7": {
            rootDocument = new ActiveXObject("Microsoft.XMLDOM");
            rootDocument.async = false;
            rootDocument.loadXML("<foo><return></return></foo>");
            newDataObject = rootDocument.getElementsByTagName("return")[0];
            break;
        }
        case "gecko":
        case "opera":
        case "safari": {
            rootDocument = document.implementation.createDocument("", "", null);
            newDataObject = rootDocument.createElement("return");
            break;
        }
        default: {
            wso2.wsf.Util.alertWarning("DOM document can not be created");
            return;
        }
    }

    var dataRowObj = rootDocument.createElement("data");
    var configObj = rootDocument.createElement("config");

    dataRowObj.appendChild(configObj);

    newDataObject.appendChild(dataRowObj);

    var tempDataServiceObj = rootDocument.createElement("temp");
    tempDataServiceObj.appendChild(newDataObject);
    xslToReload = "data_service.xsl";
    serviceSpecificName = null;
    addNewDataServiceEchoDataElement(tempDataServiceObj);
}

// TODO: note: this method will aquire meta info needed for DS from the server. 
function addNewDataServiceEchoDataElement(/*tempDataServiceObj*/) {
//    var dataServiceContents = prettyPrintDOMNode(tempDataServiceObj.getElementsByTagName("data").item(0), "", "    ", true);
    var body_xml = '<req:getDSMetaData xmlns:req="http://org.apache.axis2/xsd">\n' +
                   ' <arg0></arg0>\n' +
                   ' </req:getDSMetaData>\n';

    var callURL = serverURL + "/" + "DataServiceAdmin" ;

    new wso2.wsf.WSRequest(callURL, "getDSMetaData", body_xml, addNewDataServiceEchoDataElementCallback);
}

function addNewDataServiceEchoDataElementCallback() {

    /*TODO - First ds_step is 0 */
    dataServiceObj = this.req.responseXML.getElementsByTagName("dataWrapper")[0];
    //<dataWrapper><data>...</dataWrapper>
    var dbServerDataArray = this.req.responseXML.getElementsByTagName("dbServerData");
    for (var i = 0; i < dbServerDataArray.length; i++) {
        dataServiceObj.appendChild(dbServerDataArray[i]);
    }
    dataServiceObj.setAttribute("ds_step", 0);
    newDataService = true;
    refreshDataServiceScreen.call(this, false);
}


//TODO note: configure an existing DS
function configureDataservice(serviceName) {
    curDataServiceName = serviceName;
    newDataService = false;

    var browser = wso2.wsf.Util.getBrowser();

    switch (browser) {
        case "ie":
        case "ie7": {
            rootDocument = new ActiveXObject("Microsoft.XMLDOM");
            rootDocument.async = false;
            rootDocument.loadXML("<foo><return></return></foo>");
            break;
        }
        case "gecko":
        case "opera":
        case "safari": {
            rootDocument = document.implementation.createDocument("", "", null);
            break;
        }
        default: {
            wso2.wsf.Util.alertWarning("DOM document can not be created");
            return;
        }
    }

    getDataServiceContents(serviceName);
}

//TODO Note: get info for an existing DS
function getDataServiceContents(serviceName) {

    var body_xml = '<req:getDSMetaData xmlns:req="http://org.apache.axis2/xsd">\n' +
                   ' <arg0>' + serviceName + '</arg0>\n' +
                   ' </req:getDSMetaData>\n';

    var callURL = serverURL + "/" + "DataServiceAdmin";
    new wso2.wsf.WSRequest(callURL, "urn:getDSMetaData", body_xml, getDataServiceContentsCallback);
}

function getDataServiceContentsCallback() {

    dataServiceObj = this.req.responseXML.getElementsByTagName("dataWrapper")[0];
    //<dataWrapper><data>...</dataWrapper>
    var dbServerDataArray = this.req.responseXML.getElementsByTagName("dbServerData");
    for (var i = 0; i < dbServerDataArray.length; i++) {
        dataServiceObj.appendChild(dbServerDataArray[i]);
    }
    dataServiceObj.setAttribute("ds_step", 0);
    dataServiceObj.setAttribute("disable_name", true);
    xslToReload = "data_service.xsl";
    /*serviceSpecificName
            = this.req.responseXML.getElementsByTagName("data")[0].getAttribute("name");*/
    refreshDataServiceScreen.call(this);

}

//TODO Just a marker
function refreshDataServiceScreen(boolValue) {

    var objDiv = document.getElementById("divDataServiceDetails")
    var xsltHelperObj = new wso2.wsf.XSLTHelper();
    xsltHelperObj.transform(objDiv, dataServiceObj, "data_service.xsl", false, false, [["dsHeader",parseInt(dataServiceObj.getAttribute("ds_step")) +
                                                                                                   1]]);
    wso2.wsf.Util.showOnlyOneMain(objDiv);

    /*if (boolValue) {
        loadDatabaseUrlDriverComboBox();
    }*/
    _refreshDataServiceScreenHelper(boolValue);
}

//TODO
function configStepOne() {
    //Validation of the inputs
    var stat = ds_collectdata["stepOneValidation"]();
    if (!stat) {
        return;
    }
    refreshDataServiceScreen();
}

//TODO : note edit date source type
function editStepOne(dataSourceType) {
    if (!editDataSourceType) {
        if (!dataSourceType) {
            wso2.wsf.Util.alertWarning("Select Data Source first before editing");
            return;
        }
    }
    if (dataSourceType.length == 0) {
        wso2.wsf.Util.alertWarning("Select Data Source first before editing");
        return;
    }
    if (dataSourceType != null && dataSourceType != 0) {
        editDataSourceType = dataSourceType;
        dataServiceObj.setAttribute("dataSourceType", editDataSourceType);
    }
    var editPanelName = "Edit : " + editDataSourceType;
    showYUIPanel(editPanelName, yuiTransformer(dataServiceObj, "data_service_yui.xsl"), "500px", "step1PanelEdit", "divYUIPaneHolder");
    /*if (editDataSourceType == 'RDBMS') {
        loadDatabaseUrlDriverComboBox();
    }*/
}

//TODO note: test jdbc connection
function testJDBCConnection(driveClass, jdbcURL, username, password) {
    var body_xml = '<req:getDSMetaData xmlns:req="http://org.apache.axis2/xsd">\n' +
                   ' <driverClass>' + driveClass + '</driverClass>\n' +
                   ' <jdbcURL><![CDATA[' + jdbcURL + ']]></jdbcURL>\n' +
                   ' <username>' + username + '</username>\n' +
                   ' <password>' + password + '</password>\n' +
                   ' </req:getDSMetaData>\n';

    var callURL = serverURL + "/" + "DataServiceAdmin";
    new wso2.wsf.WSRequest(callURL, "urn:testJDBCConnection", body_xml, function() {
        var retNodeValue = this.req.responseXML.getElementsByTagName("return")[0].firstChild.nodeValue;
        wso2.wsf.Util.alertMessage(retNodeValue);
    });

}

//TODO: edit result element
function removeResultElement(queryId, eleName) {
    if ((eleName == null && eleName.length == 0)) {
        wso2.wsf.Util.alertWarning("Group by element or Row name is missing");
        return;
    }
    if (queryId == null || queryId.length == 0) {
        wso2.wsf.Util.alertWarning("Query id is required");
        return;
    }
    var qArray = dataServiceObj.getElementsByTagName('query');
    var qEle = null;
    for (var i = 0; i < qArray.length; i++) {
        if (queryId == qArray[i].getAttribute("id")) {
            qEle = qArray[i];
            break;
        }
    }
    if (!qEle) {
        wso2.wsf.Util.alertWarning("Query " + queryId +
                                   "is not pesisted. Thus, <result/> element would not be removed.");
        return;
    } else {
        var reArray = qEle.getElementsByTagName('result');
        var resultEle = null;
        for (i = 0; i < reArray.length; i++) {
            resultEle = reArray[i];
            break;
        }
        if (!resultEle) {
            wso2.wsf.Util.alertWarning("<result/> element is not available.");
            return;
        } else {
            qEle.removeChild(resultEle);
        }
    }
    var currentDiv = document.getElementById("divADDEditOutputMapping");
    currentDiv.style.display = "none";
    currentDiv.innerHTML = "";
    var divInnerHtml = yuiTransformer(dataServiceObj, "data_service_add_query.xsl", false, [["queryId",queryId]]);
    showYUIPanel("Add/Edit Query", divInnerHtml, "600px", "step2Inner13", "divDSAddQuery");

}

// TODO add a new query
function addNewQuery() {
    var divInnerHtml = yuiTransformer(dataServiceObj, "data_service_add_query.xsl");
    showYUIPanel("Add New Query", divInnerHtml, "600px", "step2Inner0", "divDSAddQuery");
}

//TODO addd new query param
//TODO : Note This object will be presisted iff query element is presit.
var transitParamEle = null;
var parentOfTransientParamEle = null;
var transitQueryEle = null;

function removeTransientElements() {
    try {
        if (transitQueryEle) {
            dataServiceObj.getElementsByTagName("data").item(0).removeChild(transitQueryEle);
            transitQueryEle = null;
        } else if (parentOfTransientParamEle && transitParamEle) {
            parentOfTransientParamEle.removeChild(transitParamEle);
            parentOfTransientParamEle = null;
            transitParamEle = null;
        }
    } catch(e) {
        // if the transient element is not available remove it.
    }
}

function addNewInputParam(queryId, sql) {
    if (queryId == null || queryId.length == 0) {
        wso2.wsf.Util.alertWarning("Query id is required prior adding an input mapping");
        return;
    }
    var qArray = dataServiceObj.getElementsByTagName('query');
    var qEle = null;
    for (var i = 0; i < qArray.length; i++) {
        if (qArray[i].getAttribute("id") == queryId) {
            qEle = qArray[i];
            break;
        }
    }
    if (!qEle) {
        qEle = rootDocument.createElement('query');
        qEle.setAttribute("id", queryId);
        dataServiceObj.getElementsByTagName("data").item(0).appendChild(qEle);
        transitQueryEle = qEle;
    }
    var sqlArray = qEle.getElementsByTagName('sql');
    var sqlEle = null;
    for (i = 0; i < sqlArray.length; i++) {
        sqlEle = sqlArray[i];
        break;
    }
    if (!sqlEle) {
        sqlEle = rootDocument.createElement("sql");
        sqlEle.appendChild(rootDocument.createTextNode(sql));
        qEle.appendChild(sqlEle);
    } else {
        sqlEle.removeChild(sqlEle.childNodes.item(0));
        sqlEle.appendChild(rootDocument.createTextNode(sql));
    }
    var divInnerHtml = yuiTransformer(dataServiceObj, "data_service_add_edit_input_mapping.xsl", false, [["queryId",queryId]]);
    showYUIPanel("Add New Input Param", divInnerHtml, "600px", "step2Inner3", "divADDEditInputMapping");
}

function addNewSpecificInputParam(queryId, paramName, obj,ordinalValue,inOutObj, oldInputParamName) {

    if (paramName == null || paramName.length == 0) {
        wso2.wsf.Util.alertWarning("Param name is required.");
        return;
    }

    var qArray = dataServiceObj.getElementsByTagName('query');
    var qEle = null;
    for (var i = 0; i < qArray.length; i++) {
        if (qArray[i].getAttribute("id") == queryId) {
            qEle = qArray[i];
            break;
        }
    }

    //TODO validation for param objects
    var paramArray = qEle.getElementsByTagName('param');
    var paramEle = null;

    if (paramName == oldInputParamName) {
        //Param is existing and its the old one
        for (i = 0; i < paramArray.length; i++) {
            if (paramName == paramArray[i].getAttribute('name')) {
                paramEle = paramArray[i];
                break;
            }
        }
        paramEle.removeAttribute('name');
        paramEle.removeAttribute('sqlType');
        paramEle.removeAttribute('type');
        paramEle.removeAttribute('ordinal');
        paramEle.setAttribute("name", paramName);
        paramEle.setAttribute("sqlType", obj[obj.selectedIndex].value);
        paramEle.setAttribute("type", inOutObj[inOutObj.selectedIndex].value);
        paramEle.setAttribute("ordinal", ordinalValue);
    } else {
        // not existing one or change one
        if (oldInputParamName == null || oldInputParamName.length == 0) {
            //new one;
            paramEle = rootDocument.createElement("param");
            paramEle.setAttribute("name", paramName);
            paramEle.setAttribute("sqlType", obj[obj.selectedIndex].value);
            paramEle.setAttribute("type", inOutObj[inOutObj.selectedIndex].value);
            paramEle.setAttribute("ordinal", ordinalValue);
            qEle.appendChild(paramEle);
        } else {
            // exsiting one
            for (i = 0; i < paramArray.length; i++) {
                if (paramName == paramArray[i].getAttribute('name')) {
                    paramEle = paramArray[i];
                    break;
                }
            }
            if (paramEle) {
                wso2.wsf.Util.alertWarning("Param already exist with the name " + paramName);
                return;
            } else {
                for (i = 0; i < paramArray.length; i++) {
                    if (oldInputParamName == paramArray[i].getAttribute('name')) {
                        paramEle = paramArray[i];
                        break;
                    }
                }
                qEle.removeChild(paramEle);
                paramEle = rootDocument.createElement("param");
                paramEle.setAttribute("name", paramName);
                paramEle.setAttribute("sqlType", obj[obj.selectedIndex].value);
                paramEle.setAttribute("type", inOutObj[inOutObj.selectedIndex].value);
                paramEle.setAttribute("ordinal", ordinalValue);
                qEle.appendChild(paramEle);
            }

        }
    }

    var currentDiv = document.getElementById("divADDEditInputMapping");
    currentDiv.style.display = "none";
    currentDiv.innerHTML = "";
    var divInnerHtml = yuiTransformer(dataServiceObj, "data_service_add_query.xsl", false, [["queryId",queryId]]);
    showYUIPanel("Add New Query", divInnerHtml, "600px", "step2Inner0", "divDSAddQuery");
}

// TODO edit an existing query 
function editExistingQuery(query) {
    var divInnerHtml = yuiTransformer(dataServiceObj, "data_service_add_query.xsl", false, [["queryId", query]]);
    showYUIPanel("Edit Query", divInnerHtml, "600px", "step2Inner1", "divDSAddQuery");
}

//TODO: note edit query
function editSpecificQuery(query, sql, type) {
    if (query == null || query.length == 0) {
        wso2.wsf.Util.alertWarning("Query id is required.");
        return;
    }

    var qArray = dataServiceObj.getElementsByTagName("query");
    var qEle;
    for (var i = 0; i < qArray.length; i++) {
        if (qArray[i].getAttribute("id") == query) {
            qEle = qArray[i];
            break;
        }
    }
    if (type == 'RDBMS' || type == 'JNDIDataSource') {
        if (sql == null || sql.length == 0) {
            wso2.wsf.Util.alertWarning("Sql statement is required.");
            return;
        }
        var eSql;
        var sqlArray = qEle.getElementsByTagName("sql");
        for (i = 0; i < sqlArray.length; i++) {
            eSql = sqlArray[i];
            break;
        }
        if (eSql) {
            eSql.removeChild(eSql.childNodes.item(0));
            eSql.appendChild(rootDocument.createCDATASection(sql));
        } else {
            eSql = rootDocument.createElement('sql');
            eSql.appendChild(rootDocument.createCDATASection(sql));
            qEle.appendChild(eSql);
        }
    } else if (type == 'EXCEL') {
        var eExcel;
        var excelArray = qEle.getElementsByTagName('excel');
        for (i = 0; i < excelArray.length; i++) {
            eExcel = excelArray[i];
            break;
        }
        if (eExcel) {
            qEle.removeChild(eExcel);
        }

        eExcel = rootDocument.createElement("excel");
        var workBookNameElement = rootDocument.createElement("workbookname");
        var startingRowElement = rootDocument.createElement("startingrow");
        var maxRowCountElement = rootDocument.createElement("maxrowcount");
        var hasHeaderElement = rootDocument.createElement("hasheader");

        var excelWBName = document.getElementById('txtExcelWorkbookName').value;
        var excelStartingRow = document.getElementById('txtExcelStartingRow').value;
        var excelMaxRowCount = document.getElementById('txtExcelMaxRowCount').value;
        if (excelWBName == null || excelWBName.length == 0) {
            wso2.wsf.Util.alertWarning("Workbook name is required");
            return;
        }
        if (excelStartingRow == null || excelStartingRow.length == 0) {
            wso2.wsf.Util.alertWarning("Strart reading from is required.");
            return;
        }
        if (excelMaxRowCount == null || excelMaxRowCount.length == 0) {
            wso2.wsf.Util.alertWarning("Rows to read is required.");
            return;
        }
        var obj = document.getElementById('txtExcelHeaderColumns');
        var hasHeaderValue = obj[obj.selectedIndex].value;
        if (hasHeaderValue == null || hasHeaderValue.length == 0) {
            wso2.wsf.Util.alertWarning("Status of the headers available is required.");
            return;
        }
        workBookNameElement.appendChild(rootDocument.createTextNode(excelWBName));
        startingRowElement.appendChild(rootDocument.createTextNode(excelStartingRow));
        maxRowCountElement.appendChild(rootDocument.createTextNode(excelMaxRowCount));
        hasHeaderElement.appendChild(rootDocument.createTextNode(hasHeaderValue));
       //add as children to excel element
        eExcel.appendChild(workBookNameElement);
        eExcel.appendChild(startingRowElement);
        eExcel.appendChild(maxRowCountElement);
        eExcel.appendChild(hasHeaderElement);

        qEle.appendChild(eExcel);
    } else if (type == 'CSV') {
        //do not do anything
    } else {
        wso2.wsf.Util.alertWarning("Data Source type : " + type + " is undefined.");
        return;
    }

    var rArray = qEle.getElementsByTagName('result');
    var rEle = null;
    for (i = 0; i < rArray.length; i++) {
        rEle = rArray[i];
        break;
    }
    var rgName = document.getElementById('txtDataServiceWrapElement').value;
    var rowName = document.getElementById('txtDataServiceRowName').value;
    var rowNamespace = document.getElementById('txtDataServiceRowNamespace').value;
    
    
    if (!rEle) {
        rEle = rootDocument.createElement("result");       
        if (!(rgName == null || rgName.length == 0)) {
           rEle.setAttribute("element", rgName);
        }
        if (!(rowName == null || rowName.length == 0)) {
           rEle.setAttribute("rowName", rowName);
        }                
        if (!(rowNamespace == null || rowNamespace.length == 0)) {
           rEle.setAttribute("defaultNamespace", rowNamespace);
        }else{
           rEle.removeAttribute("defaultNamespace");
        }
        //if rowname & row group name is null, do not set result element
        if(!(rEle.getAttribute("element") == null && rEle.getAttribute("rowName") == null)){
          qEle.appendChild(rEle);        
        }
    } else {
        rEle.removeAttribute("element");
        rEle.removeAttribute("rowName");
        rEle.removeAttribute("defaultNamespace");
        if (!(rgName == null || rgName.length == 0)) {
           rEle.setAttribute("element", rgName);
        }
        if (!(rowName == null || rowName.length == 0)) {
           rEle.setAttribute("rowName", rowName);
        }                        
        if (!(rowNamespace == null || rowNamespace.length == 0)) {
          rEle.setAttribute("defaultNamespace", rowNamespace);
        }        
        //if rowname & row group name is null, do not set result element
        if(rEle.getAttribute("element") == null || rEle.getAttribute("rowName") == null){
          qEle.removeChild(rEle);    
        }        
    }
    refreshDataServiceScreen();
}

//TODO : note: this will show the inner query explorer
//divInnerQueryExplorler_
function showInnerQueryExplorer(obj,idArray) {
    var divId;
    var divObj;
    for (var i = 0; i < idArray.length; i++) {
        divId = idArray[i];
        divObj = document.getElementById("divInnerQueryExplorler_"+divId);
        if (divObj) {
            divObj.style.display = "none";
        }
    }
    divId = obj[obj.selectedIndex].value;
    divObj = document.getElementById("divInnerQueryExplorler_" + divId);
    if (divObj) {
        divObj.style.display = "inline";
    }

}

//TODO : note : this will refresh the preview. 
function _refreshDataServiceScreenHelper(boolValue) {
    /*if (serviceSpecificName == null || serviceSpecificName == "") {
        var dsHDiv = document.getElementById('dataServiceHeader');
        showNewDataServiceHeader(dsHDiv, dataServiceObj.getAttribute("ds_step"));
    } else {
        showDataServiceHeader(document.getElementById('dataServiceHeader'), dataServiceObj.getAttribute("ds_step"));
    }*/

    /*if (dataServiceObj.getAttribute("ds_step") == "2") {
        displayAddDataServiceOperation();
        displayOperationWithParams();
    }*/

    if (!boolValue) {
        var sdPrevObj = document.getElementById("dsPreviewDiv");
        if (sdPrevObj) {
            var formattedObj = yuiTransformer(dataServiceObj.getElementsByTagName('data')[0], "data_service_preview_formatter.xsl");
            sdPrevObj.innerHTML = "";
            sdPrevObj.innerHTML = formattedObj;
            /*sdPrevObj.appendChild(document.createTextNode(
                    prettyPrintDOMNode(dataServiceObj.getElementsByTagName("data").item(0), "", "    ", true)));*/
        }
    }

}

function addEditDataServiceQueryDone() {
    var dataServiceSQL = document.getElementById('txtDataServiceSQL').value;
    var dataServiceWrapElement = document.getElementById('txtDataServiceWrapElement').value;
    var dataServiceRowName = document.getElementById('txtDataServiceRowName').value;

    var sqlObj = dataServiceQueryObj.getElementsByTagName("sql").item(0);
    sqlObj.removeChild(sqlObj.childNodes.item(0));
    sqlObj.appendChild(rootDocument.createTextNode(dataServiceSQL));

    var resultObj = dataServiceQueryObj.getElementsByTagName("result").item(0);
    resultObj.setAttribute("element", dataServiceWrapElement);
    resultObj.setAttribute("rowName", dataServiceRowName);


    // TODO fill this; get the info from server
    xslToReload = 'data_service.xsl';
    addNewDataServiceEchoDataElement(dataServiceObj);
    //refreshDataServiceScreen();
    //showGeneratedConfigFile();
}

function addConfigParameter() {
    var newParam = wso2.wsf.Util.getUserInput();
    if (newParam != null) {
        dataServiceObj.getElementsByTagName("config").item(0).appendChild(createPropelement(newParam[0], newParam[1]));
    }
    refreshDataServiceScreen();
}

function addNewConfigParameter() {
    var quDivObj = document.getElementById("divDSAddParam");
    wso2.wsf.Util.processXML(dataServiceObj, "data_service_add_config_param.xsl", quDivObj);
}

function add_param(validate) {
    if (document.getElementById("txtDataServiceParamName") != null)
    {
        var paramName = document.getElementById("txtDataServiceParamName").value;
        var paramValue = document.getElementById("txtDataServiceParamValue").value;
        if (paramName != "") {
            var isvalid = true;
            var paramset = dataServiceObj.getElementsByTagName("property");
            for (var i = 0; i < paramset.length; i++) {
                if (paramset[i].getAttribute("name") == paramName) {
                    if (!validate) {
                        wso2.wsf.Util.alertWarning("Parameter with the name \"" + paramName +
                                                   "\" already exists");
                        return false;
                    } else {
                        isvalid = false;
                    }
                }
            }
            if (isvalid) {
                dataServiceObj.getElementsByTagName("config")[0].appendChild(createPropelement(paramName, paramValue));
            }
        } else if (!validate) {
            wso2.wsf.Util.alertWarning("Parameter name is required in order to add a configuration parameter");
            return false;
        }
    }
    return true;
}

function add_ds_param() {

    ds_collectdata["ds_step0"](true);
    if (!add_param()) {
        return;
    }
    refreshDataServiceScreen();
}

function remove_ds_param(paramName) {

    var properties = dataServiceObj.getElementsByTagName("config")[0].getElementsByTagName("property");
    for (var i = 0; i < properties.length; i++) {
        if (properties[i].getAttribute("name") == paramName) {
            dataServiceObj.getElementsByTagName("config")[0].removeChild(properties[i]);
        }
    }
    refreshDataServiceScreen();
}

function addNewInputMapping() {
    var newParam = wso2.wsf.Util.getUserInputCustum("Please enter the Input Mapping name", "Please enter the SQL Type", false);
    if (newParam != null) {
        dataServiceQueryObj.appendChild(createInputMappingElement(newParam[0], newParam[1]));
    }
    refresEditDataServiceQueryScreen();
}


function addDataServiceOMElementDone() {

    var dataServiceOMElementName = document.getElementById("txtDataServiceOMElementName").value;
    var dataServiceOMColumnName = document.getElementById("txtDataServiceOMColumnName").value;

    if (dataServiceOMElementName == "") {
        wso2.wsf.Util.alertWarning("Name for an output mapping is required");
        return;
    }

//    if(editingOPMapping != "") {
    var mappings = dataServiceQueryObj.getElementsByTagName("element");
    for (var i = 0; i < mappings.length; i++) {
        if (mappings[i].getAttribute("column") == editingOPMapping && editingOPMapping != "") {
            mappings[i].parentNode.removeChild(mappings[i]);
        } else {
            if (mappings[i].getAttribute("column") == dataServiceOMColumnName) {
                wso2.wsf.Util.alertWarning("Output mapping for the specified column already exists");
                return false;
            }
        }
    }
//    }

    dataServiceQueryObj.getElementsByTagName("result").item(0).appendChild(createOutputMappingElement(dataServiceOMElementName, dataServiceOMColumnName));
    refresEditDataServiceQueryScreen();
//	refreshWizardScreen('divDataServiceAddOutput','data_service_add_query_output_mapping.xsl',dataServiceQueryObj,'dataServiceOutputMappingHeader');
}

function addDataServiceOMQueryDone() {

    var dsQueries = document.getElementById("cmbDataServiceQueryId");
    var dataServiceQueryId = dsQueries.options[dsQueries.selectedIndex].value;

//    if(editingOPMapping != "") {
    var mappings = dataServiceQueryObj.getElementsByTagName("call-query");
    for (var i = 0; i < mappings.length; i++) {
        if (mappings[i].getAttribute("href") == editingOPMapping && editingOPMapping != "") {
            mappings[i].parentNode.removeChild(mappings[i]);
        } else {
            if (mappings[i].getAttribute("href") == dataServiceQueryId) {
                wso2.wsf.Util.alertWarning("Output mapping for the query id \"" +
                                           dataServiceQueryId + "\" already present");
                return false;
            }
        }
    }

    var callQuery = createOutputMappingQuery(dataServiceQueryId);
    var dsqueries = dataServiceObj.getElementsByTagName("query");
    for (var j = 0; j < dsqueries.length; j++) {
        if (dsqueries[j].getAttribute("id") == dataServiceQueryId) {
            var queryparams = dsqueries[j].getElementsByTagName("param");
            for (var k = 0; k < queryparams.length; k++) {
                var qparaname = queryparams[k].getAttribute("name");
                callQuery.appendChild(createWithParamElement(qparaname, document.getElementById("mapping_for_" +
                                                                                                qparaname).value));
            }
        }
    }
//    }
    //    alert(dsQueries.selectedIndex + " " + dataServiceQueryId)
    //    var mappings = dataServiceQueryObj.getElementsByTagName("call-query");
    //    for(var i=0; i<mappings.length; i++) {
    //        if(mappings[i].getAttribute("href") == dataServiceQueryId) {
    //            wso2.wsf.Util.alertWarning("Output mapping for the query id \"" + dataServiceQueryId + "\" already present");
    //            return false;
    //        }
    //    }

    dataServiceQueryObj.getElementsByTagName("result").item(0).appendChild(callQuery);
//    dataServiceQueryObj.getElementsByTagName("result").item(0).appendChild(createOutputMappingQuery(dataServiceQueryId));
    refresEditDataServiceQueryScreen();
//	refreshWizardScreen('divDataServiceAddOutput','data_service_add_query_output_mapping.xsl',dataServiceQueryObj,'dataServiceOutputMappingHeader');
}

function dataserviceOMTypeSelected(outputType) {
    if (outputType == 'OutputElement') {
        document.getElementById('divOMElement').style.display = "inline";
        document.getElementById('divOMQuery').style.display = "none";
    } else if (outputType == 'Query') {
        document.getElementById('divOMElement').style.display = "none";
        document.getElementById('divOMQuery').style.display = "inline";
        displayOperationWithParams();
    }
    curDataServiceOutputMappingType = outputType;
}

function displayAddDataServiceOperation() {
    //	dataServiceCurOpObj = null;
    var opDivObj = document.getElementById("divDSAddOperation");
    wso2.wsf.Util.processXML(dataServiceObj, "data_service_add_operation.xsl", opDivObj);
//    wso2.wsf.Util.showOnlyOneMain(opDivObj);
    //    showDataServiceOperationsHeader(document.getElementById('dataServiceAddOperationHeader'));
}

function displayOperationWithParams() {
    //	dataServiceCurOpObj = null;
    dataServiceObj.setAttribute("ds_op_query_id", document.getElementById("cmbDataServiceQueryId").value);
    var opDivObj = document.getElementById("divDSOperationParams");
    wso2.wsf.Util.processXML(dataServiceObj, "data_service_operation_params.xsl", opDivObj);
//    wso2.wsf.Util.showOnlyOneMain(opDivObj);
    //    showDataServiceOperationsHeader(document.getElementById('dataServiceAddOperationHeader'));
}


function addDataServiceOperation() {
    var opName = document.getElementById("txtDataServiceOpName").value;
    var queryName = document.getElementById("cmbDataServiceQueryId").value;

    if (opName != "") {

        if (dataServiceCurOpObj == null) {
            var dsops = dataServiceObj.getElementsByTagName("operation");
            for (var i = 0; i < dsops.length; i++) {
                if (dsops[i].getAttribute("name") == opName) {
                    wso2.wsf.Util.alertWarning("Operation with the name \"" + opName +
                                               "\" already present");
                    return false;
                }
            }
            var opObj = createOpElement(opName, queryName);
            var dsqueries = dataServiceObj.getElementsByTagName("query");
            for (var j = 0; j < dsqueries.length; j++) {
                if (dsqueries[j].getAttribute("id") == queryName) {
                    var queryparams = dsqueries[j].getElementsByTagName("param");
                    for (var k = 0; k < queryparams.length; k++) {
                        var qparaname = queryparams[k].getAttribute("name");
                        opObj.getElementsByTagName("call-query")[0].appendChild(createWithParamElement(qparaname, document.getElementById("mapping_for_" +
                                                                                                                                          qparaname).value));
                    }
                }
            }
            dataServiceObj.getElementsByTagName("data").item(0).appendChild(opObj);
        } else {
            var callQueryObj = dataServiceCurOpObj.getElementsByTagName("call-query").item(0);
            callQueryObj.setAttribute("href", queryName);
            dataServiceCurOpObj.setAttribute("name", opName);
            var withparams = callQueryObj.getElementsByTagName("with-param");
            var k = 0;
            while (withparams.length != 0) {
                callQueryObj.removeChild(withparams[k]);
                k++;
            }

            var dsqueries = dataServiceObj.getElementsByTagName("query");
            for (var j = 0; j < dsqueries.length; j++) {
                if (dsqueries[j].getAttribute("id") == queryName) {
                    var queryparams = dsqueries[j].getElementsByTagName("param");
                    for (var k = 0; k < queryparams.length; k++) {
                        var qparaname = queryparams[k].getAttribute("name");
                        callQueryObj.appendChild(createWithParamElement(qparaname, document.getElementById("mapping_for_" +
                                                                                                           qparaname).value));
                    }
                }
            }
        }
    } else {
        wso2.wsf.Util.alertWarning("Name of an operation is required");
        return false;
    }
//	addNewDataServiceEchoDataElement(dataServiceObj);
    refreshDataServiceScreen();
    dataServiceCurOpObj = null;
}


//TODO : note edit operation params
function editDataServiceOperation(operationName) {
    var divInnerHtml = yuiTransformer(dataServiceObj, "data_service_add_edit_operations.xsl", false, [["operationName", operationName]]);
    showYUIPanel("Edit Operation", divInnerHtml, "600px", "step2Inner10", "divDSAddEditOperations");

    divInnerHtml =
    yuiTransformerObj(dataServiceObj, "data_service_add_edit_operatoin_query.xsl", false, [["operationName", operationName]]);
    var obj = document.getElementById("showOperationParameterMappingDivId");
    obj.innerHTML = "";
    obj.appendChild(divInnerHtml);
}

// TODO note deleting a operation
function dataServiceRemoveOperation(operationName) {

    var msgStat = confirm("Do you want to delete the operation : " + operationName);
    if (!msgStat) {
        return;
    }

    var opArray = dataServiceObj.getElementsByTagName('operation');
    var opEle = null;
    for (var i = 0; i < opArray.length; i++) {
        if (operationName == opArray[i].getAttribute('name')) {
            opEle = opArray[i];
            break;
        }
    }
    dataServiceObj.getElementsByTagName('data')[0].removeChild(opEle);
    refreshDataServiceScreen();
}

//TODO : note showOnlyRequiredDSOp
function showOnlyRequiredDSOp(queryId, operationName) {
    if (operationName == null || operationName.length == 0) {
        wso2.wsf.Util.alertWarning("Operation name is required before selecting \n" +
                                   "the quaries to be applied.");
        return;
    }
    var divInnerHtml = yuiTransformerObj(dataServiceObj, "data_service_add_edit_operatoin_query.xsl", false, [["queryId", queryId],["editOperationName",operationName]]);
    var obj = document.getElementById("showOperationParameterMappingDivId");
    obj.innerHTML = "";
    obj.appendChild(divInnerHtml);
}


function deployDataService() {
    var dataServiceContents = wso2.wsf.Util.xmlSerializerToString(dataServiceObj.getElementsByTagName("data")[0]);
//    alert('XML == > ' + wso2.wsf.Util.xmlSerializerToString(dataServiceObj.getElementsByTagName("data")[0]));
//    var dataServiceName = dataServiceObj.getElementsByTagName('data')[0].getAttribute('name');
    var body_xml = '<req:saveDataServiceContents xmlns:req="http://org.apache.axis2/xsd">\n' +
//                   ' <arg0>' + dataServiceName + '</arg0>\n' +
                   ' <dataWrapper>' + dataServiceContents + '</dataWrapper>\n' +
                   ' </req:saveDataServiceContents>\n';
//    alert(body_xml);
    var callURL = serverURL + "/" + "DataServiceAdmin";
    new wso2.wsf.WSRequest(callURL, "urn:saveDataServiceContents", body_xml, deployDataServiceCallback);
}


function deployDataServiceCallback() {
    showServiceInitializer();
}

function createOpElement(opName, queryName) {
    var opObj = rootDocument.createElement("operation");
    opObj.setAttribute("name", opName);
    var queryObj = rootDocument.createElement("call-query")
    queryObj.setAttribute("href", queryName);
    opObj.appendChild(queryObj);
    return opObj;
}

function createWithParamElement(queryParamName, paramName) {
    var opObj = rootDocument.createElement("with-param");
    if (paramName != null && paramName != "") {
        opObj.setAttribute("name", paramName);
    } else {
        opObj.setAttribute("name", queryParamName);
    }
    opObj.setAttribute("query-param", queryParamName);
    return opObj;
}


function createPropelement(propName, propValue) {
    var propObj = rootDocument.createElement("property");
    propObj.appendChild(rootDocument.createTextNode(propValue));
    propObj.setAttribute("name", propName);
    return propObj;
}

function createInputMappingElement(elementName, sqlType) {
    var imElement = rootDocument.createElement("param");
    imElement.setAttribute("name", elementName);
    imElement.setAttribute("sqlType", sqlType);
    return imElement;
}


function createOutputMappingElement(elementName, dataColumn) {
    var imElement = rootDocument.createElement("element");
    imElement.setAttribute("name", elementName);
    imElement.setAttribute("column", dataColumn);
    return imElement;
}

function createOutputMappingQuery(queryName) {
    var imElement = rootDocument.createElement("call-query");
    imElement.setAttribute("href", queryName);
    return imElement;
}

function querySQLOnChange(sqlStatement, form) {
    var sqlObj = dataServiceQueryObj.getElementsByTagName("sql").item(0);
    sqlObj.removeChild(sqlObj.childNodes.item(0));
    sqlObj.appendChild(rootDocument.createTextNode(sqlStatement));

    if (sqlStatement.length > 0) {
        changeOutputMappingFieldStatus(false);
     	//if sql contains ?, then need to enable input parameter entry box
        if (sqlStatement.indexOf('?') > -1) {
            document.getElementById('name').disabled = false;
            document.getElementById('sqlType').disabled = false;
            document.getElementById('addInputParamMappingButton').disabled = false;
        }
    } else {
        changeOutputMappingFieldStatus(true);
    }
}

function disableInputMappingFields() {
    if (dataServiceObj.getAttribute("dataSourceType") == "RDBMS"
            || dataServiceObj.getAttribute("dataSourceType") == "JNDIDataSource") {
        var sqlStatement = document.getElementById("txtDataServiceSQL").value;
    	 //if sql contains ?, then need to enable input parameter entry box
        if (sqlStatement.indexOf('?') == -1) {
            document.getElementById('name').disabled = true;
            document.getElementById('sqlType').disabled = true;
            document.getElementById('addInputParamMappingButton').disabled = true;
        }
    }
}

function disableOutputMappingFields() {
    var disableFields = false;
    if ("RDBMS" == dataServiceObj.getAttribute("dataSourceType")
            || "JNDIDataSource" == dataServiceObj.getAttribute("dataSourceType")) {
        var sqlStatement = document.getElementById("txtDataServiceSQL").value;
  	   //if sql field contains something, output mappings should be enabled 
        if (sqlStatement.length == 0) {
            disableFields = true;
        }
    } else if ("CSV" == dataServiceObj.getAttribute("dataSourceType")
            || "EXCEL" == dataServiceObj.getAttribute("dataSourceType")) {
        //for CSV & EXCEL only queryId field is visible
        var queryId = document.getElementById("txtDataServiceQueryId").value;
        if (queryId.length == 0) {
            disableFields = true;
        }
    }
    changeOutputMappingFieldStatus(disableFields);
}

function changeOutputMappingFieldStatus(disabled) {
    document.getElementById('txtDataServiceWrapElement').disabled = disabled;
    document.getElementById('txtDataServiceRowName').disabled = disabled;
    document.getElementById('cmbDataServiceOMType').disabled = disabled;
     //default selection is Element,following fields are shown for element
    document.getElementById('txtDataServiceOMElementName').disabled = disabled;
    document.getElementById('txtDataServiceOMColumnName').disabled = disabled;
    document.getElementById('addOutputParamMappingButton').disabled = disabled;
    document.getElementById('addQueryButton').disabled = disabled;
    document.getElementById('addQueryRestButton').disabled = disabled;
}


function queryWENOnChange(WEN) {
    var resultObj = dataServiceQueryObj.getElementsByTagName("result").item(0);
    resultObj.setAttribute("element", WEN);
}

function queryRNOnChange(RN) {
    var resultObj = dataServiceQueryObj.getElementsByTagName("result").item(0);
    resultObj.setAttribute("rowName", RN);
}

function newQueryIdOnChange(queryId) {
    var queryIdTrimmed = queryId.replace(/^\s+|\s+$/g, '') ;
    if (queryIdTrimmed.length == 0) {
        //user has emptied the queryId
        changeOutputMappingFieldStatus(true);
    } else {
        if ("CSV" == dataServiceObj.getAttribute("dataSourceType")) {
            changeOutputMappingFieldStatus(false);
        }
    }
    dataServiceQueryObj.setAttribute("id", queryId);
}

/*function showGeneratedConfigFile() {
    var finalScreenHTML = '<h4><div id="divGeneratedConfigHeader"></div></h4>' +
                          '<div><label>Review and Deploy Dataservice</label></div>' +
                          '<div id="formset">' +
                          '<form>' +
                          '<fieldset style="border:none;">' +
                          '<div>' +
                          '<textarea rows="30" cols="80" id="txtDataServiceReviewBox"></textarea>' +
                          '</div><p>&nbsp;</p>' +
                          '<div>' +
                          '<input type="button" value="Deploy" onclick="javascript:deployDataService();return false;"/>' +
                          '</div>' +
                          '</fieldset>' +
                          '</form>' +
                          '</div>' +
                          '</fieldset>';
    var dataServiceConfigDiv = document.getElementById("divDataServiceDisplayConfig");
    dataServiceConfigDiv.innerHTML = finalScreenHTML;
    document.getElementById("txtDataServiceReviewBox").value =
    prettyPrintDOMNode(dataServiceObj.getElementsByTagName("data").item(0), "", "    ", true);
    showNewDataServiceHeader(document.getElementById('divGeneratedConfigHeader'));
    wso2.wsf.Util.showOnlyOneMain(dataServiceConfigDiv);
}*/

// TODO : note: toggling

function changeToNextMapping(queryId, mappingObj) {
    var mappingValue = mappingObj[mappingObj.selectedIndex].value;
    if (mappingValue == 'Element') {
        document.getElementById('divOMElement').style.display = "inline";
        document.getElementById('divOMQuery').style.display = "none";
    } else if (mappingValue == 'Query') {
        document.getElementById('divOMElement').style.display = "none";
        document.getElementById('divOMQuery').style.display = "inline";
        //First time showing for new services
        var objCmb = document.getElementById('cmbDataServiceQueryId');
        var cmbValue = objCmb[objCmb.selectedIndex].value;
        var divObj = document.getElementById('divInnerQueryExplorler_'+cmbValue);
        if (divObj) {
            divObj.style.display = "inline";
        }
    }
}

//TODO : refresh parent query container
/*
*  data_service_add_query.xsl
*  divDSAddQuery
*  Add New Query
*
*/
function refreshParentQueryContainer(/*must*/queryId, /*must*/xslName, /*must*/parentDivId, /*must*/title) {
    var divInnerHtml = yuiTransformer(dataServiceObj, xslName, false, [["queryId",queryId]]);
    showYUIPanel(title, divInnerHtml, "600px", "step2Inner13", parentDivId);

}

//TODO : note: adding and editing for output params
function addEditSpecificOutputMapping(queryId, mappingObj, oldOutputFieldName, cqmObj) {
    var qArray = dataServiceObj.getElementsByTagName('query');
    var queryEle = null;
    for (var i = 0; i < qArray.length; i++) {
        if (queryId == qArray[i].getAttribute('id')) {
            queryEle = qArray[i];
            break;
        }
    }
    var resultArray = queryEle.getElementsByTagName('result');
    var resultEle = null;
    for (i = 0; i < resultArray.length; i++) {
        resultEle = resultArray[i];
        break;
    }
    var mappingValue = mappingObj[mappingObj.selectedIndex].value;
    if (mappingValue == 'Element' || mappingValue == 'Attribute') {
        var name = document.getElementById('txtDataServiceOMElementName').value;
        var column = document.getElementById('txtDataServiceOMColumnName').value;
        if (name == null || name.length == 0) {
            wso2.wsf.Util.alertWarning("Output field name is required");
            return;
        }
        if (column == null || column.length == 0) {
            wso2.wsf.Util.alertWarning("SQL column name is required");
            return;
        }
        var eEleArray = null;
        if (mappingValue == 'Element') {
            eEleArray = resultEle.getElementsByTagName('element');
        } else if (mappingValue == 'Attribute') {
            eEleArray = resultEle.getElementsByTagName('attribute');
        } else {
            wso2.wsf.Util.alertWarning("Mapping Type is not available");
            return;
        }
        var eEle1 = null;
        if (name == oldOutputFieldName) {
            //same elements and in the editing stage
            for (i = 0; i < eEleArray.length; i++) {
                if (eEleArray[i].getAttribute('name') == name) {
                    eEle1 = eEleArray[i];
                    break;
                }
            }
            eEle1.removeAttribute("name");
            eEle1.removeAttribute("column");
            eEle1.setAttribute("name", name);
            eEle1.setAttribute("column", column);
        } else {
            //different element; thus this could be a new element or old one
            if (oldOutputFieldName == null || oldOutputFieldName.length == 0) {
                // aha new element
                for (i = 0; i < eEleArray.length; i++) {
                    if (eEleArray[i].getAttribute('name') == name) {
                        eEle1 = eEleArray[i];
                        break;
                    }
                }
                if (eEle1) {
                    wso2.wsf.Util.alertWarning("Element already exist with the name " + name);
                    return;
                }
                if (mappingValue == 'Element') {
                   eEle1 = rootDocument.createElement("element");
                } else {
                   eEle1 = rootDocument.createElement("attribute");
                }
                eEle1.setAttribute("name", name);
                eEle1.setAttribute("column", column);
                resultEle.appendChild(eEle1);
            } else {
                for (i = 0; i < eEleArray.length; i++) {
                    if (eEleArray[i].getAttribute('name') == name) {
                        eEle1 = eEleArray[i];
                        break;
                    }
                }
                if (eEle1) {
                    wso2.wsf.Util.alertWarning("Element already exist with the name " + name);
                    return;
                } else {
                    for (i = 0; i < eEleArray.length; i++) {
                        if (eEleArray[i].getAttribute('name') == oldOutputFieldName) {
                            eEle1 = eEleArray[i];
                            break;
                        }
                    }
                    resultEle.removeChild(eEle1);
                    if (mappingValue == 'Element') {
                        eEle1 = rootDocument.createElement("element");
                    } else {
                        eEle1 = rootDocument.createElement("attribute");
                    }
                    eEle1.setAttribute("name", name);
                    eEle1.setAttribute("column", column);
                    resultEle.appendChild(eEle1);
                }

            }

        }
    } else if (mappingValue == 'Query') {
        var obj = document.getElementById('cmbDataServiceQueryId');
        var objValue = obj[obj.selectedIndex].value;
        var cqArray = resultEle.getElementsByTagName("call-query");
        var tEle = null;
        for (i = 0; i < cqArray.length; i++) {
            if (cqArray[i].getAttribute("href") == objValue) {
                tEle = cqArray[i];
                break;
            }
        }
        if (!tEle) {
            tEle = rootDocument.createElement("call-query");
            tEle.setAttribute("href", objValue);
            resultEle.appendChild(tEle);
        } else {
            resultEle.removeChild(tEle);
            tEle = rootDocument.createElement("call-query");
            tEle.setAttribute("href", objValue);
            resultEle.appendChild(tEle);
        }
        var withParamObj = cqmObj[objValue];
        for(var o in withParamObj) {
            var n = o;
            var v = withParamObj[n];
            var withParamEle = rootDocument.createElement("with-param");
            tEle.appendChild(withParamEle);
            if (v && v.length != 0) {
                withParamEle.setAttribute("name", v);
            } else {
                withParamEle.setAttribute("name", n);
            }
            withParamEle.setAttribute("query-param", n);
        }

    }
    var currentDiv = document.getElementById("divADDEditOutputMapping");
    currentDiv.style.display = "none";
    currentDiv.innerHTML = "";
    var divInnerHtml = yuiTransformer(dataServiceObj, "data_service_add_query.xsl", false, [["queryId",queryId]]);
    showYUIPanel("Add/Edit Query", divInnerHtml, "600px", "step2Inner13", "divDSAddQuery");
}

//TODO : note : add new output mapping. 
function addNewOutPutMappingForQuery(queryId, sql, type) {
    if (!queryId) {
        wso2.wsf.Util.alertWarning("Required queryId before adding output mapping.");
        return;
    }
    var qArray = dataServiceObj.getElementsByTagName('query');
    var queryEle = null;
    for (var i = 0; i < qArray.length; i++) {
        if (queryId == qArray[i].getAttribute('id')) {
            queryEle = qArray[i];
            break;
        }
    }
    if (!queryEle) {
        queryEle = rootDocument.createElement("query");
        queryEle.setAttribute("id", queryId);
        dataServiceObj.getElementsByTagName("data").item(0).appendChild(queryEle);
    }

    if (type == "RDBMS" || type == "JNDIDataSource") {
        var sqlArray = queryEle.getElementsByTagName('sql');
        var sqlEle = null;
        for (i = 0; i < sqlArray.length; i++) {
            sqlEle = sqlArray[i];
            break;
        }
        if (!sqlEle) {
            sqlEle = rootDocument.createElement("sql");
            sqlEle.appendChild(rootDocument.createTextNode(sql));
            queryEle.appendChild(sqlEle);
        } else {
            sqlEle.removeChild(sqlEle.childNodes.item(0));
            sqlEle.appendChild(rootDocument.createTextNode(sql));
        }
    } else if (type == "EXCEL") {
        //filling the missing pieces
        var eExcel;
        var excelArray = queryEle.getElementsByTagName('excel');
        for (i = 0; i < excelArray.length; i++) {
            eExcel = excelArray[i];
            break;
        }
        if (eExcel) {
            queryEle.removeChild(eExcel);
        }

        eExcel = rootDocument.createElement("excel");
        var workBookNameElement = rootDocument.createElement("workbookname");
        var startingRowElement = rootDocument.createElement("startingrow");
        var maxRowCountElement = rootDocument.createElement("maxrowcount");
        var hasHeaderElement = rootDocument.createElement("hasheader");

        var excelWBName = document.getElementById('txtExcelWorkbookName').value;
        var excelStartingRow = document.getElementById('txtExcelStartingRow').value;
        var excelMaxRowCount = document.getElementById('txtExcelMaxRowCount').value;

        var obj = document.getElementById('txtExcelHeaderColumns');
        var hasHeaderValue = obj[obj.selectedIndex].value;
        if (hasHeaderValue == null || hasHeaderValue.length == 0) {
            wso2.wsf.Util.alertWarning("Status of the headers available is required.");
            return;
        }
        workBookNameElement.appendChild(rootDocument.createTextNode(excelWBName));
        startingRowElement.appendChild(rootDocument.createTextNode(excelStartingRow));
        maxRowCountElement.appendChild(rootDocument.createTextNode(excelMaxRowCount));
        hasHeaderElement.appendChild(rootDocument.createTextNode(hasHeaderValue));
       //add as children to excel element
        eExcel.appendChild(workBookNameElement);
        eExcel.appendChild(startingRowElement);
        eExcel.appendChild(maxRowCountElement);
        eExcel.appendChild(hasHeaderElement);

        queryEle.appendChild(eExcel);
    }

    var resultArray = queryEle.getElementsByTagName('result');
    var resultEle = null;
    for (i = 0; i < resultArray.length; i++) {
        resultEle = resultArray[i];
        break;
    }
    if (!resultEle) {
        resultEle = rootDocument.createElement("result");
        queryEle.appendChild(resultEle);
    }
    var elementName = document.getElementById("txtDataServiceWrapElement").value;
    var rowName = document.getElementById("txtDataServiceRowName").value;
    var rowNamespace = document.getElementById("txtDataServiceRowNamespace").value;
    //eg. INSERT,UPDATE,SELECT,etc
    //Only interested in INSERT & UPDATE
    var firstPart = sql.substring(0,6); 
    if(firstPart.toLowerCase() == "insert" || firstPart.toLowerCase() == "update"){
     //grouped by element & row name are not needed here
    }else{
      if (elementName == null || elementName.length == 0) {
        wso2.wsf.Util.alertMessage("Grouped by element is required");
        return;
      }
      if (rowName == null || rowName.length == 0) {
        wso2.wsf.Util.alertMessage("Row name is required");
        return;
      }    
    }
    resultEle.setAttribute("element", elementName);
    resultEle.setAttribute("rowName", rowName);
    resultEle.setAttribute("defaultNamespace", rowNamespace);
    //TODO : fix this
    var divInnerHtml = yuiTransformer(dataServiceObj, "data_service_add_edit_result_mapping.xsl", false, [["queryId",queryId]]);
    showYUIPanel("Add New Output Mapping ", divInnerHtml, "600px", "step2Inner10", "divADDEditOutputMapping");


}

//TODO : note edit query output mapping
function editQueryOutputMappingElement(queryId, eleName, colName) {
    var divInnerHtml = yuiTransformer(dataServiceObj, "data_service_add_edit_result_mapping.xsl", false, [["queryId",queryId],["eleName",eleName],["colName", colName]]);
    showYUIPanel("Edit Output Mapping ", divInnerHtml, "600px", "step2Inner10", "divADDEditOutputMapping");
}

//TODO: note edit query output mapping attribute
function editQueryOutputMappingAttribute(queryId, atName, colName) {
    var divInnerHtml = yuiTransformer(dataServiceObj, "data_service_add_edit_result_mapping.xsl", false, [["queryId",queryId],["atName",atName],["colName", colName]]);
    showYUIPanel("Edit Output Mapping ", divInnerHtml, "600px", "step2Inner10", "divADDEditOutputMapping");

}

function editQueryOutputMappingCallQuery(queryId, queryHref) {
    var divInnerHtml = yuiTransformer(dataServiceObj, "data_service_add_edit_result_mapping.xsl", false, [["queryId",queryId],["queryHref", queryHref]]);
    showYUIPanel("Add New Output Mapping ", divInnerHtml, "600px", "step2Inner10", "divADDEditOutputMapping");
}

// TODO: note; To final step 
function stepTwoToSetpFinal() {
    dataServiceObj.setAttribute("ds_step", parseInt(dataServiceObj.getAttribute("ds_step")) + 1);
    refreshDataServiceScreen();
}

// TODO : note add new operaiton. 
function addNewOperationForDataService() {
    var divInnerHtml = yuiTransformer(dataServiceObj, "data_service_add_edit_operations.xsl");
    showYUIPanel("Add New Operation", divInnerHtml, "600px", "step2Inner10", "divDSAddEditOperations");

    divInnerHtml = yuiTransformerObj(dataServiceObj, "data_service_add_edit_operatoin_query.xsl");
    var obj = document.getElementById("showOperationParameterMappingDivId");
    obj.innerHTML = "";
    obj.appendChild(divInnerHtml);
}

//TODO : note add new operation
function addNewOperationForDataServiceOK(paramObj, status, oldOperationName) {
    var queryName = null;
    var params = new Object();
    for (var param in paramObj) {
        if (param == "queryNameForOperation1234UUURRX") {
            queryName = paramObj[param];
            continue;
        }
        params[param] = paramObj[param];
    }
    var operationName = document.getElementById('operationNameTextId').value;
    if (operationName == null || operationName.length == 0) {
        wso2.wsf.Util.alertMessage("Operation name is required");
        return;
    }
    //TODO validation for existing operaiton
    var opArray = dataServiceObj.getElementsByTagName('operation');
    var tmpOpEle = null;
    if (operationName == oldOperationName) {
        //This is an exiting operation and going to change its @
        for (var i = 0; i < opArray.length; i++) {
            if (operationName == opArray[i].getAttribute('name')) {
                tmpOpEle = opArray[i];
                break;
            }
        }
        if (tmpOpEle) {
            dataServiceObj.getElementsByTagName('data')[0].removeChild(tmpOpEle);
        }
    } else {
        if (oldOperationName == null || oldOperationName.length == 0) {
            //new operation do not do anything just let it go
        } else {
            //existing operation
            for (var i = 0; i < opArray.length; i++) {
                if (operationName == opArray[i].getAttribute('name')) {
                    tmpOpEle = opArray[i];
                    break;
                }
            }
            if (tmpOpEle) {
                wso2.wsf.Util.alertWarning("There already exist an operation named " + operationName + ".\n" +
                                           "The given operation name will cause a conflict.");
                return;
            } else {
                //removeing the old one
                for (var i = 0; i < opArray.length; i++) {
                    if (oldOperationName == opArray[i].getAttribute('name')) {
                        tmpOpEle = opArray[i];
                        break;
                    }
                }
                dataServiceObj.getElementsByTagName('data')[0].removeChild(tmpOpEle);
                tmpOpEle = rootDocument.createElement("operation");
            }

        }
    }

    if (status == "FALSE") {
        var opEle = rootDocument.createElement("operation");
        opEle.setAttribute("name", operationName);
        var cqEle = rootDocument.createElement("call-query");
        cqEle.setAttribute("href", queryName);
        opEle.appendChild(cqEle);
        dataServiceObj.getElementsByTagName("data").item(0).appendChild(opEle);
    }
    if (status == "TRUE") {
        opEle = rootDocument.createElement("operation");
        opEle.setAttribute("name", operationName);
        cqEle = rootDocument.createElement("call-query");
        cqEle.setAttribute("href", queryName);
        opEle.appendChild(cqEle);
        dataServiceObj.getElementsByTagName("data").item(0).appendChild(opEle);
        for (var k in params) {
            var n = k;
            var v = params[k];
            var wpEle = rootDocument.createElement("with-param");
            if (v == null || v.length == 0) {
                wpEle.setAttribute("name", n);
                wpEle.setAttribute("query-param", n);
            } else {
                wpEle.setAttribute("name", v);
                wpEle.setAttribute("query-param", n);
            }
            cqEle.appendChild(wpEle);
        }

    }
    refreshDataServiceScreen();
}

//TODO : note remove query output mapping
function removeQueryOutputMapping(queryId, mappingType, commonName) {

    var msgStat = confirm("Do you want to delete the output mapping : " + commonName);
    if (!msgStat) {
        return;
    }

    var qArray = dataServiceObj.getElementsByTagName('query');
    var queryEle = null;
    for (var i = 0; i < qArray.length; i++) {
        if (queryId == qArray[i].getAttribute('id')) {
            queryEle = qArray[i];
            break;
        }
    }

    var resultArray = queryEle.getElementsByTagName('result');
    var resultEle = null;
    for (i = 0; i < resultArray.length; i++) {
        resultEle = resultArray[i];
        break;
    }

    if (mappingType == "Element") {
        var eArray = resultEle.getElementsByTagName('element');
        var eEle = null;
        for (i = 0; i < eArray.length; i++) {
            if (eArray[i].getAttribute('name') == commonName) {
                eEle = eArray[i];
                break;
            }
        }
        resultEle.removeChild(eEle);
    } else if (mappingType == "Query") {
        var cqArray = resultEle.getElementsByTagName('call-query');
        var cqEle = null;
        for (i = 0; i < cqArray.length; i++) {
            if (cqArray[i].getAttribute('href') == commonName) {
                cqEle = cqArray[i];
                break;
            }
        }
        resultEle.removeChild(cqEle);
    } else if (mappingType == "Attribute") {
       var atArray = resultEle.getElementsByTagName('attribute');
        var atEle = null;
        for (i = 0; i < eArray.length; i++) {
            if (atArray[i].getAttribute('name') == commonName) {
                atEle = atArray[i];
                break;
            }
        }
        resultEle.removeChild(atEle);
    }
    var currentDiv = document.getElementById("divADDEditOutputMapping");
    currentDiv.style.display = "none";
    currentDiv.innerHTML = "";
    var divInnerHtml = yuiTransformer(dataServiceObj, "data_service_add_query.xsl", false, [["queryId",queryId]]);
    showYUIPanel("Add New Query", divInnerHtml, "600px", "step2Inner13", "divDSAddQuery");

}

//TODO : note: validate query string value. 
function validateQueryTextValue(obj) {
    var queries = dataServiceObj.getElementsByTagName("query");
    for (var i = 0; i < queries.length; i++) {
        if (obj.value == queries[i].getAttribute("id")) {
            wso2.wsf.Util.alertWarning("Query by the name : " + obj.value + " already exist. \n" +
                                       "Type different value for query id");
            obj.value = "";
            break;
        }
    }
}

//TODO : note: removing the transient querty
function removeTransientQuery(queryId) {
    if (queryId) {
        var qArray = dataServiceObj.getElementsByTagName('query');
        var queryEle = null;
        for (var i = 0; i < qArray.length; i++) {
            if (queryId == qArray[i].getAttribute('id')) {
                queryEle = qArray[i];
                break;
            }
        }
        if (queryEle) {
            dataServiceObj.removeChild(queryEle);
        }
    }

}

//TOdO : note: validate all operation names
function validateOperationNameValue(obj) {
    var operations = dataServiceObj.getElementsByTagName("operation");
    for (var i = 0; i < operations.length; i++) {
        if (obj.value == operations[i].getAttribute("name")) {
            wso2.wsf.Util.alertWarning("Operation by the name : " + obj.value + " already exist. \n" +
                                       "Type different value for operation name.");
            obj.value = "";
            break;
        }
    }

}

//TODO note: add a new query with the ok button 
function addNewQueryOK(queryId) {

    if (queryId == null || queryId.length == 0) {
        wso2.wsf.Util.alertWarning("Query id is required.");
        return;
    }

    var qArray = dataServiceObj.getElementsByTagName('query');
    var queryEle;
    for (var i = 0; i < qArray.length; i++) {
        if (queryId == qArray[i].getAttribute('id')) {
            wso2.wsf.Util.alertWarning("A query already exist with the id : " + queryId);
            return;
        }
    }
    queryEle = rootDocument.createElement("query");
    queryEle.setAttribute("id", queryId);

    //TODO: reslut
    var rArray = queryEle.getElementsByTagName('result');
    var rEle = null;
    for (i = 0; i < rArray.length; i++) {
        rEle = rArray[i];
        break;
    }
    var rgName = document.getElementById('txtDataServiceWrapElement').value;
    var rowName = document.getElementById('txtDataServiceRowName').value;
    var rowNamespace = document.getElementById('txtDataServiceRowNamespace').value;

    if (!rEle) {
        rEle = rootDocument.createElement("result");       
        if (!(rgName == null || rgName.length == 0)) {
           rEle.setAttribute("element", rgName);
        }
        if (!(rowName == null || rowName.length == 0)) {
           rEle.setAttribute("rowName", rowName);
        }                
        if (!(rowNamespace == null || rowNamespace.length == 0)) {
           rEle.setAttribute("defaultNamespace", rowNamespace);
        }else{
           rEle.removeAttribute("defaultNamespace");
        }
        //if rowname & row group name is null, do not set result element
        if(!(rEle.getAttribute("element") == null && rEle.getAttribute("rowName") == null)){
          qEle.appendChild(rEle);        
        }
    } else {
        rEle.removeAttribute("element");
        rEle.removeAttribute("rowName");
        rEle.removeAttribute("defaultNamespace");
        if (!(rgName == null || rgName.length == 0)) {
           rEle.setAttribute("element", rgName);
        }
        if (!(rowName == null || rowName.length == 0)) {
           rEle.setAttribute("rowName", rowName);
        }                        
        if (!(rowNamespace == null || rowNamespace.length == 0)) {
          rEle.setAttribute("defaultNamespace", rowNamespace);
        }        
        //if rowname & row group name is null, do not set result element
        if(rEle.getAttribute("element") == null || rEle.getAttribute("rowName") == null){
          qEle.removeChild(rEle);    
        }        
    }
    

    if ("EXCEL" == dataServiceObj.getAttribute("dataSourceType")) {
        if (rgName == null || rgName.length == 0) {
          wso2.wsf.Util.alertWarning("Group by element is required");
          return;
        }
        if (rowName == null || rowName.length == 0) {
          wso2.wsf.Util.alertWarning("Row name element is required");
          return;
        }
    
        //sqlEle.appendChild(rootDocument.createTextNode("UseSheet=0:StartReadingFromRow=1"));
        //create excel elements
        var excelElement = rootDocument.createElement("excel");
        var workBookNameElement = rootDocument.createElement("workbookname");
        var startingRowElement = rootDocument.createElement("startingrow");
        var maxRowCountElement = rootDocument.createElement("maxrowcount");
        var hasHeaderElement = rootDocument.createElement("hasheader");

       //append text box values
        //TODO validation for inputs.

        var excelWBName = document.getElementById('txtExcelWorkbookName').value;
        var excelStartingRow = document.getElementById('txtExcelStartingRow').value;
        var excelMaxRowCount = document.getElementById('txtExcelMaxRowCount').value;
        if (excelWBName == null || excelWBName.length == 0) {
            wso2.wsf.Util.alertWarning("Workbook name is required");
            return;
        }
        if (excelStartingRow == null || excelStartingRow.length == 0) {
            wso2.wsf.Util.alertWarning("Strart reading from is required.");
            return;
        }
        if (excelMaxRowCount == null || excelMaxRowCount.length == 0) {
            wso2.wsf.Util.alertWarning("Rows to read is required.");
            return;
        }
        var obj = document.getElementById('txtExcelHeaderColumns');
        var hasHeaderValue = obj[obj.selectedIndex].value;
        if (hasHeaderValue == null || hasHeaderValue.length == 0) {
            wso2.wsf.Util.alertWarning("Status of the headers available is required.");
            return;
        }

        workBookNameElement.appendChild(rootDocument.createTextNode(excelWBName));
        startingRowElement.appendChild(rootDocument.createTextNode(excelStartingRow));
        maxRowCountElement.appendChild(rootDocument.createTextNode(excelMaxRowCount));
        hasHeaderElement.appendChild(rootDocument.createTextNode(hasHeaderValue));
       //add as children to excel element
        excelElement.appendChild(workBookNameElement);
        excelElement.appendChild(startingRowElement);
        excelElement.appendChild(maxRowCountElement);
        excelElement.appendChild(hasHeaderElement);

        queryEle.appendChild(excelElement);


    } else if ("RDBMS" == dataServiceObj.getAttribute("dataSourceType")
            || "JNDIDataSource" == dataServiceObj.getAttribute("dataSourceType")) {
        var sqlEle = rootDocument.createElement("sql");
        var sqlEleTextNode = rootDocument.createCDATASection((document.getElementById('txtDataServiceSQL').value));
        sqlEle.appendChild(sqlEleTextNode);
        queryEle.appendChild(sqlEle);
    } else if ("CSV" == dataServiceObj.getAttribute("dataSourceType")) {
        if (rgName == null || rgName.length == 0) {
          wso2.wsf.Util.alertWarning("Group by element is required");
          return;
        }
        if (rowName == null || rowName.length == 0) {
          wso2.wsf.Util.alertWarning("Row name element is required");
          return;
        }    
    }

    /*var resultEle = rootDocument.createElement("result");
    resultEle.setAttribute("element", "");
    resultEle.setAttribute("rowName", "");
    queryEle.appendChild(resultEle);*/
    dataServiceObj.getElementsByTagName("data").item(0).appendChild(queryEle);

    refreshDataServiceScreen();
}
var dataServiceNewQuery = false;

function addDataServiceQuery() {
    dataServiceNewQuery = true;

    var queryEle = rootDocument.createElement("query");


    if ("EXCEL" == dataServiceObj.getAttribute("dataSourceType")) {
        queryEle.setAttribute("id", "");
	   //sqlEle.appendChild(rootDocument.createTextNode("UseSheet=0:StartReadingFromRow=1"));
        //create excel elements
        var excelElement = rootDocument.createElement("excel");
        var workBookNameElement = rootDocument.createElement("workbookname");
        var hasHeaderElement = rootDocument.createElement("hasheader");
        var startingRowElement = rootDocument.createElement("startingrow");
        var maxRowCountElement = rootDocument.createElement("maxrowcount");

       //append text box values
        workBookNameElement.appendChild(rootDocument.createTextNode(""));
        maxRowCountElement.appendChild(rootDocument.createTextNode(""));
        hasHeaderElement.appendChild(rootDocument.createTextNode(""));
        startingRowElement.appendChild(rootDocument.createTextNode(""));

       //add as children to excel element
        excelElement.appendChild(workBookNameElement);
        excelElement.appendChild(hasHeaderElement);
        excelElement.appendChild(startingRowElement);
        excelElement.appendChild(maxRowCountElement);

        queryEle.appendChild(excelElement);


    } else if ("RDBMS" == dataServiceObj.getAttribute("dataSourceType")
            || "JNDIDataSource" == dataServiceObj.getAttribute("dataSourceType")) {
        var sqlEle = rootDocument.createElement("sql");
        queryEle.setAttribute("id", "");
        sqlEle.appendChild(rootDocument.createTextNode(""));
        queryEle.appendChild(sqlEle);
    } else if ("CSV" == dataServiceObj.getAttribute("dataSourceType")) {
        queryEle.setAttribute("id", "");
    }

    var resultEle = rootDocument.createElement("result");
    resultEle.setAttribute("element", "");
    resultEle.setAttribute("rowName", "");
    queryEle.appendChild(resultEle);
    dataServiceObj.getElementsByTagName("data").item(0).appendChild(queryEle);
    dataServiceQueryObj = queryEle;
    refresEditDataServiceQueryScreen();
}

/*function editDataServiceQuery(queryName) {
    dataServiceQueryObj =
    getNodeWithPropertyFromCollection(dataServiceObj.getElementsByTagName("query"), "id", queryName);
    refresEditDataServiceQueryScreen();
}*/


function refresEditDataServiceQueryScreen() {
    editingIPMapping = "";
    editingOPMapping = "";
    //removeEmptyQueries();
    // TODO this is a inner div from data_service.xsl.
    var quDivObj = document.getElementById("divDSAddQuery");
    //TODO allow this from YUI 
    //    wso2.wsf.Util.processXML(dataServiceQueryObj, "data_service_add_query.xsl", quDivObj);

    //    showDataServiceQueryHeader(document.getElementById('dataServiceAddQueryHeader'));
    //	wso2.wsf.Util.showOnlyOneMain(document.getElementById('divDataServiceAddQuery'));
}

var editingIPMapping = "";

/*function edit_ds_ip_mapping(mappingName, mappingValue) {

    document.dataServiceAddQueryForm.name.value = mappingName;
    document.dataServiceAddQueryForm.sqlType.value = mappingValue;
    editingIPMapping = mappingName;
}*/

//TODO : Note: This method will remove an assinged query from tree iff it is not referenced.
// TODO : Thus, first reference need to be removed.
function removeDSQuery(queryId) {
    var msgStat = confirm("Do you want to delete the query : " + queryId);
    if (!msgStat) {
        return;
    }
    //    add_query(true);
    var queries = dataServiceObj.getElementsByTagName("query");
    var references = dataServiceObj.getElementsByTagName("call-query");

    for (var i = 0; i < references.length; i++) {
        if (references[i].getAttribute("href") == queryId) {
            wso2.wsf.Util.alertMessage("Can not delete the query with id \"" + queryId +
                                       "\". There are operations refering to this query");
            return;
        }
    }

    for (i = 0; i < queries.length; i++) {
        if (queries[i].getAttribute("id") == queryId) {
            dataServiceObj.getElementsByTagName("data")[0].removeChild(queries[i]);
        }
    }
    refreshDataServiceScreen();

}

function getNodeWithPropertyFromCollection(objCollection, propName, propValue) {
    for (var i = 0; i < objCollection.length; i++) {
        var curr = objCollection.item(i);
        var currPropValue = getAttbute(propName, curr);
        if (currPropValue == propValue) {
            return curr;
        }
    }
	// Return null if no node is found with the given attribute.
    return null;
}

function stepTwoToStepOne() {
    dataServiceObj.setAttribute("ds_step", parseInt(dataServiceObj.getAttribute("ds_step")) - 1);
    refreshDataServiceScreen();
}

function setpFinalToSetpTwo() {
    dataServiceObj.setAttribute("ds_step", parseInt(dataServiceObj.getAttribute("ds_step")) - 1);
    refreshDataServiceScreen();
}


// TODO This is the first "Next >"
function stepOneToStepTwo() {
    var dst = dataServiceObj.getAttribute("dataSourceType");
    var dsn = dataServiceObj.getAttribute("disable_name");
    if (!(dsn =='true')) {
        if (newDataService && !dst) {
            wso2.wsf.Util.alertWarning("Data Source must be provided in order to proceed");
            return;
        }
    }
    //This will first validate the inputs before stepping to the next section of the wizard
    if (!ds_collectdata["ds_step" + dataServiceObj.getAttribute("ds_step")]()) {
        return;
    }

    if (dataServiceObj.getAttribute("ds_step") == "0") {
        //var ds_dataSourceType = document.getElementById("databaseSourceType").value;
        add_param(true);
    }

    dataServiceObj.setAttribute("ds_step", parseInt(dataServiceObj.getAttribute("ds_step")) + 1);
    setDataSourceType();
    //TODO following will add an empty Query
    refreshDataServiceScreen();
}

function ds_back() {
    ds_collectdata["ds_step" + dataServiceObj.getAttribute("ds_step")](true);
//        refreshDataServiceScreen();
    //        return;
    //    }
    dataServiceObj.setAttribute("ds_step", parseInt(dataServiceObj.getAttribute("ds_step")) - 1);
    refreshDataServiceScreen();
}

//TODO add quary
function add_ds_query() {
    add_query();
    refreshDataServiceScreen();
}

/*
function remove_query_op_mapping(href) {

    var mappings = dataServiceQueryObj.getElementsByTagName("call-query");
    for (var i = 0; i < mappings.length; i++) {
        if (mappings[i].getAttribute("href") == href) {
            mappings[i].parentNode.removeChild(mappings[i]);
        }
    }

    refresEditDataServiceQueryScreen();
}
*/

function remove_element_op_mapping(column) {

    var mappings = dataServiceQueryObj.getElementsByTagName("element");
    for (var i = 0; i < mappings.length; i++) {
        if (mappings[i].getAttribute("column") == column) {
            mappings[i].parentNode.removeChild(mappings[i]);
        }
    }

    refresEditDataServiceQueryScreen();
}

var editingOPMapping = "";

/*function edit_query_op_mapping(href) {

    editingOPMapping = href;
    document.getElementById("cmbDataServiceOMType").options[1].selected = true;
    dataserviceOMTypeSelected("Query");
    var optionset = document.getElementById("cmbDataServiceQueryId").options;
    for (var i = 0; i < optionset.length; i++) {
        if (optionset[i].value == href) {
            optionset[i].selected = true;
        }
    }

    var dsqueries = dataServiceObj.getElementsByTagName("query");
    for (var i = 0; i < dsqueries.length; i++) {
        if (dsqueries[i].getAttribute("id") == href) {
            var withparams = dataServiceQueryObj.getElementsByTagName("with-param");
            for (var j = 0; j < withparams.length; j++) {
                document.getElementById("mapping_for_" +
                                        withparams[j].getAttribute("query-param")).value =
                withparams[j].getAttribute("name");
            }
        }
    }
}

function edit_element_op_mapping(name, column) {

    editingOPMapping = column;
    document.getElementById("cmbDataServiceOMType").options[0].selected = true;
    dataserviceOMTypeSelected("OutputElement");
    document.getElementById("txtDataServiceOMElementName").setAttribute("value", name);
    document.getElementById("txtDataServiceOMColumnName").setAttribute("value", column);
}*/


//TODO
//TODO
//TODO Step one validation
ds_collectdata["stepOneValidation"] = function () {
    if (newDataService) {
        //validate data source type
        var databaseSourceTypeObj = document.getElementById("databaseSourceType");
        var ds_dataSourceType = databaseSourceTypeObj[databaseSourceTypeObj.selectedIndex].value;
        var valid;
        if ("RDBMS" == ds_dataSourceType) {
            var databaseServerType = document.getElementById("databaseServerType").value;
            var driver = document.getElementById("org.wso2.ws.dataservice.driver").value;
            var protocol = document.getElementById("org.wso2.ws.dataservice.protocol").value;

            if (databaseServerType == " # ") {
                //TODO no value in returning here 
                //                wso2.wsf.Util.alertWarning("Please select a Database type.");
                //                return false;
            }
            if (driver == null || driver.replace(/^\s+|\s+$/g, "") == "") {
                wso2.wsf.Util.alertWarning("Please enter a correct driver class.");
                return false;
            }
            if (protocol == null || protocol.replace(/^\s+|\s+$/g, "") == "") {
                wso2.wsf.Util.alertWarning("Please enter a correct JDBC Url.");
                return false;
            }
        } else if ("CSV" == ds_dataSourceType) {
            valid = validateCSVConfigurationScreen();
            if (! valid) {
                return false;
            }
        } else if ("EXCEL" == ds_dataSourceType) {
            var val = document.getElementById("excel_datasource").value;
            if (val == null || val.replace(/^\s+|\s+$/g, "") == "") {
                wso2.wsf.Util.alertWarning("Please select a correct MS Excel file location.");
                return false;
            }
        } else if ("JNDIDataSource" == ds_dataSourceType) {
            valid = validateJNDIConfigurationScreen();
            if (! valid) {
                return false;
            }
        }
    }
    var properties = dataServiceObj.getElementsByTagName("property");
    for (var i = 0; i < properties.length; i++) {
        if (document.getElementById(properties[i].getAttribute("name")) != null) {
            if (properties[i].childNodes.length) {
                properties[i].removeChild(properties[i].childNodes[0]);
            }
            properties[i].appendChild(rootDocument.createTextNode(//"<![CDATA["
                    document.getElementById(properties[i].getAttribute("name")).value));//+ "]]>"));
        }
    }
    return true;
}

// TODO javascript functios for validation. This should follow Java naming conventions.
//TODO
//TODO
//TODO
ds_collectdata["ds_step0"] = function (validate) {
    if (newDataService) {
        //validate service name
        var ds_name = document.getElementById("dataServiceName").value;
        if (ds_name != null && ds_name.length != 0) {
            dataServiceObj.getElementsByTagName("data")[0].setAttribute("name", ds_name);
        } else if (!validate) {
            wso2.wsf.Util.alertWarning("Name of the data service must be provided in order to proceed");
            return false;
        }
    }
    return true;
}

function validateJNDIConfigurationScreen() {
    var contextClass = document.getElementById('jndi_context_class').value;
    contextClass = contextClass.replace(/^\s+|\s+$/g, '');

    var providerUrl = document.getElementById('jndi_provider_url').value;
    providerUrl = providerUrl.replace(/^\s+|\s+$/g, '');

    var resourceName = document.getElementById('jndi_resource_name').value;
    resourceName = resourceName.replace(/^\s+|\s+$/g, '');


    if (contextClass == '') {
        wso2.wsf.Util.alertWarning("Please enter JNDI Context Class.");
        return false;
    }
    if (providerUrl == '') {
        wso2.wsf.Util.alertWarning("Please enter provider url.");
        return false;
    }
    if (resourceName == '') {
        wso2.wsf.Util.alertWarning("Please JNDI resource name.");
        return false;
    }
    return true;
}

function validateCSVConfigurationScreen() {
    var resourcePath = document.getElementById('csv_datasource').value;
    resourcePath = resourcePath.replace(/^\s+|\s+$/g, '');

    var hasHeader = document.getElementById('csv_hasheader').value;
    hasHeader = hasHeader.replace(/^\s+|\s+$/g, '');

    var startingrow = document.getElementById('csv_startingrow').value;
    startingrow = startingrow.replace(/^\s+|\s+$/g, '');

    var maxRowCount = document.getElementById('csv_maxrowcount').value;
    maxRowCount = startingrow.replace(/^\s+|\s+$/g, '');

    if (resourcePath == '') {
        wso2.wsf.Util.alertWarning("Please enter CSV File Location.");
        return false;
    }
    if (hasHeader == '') {
        wso2.wsf.Util.alertWarning("Please select value for Header Available field.");
        return false;
    }
    if (startingrow == '') {
        wso2.wsf.Util.alertWarning("Please enter numeric value for starting Row.");
        return false;
    }
    if (maxRowCount == '') {
        wso2.wsf.Util.alertWarning("Please enter numeric value for Max Row Count.");
        return false;
    }

    return true;
}


ds_collectdata["ds_step1"] = function collect_ds_query_data(validate) {

    var retval = add_query(true);

    if (dataServiceObj.getElementsByTagName("query").length == 0 && !validate) {
        wso2.wsf.Util.alertWarning("Data service needs at least one Query to proceed");
        return false;
    }

    return retval;
}

function add_query(validate) {
    var queryId = document.getElementById("txtDataServiceQueryId").value;
    var isValidQuery = true;
    if (queryId != "") {
        dataServiceQueryObj.setAttribute("id", queryId);
    } else if (!validate) {
        wso2.wsf.Util.alertWarning("Missing value for required field Query ID");
        return false;
    } else {
        isValidQuery = false;
    }

    //removes query elements with id=""
    removeEmptyQueries();

    var dataSourceType = dataServiceObj.getAttribute("dataSourceType");
    if ("RDBMS" == dataSourceType || "JNDIDataSource" == dataSourceType) {
        var sql = document.getElementById("txtDataServiceSQL").value;
        if (isValidQuery) {
            dataServiceObj.getElementsByTagName("data")[0].appendChild(dataServiceQueryObj);
        } else if (!validate) {
            return false;
        }
    } else if ("EXCEL" == dataSourceType) {
    }
    return true;
}

/*
 *  removes query elements with id=""
 */
function removeEmptyQueries() {
    var queries = dataServiceObj.getElementsByTagName("query");
    for (var i = 0; i < queries.length; i++) {
        if (queries[i].getAttribute("id") == "") {
            dataServiceObj.getElementsByTagName("data")[0].removeChild(queries[i]);
        }
    }
}

ds_collectdata["ds_step2"] = function collect_ds_operation_data() {

    return true;
}

//TODO : note remove a mapping.
function removeDSInputMapping(queryId, paramName) {

    var msgStat = confirm("Do you want to delete the parameter : " + paramName);
    if (!msgStat) {
        return;
    }

    var qArray = dataServiceObj.getElementsByTagName('query');
    var qEle = null;
    for (var i = 0; i < qArray.length; i++) {
        if (qArray[i].getAttribute("id") == queryId) {
            qEle = qArray[i];
            break;
        }
    }

    var paramArray = qEle.getElementsByTagName('param');
    var paramEle = null;
    for (i = 0; i < paramArray.length; i++) {
        if (paramName == paramArray[i].getAttribute('name')) {
            paramEle = paramArray[i];
            break;
        }
    }
    qEle.removeChild(paramEle);
    var divInnerHtml = yuiTransformer(dataServiceObj, "data_service_add_query.xsl", false, [["queryId",queryId]]);
    showYUIPanel("Add New Query", divInnerHtml, "600px", "step2Inner0", "divDSAddQuery");

}

function editDSInputMapping(queryId, paramName, sqlType,inOutType,ordinal) {
    var divInnerHtml = yuiTransformer(dataServiceObj, "data_service_add_edit_input_mapping.xsl", false, [["queryId",queryId],["paramName",paramName],["paramSqlType",sqlType],["paramInOutType",inOutType],["paramOrdinal",ordinal],["edit","true"]]);
    showYUIPanel("Edit Input Param", divInnerHtml, "600px", "step2Inner4", "divADDEditInputMapping");
}


/*
function remove_ds_ip_mapping(mappingName) {

    remove_ip_mapping(mappingName);
    refresEditDataServiceQueryScreen();
}
*/

function remove_ip_mapping(mappingName) {

    var mappings = dataServiceObj.getElementsByTagName("param");
    for (var i = 0; i < mappings.length; i++) {
        if (mappings[i].getAttribute("name") == mappingName) {
            mappings[i].parentNode.removeChild(mappings[i]);
        }
    }
}

function remove_ds_op_mapping(mappingName) {

    remove_op_mapping(mappingName);
    refresEditDataServiceQueryScreen();
}

function remove_op_mapping(mappingName) {

    var mappings = dataServiceObj.getElementsByTagName("param");
    for (var i = 0; i < mappings.length; i++) {
        if (mappings[i].getAttribute("name") == mappingName) {
            mappings[i].parentNode.removeChild(mappings[i]);
        }
    }
}

function addQueryElementToDS() {
    dataServiceNewQuery = true;

    var queryEle = rootDocument.createElement("query");
    queryEle.setAttribute("id", "");

    var sqlEle = rootDocument.createElement("sql");
    sqlEle.appendChild(rootDocument.createTextNode(""));

    var resultEle = rootDocument.createElement("result");
    resultEle.setAttribute("element", "element");
    resultEle.setAttribute("rowName", "rowName");

    queryEle.appendChild(sqlEle);

    dataServiceQueryObj = queryEle;
	//addInputParamToQuery();
    //addNewInputParamMapping("","");

    dataServiceQueryObj.appendChild(resultEle);


    dataServiceObj.getElementsByTagName("data").item(0).appendChild(dataServiceQueryObj);
    refresEditDataServiceQueryScreen();
}

function addInputParamToQuery(queryId) {
    //alert(queryId);
    var paramEle = rootDocument.createElement("param");
    paramEle.setAttribute("name", "");
    paramEle.setAttribute("sqlType", "");
    dataServiceQueryObj.appendChild(paramEle);

    var tmp = dataServiceObj.getElementsByTagName("data").item(0).getElementsByTagName("query");
    for (i = 0; i < tmp.length; i += 1) {
        //alert(tmp[i].getAttribute("id"));

    }
    if (tmp.length > 0) {
        //alert(wso2.wsf.Util.xmlSerializerToString(tmp));
    }
}


function updateDSWithNewQuery() {
    var dataServiceSQL = document.getElementById('txtDataServiceSQL').value;
	//var dataServiceWrapElement = document.getElementById('txtDataServiceWrapElement').value;
    //var dataServiceRowName = document.getElementById('txtDataServiceRowName').value;

    var sqlObj = dataServiceQueryObj.getElementsByTagName("sql").item(0);
    sqlObj.removeChild(sqlObj.childNodes.item(0));
    sqlObj.appendChild(rootDocument.createTextNode(dataServiceSQL));

	//var resultObj = dataServiceQueryObj.getElementsByTagName("result").item(0);
    //resultObj.setAttribute("element", dataServiceWrapElement);
    //resultObj.setAttribute("rowName", dataServiceRowName);

    xslToReload = 'data_service_add_query.xsl';
    addNewDataServiceEchoDataElement(dataServiceObj);
}

function addNewInputParamMapping(param, sqlType) {
    if (param != "" && sqlType != "- select the type -") {
        var params = dataServiceQueryObj.getElementsByTagName("param");
        for (var i = 0; i < params.length; i++) {
            if (editingIPMapping != "" && params[i].getAttribute("name") == editingIPMapping) {
                params[i].parentNode.removeChild(params[i]);
            } else {
                if (params[i].getAttribute("name") == param) {
                    wso2.wsf.Util.alertWarning("Input mapping with the name \"" + param +
                                               "\" already present");
                    return false;
                }
            }
        }
        dataServiceQueryObj.appendChild(createInputMappingElement(param, sqlType));
    } else {
        wso2.wsf.Util.alertWarning("Both Name & SQL Type are mandatory for a parameter");
        return false;
    }
    refresEditDataServiceQueryScreen();
}

function refreshWizardScreen(divId, xslFile, domObject) {
    var quDivObj = document.getElementById(divId);
    wso2.wsf.Util.processXML(domObject, xslFile, quDivObj);
}


function showDSQueryOutputMappingsScreen() {
    ds_collectdata["ds_step1"]();
    refreshWizardScreen('divAddDSQueryOPMapping', 'data_service_add_query_output_mapping.xsl', dataServiceObj);
}


function loadDatabaseUrlDriverComboBox() {
    var body_xml = '<ns1:getDatabaseUrlDriverList  xmlns:ns1="http://org.apache.axis2/xsd">\n' +
                   ' </ns1:getDatabaseUrlDriverList>\n';

    var callURL = serverURL + "/" + "DataServiceAdmin" + "/" ;
    new wso2.wsf.WSRequest(callURL, "getDatabaseUrlDriverList", body_xml, loadDatabaseServerListCallback);
}

function loadDatabaseServerListCallback() {
    var comboToLoad = document.getElementById('databaseServerType');
    var data = this.req.responseXML;
    var rets = data.getElementsByTagName("return");
    var len = rets.length;
    var count;
    for (count = 0; count < len; count++) {
        comboToLoad.options[count] =
        new Option(rets[count].getElementsByTagName("serverId").item(0).firstChild.nodeValue);
        comboToLoad.options[count].text =
        rets[count].getElementsByTagName("serverId").item(0).firstChild.nodeValue;
        comboToLoad.options[count].value =
        rets[count].getElementsByTagName("jdbcUrl").item(0).firstChild.nodeValue + "#" +
        rets[count].getElementsByTagName("driverClass").item(0).firstChild.nodeValue;
    }
    comboToLoad.options[count] = new Option('--SELECT--');
    comboToLoad.options[count].value = ' # ';
    comboToLoad.selectedIndex = count;
    _refreshDataServiceScreenHelper();
}

function setJDBCValues(obj, document) {
    var selectedValue = obj[obj.selectedIndex].value;
    var jdbcUrl = selectedValue.substring(0, selectedValue.indexOf("#"));
    var driverClass = selectedValue.substring(selectedValue.indexOf("#") + 1, selectedValue.length);
    document.getElementById('org.wso2.ws.dataservice.protocol').value = jdbcUrl;
    document.getElementById('org.wso2.ws.dataservice.driver').value = driverClass;
}

/*TODO call from data_service.xsl*/
function setConfigurationScreen(dataSourceType) {
    editDataSourceType = dataSourceType;
    //remove all properties
    /*var propArray = dataServiceObj.getElementsByTagName("config").item(0).getElementsByTagName("property");
    var configObj = dataServiceObj.getElementsByTagName("config").item(0);
    for (var i = 0; i < propArray.length; i++) {
        configObj.removeChild(propArray[i]);
    }*/
    var configLObj = dataServiceObj.getElementsByTagName("config")[0];
    dataServiceObj.getElementsByTagName('data')[0].removeChild(configLObj);
    dataServiceObj.getElementsByTagName('data')[0].appendChild(rootDocument.createElement("config"));
    //preserve data service name
    var dataServiceName = document.getElementById("dataServiceName").value;
    if (dataServiceName != null && dataServiceName.length != 0) {
        if (dataServiceObj.getElementsByTagName("data")[0].getAttribute("name")) {
            dataServiceObj.getElementsByTagName("data")[0].removeAttribute("name");
        }
        dataServiceObj.getElementsByTagName("data")[0].setAttribute("name", dataServiceName);
    }

    var hdDataSource = "Data Source Type : " + dataSourceType;

    if (dataSourceType == 'EXCEL') {
        dataServiceObj.getElementsByTagName("config").item(0).appendChild(createPropelement('excel_datasource', 'path-to-your-excel-file'));
        dataServiceObj.setAttribute("dataSourceType", "EXCEL");
//       refreshDataServiceScreen.call(this,false);
        showYUIPanel(hdDataSource, yuiTransformer(dataServiceObj, "data_service_yui.xsl"), "550px", "step10PanelID", "divYUIPaneHolder");
    } else if (dataSourceType == 'CSV') {

        dataServiceObj.getElementsByTagName("config").item(0).appendChild(createPropelement('csv_datasource', 'path-to-your-csv-file'));
        dataServiceObj.getElementsByTagName("config").item(0).appendChild(createPropelement('csv_columnseperator', ','));
        dataServiceObj.getElementsByTagName("config").item(0).appendChild(createPropelement('csv_columns', ''));
        dataServiceObj.getElementsByTagName("config").item(0).appendChild(createPropelement('csv_columnordinal', ''));
        dataServiceObj.getElementsByTagName("config").item(0).appendChild(createPropelement('csv_startingrow', ''));
        dataServiceObj.getElementsByTagName("config").item(0).appendChild(createPropelement('csv_maxrowcount', '-1'));
        dataServiceObj.getElementsByTagName("config").item(0).appendChild(createPropelement('csv_hasheader', ''));
        dataServiceObj.setAttribute("dataSourceType", "CSV");
//       refreshDataServiceScreen.call(this,false);
        showYUIPanel(hdDataSource, yuiTransformer(dataServiceObj, "data_service_yui.xsl"), "550px", "step11PanelID", "divYUIPaneHolder");
    } else if (dataSourceType == 'RDBMS') {

        dataServiceObj.getElementsByTagName("config").item(0).appendChild(createPropelement("org.wso2.ws.dataservice.driver", ""));
        dataServiceObj.getElementsByTagName("config").item(0).appendChild(createPropelement("org.wso2.ws.dataservice.protocol", ""));
        dataServiceObj.getElementsByTagName("config").item(0).appendChild(createPropelement("org.wso2.ws.dataservice.user", ""));
        dataServiceObj.getElementsByTagName("config").item(0).appendChild(createPropelement("org.wso2.ws.dataservice.password", ""));
        dataServiceObj.getElementsByTagName("config").item(0).appendChild(createPropelement("org.wso2.ws.dataservice.minpoolsize", ""));
        dataServiceObj.getElementsByTagName("config").item(0).appendChild(createPropelement("org.wso2.ws.dataservice.maxpoolsize", ""));        
        dataServiceObj.setAttribute("dataSourceType", "RDBMS");
//       refreshDataServiceScreen.call(this,true);
        showYUIPanel(hdDataSource, yuiTransformer(dataServiceObj, "data_service_yui.xsl"), "550px", "step1PanelID", "divYUIPaneHolder");
//        loadDatabaseUrlDriverComboBox();
    } else if (dataSourceType == 'JNDIDataSource') {
        dataServiceObj.getElementsByTagName("config").item(0).appendChild(createPropelement("jndi_context_class", ""));
        dataServiceObj.getElementsByTagName("config").item(0).appendChild(createPropelement("jndi_provider_url", ""));
        dataServiceObj.getElementsByTagName("config").item(0).appendChild(createPropelement("jndi_resource_name", ""));
        dataServiceObj.getElementsByTagName("config").item(0).appendChild(createPropelement("jndi_username", ""));
        dataServiceObj.getElementsByTagName("config").item(0).appendChild(createPropelement("jndi_password", ""));
        dataServiceObj.setAttribute("dataSourceType", "JNDIDataSource");
//       refreshDataServiceScreen.call(this,false);
        showYUIPanel(hdDataSource, yuiTransformer(dataServiceObj, "data_service_yui.xsl"), "550px", "step12PanelID", "divYUIPaneHolder");
    }
    //set the selected value
    //    document.getElementById("databaseSourceType").value = dataSourceType;
    //    document.getElementById("dataServiceName").value = dataServiceName;
    //dataServiceObj.getElementsByTagName("data")[0].setAttribute("name", dataServiceName);
}

function setDataSourceType() {
    var properties = dataServiceObj.getElementsByTagName("config").item(0).getElementsByTagName("property");
    for (var a = 0; a < properties.length; a++) {
        var property = properties[a];
        if (property.getAttribute("name") == "org.wso2.ws.dataservice.driver") {
            dataServiceObj.setAttribute("dataSourceType", "RDBMS");
        } else if (property.getAttribute("name") == "csv_datasource") {
            dataServiceObj.setAttribute("dataSourceType", "CSV");
        } else if (property.getAttribute("name") == "excel_datasource") {
            dataServiceObj.setAttribute("dataSourceType", "EXCEL");
        } else if (property.getAttribute("name") == "jndi_datasource") {
            dataServiceObj.setAttribute("dataSourceType", "JNDIDataSource");
        } else if (property.getAttribute("name") == "jndi_datasource") {
            dataServiceObj.setAttribute("dataSourceType", "JNDIDataSource");
        }
    }

}


function addAdditionalParameters() {
    if (document.getElementById('addAdditionalParamaters').checked) {
        document.getElementById('divDSAddParam').style.display = "inline";

        document.getElementById('addAdditionalParamaters').checked = true;
    } else {
        document.getElementById('divDSAddParam').style.display = "none";
     //document.getElementById('addAdditionalParamaters').checked = false;
    }
}


function excelWorkbookNameOnChange(workBookName, form) {
    var excelObj = dataServiceQueryObj.getElementsByTagName("excel").item(0);
    var workBookObj = excelObj.getElementsByTagName("workbookname").item(0);
    workBookObj.removeChild(workBookObj.childNodes.item(0));
    workBookObj.appendChild(rootDocument.createTextNode(workBookName));
    checkValidValuesForExcelQuery();
}

function excelHeaderColumnsOnChange(headerColumns, form) {
    var excelObj = dataServiceQueryObj.getElementsByTagName("excel").item(0);
    var hasHeaderObj = excelObj.getElementsByTagName("hasheader").item(0);
    hasHeaderObj.removeChild(hasHeaderObj.childNodes.item(0));
    hasHeaderObj.appendChild(rootDocument.createTextNode(headerColumns));
    checkValidValuesForExcelQuery();
}

function excelStartingRowOnChange(startingRow, form) {
    var excelObj = dataServiceQueryObj.getElementsByTagName("excel").item(0);
    var startingRowObj = excelObj.getElementsByTagName("startingrow").item(0);
    startingRowObj.removeChild(startingRowObj.childNodes.item(0));
    startingRowObj.appendChild(rootDocument.createTextNode(startingRow));
    checkValidValuesForExcelQuery();
}

function excelMaxRowCountOnChange(maxRowCount, form) {
    var excelObj = dataServiceQueryObj.getElementsByTagName("excel").item(0);
    var maxRowCountObj = excelObj.getElementsByTagName("maxrowcount").item(0);
    maxRowCountObj.removeChild(maxRowCountObj.childNodes.item(0));
    maxRowCountObj.appendChild(rootDocument.createTextNode(maxRowCount));
    checkValidValuesForExcelQuery();
}

/*
 * Checks if all excel query fields are filled with proper values
 * and enables output mapping section
 */
function checkValidValuesForExcelQuery() {
    var enableFields = true;

    var excelQueryIdValue = document.getElementById('txtDataServiceQueryId').value;
    excelQueryIdValue = excelQueryIdValue.replace(/^\s+|\s+$/g, '');

    var workBookObjValue = document.getElementById('txtExcelWorkbookName').value;
    workBookObjValue = workBookObjValue.replace(/^\s+|\s+$/g, '');

    var hasHeaderObjValue = document.getElementById('txtExcelHeaderColumns').value;
    hasHeaderObjValue = hasHeaderObjValue.replace(/^\s+|\s+$/g, '');

    var startingRowObjValue = document.getElementById('txtExcelStartingRow').value;
    startingRowObjValue = startingRowObjValue.replace(/^\s+|\s+$/g, '');

    var maxRowCountObjValue = document.getElementById('txtExcelMaxRowCount').value;
    maxRowCountObjValue = maxRowCountObjValue.replace(/^\s+|\s+$/g, '');

    if (excelQueryIdValue != ''
            && workBookObjValue != ''
            && hasHeaderObjValue != ''
            && startingRowObjValue != ''
            && maxRowCountObjValue != '') {
        //if all fields have non empty values enable,
        //output mappings section
        enableFields = false;
    }
    changeOutputMappingFieldStatus(enableFields);
}


function getCSVHeaderColumnNames(document) {
    var resourcePath = document.getElementById('csv_datasource').value;
    resourcePath = resourcePath.replace(/^\s+|\s+$/g, '');

    var hasHeader = document.getElementById('csv_hasheader').value;
    hasHeader = hasHeader.replace(/^\s+|\s+$/g, '');

    var dataSourceType = 'csv';
    var okToProceed = validateCSVConfigurationScreen();
    if (! okToProceed) {
        return false;
    }
   
   //Rest seleted column ordering, user has to start selecting from beginning 
    csvSelectedColumnOrder = 0;

    var body_xml = '<ns1:getHeaderColumnNames  xmlns:ns1="http://org.apache.axis2/xsd">\n' +
                   ' <arg0>' + resourcePath + '</arg0>\n' +
                   ' <arg1><![CDATA[' + hasHeader + ']]></arg1>\n' +
                   ' <arg2>' + dataSourceType + '</arg2>\n' +
                   ' </ns1:getHeaderColumnNames>\n';

    var callURL = serverURL + "/" + "DataServiceAdmin" + "/" ;
    new wso2.wsf.WSRequest(callURL, "getHeaderColumnNames", body_xml, getCSVHeaderColumnNamesCallback);
}

function getCSVHeaderColumnNamesCallback() {
    var comboToLoad = document.getElementById('csvColumnSelection');
    try {
        var data = this.req.responseXML;
        var rets = data.getElementsByTagName("return");
        var len = rets.length;
        var count;
        for (count = 0; count < len; count++) {
            comboToLoad.options[count] = new Option(rets[count].firstChild.nodeValue);
            comboToLoad.options[count].text = rets[count].firstChild.nodeValue;
            comboToLoad.options[count].value = rets[count].firstChild.nodeValue;
        }
        document.getElementById('divCSVColumnSelection').style.display = "inline";
    } catch(e) {
        wso2.wsf.Util.alertWarning("Processing error occurred. Does CSV File location points to a correct file path?");
    }
}

function showValue() {
    var csvColumns = document.getElementById('mycolumns');
    var selectedArray = new Array();
    var count = 0;
    for (i = 0; i < csvColumns.options.length; i++) {
        if (csvColumns.options[i].selected) {
            selectedArray[count] = csvColumns.options[i].value;
            count++;
        }
    }
    document.getElementById('csv_columns').value = selectedArray;
    document.getElementById('csv_columnordinal').value = selectedArray;
}


function setCSVColumnSelection() {
    var csvColumns = document.getElementById('csvColumnSelection');
    if (csvSelectedColumnOrder == csvColumns.options.length) {
        var message = "You have aleady selected all columns.This will reset all column selections done so far. Do you want to continue?";
        if (confirm(message)) {
            csvSelectedColumnOrder = 0;
            getCSVHeaderColumnNames(document);
        }
        return false;
    }

    for (i = 0; i < csvColumns.options.length; i++) {
        if (csvColumns.options[i].selected) {
            if (csvColumns.options[i].text.indexOf('as column no') == -1) {
                csvSelectedColumnOrder++;
                if (csvSelectedColumnOrder > 1) {
                    document.getElementById('csv_columns').value =
                    document.getElementById('csv_columns').value + ',' + csvColumns.options[i].text;
                    document.getElementById('csv_columnordinal').value =
                    document.getElementById('csv_columnordinal').value + ',' +
                    csvSelectedColumnOrder;
                } else {
                    document.getElementById('csv_columns').value = csvColumns.options[i].text;
                    document.getElementById('csv_columnordinal').value = csvSelectedColumnOrder;
                }
                csvColumns.options[i].text =
                csvColumns.options[i].text + " as column no : " + csvSelectedColumnOrder;
                csvColumns.options[i].value =
                csvColumns.options[i].value + ":" + csvSelectedColumnOrder;

            }
        }
    }
}
/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

function registerProductCallback(){

    var objDiv = document.getElementById("registerProduct");
    var objDataElement = this.req.responseXML.getElementsByTagName("return")[0];
    var strHTML = "<h2>Register product</h2>" +
				"<p>Thank you for downloading WSO2 Web Services Application Server v2.2-RC1.</p>" +
				"<p>Technical information requested will help us improve the product and better serve customer needs. Registration will also help us provide fast and effective support services to our users.</p>" +
				"<p>All information will be sent directly to WSO2. Please note that you will be registered in the WSO2 developer portal <a href=\"http://www.wso2.org\" target=\"_blank\">WSO2 Oxygen Tank</a> in the near future as well.</p>" +
				"<p>Kindly use the form below for registration. Note that registration is entirely voluntary and failure to complete or submit this form will not diminish any rights.</p>" +
				"<p>Also it is not mandatory to fill in all the fields in the form for submission.</p>" +
                  "<div id='formset'>" + "<form method='post' action='https://www.wso2.org/project/wsas/java/1.1/registration.php' target='_blank'>" +
                  "<fieldset style='border: 0px;'>" +
                  "<legend>The following information will be sent to WSO2</legend>" +
                    "<br/>" +
                    "<fieldset>" +
                    "<legend>Java VM</legend>" +
					"<div><label>JRE Name</label><input name='registerProductJavaRuntimeName' type='text' value='" + objDataElement.getElementsByTagName("javaRuntimeName")[0].firstChild.nodeValue + "' size='50'/></div>" +
					"<div><label>Java Version</label><input name='registerProductJavaVersion' type='text' value='" + objDataElement.getElementsByTagName("javaVersion")[0].firstChild.nodeValue + "' size='50'/></div>" +
					"<div><label>Java Vendor</label><input name='registerProductJavaVMVendor' type='text' value='" + objDataElement.getElementsByTagName("javaVMVendor")[0].firstChild.nodeValue + "' size='50'/></div>" +
					"<div><label>Java VM Version</label><input name='registerProductJavaVMVersion' type='text' value='" + objDataElement.getElementsByTagName("javaVMVersion")[0].firstChild.nodeValue + "' size='50'/></div>" +
					"</fieldset>" +
					"<fieldset>" +
					"<legend>Operating system</legend>" +
					"<div><label>OS Name</label><input name='registerProductOsName' type='text' value='" + objDataElement.getElementsByTagName("osName")[0].firstChild.nodeValue + "' size='50'/></div>" +
					"<div><label>OS Version</label><input name='registerProductOsVersion' type='text' value='" + objDataElement.getElementsByTagName("osVersion")[0].firstChild.nodeValue + "' size='50'/></div>" +
					"</fieldset>" +
					"<fieldset>" +
					"<legend>User</legend>" +
					"<div><label>User Country</label><input name='registerProductUserCountry' type='text' value='" + objDataElement.getElementsByTagName("userCountry")[0].firstChild.nodeValue + "' size='50'/></div>" +
                    "<div><label>Contact First Name</label><input name='registerProductContactFirstName' type='text' value='' size='50'/></div>" +
                    "<div><label>Contact Last Name</label><input name='registerProductContactLastName' type='text' value='' size='50'/></div>" +
                    "<div><label>Contact Email</label><input name='registerProductContactEmail' type='text' value='' size='50'/></div>" +
					"<div><label>Company Name</label><input name='registerProductCompanyName' type='text' value='' size='50'/></div>" +
                    "<div><label>Phone Number</label><input name='registerProductContactPhoneNumber' type='text' value='' size='50'/></div>" +
                    "<div><label>Fax</label><input name='registerProductContactFax' type='text' value='' size='50'/></div>" +
					"<div><label>Address</label><input name='registerProductCompanyAddress' type='text' value='' size='50'/></div>" +
					"<div><label>City</label><input name='registerProductCompanyCity' type='text' value='' size='50'/></div>" +
					"<div><label>State</label><input name='registerProductCompanyState' type='text' value='' size='50'/></div>" +
					"<div><label>Zip</label><input name='registerProductCompanyZip' type='text' value='' size='50'/></div>" +
					"<div><label>Industry</label><input name='registerProductIndustry' type='text' value='' size='50'/></div>" +
					"</fieldset>" +
					"<fieldset>" +
					"<legend>Password</legend>" +
					"<div><label>Password</label><input name='registerProductPassword1' id='registerProductPassword1' type='password' value='' size='50'/></div>" +
					"<div><label>Confirm password</label><input name='registerProductPassword2' id='registerProductPassword2' type='password' value='' size='50'/></div>" +
					"</fiedset>" +
                    "<br/>" +
					"<div class='buttonrow'><input type='submit' value='Register' onclick='javascript:return sendRegistrationInfo();'/></div>" +
                  "</fieldset>" +
                  "</form>" +
                  "</div>";
    objDiv.innerHTML = strHTML;
    wso2.wsf.Util.showOnlyOneMain(objDiv);
}

function reportRegisterProduct(){
    var body_xml = ' <ns1:serverRegistered xmlns:ns1="http://org.apache.axis2/xsd"/>\n';

    var callURL = serverURL + "/" + GLOBAL_SERVICE_STRING ;
    new wso2.wsf.WSRequest(callURL,"serverRegistered",body_xml,function(){});
}



function sendRegistrationInfo(){
	if (document.getElementById('registerProductPassword1').value != document.getElementById('registerProductPassword2').value){
		wso2.wsf.Util.alertWarning("Passwords entered do not match.");
		return false;
	}
    reportRegisterProduct();
    var regDiv = document.getElementById('divRegisterProductSuccess');
     regDiv.innerHTML='<p>&nbsp;</p><p>&nbsp;</p><p>&nbsp;</p><center><h2>You have successfully registered WSO2 Web Services Application Server v2.2-RC1.</h2></center>';
    userNameString = "<nobr>Signed in as <strong>" + userName + "</strong>&nbsp;&nbsp;|&nbsp;&nbsp;<a id='logOutA' href='#' " +
    		"onclick='javascript:wso2.wsf.Util.logout(wso2.wsf.Util.logout[\"callback\"]); " +
    		"return false;'>Sign Out</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a target=\"_blank\" href='docs/user_guide.html'>Docs</a></nobr>";
    document.getElementById("meta").innerHTML = userNameString;
    wso2.wsf.Util.showOnlyOneMain(regDiv);
    return true;
}
var xhtml = "http://www.w3.org/1999/xhtml";

var GLOBAL_SERVICE_STRING = "GlobalAdmin";
var SERVER_ADMIN_STRING = "ServerAdmin";
var SERVICE_GROUP_ADMIN_STRING = "ServiceGroupAdmin";
var MODULE_ADMIN_STRING = "ModuleAdmin";
var LOGGING_SERVICE_STRING = "LoggingService";

var SECURITY_SCENARIO_CONFIG_ADMIN = "SecurityScenarioConfigAdmin";

var CRYPTO_ADMIN_STRING = "CryptoAdmin";
/*
@deprecate
*/
var RAMPART_INFLOW_CONFIG_ADMIN_STRING = "RampartInflowConfigAdmin";
/*
@deprecated
*/
var RAMPART_OUTFLOW_CONFIG_ADMIN_STRING = "RampartOutflowConfigAdmin";

var WSO2WSAS_SIGN_IN_STATUS = "WSO2WSAS_SIGN_IN_STATUS";

function init() {

    wso2.wsf.Util.initURLs();

    /*Initialize the XSLT cache*/
    wso2.wsf.XSLTHelper.init();
    /*initialize the dhtml history object*/
    initialize();
    /* If a vaild JSESSIONID is present refresh the login for the given domain */
    var jsessionId = wso2.wsf.Util.getCookie("JSESSIONID");
    if (jsessionId) {
        var ping = wsasPing();
        if (ping) {
            userName = wso2.wsf.Util.getCookie('userName');
            finishLogin();
        } else {
           wsasLogingHelper();
        }
    } else {
        wsasLogingHelper();
        //        document.formLogin.txtUserName.focus();
    }
}

function wsasLogingHelper() {
    userNameString =
    "<nobr><a href='about.html' target='_blank'>About</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='docs/index_docs.html' target='_blank'>Docs</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a id='logInA' href='#' onclick='javascript:wsasLogin(); return false;'>Sign In</a></nobr>";
    document.getElementById("meta").innerHTML = userNameString;
    var stat = wso2.wsf.Util.getCookie(WSO2WSAS_SIGN_IN_STATUS);
    if (stat && stat == "TRUE" && wso2.wsf.Util.getProtocol() == "https") {
        wso2.wsf.Util.deleteCookie(WSO2WSAS_SIGN_IN_STATUS);
        showLoginPage();
    } else {
        showGeneralHome();
    }
}

function wsasLogin() {
    /*Only for protocol determination*/
    var _tmpURL = locationString.substring(0, locationString.lastIndexOf('/'));
    if (_tmpURL.indexOf('https') == -1) {
        wso2.wsf.Util.setCookie(WSO2WSAS_SIGN_IN_STATUS, "TRUE");
        //Redirection to SSL will happen in follow,
        window.location = URL;
    } else {
        /*var loginDiv = document.getElementById('logincontainer');
        wso2.wsf.Util.showOnlyOneMain(loginDiv, true);*/
        showLoginPage();
    }
}

function wsasLoginCallback() {
    var isLogInDone = this.req.responseXML.getElementsByTagName("return")[0].firstChild.nodeValue;
    if (isLogInDone != "true") {
        loginFail();
        return;
    }
    userName = document.formWSASLogin.txtUserName.value;
    if (userName) {
        wso2.wsf.Util.setCookie("userName", userName);
    }

    /*initialize the dhtml history object*/
    initialize();
    /*Start login*/
    finishLogin();
}

function showForgotPassword(params) {
   wsasDivRendererHelper("forgotPassword", "login_helper.xsl", "divForgotPassword", params);
}

function showSignInHelp() {
   wsasDivRendererHelper("signInHelp", "login_helper.xsl", "divSignInHelp");
}

function showLoginPage() {
    wsasDivRendererHelper("wsasLogin", "login.xsl", "divFaq");
    document.formWSASLogin.txtUserName.focus();

}

function wsasDivRendererHelper(rootEleName, xslName, divName, params) {
    var tmpTransformationNode;
    /*
    The checking for the existance for window.XMLHttpRequest to figure out
    the browser and the functionality was dropped since the new version of
    IE has this object.
    */
    if (wso2.wsf.Util.isIE()) {
        tmpTransformationNode = new ActiveXObject("Microsoft.XmlDom");
        var sXml = "<"+rootEleName+"></"+rootEleName+">";
        tmpTransformationNode.loadXML(sXml);
    } else {
        tmpTransformationNode =
        document.implementation.createDocument("", rootEleName, null);
    }
    var objDiv = document.getElementById(divName);
    var xsltHelperObj = new wso2.wsf.XSLTHelper();
    xsltHelperObj.transform(objDiv, tmpTransformationNode, xslName, false, false, params);
    wso2.wsf.Util.showOnlyOneMain(objDiv, false);
}

/* changing css on runtime related to Menu Items*/

var selectedMenuItem = null;
var selectedMenuItemClass = null;

function renderSelectedMenuItem(obj, index) {
    if (obj != null && index) {
        if (selectedMenuItem != null) {
            selectedMenuItem.className = selectedMenuItemClass;
        }
        selectedMenuItem = obj;
        selectedMenuItemClass = selectedMenuItem.className;
        selectedMenuItem.className = MenuClassFactory.getClass(index);
    }

}

function renderGeneralHomeMenueExplicitly() {
    var obj = document.getElementById('menu_home_link_general_id');
    if (obj != null) {
        if (selectedMenuItem != null) {
            selectedMenuItem.className = selectedMenuItemClass;
        }
        selectedMenuItem = obj;
        selectedMenuItemClass = selectedMenuItem.className;
        selectedMenuItem.className = MenuClassFactory.getClass(0);
    }
}

function renderHomeMenuExplicitly() {
    var obj = document.getElementById('menu_home_link_id');
    if (obj != null) {
        if (selectedMenuItem != null) {
            selectedMenuItem.className = selectedMenuItemClass;
        }
        selectedMenuItem = obj;
        selectedMenuItemClass = selectedMenuItem.className;
        selectedMenuItem.className = MenuClassFactory.getClass(0);
    }
}

/*Object that uses to execute Second run of the '*' file upload method*/

function FileExcutor() {
}

/*Encounter for bug
FileExcutor.execute = foo; is the method should be called with extraStoreDirUUID(uuid);
*/
new FileExcutor();

/*This is the method that's gonna invoked by CertificateFileUploadExecutor for WS Call*/
function extraStoreDirUUID(uuid) {
    FileExcutor.execute(uuid);
}

/*
the method storeDiv(divName, isReloadDiv); when isReloadDiv is true,
div object is not added to the histry stack of the browser.

security.js is architectured in a way, that it will load from a main
div and populate other inner divs base on Web Service calls.

Thus, the method transformationWithoutHistory(xslFile,objDiv) will transform any
internal div without adding it to the browserstack

*/

function transformationWithoutHistory(xmlObj, xslFile, objDiv, params) {
    var xsltHelperObj = new wso2.wsf.XSLTHelper();
    xsltHelperObj.transform(objDiv, xmlObj, xslFile, false, false, params);
    wso2.wsf.Util.showOnlyOneMain(objDiv, true);

}

function showRestartServer(thisObj, index) {

    if (thisObj && index) {
        renderSelectedMenuItem(thisObj, index);
        gatherHistoryObject(thisObj.id, index);
    }

    /*
    restartServer with xsl
    */

    var tmpTransformationNode;

    if (window.XMLHttpRequest && !wso2.wsf.Util.isIE()) {
        tmpTransformationNode =
        document.implementation.createDocument("", "restartServer", null);
    } else if (window.ActiveXObject) {
        tmpTransformationNode = new ActiveXObject("Microsoft.XmlDom");
        var sXml = "<restartServer></restartServer>";
        tmpTransformationNode.loadXML(sXml);
    }
    var objDiv = document.getElementById("divRestartServer");
    wso2.wsf.Util.processXML(tmpTransformationNode, "restart_server.xsl", objDiv);
    wso2.wsf.Util.showOnlyOneMain(objDiv);

}

/*Menu rendering*/

function MenuClassFactory() {
}

/* indexes and elements have a one to one relationship*/
MenuClassFactory.classElements =
new Array(
        'menu_home_link_class_clicked',
        'menu_services_class_clicked',
        'menu_modules_class_clicked',
        'menu_security_class_clicked',
        'menu_transports_class_clicked',
        'menu_keystore_class_clicked',
        'menu_logs_class_clicked',
        'menu_restart_server_class_clicked',
        'menu_system_class_clicked',
        'menu_stat_class_clicked',
        'menu_log_class_clicked',
        'menu_tracer_class_clicked',
        'menu_axis_config_class_clicked',
        'menu_wsdl2code_class_clicked',
        'menu_item_class_clicked',
        'menu_item_class_wsdl2code_clicked', //15
        'menu_item_class_wsdlview_clicked',
        'menu_item_class_wsdlconverter_clicked',
        'menu_item_class_tryit_clicked',
        'menu_item_class_aarval_clicked',
        'menu_item_class_marval_clicked');
// 20

function getMenuFactoryClassElements(index) {
    return MenuClassFactory.classElements[index];
}

MenuClassFactory.getClass = getMenuFactoryClassElements;

/** A function that is called whenever the user
 presses the back or forward buttons. This
 function will be passed the newLocation,
 as well as any history data we associated
 with the location. */
function handleHistoryChange(newLocation, historyData) {
    var actDivName = newLocation.substring(3, newLocation.length);
    var shouldDisplay = false;
    var divId;
    var divIndex
    // This is done to stop the screen from jumping about.
    if (actDivName.indexOf("divHome") > -1) {
        showHomeMenu();
        return;
    }
    if (historyData != null) {
        var objValue = historyData.menuObj;
        if (objValue != undefined) {
            var divIdIndex = objValue.indexOf(":");

            divId = objValue.substring(0, divIdIndex);
            divIndex = objValue.substring(divIdIndex + 1, objValue.length);

            shouldDisplay = true;


        }

    }

    // lastHash from mf_ui; main.js
    if (shouldDisplay) {
        renderSelectedMenuItem(document.getElementById(divId), divIndex);
    }
    // This is must
    lastHash = newLocation;

    if (actDivName.indexOf("divListServiceGroups") > -1 && shouldDisplay) {
        startServices();

    } else if (actDivName.indexOf("divStatistics") > -1 && shouldDisplay) {
        monitorSystemMenu();
    } else {
        eval("wso2.wsf.Util.showOnlyOneMain(document.getElementById('" + actDivName + "'), true)");
    }
    return;

}


function gatherHistoryObject(objId, index) {
    mainMenuObjectId = objId;
    mainMenuObjectIndex = index;
}
/*
return false ; validation fails
return true ; validation passes
*/
function parseParameterName(value) {
    var regexParamName = /[<>"'&;]+/;

    if (regexParamName.test(value)) {
        return false;
    } else {
        return true;
    }
}
/**
 * stoppingRefreshingMethodsHook is an hook. 
 */
function stoppingRefreshingMethodsHook() {
    // initializing the showDiv variable
    clearInterval(showHomeInterval);
    showDivHome = false;
    showHomeInterval = 0;
    clearInterval(showDivInterval);
    showDivStatistics = false;
    showDivInterval = 0;
    // stoping refreshing methods from listService and listServiceGroup
    clearInterval(listServiceDataRequestInterval);
    showListServiceDataDiv = false;
    listServiceDataRequestInterval = 0;

    clearInterval(listServiceGroupsRequestInterval);
    showListServcieGroupDiv = false;
    listServiceGroupsRequestInterval = 0;

    clearInterval(showGraphDivInterval);
    showGraphDivHome = false;
    showGraphDivInterval = 0;
}

var currentClassMethodOperation = "";
function selectClassMethodOperation(op, suffix, obj) {
    if (obj != null || obj != undefined) {
        obj.style.display = "none";
    }
    if (currentClassMethodOperation != "") {
        currentClassMethodOperation.style.display = "none";
    }
    currentClassMethodOperation = document.getElementById(suffix + op);
    currentClassMethodOperation.style.display = "block";

}

/*
Security Handling
*/

function dynamicallyLoadSecurityJs() {

    var rampartConfigObj = document.getElementById('rampartConfigId');
    var rampartConfigTransformerHelperObj = document.getElementById('rampartConfigTransformerHelperId');

    if ((rampartConfigObj == null) && (rampartConfigTransformerHelperObj == null)) {
        var script1 = document.createElement('script');
        script1.id = "rampartConfigId";
        script1.type = 'text/javascript';
        script1.src = 'extensions/core/js/rampart_config.js';
        document.getElementsByTagName('head')[0].appendChild(script1);

        var script2 = document.createElement('script');
        script2.id = "rampartConfigTransformerHelperId";
        script2.type = 'text/javascript';
        script2.src = 'extensions/core/js/rampart_specific_transformer.js';
        document.getElementsByTagName('head')[0].appendChild(script2);
    }
}


function showSecurityConfigurationInfo() {

    /*stopping the refreshing first */
    stoppingRefreshingMethodsHook();

    dynamicallyLoadSecurityJs();

    var body_xml = '<req:getScenarios xmlns:req="http://org.apache.axis2/xsd">' +
                   '<serviceName>'+getServiceSpecificName()+'</serviceName>' +
                   '</req:getScenarios>';

    var callURL = serverURL + "/" + SECURITY_SCENARIO_CONFIG_ADMIN + "/" ;
    new wso2.wsf.WSRequest(callURL,"getScenarios",body_xml,showSecurityConfigurationInfoCallback);
}

function showSecurityConfigurationInfoCallback() {

    /*var data = getBody(xhReq.responseXML);
    alert(xmlSerializerToString(data));*/

    wso2.wsf.Util.callbackhelper(this.req.responseXML,"list_security_main_info.xsl",document.getElementById('divSecurityConfiguration'));
    showConfigurationSecenarios(document.getElementById('headerListSecurity'));
}

// Timestamp configuratation with Objects

function TimeStamp() {
    this.serviceId = '';
    this.operationSOAPAction = '';
    this.tsFirst = true;
}
//setters
TimeStamp.prototype.setServiceId = function(serviceId) {
    this.serviceId = serviceId;
}

TimeStamp.prototype.setOperationSOAPAction = function(operationSOAPAction)  {
    this.operationSOAPAction = operationSOAPAction;
}

TimeStamp.prototype.setTsFirst = function(tsFirst) {
    this.tsFirst = tsFirst;
}

// getters
TimeStamp.prototype.getServiceId = function() {
    return this.serviceId
}

TimeStamp.prototype.getOperationSOAPAction = function()  {
    return this.operationSOAPAction;
}

TimeStamp.prototype.getTsFirst = function() {
    return this.tsFirst;
}

function showTimsStampMainInfo(){
//TODO maiking divs independent and generaic
    var objDiv = document.getElementById('divTimestampConfig');

    var strInnerHtml ="<div id='timestampHeader'></div>"+
                      "<h2>Timestamp Configuration</h2>"+
                      "<fieldset style='border:none;'>"+
                      "<div id='formset'>"+
                      "<form>"+
                      "<fieldset>"+
                      "<legend>Inflow Configuration</legend>"+
                      "<div id='inflow_configuration_setting' />"+
                      "</fieldset>"+
                      "</form>"+
                      "<form>" +
                      "<fieldset>"+
                      "<legend>Outflow Configuration</legend>" +
                      "<div id='outflow_configuration_setting' />"+
                      "</fieldset>"+
                      "</form>"+
                      "</div>"+
                      "</fieldset>";
    objDiv.innerHTML = "";
    objDiv.innerHTML = strInnerHtml;
    wso2.wsf.Util.showOnlyOneMain(objDiv);

    //starting with ts inflow configuration
    showTSInflowConfiguration();

}

function showTSInflowConfiguration() {
    var body_xml = '<req:enableTimestampRequest xmlns:req="http://org.apache.axis2/xsd">' +
                   '<serviceId>'+ getServiceSpecificName() +'</serviceId>'+
                   '<operationSOAPAction></operationSOAPAction>'+
                   '</req:enableTimestampRequest>';

   var callURL = serverURL + "/" + RAMPART_INFLOW_CONFIG_ADMIN_STRING + "/" ;
    new wso2.wsf.WSRequest(callURL,"enableTimestamp",body_xml,showTSInflowConfigurationCallback);
}

function showTSInflowConfigurationCallback() {

    transformationWithoutHistory(this.req.responseXML,"timestamp_inflow_config.xsl", document.getElementById("inflow_configuration_setting"));

    showTSOutflowConfiguration();

}

function disableTimeStampConfig(rampartFlowString,flowCallback,flow) {
    var body_xml;
    if (flow == 1) {
        body_xml =     '<req:disableTimestampRequest xmlns:req="http://org.apache.axis2/xsd">' +
                       '<serviceId>' + getServiceSpecificName() + '</serviceId>' +
                       '<operationSOAPAction></operationSOAPAction>' +
                       '</req:disableTimestampRequest>';
    }else if (flow == 2) {
        body_xml =     '<req:disableTimestampRequest xmlns:req="http://org.apache.axis2/xsd">' +
                       '<serviceId>' + getServiceSpecificName() + '</serviceId>' +
                       '<operationSOAPAction></operationSOAPAction>' +
                       '<repetition>0</repetition>'+
                       '</req:disableTimestampRequest>';
    }

   var callURL = serverURL + "/" + rampartFlowString + "/" ;
    new wso2.wsf.WSRequest(callURL,"disableTimestamp",body_xml,flowCallback);

}

function showTSOutflowConfiguration() {
    var body_xml = '<req:enableTimestampRequest xmlns:req="http://org.apache.axis2/xsd">' +
                   '<serviceId>'+ getServiceSpecificName() +'</serviceId>'+
                   '<operationSOAPAction></operationSOAPAction>'+
                   '<repetition>0</repetition>'+ // TODO Zero is hard coded need to chage for different values
                   '</req:enableTimestampRequest>';

   var callURL = serverURL + "/" + RAMPART_OUTFLOW_CONFIG_ADMIN_STRING + "/" ;
    new wso2.wsf.WSRequest(callURL,"enableTimestamp",body_xml,showTSOutflowConfigurationCallback);

}

function showTSOutflowConfigurationCallback() {

    transformationWithoutHistory(this.req.responseXML,"timestamp_outflow_config.xsl", document.getElementById("outflow_configuration_setting"));

    showTimeStampDiv(document.getElementById('timestampHeader'));
}

function showTSOutflowConfigurationDivCallback() {
    transformationWithoutHistory(this.req.responseXML,"timestamp_outflow_config.xsl", document.getElementById("outflow_configuration_setting"));
}

//flow - 1 : inflow ; 2 : outflow
function timestampFlowConfig(checkboxObj, flow) {
    if (checkboxObj.checked) {
        //callfor showTimestampConfiguration();
        if (flow == 1) {
            showTSInflowConfiguration();
        } else if (flow == 2) {
            showTSOutflowConfiguration();
        }
        return true;
    } else {

        if (flow == 1){
           disableTimeStampConfig(RAMPART_INFLOW_CONFIG_ADMIN_STRING,showTSInflowConfigurationCallback,flow);
        } else if (flow == 2) {
           disableTimeStampConfig(RAMPART_OUTFLOW_CONFIG_ADMIN_STRING,showTSOutflowConfigurationDivCallback,flow);
        }
        // callfor disableTimeStampConfig();
        return true;
    }

}

//callbacks to disableTimeStampConfig()

function disableTimeStampConfigInflowCallback() {
   if (!onError()) {
        return;
   }

}

function setTimestampOrder(rampartFlowString,booleanValue,flow,flowCallback) {
    var body_xml;
    if (flow == 1) {
        body_xml =     '<req:setTimestampOrderRequest xmlns:req="http://org.apache.axis2/xsd">' +
                       '<serviceId>' + getServiceSpecificName() + '</serviceId>' +
                       '<operationSOAPAction></operationSOAPAction>' +
                       '<tsFirst>'+booleanValue+'</tsFirst>'+
                       '</req:setTimestampOrderRequest>' ;
    }else if (flow == 2) {
        body_xml =     '<req:setTimestampOrderRequest xmlns:req="http://org.apache.axis2/xsd">' +
                       '<serviceId>' + getServiceSpecificName() + '</serviceId>' +
                       '<operationSOAPAction></operationSOAPAction>' +
                       '<repetition>0</repetition>'+
                       '<tsFirst>'+booleanValue+'</tsFirst>'+
                       '</req:setTimestampOrderRequest>';
    }

   var callURL = serverURL + "/" + rampartFlowString + "/" ;
    new wso2.wsf.WSRequest(callURL,"setTimestampOrder",body_xml,flowCallback);

}



/*
tracer.js handles script related to tracing SOAP messages at server side.
*/

/* For Monitoring Status */

function setMonitoring(obj) {


    var value = obj[obj.selectedIndex].value;

    var body_xml = '<req:setMonitoring xmlns:req="http://org.apache.axis2/xsd">\n' +
                   '<flag>' + value + '</flag>\n' +
                   ' </req:setMonitoring>\n';

    var callURL = serverURL + "/" + "wso2tracer" ;
    new wso2.wsf.WSRequest(callURL, "setMonitoring", body_xml, viewTracerCallback);
}

function viewTracer(thisObj, index) {

    if (thisObj && index) {
        renderSelectedMenuItem(thisObj, index);
        gatherHistoryObject(thisObj.id, index);
    }

    var body_xml = '<req:getMessages xmlns:req="http://org.apache.axis2/xsd">\n' +
                   '<numberOfMessages>250</numberOfMessages>\n' +
                   '<filter></filter>\n' +
                   '</req:getMessages>\n';

    var callURL = serverURL + "/" + "wso2tracer" ;
    new wso2.wsf.WSRequest(callURL, "getLastMessages", body_xml, viewTracerCallback);
}

function viewTracerCallback() {

    wso2.wsf.Util.callbackhelper(this.req.responseXML, "tracer.xsl", document.getElementById("divTracer"));
}


// this is a call through tracer.xslt
function traceMessage(valueObject) {

    var value = valueObject[valueObject.selectedIndex].value;

    var splitValues = value.split("-");

    var body_xml = '<req:getMessageRequest xmlns:req="http://org.apache.axis2/xsd">\n' +
                   '<serviceId>' + splitValues[0] + '</serviceId>\n' +
                   '<operationName>' + splitValues[1] + '</operationName>\n' +
                   '<messageSequence>' + splitValues[2] + '</messageSequence>\n' +
                   '</req:getMessageRequest>\n';

    var callURL = serverURL + "/" + "wso2tracer" ;
    new wso2.wsf.WSRequest(callURL, "getMessage", body_xml, loadTracerTextBoxes);
}

function loadTracerTextBoxes() {
    transformationWithoutHistoryShowingAllDivs(this.req.responseXML, "tracer.xsl", document.getElementById("informationMainTableDivId"));
}

function transformationWithoutHistoryShowingAllDivs(data, xslFile, objDiv) {
    wso2.wsf.Util.processXML(data, xslFile, objDiv);
}

function shrinkRequestTextBox() {

    var txtAreaSend = document.getElementById('txtAreaSend');
    var txtAreaRecieve = document.getElementById('txtAreaReceive');

    var tracerZoomLink2 = document.getElementById('tracer_zoom_out_link_2');
    var tracerZoomLink1 = document.getElementById('tracer_zoom_out_link_1');


    var tRows = txtAreaRecieve.rows;

    if (tRows == "1") {
        tracerZoomLink1.className = ".cornerCollapse";
        tracerZoomLink1.src = "extensions/core/images/collapse.gif";
        tracerZoomLink1.title = "Reduce observable space";

    }

    if (tRows == '15') {

        tracerZoomLink1.className = ".cornerExpand";
        tracerZoomLink1.src = "extensions/core/images/expand.gif";
        tracerZoomLink1.title = "Expand observable space";
        txtAreaSend.rows = '30';
        txtAreaRecieve.rows = '1';

    } else {

        tracerZoomLink2.className = ".cornerCollapse";
        tracerZoomLink2.src = "extensions/core/images/collapse.gif";
        tracerZoomLink2.title = "Reduce observable space";

        txtAreaRecieve.rows = '15';
        txtAreaSend.rows = '15';

    }
}

function shrinkResponseTextBox() {
    var txtAreaSend = document.getElementById('txtAreaSend');
    var txtAreaRecieve = document.getElementById('txtAreaReceive');

    var tracerZoomLink2 = document.getElementById('tracer_zoom_out_link_2');
    var tracerZoomLink1 = document.getElementById('tracer_zoom_out_link_1');

    var tRows = txtAreaSend.rows;

    if (tRows == "1") {
        tracerZoomLink2.className = ".cornerCollapse";
        tracerZoomLink2.src = "extensions/core/images/collapse.gif";
        tracerZoomLink2.title = "Reduce observable space";

    }

    if (tRows == '15') {
        tracerZoomLink2.className = ".cornerExpand";
        tracerZoomLink2.src = "extensions/core/images/expand.gif";
        tracerZoomLink2.title = "Expand observable space";

        txtAreaSend.rows = '1';
        txtAreaRecieve.rows = '30';

    } else {
        tracerZoomLink1.className = ".cornerCollapse";
        tracerZoomLink1.src = "extensions/core/images/collapse.gif";
        tracerZoomLink1.title = "Reduce observable space";

        txtAreaSend.rows = '15';
        txtAreaRecieve.rows = '15';

    }
}

function findMaskedObjects(findValue) {

    if (findValue != null && findValue.length == 0) {
        wso2.wsf.Util.alertMessage("Please use a string to filter");
        return false;
    }
    var body_xml = '<req:getMessagesRequest xmlns:req="http://org.apache.axis2/xsd">\n' +
                   '<numberOfMessages>30</numberOfMessages>\n' +
                   '<filter>' + findValue + '</filter>\n' +
                   '</req:getMessagesRequest>\n';

    var callURL = serverURL + "/" + "wso2tracer" ;
    new wso2.wsf.WSRequest(callURL, "getMessages", body_xml, findMaskedObjectsCallback);
}

function findMaskedObjectsCallback() {

    transformationWithoutHistoryShowingAllDivs(this.req.responseXML, "tracer.xsl", document.getElementById("divTracer"));

}




var retyped_pw_error = "Password and re-entered password do not match!";

var currentUserName;

function globalSecuritySettings(thisObj,index) {

    if (thisObj && index) {
        renderSelectedMenuItem(thisObj,index);
        gatherHistoryObject(thisObj.id, index);
    }
    
    var objDiv = document.getElementById("divUsers");

    var strHTML =  "<div style=\"align:left;\"><h2>Security Management</h2>"+
                   "<div id='formset'>"+
                   "<form>" +
                   "<fieldset>" +
                   "<legend>User and Role Management</legend>"+
                   "<h4><a href='#' onclick='manageRole(); return false;'><nobr/>Role Management</nobr></a></h4><p>Create new roles and edit existing roles.</p><p>&nbsp;</p>" +
                   "<h4><a href='#' onclick='manageUser(); return false;'><nobr>User Management</nobr></a></h4><p>Create new users, assign roles to users and edit existing users.</p>"+
                   "</fieldset>"+
                   "</form>"+
                   "</div></div>";

    objDiv.innerHTML = strHTML;
    wso2.wsf.Util.showOnlyOneMain(objDiv);
}
function manageUsers() {
    globalSecuritySettings();
}

function manageRole() {

    var body_xml = '<req:getRoleNamesAndDescriptionsRequest xmlns:req="http://org.apache.axis2/xsd">\n' +
                   ' </req:getRoleNamesAndDescriptionsRequest>\n';

    var callURL = serverURL + "/" + "UserAdmin" + "/" ;
    new wso2.wsf.WSRequest(callURL,"getRoleNamesAndDescriptions",body_xml,function(){
        wso2.wsf.Util.callbackhelper(this.req.responseXML,"role.xsl",document.getElementById("divManageRole"));
    });
}


function manageUser() {

    var body_xml = '<req:getUserNamesRequest xmlns:req="http://org.apache.axis2/xsd">\n' +
                   ' </req:getUserNamesRequest>\n';

    var callURL = serverURL + "/" + "UserAdmin" + "/" ;
    new wso2.wsf.WSRequest(callURL,"getUserNames",body_xml,function(){
        wso2.wsf.Util.callbackhelper(this.req.responseXML,"user.xsl", document.getElementById("divManageUser"));
    });
}

function editUsers(userName, userRole) {
    var strHTML1 =  "<h4><a href='#' onclick='javascript:manageUsers(); return false;'>Users</a>&nbsp;&gt;&nbsp;<a href='#' onclick='javascript:manageUser(); return false;'>User Management</a>&nbsp;&gt;&nbsp;Edit User</h4>" +
                  "<div id='formset'><form>";

    //regex for userName

    userName = userName.replace(/\xA7/g,"'"); // ASCII Value  \xA7 --> §

    currentUserName = userName;

    // Change role. We do not allow changing of role of the admin user
    var strHTML2 = (userName == 'admin')? "" :
                   "<fieldset>" +
                  "<legend>Assign role to user '" + userName + "'</legend>" +
                  "<div><label>User Role</label>" + "<select id='editUser_RoleCombo'></select></div>" +
                  "<div class='buttonrow'><input type='button' onclick='addUserWtihRole(document.getElementById(\"editUser_RoleCombo\"));' value='Assign'/></div>" +
                  "</fieldset>";

    // change password
    var strHTML3 = "<fieldset>" +
                  "<legend>Change password of user '" + userName + "'</legend>" +
                  "<div><label>New Password<font color='red'>*</font></label>" + "<input type='password' id='editUser_password'/></div>" +
                  "<div><label>Re-enter New Password<font color='red'>*</font></label>" + "<input type='password' id='editUser_password_re'/></div>" +
                  "<div class='buttonrow'><input type='button' onclick='saveEditUserPw(document.getElementById(\"editUser_password\"), document.getElementById(\"editUser_password_re\"));' value='Change Password'/></div>" +
                  "</fieldset>" +
                  "</form></div>";

    var strHTML = strHTML1 + strHTML2 + strHTML3;
    document.getElementById("divEditUser").innerHTML = strHTML;
    wso2.wsf.Util.showOnlyOneMain(document.getElementById("divEditUser"));

    var body_xml = '<req:getRoleNamesRequest xmlns:req="http://org.apache.axis2/xsd">\n' +
                   ' </req:getRoleNamesRequest>\n';

    var callURL = serverURL + "/" + "UserAdmin" + "/" ;
    var params = new Object();
    params["defaultRole"] = userRole;
    new wso2.wsf.WSRequest(callURL,"getRoleNames",body_xml,editUsersCallback,params);
}

function editUsersCallback() {

    var defaultRole = this.params["defaultRole"];
    var comboToLoad = document.getElementById('editUser_RoleCombo');
    if (comboToLoad != null) {
        var data = this.req.responseXML;
        var rets = data.getElementsByTagName("return");
        var len = rets.length;
        var count;
        for (count = 0; count < len; count++) {
            comboToLoad.options[count] = new Option(rets[count].firstChild.nodeValue);
            comboToLoad.options[count].value = rets[count].firstChild.nodeValue;
            if (rets[count].firstChild.nodeValue == defaultRole) {
                comboToLoad.options[count].selected = true;
            }
        }
    }
}
function saveEditUser(userNameObj, roleCombo) {

    var un = userNameObj.value;
    var roleName = roleCombo.value;
    var body_xml = '<req:editUserRoleRequest xmlns:req="http://org.apache.axis2/xsd">\n' +
                   ' <req:username>' + un + '</req:username>\n' +
                   ' <req:role>' + roleName + '</req:role>\n' +
                   ' </req:editUserRoleRequest>\n';

    var callURL = serverURL + "/" + "UserAdmin" + "/" ;
    new wso2.wsf.WSRequest(callURL,"editUserRole",body_xml,saveEditUserCallback);

}

function saveEditUserPw(pw, pw_re) {

    var un = currentUserName;
    var pwv = pw.value;
    if (pwv  == null || wso2.wsf.Util.trim(pwv) == "") {
        wso2.wsf.Util.alertWarning('New Password cannot be Empty');
        return false;
    }
    var pw_rev = pw_re.value;
    if (wso2.wsf.Util.trim(pwv) != wso2.wsf.Util.trim(pw_rev)) {
        wso2.wsf.Util.alertWarning(retyped_pw_error);
        return false;
    }
    var body_xml = '<req:changeUserPasswordRequest xmlns:req="http://org.apache.axis2/xsd">\n' +
                   ' <req:username><![CDATA[' + un + ']]></req:username>\n' +
                   ' <req:password><![CDATA[' + pwv + ']]></req:password>\n' +
                   ' </req:changeUserPasswordRequest>\n';

    var callURL = serverURL + "/" + "UserAdmin" + "/" ;
    new wso2.wsf.WSRequest(callURL,"changeUserPasswordRequest",body_xml,saveEditUserPwCallback);
}

function saveEditUserCallback() {

    var data = this.req.responseXML;

    if (data.getElementsByTagName("return")[0].firstChild.nodeValue == "true") {
        wso2.wsf.Util.alertMessage("Editing user was successful.");
    }
    manageUser();
}

function saveEditUserPwCallback() {

    var data = this.req.responseXML;

    if (data.getElementsByTagName("return")[0].firstChild.nodeValue == "true") {
        wso2.wsf.Util.alertMessage("Password was successfully updated.");
        manageUser();
    } else {
        wso2.wsf.Util.alertWarning("Password update failed.");
    }
}

//add user - used in user management
function addUser(userName, password, password_re, role, description) {
    var un = userName.value;
    var pw = password.value;
    var dp = description.value;
    if(un == null || wso2.wsf.Util.trim(un) == ""){
        wso2.wsf.Util.alertWarning("Please enter a valid username.");
        return false;
    }
    if(pw == null || wso2.wsf.Util.trim(pw) == ""){
        wso2.wsf.Util.alertWarning("Please enter the password.");
        return false;
    }

    var pw_re = password_re.value;
    if (pw != pw_re) {
        wso2.wsf.Util.alertWarning(retyped_pw_error);
        return false;
    }
    var rl = role[role.selectedIndex].value;

    if(dp == null || wso2.wsf.Util.trim(dp) == ""){
        dp = "";
    }
    var body_xml = '<req:addUserRequest xmlns:req="http://org.apache.axis2/xsd">\n' +
                   ' <req:username><![CDATA[' + un + ']]></req:username>\n' +
                   ' <req:password><![CDATA[' + pw + ']]></req:password>\n' +
                   ' <req:role><![CDATA[' + rl + ']]></req:role>\n' +
                   ' <req:description><![CDATA[' + dp + ']]></req:description>\n' +
                   ' </req:addUserRequest>\n';

    var callURL = serverURL + "/" + "UserAdmin" + "/" ;
    role.value = "";
    password.value = "";
    password_re.value = "";
    role.value = "";
    new wso2.wsf.WSRequest(callURL,"addUser",body_xml,addUserCallback);
}

function addUserCallback() {

    wso2.wsf.Util.showResponseMessage(this.req.responseXML);
    manageUser();
}

function addRoleCallBack() {

    var data = this.req.responseXML;
    var text = data.getElementsByTagName('return')[0];

    if (text.firstChild.nodeValue == 'true'){
        wso2.wsf.Util.alertMessage("User role was added successfully.");
    }else {
        wso2.wsf.Util.alertWarning("User role already exists.");
    }
    manageRole();
}

function addRole(role,description) {
    var rolename = role.value;
    var roleDescription = description.value;
    if(rolename == null || wso2.wsf.Util.trim(rolename) == ""){
        wso2.wsf.Util.alertWarning("Please enter a valid Role name.");
        return false;
    }
    if(roleDescription == null || wso2.wsf.Util.trim(roleDescription) == ""){
        roleDescription = "";
    }
    if (wso2.wsf.Util.trim(rolename) != '') {
        var xsltFileName = "role.xsl";
        var body_xml = '<req:addRoleRequest xmlns:req="http://org.apache.axis2/xsd">\n' +
                       ' <req:role><![CDATA[' + rolename + ']]></req:role>\n' +
                       ' <req:description><![CDATA[' + roleDescription + ']]></req:description>\n' +
                       ' </req:addRoleRequest>\n';

        var callURL = serverURL + "/" + "UserAdmin" + "/" ;
        role.value = "";
        //TODO do a proper QA
//        send("addRole", body_xml, xsltFileName, callURL, document.getElementById("divAddRole"), false, addRoleCallBack);
        new wso2.wsf.WSRequest(callURL,"addRole",body_xml,addRoleCallBack);
    } else {
        wso2.wsf.Util.alertWarning("Please specify the user role to add.");
    }

    //refresh page
    //manageRole();
}

// loading the user names for the combo
function loadUserListComboBox() {
    var body_xml = '<req:getRoleNamesRequest xmlns:req="http://org.apache.axis2/xsd">\n' +
                   ' </req:getRoleNamesRequest>\n';

    var callURL = serverURL + "/" + "UserAdmin" + "/" ;
    new wso2.wsf.WSRequest(callURL,"getRoleNames",body_xml,loadUserListCallback);

}

//load user list callback.
function loadUserListCallback() {

    var comboToLoad = document.getElementById('roleSelectBox');
    var data = this.req.responseXML;
    var rets = data.getElementsByTagName("return");
    var len = rets.length;
    var count;
    for (count = 0; count < len; count++) {
        comboToLoad.options[count] = new Option(rets[count].firstChild.nodeValue);
        comboToLoad.options[count].value = rets[count].firstChild.nodeValue;
    }

}
function loadUsersComboBox() {
    var xsltFileName = "user.xsl";
    var body_xml = '<req:getUsersRequest xmlns:req="http://org.apache.axis2/xsd">\n' +
                   ' </req:getUsersRequest>\n';

    var callURL = serverURL + "/" + "UserAdmin" + "/" ;
    new wso2.wsf.WSRequest(callURL,"getUsers",body_xml,loadUsersCallback);
}

function loadUsersCallback() {

    var comboToLoad = document.getElementById('serviceUserName');
    var data = this.req.responseXML;
    var rets = data.getElementsByTagName("return");
    var len = rets.length;
    var count;
    for (count = 0; count < len; count++) {
        comboToLoad.options[count] = new Option(rets[count].firstChild.nodeValue);
        comboToLoad.options[count].value = rets[count].firstChild.nodeValue;
    }
}

function deleteUser(user) {

    user = user.replace(/\xA7/g,"'");

    if (user == 'admin') {
        wso2.wsf.Util.alertWarning("You cannot delete the default admin account!");
        return false;
    }
    var deleteIt= confirm("Do you really want to delete user "+ user +"?");
    if (deleteIt) {
        var body_xml = '<req:deleteUserRequest xmlns:req="http://org.apache.axis2/xsd">\n' +
                       '<req:deleteUser><![CDATA[' + user + ']]></req:deleteUser>\n'+
                       '</req:deleteUserRequest>\n';

        var callURL = serverURL + "/" + "UserAdmin" + "/" ;
        new wso2.wsf.WSRequest(callURL,"deleteUser",body_xml,deleteUserCallback);
    }
}

function deleteUserCallback() {

    wso2.wsf.Util.alertMessage("User was deleted successfully.");
    manageUser();
}

function deleteRole(user,role) {

    user = user.replace(/\xA7/g,"'");
    role = role.replace(/\xA7/g,"'");

    if (user == 'admin') {
        wso2.wsf.Util.alertWarning("You cannot modify the default admin account settings!");
        return false;
    }
    var deleteIt= confirm("Do you really want to unassign role "+ role +" from user " + user + "?");
    if (deleteIt) {
        var body_xml = '<req:deleteRoleFromUserRequest xmlns:req="http://org.apache.axis2/xsd">\n' +
                       '<req:username><![CDATA[' + user + ']]></req:username>\n'+
                       '<req:role><![CDATA[' + role + ']]></req:role>\n'+
                       '</req:deleteRoleFromUserRequest>\n';

        var callURL = serverURL + "/" + "UserAdmin" + "/" ;
        new wso2.wsf.WSRequest(callURL,"deleteRoleFromUser",body_xml,deleteRoleCallback);
    }
}

function deleteRoleCallback() {

    var data = this.req.responseXML;

    if (data.getElementsByTagName("return")[0].firstChild.nodeValue == "true") {
        wso2.wsf.Util.alertMessage("Unassigned user from role successfully.");
    } else {
        wso2.wsf.Util.alertWarning("Role Cannot be removed since a user should have at least one role.<br/>" +
                    "Please assign another role to this user before trying removing this role.");
    }
    manageUser();
}

function addUserWtihRole(role) {

    if (currentUserName == 'admin') {
        wso2.wsf.Util.alertWarning("You cannot modify the default admin account settings!");
        return false;
    }


    rl = role[role.selectedIndex].value;

    var body_xml = '<req:assignRoleToUser xmlns:req="http://org.apache.axis2/xsd">\n' +
                   '<req:username><![CDATA[' + currentUserName + ']]></req:username>\n'+
                   '<req:role><![CDATA[' + rl + ']]></req:role>\n'+
                   '</req:assignRoleToUser>\n';

    var callURL = serverURL + "/" + "UserAdmin" + "/" ;
    new wso2.wsf.WSRequest(callURL,"assignRoleToUser",body_xml,addUserWtihRoleCallback);

}

function addUserWtihRoleCallback() {

    wso2.wsf.Util.alertMessage("Role successfully assigned to user");
    manageUser();
}

function deleteRoleCompletely(role) {
    role = role.replace(/\xA7/g,"'");

    if (role == 'admin') {
        wso2.wsf.Util.alertWarning("You cannot delete the default admin role!");
        return false;
    }
    var deleteIt= confirm("Do you really want to delete role "+ role +"?");
    if (deleteIt) {
        var body_xml = '<req:deleteRoleCompletelyRequest xmlns:req="http://org.apache.axis2/xsd">\n' +
                       '<req:role><![CDATA[' + role + ']]></req:role>\n'+
                       '</req:deleteRoleCompletelyRequest>\n';

        var callURL = serverURL + "/" + "UserAdmin" + "/" ;
        new wso2.wsf.WSRequest(callURL,"deleteRoleCompletely",body_xml,deleteRoleCompletelyCallback);
    }
}

function deleteRoleCompletelyCallback() {

    var data = this.req.responseXML;

    var deleteStatement = data.getElementsByTagName("return")[0].firstChild.nodeValue;
    wso2.wsf.Util.alertMessage(deleteStatement);

    manageRole();

}

/*
transports.js will work on the TrasportAdmin related administration
*/

var TRANSPORT_ADMIN = "TransportAdmin";

var HTTPS_PORT;

var KEYSTORE_PASSWORD;
var KEYSTORE_REE_PASSWORD;
var KEYSTORE_TYPE;

function showTransports(thisObj,index) {

    if (thisObj && index) {
        renderSelectedMenuItem(thisObj,index);
        gatherHistoryObject(thisObj.id, index);
    }

    var body_xml = '<ns1:listTransportsRequest xmlns:ns1="http://org.apache.axis2/xsd">' +
                   '</ns1:listTransportsRequest>';

    var callURL = serverURL + "/" + TRANSPORT_ADMIN + "/" + "listTransports";
    new wso2.wsf.WSRequest(callURL,"listTransports",body_xml,showTransportsCallback);

}

function addNewTransport_1() {
    var body_xml = '<ns1:getAvailableProtocolsRequest xmlns:ns1="http://org.apache.axis2/xsd">' +
                   '</ns1:getAvailableProtocolsRequest>';

    var callURL = serverURL + "/" + TRANSPORT_ADMIN + "/" + "getAvailableProtocols";
    new wso2.wsf.WSRequest(callURL,"getAvailableProtocols",body_xml,addNewTransport_1Callback);

}

function showTransportsCallback() {

    transportOnly = true;

    wso2.wsf.Util.callbackhelper(this.req.responseXML,"list_transport.xsl",document.getElementById("divListTransport"));
}

function addNewTransport_1Callback() {

    wso2.wsf.Util.callbackhelper(this.req.responseXML,"add_new_transport_1.xsl",document.getElementById("divAddNewTransport_1"));
}


function addNewTrasportHTTPSPort() {

    //SOAP Call for get the PORT for the HTTPS Transport
    var body_xml = '<ns1:getAvailablePortRequest xmlns:ns1="http://org.apache.axis2/xsd">' +
                   '</ns1:getAvailablePortRequest>';

    var callURL = serverURL + "/" + TRANSPORT_ADMIN + "/" + "getAvailablePort";
    new wso2.wsf.WSRequest(callURL,"getAvailablePort",body_xml,addNewTrasportHTTPSPortCallback);

}

function addNewTrasportHTTPSPortCallback() {

    var data = this.req.responseXML;
    var port = data.getElementsByTagName("return")[0].firstChild.nodeValue;

    HTTPS_PORT = port;

    // second view of HTTPS

    addNewTransport_2();

}

function addNewTransport_2() {
    var objDiv = document.getElementById("divAddNewTransport_2");
    /*"<h4><a href='#' onClick='javascript:showEndpoints(); return false;'>Endpoint Management</a>"+
                  "</a>&nbsp;&gt;&nbsp;Add Endpoint</h4>" +*/
    var strHTML = "<h2>Transport Management Wizard</h2>"+
                  "<fieldset style='border:none;'>" +
                  "<div id='formset'><form>" +
                  "<fieldset>" +
                  "<legend>Select Https Port - step 2</legend>" +
                  "<div><label>HTTPS Port<font color='red'>*</font></label><input type='text' id='httpsPort'/></div>" +
                  "<div class='buttonrow'>" +
                  "<input type='button' onclick='javascript:addNewTransport_1();return false;' value='< Back'/>" +
                  "<input type='button' onclick='javascript:isHTTPSPortAvailable();return false;' value='Next >'/>" +
                  "</div>" +
                  "</fieldset>" +
                  "</form>" +
                  "</div>" +
                  "</fieldset>";

    objDiv.innerHTML = strHTML;
    wso2.wsf.Util.showOnlyOneMain(objDiv);

    // filling the text input httpsPort
    var objInput = document.getElementById('httpsPort');
    objInput.value = HTTPS_PORT;
}

function next_1(objCombo) {
    var transportProtocol = objCombo[objCombo.selectedIndex].text;
    if (transportProtocol == null) {
        transportProtocol = objCombo[objCombo.selectedIndex].value;
    }

    if (transportProtocol == 'HTTPS') {
        // do the http stuff
        addNewTrasportHTTPSPort();
    } else {
        // added new transport on something other
        alert('Do it have to finish it here !');
    }



}

function isHTTPSPortAvailable() {

    var httpsPortObj = document.getElementById('httpsPort');

    var body_xml = '<ns1:isPortAvailableRequest xmlns:ns1="http://org.apache.axis2/xsd">' +
                   '<port>' + httpsPortObj.value + '</port>'
                   '</ns1:isPortAvailableRequest>';

    var callURL = serverURL + "/" + TRANSPORT_ADMIN + "/" + "isPortAvailable";
    new wso2.wsf.WSRequest(callURL,"isPortAvailable",body_xml,isHTTPSPortAvailableCallback);

}

function isHTTPSPortAvailableCallback() {

    var data = this.req.responseXML;
    var isAvailable = data.getElementsByTagName("return")[0].firstChild.nodeValue;

    if (isAvailable == 'true') {
        // go forward
//        addNewTransportHttps_3();
        getAllkeystoreNames();
    }else {
        wso2.wsf.Util.alertWarning("HTTPS Port Already Exists.\n"+
                     "Please try another port or the System\n"+
                     "generate one.");
        addNewTrasportHTTPSPort();

    }


}

function transportWizardStatus() {
    var objDiv = document.getElementById("divCompleteTransportWizard");

    var strHTML ="<h2>Transport Management Wizard</h2>" +
                 "<fieldset style='border:none;'>" +
                  "<div id='formset'><form>" +
                  "<fieldset>" +
                  "<legend>Transport Selection Status</legend>" +
                  "<div><label>Selected Protocol</label><font color='blue'>HTTPS</font></div>" +  // HTTPS Value being hardcoded
                  "<div><label>Selected Port</label><font color='blue'>"+HTTPS_PORT +"</font></div>" +
                  "<div><label>Selected Keystore</label><font color='blue'>"+ KEYSTORE_FOR_TRANSPORT +"</font></div>" +
                  "<div class='buttonrow'>" +
                  "<input type='button' onclick='javascript:addNewTransport_2();return false;' value='< Back'/>" +
                  "<input type='button' onclick='javascript:createHTTPSTransportSOAP();return false;' value='Next >'/>" +
                  "</div>" +
                  "</fieldset>" +
                  "</form>" +
                  "</div>" +
                  "</fieldset>";

    objDiv.innerHTML = strHTML;
    wso2.wsf.Util.showOnlyOneMain(objDiv);
}



function createHTTPSTransport(objRadio) {
    var checkedRadioObjValue;
    var checkedRadioObj = false;
    for (var i = 0; objRadio.length; i++) {
        if (objRadio[i].checked) {
            checkedRadioObjValue = objRadio[i].value;
            KEYSTORE_FOR_TRANSPORT = checkedRadioObjValue;
            checkedRadioObj = true;
            break;
        }

        if (objRadio[i] == (objRadio.length - 1)) {
            wso2.wsf.Util.alertWarning("Please select a keystore to continue.");
        }
    }
    if (checkedRadioObj) {
        checkedRadioObj = false;
        transportWizardStatus();
    }

}

function createHTTPSTransportSOAP() {
    var body_xml = '<ns1:createHTTPSTransportRequest xmlns:ns1="http://org.apache.axis2/xsd">' +
                   '<keyStoreName>'+ KEYSTORE_FOR_TRANSPORT+'</keyStoreName>'+
                   '<port>'+ HTTPS_PORT+'</port>'+
                   '</ns1:createHTTPSTransportRequest>';

    var callURL = serverURL + "/" + TRANSPORT_ADMIN + "/" + "createHTTPSTransport";
    new wso2.wsf.WSRequest(callURL,"createHTTPSTransport",body_xml,createHTTPSTransportSOAPCallback);
}

function createHTTPSTransportSOAPCallback() {

    var data = this.req.responseXML;
    var listenerstatus = data.getElementsByTagName("return")[0].firstChild.nodeValue;


    finishTranportSetting(listenerstatus);
}

function finishTranportSetting(datum) {
    var objDiv = document.getElementById("divFinishTransporSetting");
    /*"<h4><a href='#' onClick='javascript:showEndpoints(); return false;'>Endpoint Management</a>"+
  "</a>&nbsp;&gt;&nbsp;Add Endpoint</h4>" +*/
    var strHTML = "<h2>Transport Management Wizard</h2>"+
                  "<fieldset style='border:none;'>" +
                  "<div id='formset'>" +
                  "<form>" +
                  "<fieldset>" +
                  "<legend>Listener Status</legend>" +
                  "<div><h3>"+ datum +"</h3></div>" +
                  "<div class='buttonrow'>" +
                  "<input type='button' onclick='javascript:showTransports();return false;' value='Finish'/>" +
                  "</div>" +
                  "</fieldset>" +
                  "</form>" +
                  "</div>" +
                  "</fieldset>";

    objDiv.innerHTML = strHTML;
    wso2.wsf.Util.showOnlyOneMain(objDiv);

}

function getTransportDetails(transportProtocol) {
    
    var body_xml = '<ns1:getTransportDetailsRequest xmlns:ns1="http://org.apache.axis2/xsd">' +
                   '<transportProtocol>'+transportProtocol+'</transportProtocol>'+
                   '</ns1:getTransportDetailsRequest>';

    var callURL = serverURL + "/" + TRANSPORT_ADMIN + "/" + "getTransportDetails";
    new wso2.wsf.WSRequest(callURL,"getTransportDetails",body_xml,showTreeBranch);

}
function getSelectedValue(comboBoxName) {
    comboBox = document.getElementById(comboBoxName);
    comboBoxValue = comboBox[comboBox.selectedIndex].value;
    return comboBoxValue;
}

function setSelectedValue(comboBoxName, selectedValue) {
    comboBox = document.getElementById(comboBoxName);
    var len = comboBox.options.length;
    for (i = 0; i < len; i += 1) {
        if (comboBox.options[i].value == selectedValue) {
            comboBox.selectedIndex = i;
        }
    }
}

function systemLogConfig(thisObj, index) {
    if (thisObj && index) {
        renderSelectedMenuItem(thisObj, index);
        gatherHistoryObject(thisObj.id, index);
    }
    var bodyXml = '<req:getSystemLogRequest xmlns:req="http://org.apache.axis2/xsd">\n' +
                   ' </req:getSystemLogRequest>\n';

    var callURL = serverURL + "/" + "LoggingAdmin" ;
    new wso2.wsf.WSRequest(callURL, "getSystemLog", bodyXml, systemLogConfigCallback);
}

function systemLogConfigCallback() {
    wso2.wsf.Util.callbackhelper(this.req.responseXML, "log1.xsl", document.getElementById("divSystemConfiguration"));
    //Load the loggers
    var bodyXml =  '<req:getAllLoggerData xmlns:req="http://org.apache.axis2/xsd">\n' +
                   '<logNameFilter nillable="true"></logNameFilter>\n'+
                   '<beginsWith>false</beginsWith>\n'+
                   '</req:getAllLoggerData>\n';
    var callURL = serverURL + "/" + "LoggingAdmin" ;
    new wso2.wsf.WSRequest(callURL, "urn:getAllLoggerData", bodyXml, function() {
        transformationWithoutHistory(this.req.responseXML, "log2.xsl", document.getElementById("divLogConfig.loggers"));
    });
}

function showLoggers(logNameFilter, beginsWith){
    if(beginsWith == null){
        beginsWith = false;
    }
    var body_xml = '<req:getAllLoggerData xmlns:req="http://org.apache.axis2/xsd">\n' +
                   ' <req:logNameFilter>' + logNameFilter + '</req:logNameFilter>\n' +
                   ' <req:beginsWith>' + beginsWith + '</req:beginsWith>\n' +
                   '</req:getAllLoggerData>\n';

    var callURL = serverURL + "/" + "LoggingAdmin" ;
    new wso2.wsf.WSRequest(callURL, "getAllLoggerData", body_xml, showLoggersCallback);
}

function showLoggersCallback(){
    transformationWithoutHistory(this.req.responseXML, "log2.xsl", document.getElementById("divLogConfig.loggers"));
}

function updateLoggerData() {

    var loggerName = getSelectedValue("loggerNameSettingCombo");
    var body_xml = '<req:getLoggerDataRequest xmlns:req="http://org.apache.axis2/xsd">\n' +
                   ' <req:loggerName>' + loggerName + '</req:loggerName>\n' +
                   ' </req:getLoggerDataRequest>\n';

    var callURL = serverURL + "/" + "LoggingAdmin" ;
    new wso2.wsf.WSRequest(callURL, "getLoggerData", body_xml, updateLoggerDataCallBack);
}

function updateLoggerDataCallBack() {

    var logLevelCombBox = document.getElementById("loggerLogLevelSettingCombo");
    //alert(prettyPrintDOMNode(xhReq.responseXML));
    var logLevel = this.req.responseXML.getElementsByTagName("level");
    var logLevelStr = logLevel[0].firstChild.nodeValue;
    var len = logLevelCombBox.options.length;
    for (i = 0; i < len; i += 1) {
        if (logLevelCombBox.options[i].value == logLevelStr) {
            logLevelCombBox.selectedIndex = i;
        }
    }

    var additivityElemet = this.req.responseXML.getElementsByTagName("aditivity");
    var additivity = additivityElemet[0].firstChild.nodeValue;
    var additivityCoboBox = document.getElementById("loggerAdditiviySettingCombo");
    if (additivity == 'true') {
        additivityCoboBox.selectedIndex = 0;
    } else {
        additivityCoboBox.selectedIndex = 1;
    }

}

function updateAppenderData() {

    var appenderName = getSelectedValue("appeanderNameSettingCombo");
    var body_xml = '<req:getAppenderDataRequest xmlns:req="http://org.apache.axis2/xsd">\n' +
                   ' <req:appenderName>' + appenderName + '</req:appenderName>\n' +
                   ' </req:getAppenderDataRequest>\n';

    var callURL = serverURL + "/" + "LoggingAdmin" ;

    new wso2.wsf.WSRequest(callURL, "getAppenderData", body_xml, updateAppenderDataCallback);
}


/* updates the appender text in text box*/

function updateAppenderDataCallback() {


    var patternInputBox = document.getElementById("appenderLogPatternField");
    var logPattern = this.req.responseXML.getElementsByTagName("pattern");
    var logFile = this.req.responseXML.getElementsByTagName("logFile");
    patternInputBox.value = logPattern[0].firstChild.nodeValue;

    // set the threshold
    var threshold = this.req.responseXML.getElementsByTagName("threshold");
    setSelectedValue("appenderThresholdCombo", threshold[0].firstChild.nodeValue)

    var appenderLogFileDiv = document.getElementById("appenderLogFileDiv");
    var appenderSysLogDiv = document.getElementById("appenderSysLogDiv");

    var appenderIsFileAppenderElement = this.req.responseXML.getElementsByTagName("isFileAppender");
    var appenderIsFileAppender = appenderIsFileAppenderElement[0].firstChild.nodeValue;

    if (appenderIsFileAppender == 'true') {
        appenderLogFileDiv.style.display = "inline";
        var logFileInputBox = document.getElementById("appenderLogFile");
        logFileInputBox.value = logFile[0].firstChild.nodeValue;
    } else {
        appenderLogFileDiv.style.display = "none";
    }

    var appenderIsSysLogAppenderElement = this.req.responseXML.getElementsByTagName("isSysLogAppender");
    var appenderIsSysLogAppender = appenderIsSysLogAppenderElement[0].firstChild.nodeValue;

    if (appenderIsSysLogAppender == 'true') {
        appenderSysLogDiv.style.display = "inline";
        // set sysLog host
        var sysLogHost = this.req.responseXML.getElementsByTagName("sysLogHost");
        var sysLogHostInputBox = document.getElementById("appenderSysLogHost");
        sysLogHostInputBox.value = sysLogHost[0].firstChild.nodeValue;

        // set Facility
        var facility = this.req.responseXML.getElementsByTagName("facility");
        setSelectedValue("appenderFacilitySettingCombo", facility[0].firstChild.nodeValue)
    } else {
        appenderSysLogDiv.style.display = "none";
    }
}

function storeAppenderData() {

    var appenderName = getSelectedValue("appeanderNameSettingCombo");
    var appenderPattern = document.getElementById("appenderLogPatternField").value;
    var threshold = getSelectedValue("appenderThresholdCombo");

    var logFileInputBox = document.getElementById("appenderLogFile");
    var sysLogHostInputBox = document.getElementById("appenderSysLogHost");
    var facility = getSelectedValue("appenderFacilitySettingCombo");
    var persist = document.getElementById('persistLogId');

    var body_xml;
    var callURL = serverURL + "/" + "LoggingAdmin" ;

    if (appenderName == "WSO2WSAS_LOGFILE" && wso2.wsf.Util.trim(logFileInputBox.value) == "") {
        wso2.wsf.Util.alertWarning("Please specify a valid log file.");
        return;
    }

    body_xml = '<req:updateAllAppenderDataRequest xmlns:req="http://org.apache.axis2/xsd">\n' +
               ' <req:appenderName>' + appenderName + '</req:appenderName>\n' +
               ' <req:appenderPattern>' + appenderPattern + '</req:appenderPattern>\n' +
               ' <req:threshold>' + threshold + '</req:threshold>\n' +
               ' <req:logFileName>' + logFileInputBox.value + '</req:logFileName>\n' +
               ' <req:sysLogHost>' + sysLogHostInputBox.value + '</req:sysLogHost>\n' +
               ' <req:facility>' + facility + '</req:facility>\n' +
               ' <req:persist>' + persist.checked + '</req:persist>\n' +
               ' </req:updateAllAppenderDataRequest>\n';

    new wso2.wsf.WSRequest(callURL, "updateAllAppenderData", body_xml, storeAppenderDataCallBack);

}

function storeAppenderDataCallBack() {
    wso2.wsf.Util.alertMessage("Successfully updated appender data.")
}

function storeLoggerData() {

    var loggerName = getSelectedValue("loggerNameSettingCombo");
    var loggerLevel = getSelectedValue("loggerLogLevelSettingCombo");
    var loggerAditivity = getSelectedValue("loggerAdditiviySettingCombo");

    var callURL = serverURL + "/" + "LoggingAdmin" ;
    var body_xml = '<req:updateLoggerDataRequest xmlns:req="http://org.apache.axis2/xsd">\n' +
                   ' <req:loggerName>' + loggerName + '</req:loggerName>\n' +
                   ' <req:loggerLevel>' + loggerLevel + '</req:loggerLevel>\n' +
                   ' <req:additivity>' + loggerAditivity + '</req:additivity>\n' +
                   ' </req:updateLoggerDataRequest>\n';

    new wso2.wsf.WSRequest(callURL, "updateLoggerData", body_xml, storeLoggerDataCallBack);
}

function storeLoggerDataCallBack() {
    wso2.wsf.Util.alertMessage("Successfully updated logger data.");
}

/* Will update the log level, patern and file on the server globally. */
function setGlobalLogData() {
    var change = confirm("Do you really want to change the global Log4J configuration?");
    if (change) {
        var logLevel = getSelectedValue("globalLogLevelSettingCombo");
        var logPattern = document.getElementById('globalLogPatternField').value;
        var persist = document.getElementById('persistLogId');

        var body_xml = '<req:updateSystemLogRequest xmlns:req="http://org.apache.axis2/xsd">\n' +
                       ' <logLevel>' + logLevel + '</logLevel>\n' +
                       ' <logPattern>' + logPattern + '</logPattern>\n' +
                       ' <persist>' + persist.checked + '</persist>\n' +
                       ' </req:updateSystemLogRequest>\n';

        var callURL = serverURL + "/" + "LoggingAdmin" ;

        new wso2.wsf.WSRequest(callURL, "urn:updateSystemLog", body_xml, function() {
            wso2.wsf.Util.alertMessage("Global Log4J Configuration successfully updated.");
            systemLogConfig();
        });
    }
}


function restoreDefaults() {
    var restore = confirm("Do you really want to restore the original logging configuration?");

    if (restore) {
        var body_xml = '<req:restoreDefaults xmlns:req="http://org.apache.axis2/xsd">\n' +
                       '</req:restoreDefaults>\n';
        var callURL = serverURL + "/" + "LoggingAdmin" ;
        new wso2.wsf.WSRequest(callURL, "restoreDefaults", body_xml, restoreDefaultsCallback);
    }
}

function restoreDefaultsCallback() {
    wso2.wsf.Util.alertMessage("Successfully restored default logging configuration.");
    systemLogConfig();
}

function updateLogParams(name, level, additivity, persist, stat) {

    var bodyXml = '<req:updateLoggerData xmlns:req="http://org.apache.axis2/xsd">\n' +
                  '<loggerName><![CDATA[' + name + ']]></loggerName>\n' +
                  '<loggerLevel>' + level + '</loggerLevel>\n' +
                  '<additivity>' + additivity + '</additivity>\n' +
                  '<persist>' + persist + '</persist>\n' +
                  '</req:updateLoggerData>\n';
    var callURL = serverURL + "/" + "LoggingAdmin" ;

    if (stat == 1) {
        new wso2.wsf.WSRequest(callURL, "urn:updateLoggerData", bodyXml, function() {
//            wso2.wsf.Util.alertMessage("Effective Level has been successfully updated.");
        });
    }

    if (stat == 2) {
        new wso2.wsf.WSRequest(callURL, "urn:updateLoggerData", bodyXml, function() {
//            wso2.wsf.Util.alertMessage("Additivity has been successfully changed.");
        });
    }

}/*
Service Group manipulation
*/

var moduleServiceGroupName;

/**
 * Intialize the service group with the given name.
 */
function showServiceGroupInfo(serviceGroupName) {
    /* stopping the refreshing first when the system running in very latent systems */
    stoppingRefreshingMethodsHook();

    moduleServiceGroupName = serviceGroupName;
    var body_xml = '<req:listServiceGroup xmlns:req="http://org.apache.axis2/xsd">' +
                   '<serviceGroupName>' + serviceGroupName + '</serviceGroupName>' +
                   '</req:listServiceGroup>';

    var callURL = serverURL + "/" + SERVICE_GROUP_ADMIN_STRING + "/" ;
    new wso2.wsf.WSRequest(callURL, "urn:listServiceGroup", body_xml, showServiceGroupInfoCallback);

}

/**
 * configureMTOM
 */
function configureMTOM(flag,serviceGroupName) {
    var body_xml = '<req:configureMTOM xmlns:req="http://org.apache.axis2/xsd">' +
                   '<flag>' + flag + '</flag>' +
                   '<serviceGroupName>' + serviceGroupName + '</serviceGroupName>' +
                   '</req:configureMTOM>';

    var callURL = serverURL + "/" + SERVICE_GROUP_ADMIN_STRING + "/" ;
    new wso2.wsf.WSRequest(callURL, "urn:configureMTOM", body_xml, showServiceGroupInfoCallback);

}

function showServiceGroupInfoCallback() {
    wso2.wsf.Util.callbackhelper(this.req.responseXML, "list_servicegroup_main_info.xsl", document.getElementById('divshowServiceGroupInfo'));

}

function getServiceGroupSpecificParametersForConfig(serviceGroupId) {
    if (serviceGroupId == null) { // this happend only when call made within to this service
        serviceGroupId = moduleServiceGroupName;

    } else {
        moduleServiceGroupName = serviceGroupId;
    }
    var body_xml = '<req:getDeclaredServiceGroupParametersRequest xmlns:req="http://org.apache.axis2/xsd">' +
                   '<serviceGroupId>' + serviceGroupId + '</serviceGroupId>' +
                   '</req:getDeclaredServiceGroupParametersRequest>';

    var callURL = serverURL + "/" + SERVICE_GROUP_ADMIN_STRING + "/" ;
    new wso2.wsf.WSRequest(callURL,"getDeclaredServiceGroupParameters",body_xml,getServiceGroupSpecificParametersForConfigCallback);
}

function getServiceGroupSpecificParametersForConfigCallback() {

    wso2.wsf.Util.callbackhelper(this.req.responseXML,"list_service_group_params_edit.xsl", document.getElementById("divGetServiceGroupSpecficParameters"));
    showlistServiceGroupParamHeader(document.getElementById('listServiceGroupParamEditHeader'));

}

function addServiceGroupParameter() {
    var newParam = wso2.wsf.Util.getUserInput();
    if (newParam != null) {
        processSingleOperationParameterConfigEntrySG(moduleServiceGroupName,
                newParam[0],
                newParam[1], getServiceGroupSpecificParametersForConfig);
    }

}
function removeServiceGroupParameter(button) {
        processSingleOperationParameterConfigEntrySGRemoval(moduleServiceGroupName,
                button.id, getServiceGroupSpecificParametersForConfig);
    

}
function processSingleOperationParameterConfigEntrySGRemoval(serviceGroupName, parameterName,
		 callback) {

    if (!parseParameterName(parameterName)) {
        wso2.wsf.Util.alertMessage("Parameter name contains an invalid character");
        return false;
    }


    var body_xml = '<ns1:removeServiceGroupParameterRequest xmlns:ns1="http://org.apache.axis2/xsd">' +
                   '<serviceGroupId>' + serviceGroupName + '</serviceGroupId>' +
                   '<parameter locked="false" name="' + parameterName + '"></parameter>' +
                   '</ns1:removeServiceGroupParameterRequest>';

    var callURL = serverURL + "/" + SERVICE_GROUP_ADMIN_STRING;
    //update the information in operation display page
    updateServiceGroupOperationInfoDisplay("Sending value for " + parameterName);
    new wso2.wsf.WSRequest(callURL,"removeServiceGroupParameter",body_xml,callback);

}

function processMultipleOperationParameterConfigEntrySG(serviceGroupName, parameterNamesObj,
                                                      parameterValueObj){
    // the length of  parameterNamesObj and  parameterValueObj are same

    var paramElements = '';
    for (var i = 0 ; i < parameterNamesObj.length; i++) {
        paramElements += '<parameter locked="false" name="' + parameterNamesObj[i] + '"><![CDATA[' + parameterValueObj[i] +']]></parameter>\n';
    }

    var body_xml = '<ns1:setServiceGroupParameters xmlns:ns1="http://org.apache.axis2/xsd">\n' +
                   '<serviceGroupId>' + serviceGroupName + '</serviceGroupId>\n' +
                   paramElements +
                   '</ns1:setServiceGroupParameters>';

    var callURL = serverURL + "/" + SERVICE_GROUP_ADMIN_STRING;
    new wso2.wsf.WSRequest(callURL,"setServiceGroupParameters",body_xml,processMultipleOperationParameterConfigEntrySGCallback);


}

function processMultipleOperationParameterConfigEntrySGCallback() {

    wso2.wsf.Util.alertMessage("Service group parameters were successfully updated.");

    getServiceGroupSpecificParametersForConfig(moduleServiceGroupName);



}
function processSingleOperationParameterConfigEntrySG(serviceGroupName, parameterName,
                                                      parameterValue, callback) {

    if (!parseParameterName(parameterName)) {
        wso2.wsf.Util.alertMessage("Parameter name contains an invalid character");
        return false;
    }


    var body_xml = '<ns1:setServiceGroupParameterRequest xmlns:ns1="http://org.apache.axis2/xsd">' +
                   '<serviceGroupId>' + serviceGroupName + '</serviceGroupId>' +
                   '<parameter locked="false" name="' + parameterName + '"><![CDATA[' + parameterValue +
                   ']]></parameter>' +
                   '</ns1:setServiceGroupParameterRequest>';

    var callURL = serverURL + "/" + SERVICE_GROUP_ADMIN_STRING;
    //update the information in operation display page
    updateServiceGroupOperationInfoDisplay("Sending value for " + parameterName);
    new wso2.wsf.WSRequest(callURL,"setServiceGroupParameter",body_xml,callback);

}
/*
arrayOfName and arrayOfvalues have one to one
*/
function processServiceGroupParameterConfigUpdate(arrayOfNames, arrayOfValues) {

    processMultipleOperationParameterConfigEntrySG(
            moduleServiceGroupName,
            arrayOfNames,
            arrayOfValues);
}

function updateServiceGroupOperationInfoDisplay(message) {
    document.getElementById('serviceGroupParamUpdate').innerHTML = message;
}

// Module Management


function engageModulePerServiceGroup(serviceGroupId) {
    moduleServiceGroupName = serviceGroupId;

    var objDiv = document.getElementById("divEngageModuleForServiceGroup");
    var strInnerHtml = "<h4><a href='#' onClick='javascript:showServiceInitializer(); return false;'>Services</a>&nbsp;&gt;&nbsp;<a href='#' onClick='javascript:showServiceGroupInfo(\"" + serviceGroupId + "\"); return false;'>" + "ServiceGroup[" +serviceGroupId +"]"+ "</a>&nbsp;&gt;&nbsp;Engage Modules</h4>" +
                  "<fieldset style='border: none;'>" +
                  "<div id='formset'>" +
                  "<form>" +
                  "<fieldset>" +
                  "<legend>Engage module to Service Group <font color='blue'>" + serviceGroupId + "</font></legend>" +
                  "<div><label>Module</label><span id='engageModulePerServiceGroupCombo'></span></div>" +
                  "<div class='buttonrow'><input type='button' onclick='javascript:engageModulePerServiceGroupExec(\"" + serviceGroupId + "\", document.getElementById(\"cmbEngageModulePerServiceGroupCombo\").value);' value='Engage'/></div>" +
                  "</fieldset>" +
                  "</form>" +
                  "<div id='modulesEngageOnServiceGroup' style='display:inline; position: relative; top: 20px;'></div>" +
                  "<div id='globleModulesOnServiceGroup' style='display:inline; position: relative; top: 20px;'></div>" +
                  "</div>" +
                  "</fieldset>";


    objDiv.innerHTML = strInnerHtml;
    wso2.wsf.Util.showOnlyOneMain(objDiv);

    //globally engage

    body_xml = '<req:listGloballyEngagesModulesRequest xmlns:req="http://org.apache.axis2/xsd">\n' +
               ' </req:listGloballyEngagesModulesRequest>\n';
    callURL = serverURL + "/" + "ModuleAdmin" + "/" ;
    new wso2.wsf.WSRequest(callURL,"listGloballyEngagesModules",body_xml,globallyEngageModulesOnServiceGroupCallback);

}

function globallyEngageModulesOnServiceGroupCallback() {

    var xsltFileName = "list_engaged_modules_per_service.xsl";
    var objDiv = document.getElementById("globleModulesOnServiceGroup");
    var data = this.req.responseXML;
    wso2.wsf.Util.processXML(data, xsltFileName, objDiv);

    //listing for  modulesEngageOnServiceGroup
    var body_xml = '<req:listServiceGroupModulesRequest xmlns:req="http://org.apache.axis2/xsd">' +
                   ' <serviceGroupId>' + moduleServiceGroupName + '</serviceGroupId>' +
                   ' </req:listServiceGroupModulesRequest>';

    var callURL = serverURL + "/" + "ModuleAdmin" + "/" ;
    new wso2.wsf.WSRequest(callURL,"listServiceGroupModules",body_xml,listServiceGroupModulesCallback);

}

function listServiceGroupModulesCallback() {

    var xsltFileName = "list_engaged_modules_per_service.xsl";
    var objDiv = document.getElementById("modulesEngageOnServiceGroup");
    var data = this.req.responseXML;
    wso2.wsf.Util.processXML(data, xsltFileName, objDiv);

    //listing the engageModulePerServiceGroupCombo

    getGlobalModuleComboServiceGroup(document.getElementById("engageModulePerServiceGroupCombo"), "cmbEngageModulePerServiceGroupCombo");


}


function getGlobalModuleComboServiceGroup(cmbSpan, cmbName) {
    moduleSpanToUse = cmbSpan;
    moduleComboName = cmbName;
//    alert("Global module getting function called");

    var body_xml = '<ns1:listModules  xmlns:ns1="http://org.apache.axis2/xsd"/>\n';

    var callURL = serverURL + "/" + MODULE_ADMIN_STRING + "/" + "listModules";
    new wso2.wsf.WSRequest(callURL,"listModules",body_xml,getGlobalModuleComboServiceGroupCallback);

}

function getGlobalModuleComboServiceGroupCallback() {

    var data = this.req.responseXML;

//    alert("XSL = " + (new XMLSerializer()).serializeToString(data));

    var strHTML = "<select id='" + moduleComboName + "'>";
    var rets = data.getElementsByTagName("return");
    var len = rets.length;
    var count;
    var moduleVersion;
    for (count = 0; count < len; count++) {
    	if (rets[count].getElementsByTagName("moduleVersion")[0].firstChild != null){
    		moduleVersion = rets[count].getElementsByTagName("moduleVersion")[0].firstChild.nodeValue;
    	} else {
    		moduleVersion = "";
    	}
        displayModuleVersion = (moduleVersion == "" ? "" : ("-"+moduleVersion));
        strHTML += "<option value='" + rets[count].getElementsByTagName("moduleId")[0].firstChild.nodeValue + '||' + moduleVersion + "'>" + rets[count].getElementsByTagName("modulename")[0].firstChild.nodeValue +displayModuleVersion+ "</option>\n";
    }
    strHTML += "</select>"

    moduleSpanToUse.innerHTML = strHTML;

}

function engageModulePerServiceGroupExec(serviceGroupId, moduleName) {
    var moduleVersion = moduleName.substring(moduleName.indexOf('||') + 2, moduleName.length);
    moduleServiceGroupName = serviceGroupId;
    setModuleVersion = moduleVersion;
    moduleName = moduleName.substring(0, moduleName.indexOf('||'));
    //	alert("engageModulePerServiceExec Called with serviceName = " +serviceName + " || moduleName = " + moduleName + " ||| moduleVersion = " + moduleVersion);
    setModuleName = moduleName;

    var body_xml = '<req:engageModuleForServiceGroupRequest xmlns:req="http://org.apache.axis2/xsd">\n' +
                   ' <moduleId>' + moduleName + '</moduleId>\n' +
                   ' <moduleVersion>' + moduleVersion + '</moduleVersion>\n' +
                   ' <serviceGroupId>' + serviceGroupId + '</serviceGroupId>\n' +
                   ' </req:engageModuleForServiceGroupRequest>\n';

    var callURL = serverURL + "/" + "ModuleAdmin" + "/" ;
    new wso2.wsf.WSRequest(callURL,"engageModuleForServiceGroup",body_xml,engageModulePerServiceGroupExecCallback);

}

function engageModulePerServiceGroupExecCallback() {

    var data = this.req.responseXML;
    var text = data.getElementsByTagName('return')[0];

    wso2.wsf.Util.alertMessage(text.firstChild.nodeValue);

    setTimeout(function() {engageModulePerServiceGroup(moduleServiceGroupName);},1000);

}

function disengageModuelfromServiceGroupExec(moduleName, moduleVersion) {
    var body_xml = '<req:disengageModuleFromServiceGroupRequest xmlns:req="http://org.apache.axis2/xsd">\n' +
                   '<moduleId>' + moduleName + '</moduleId>\n' +
                   '<moduleVersion>' + moduleVersion + '</moduleVersion>\n' +
                   '<serviceGroupId>' + moduleServiceGroupName + '</serviceGroupId>\n' +
                   '</req:disengageModuleFromServiceGroupRequest>\n';

    var callURL = serverURL + "/" + "ModuleAdmin" + "/" ;
    new wso2.wsf.WSRequest(callURL,"disengageModuleFromServiceGroup",body_xml,disengageModuelfromServiceGroupExecCallback);

}

function disengageModuelfromServiceGroupExecCallback() {

    wso2.wsf.Util.alertMessage("Module was disengaged from service successfully.");
    setTimeout(function() {engageModulePerServiceGroup(moduleServiceGroupName);},1000);

}

function dumpAAR(serviceGroupName) {

    var body_xml = '<req:dumpAAR xmlns:req="http://org.apache.axis2/xsd">\n' +
                   '<serviceGroupName>' + serviceGroupName + '</serviceGroupName>\n' +
                   '</req:dumpAAR>\n';

    var callURL = serverURL + "/" + SERVICE_GROUP_ADMIN_STRING ;
    new wso2.wsf.WSRequest(callURL,"dumpAAR",body_xml,generateCallBack);

}
var cachedMsgFlowsXML;

function axisConfig(thisObj,index) {

    if (thisObj && index) {
        renderSelectedMenuItem(thisObj,index);
        gatherHistoryObject(thisObj.id, index);
    }

    var body_xml = '<req:getAxisConfigDataRequest xmlns:req="http://org.apache.axis2/xsd">\n' +
                   ' </req:getAxisConfigDataRequest>\n';

    var callURL = serverURL + "/" + "AxisConfigAdmin" ;

    new wso2.wsf.WSRequest(callURL,"getAxisConfigData",body_xml,function(){
        cachedMsgFlowsXML = this.req.responseXML;
        wso2.wsf.Util.callbackhelper(cachedMsgFlowsXML,"msg_flows_graphic.xsl",document.getElementById("divAxisFlowChain"));
    });
}

function listEngagedOperationHandlers(operationName){
	if (operationName != null){
		operationNameForEngagedOperationHandlers = operationName;
	} else {
		operationName = operationNameForEngagedOperationHandlers;
	}
    var body_xml = '<req:getOperationAxisConfigData xmlns:req="http://org.apache.axis2/xsd">\n' +
                   ' <req:serviceId>' + getServiceSpecificName() + '</req:serviceId>\n' +
                   ' <req:operationId>' + operationName + '</req:operationId>\n' +
                   ' </req:getOperationAxisConfigData>\n';
    var callURL = serverURL + "/" + "AxisConfigAdmin" ;

    new wso2.wsf.WSRequest(callURL,"getOperationAxisConfigData",body_xml,listEngagedOperationHandlersCallback);
}

function listEngagedOperationHandlersCallback(){
    cachedMsgFlowsXML = this.req.responseXML;
    wso2.wsf.Util.callbackhelper(cachedMsgFlowsXML,"msg_flows_graphic_per_service.xsl", document.getElementById("divAxisFlowChainPerService"));

    var _text = "<h4><a href=\"#\" onClick=\"javascript:showServiceInitializer(); return false;\">Services</a>&nbsp;&gt;&nbsp;" +
                                           "<a href=\"#\" onClick=\"javascript:listServiceData('"+ getServiceSpecificName() +"'); return false;\">"+ getServiceSpecificName() + "</a>&nbsp;&gt;&nbsp;" +
                                           '<a onclick="javascript:listAllOperations(\'' + getServiceSpecificName() + '\'); return false;" href="#">Operations[' + operationNameForEngagedOperationHandlers + ']</a>&gt;&nbsp;Flows</h4>' +
    		'<h2>Axis2 Handlers for Operation</h2>';
	document.getElementById('divAxisFlowChainGraphicPerServiceHeader').innerHTML  = _text;
    		
}	

function axisConfigText() {
    var body_xml = '<req:getAxisConfigDataRequest xmlns:req="http://org.apache.axis2/xsd">\n' +
                   ' </req:getAxisConfigDataRequest>\n';

    var callURL = serverURL + "/" + "AxisConfigAdmin" ;

    new wso2.wsf.WSRequest(callURL,"getAxisConfigData",body_xml,function(){
        wso2.wsf.Util.callbackhelper(this.req.responseXML,"msg_flows_text.xsl",document.getElementById("divAxisFlowChainText"));
    });
}

function axisConfigTextPerSerivce() {
    var body_xml = '<req:getOperationAxisConfigData xmlns:req="http://org.apache.axis2/xsd">\n' +
                   ' <req:serviceId>' + getServiceSpecificName() + '</req:serviceId>\n' +
                   ' <req:operationId>' + operationNameForEngagedOperationHandlers + '</req:operationId>\n' +
                   ' </req:getOperationAxisConfigData>\n';
    var callURL = serverURL + "/" + "AxisConfigAdmin" ;

    new wso2.wsf.WSRequest(callURL,"getOperationAxisConfigData",body_xml,axisConfigTextPerSerivceCallback);
}


function axisConfigTextPerSerivceCallback(){

    wso2.wsf.Util.callbackhelper(this.req.responseXML,"msg_flows_text_per_service.xsl", document.getElementById("divAxisFlowChainTextPerService"));

    var _text = "<h4><a href=\"#\" onClick=\"javascript:showServiceInitializer(); return false;\">Services</a>&nbsp;&gt;&nbsp;" +
                                           "<a href=\"#\" onClick=\"javascript:listServiceData('"+ getServiceSpecificName() +"'); return false;\">"+ getServiceSpecificName() + "</a>&nbsp;&gt;&nbsp;" +
                                           '<a onclick="javascript:listAllOperations(\'' + getServiceSpecificName() + '\'); return false;" href="#">Operations[' + operationNameForEngagedOperationHandlers + ']</a></h4>' +
    		'<h2>Axis2 Handlers for Operation</h2>';
	document.getElementById('divAxisFlowChainTextHeaderPerService').innerHTML  = _text;

}

function axisConfigHandlers(flowName, flowNodeName, phaseName) {
	var flowImgName;
	//Since it can only be in or out ;-)
	if (flowName.indexOf("Out") == -1){
		flowImgName = "inflow";
	} else {
		flowImgName = "outflow";	
	}
    var objPhase = getPhaseObject(flowNodeName, phaseName);
	objPhase.setAttribute("imgFlowName", flowImgName);
    wso2.wsf.Util.processXML(objPhase, "msg_flow_handlers.xsl", document.getElementById("divAxisFlowChainHandlers"));

    document.getElementById("divAxisFlowChainHandlersHeader").innerHTML =
    '<h4><a onclick="javascript:axisConfig(); return false;" href="#">Message Flows</a>&nbsp;&gt;&nbsp;' +
    ' Flow [' + flowName + '] - Phase [' + phaseName + ']</h4>' +
    '<h2>Axis2 Handlers for phase : ' + phaseName + ' in ' + flowName + '</h2>';

    wso2.wsf.Util.showOnlyOneMain(document.getElementById("divAxisFlowChainHandlers"));
}

function axisConfigHandlersPerService(flowName, flowNodeName, phaseName) {
	var flowImgName;
	//Since it can only be in or out ;-)
	if (flowName.indexOf("Out") == -1){
		flowImgName = "inflow";
	} else {
		flowImgName = "outflow";	
	}
    var objPhase = getPhaseObject(flowNodeName, phaseName);
	objPhase.setAttribute("imgFlowName", flowImgName);
    wso2.wsf.Util.processXML(objPhase, "msg_flow_handlers_per_service.xsl", document.getElementById("divAxisFlowChainHandlers"));
   
    var _text = "<h4><a href=\"#\" onClick=\"javascript:showServiceInitializer(); return false;\">Services</a>&nbsp;&gt;&nbsp;" +
                                           "<a href=\"#\" onClick=\"javascript:listServiceData('"+ getServiceSpecificName() +"'); return false;\">"+ getServiceSpecificName() + "</a>&nbsp;&gt;&nbsp;"+
            '<a onclick="javascript:listAllOperations(\'' + getServiceSpecificName() +'\'); return false;" href="#">Operations[' + operationNameForEngagedOperationHandlers + ']</a>&nbsp;&gt;&nbsp;' +
			'<a onclick="javascript:listEngagedOperationHandlers(); return false;" href="#">Message Flows</a>&nbsp;&gt;&nbsp;' +
   			' Flow [' + flowName + '] - Phase [' + phaseName + ']</h4>' +
    		'<h2>Axis2 Handlers for Phase : ' + phaseName + ' in ' + flowName + '</h2>';

    document.getElementById("divAxisFlowChainHandlersHeaderPerService").innerHTML = _text;

    wso2.wsf.Util.showOnlyOneMain(document.getElementById("divAxisFlowChainHandlers"));
}

/*function breakClassName(className) {
    var newClassName = "";
    var count;
    for (count = 0; count < className.length(); count++) {
        if (char(className.charAt(count)) > 64) {
            newClassName = newClassName + " " + className.charAt(count);
        } else {
            newClassName += className.charAt(count);
        }
    }
    return newClassName;
}*/


function getPhaseObject(flowName, expPhaseName) {
    var flowObject = getElementsByTagNameCrossBrowser(cachedMsgFlowsXML, flowName)[0];
    var xml = getElementsByTagNameCrossBrowser(flowObject, "phases");
    var curPhaseName;
    for (var x = 0; x < xml.length; x++) {
        var phaseChildNodes = xml[x].childNodes;
        for (var y = 0; y < phaseChildNodes.length; y++) {
            if (phaseChildNodes[y].nodeName == "name") {
                curPhaseName = phaseChildNodes[y].firstChild.nodeValue;
                break;
            }

        }
        if (expPhaseName == curPhaseName) {
            return xml[x];
        }
    }
}

function getElementsByTagNameCrossBrowser(xml, tagName) {
    try {
        return xml.getElementsByTagName(tagName);
    } catch(e) {
    }
    try {
        return xml.getElementsByTagName(xml.firstChild.nextSibling.prefix + ":" + tagName);
    } catch(e) {
    }
    alert("getElementsByTagName not supported");
}
/*Administration service of the WSO2WSAS-SecurityTokenService*/

function getTrustedServices() {
    var bodyXML = '<req:getTrustedServices xmlns:req="http://org.apache.axis2/xsd">\n' +
                   '</req:getTrustedServices>\n';

    var callURL = serverURL + "/" + "STSAdmin" ;
    new wso2.wsf.WSRequest(callURL,"urn:getTrustedServices",bodyXML,getTrustedServicesCallback);

}

function getTrustedServicesCallback() {
    wso2.wsf.Util.callbackhelper(this.req.responseXML,"sts_main_info.xsl", document.getElementById("divSTS"));
    showSTSHeader(document.getElementById('genericScenarioHeader'));

    //populate cert aliases
    getCertAliasOfPrimaryKeyStore();

}


function getCertAliasOfPrimaryKeyStore() {
    var bodyXML = '<req:getCertAliasOfPrimaryKeyStore xmlns:req="http://org.apache.axis2/xsd">\n' +
                  '</req:getCertAliasOfPrimaryKeyStore>\n';

    var callURL = serverURL + "/" + "STSAdmin" ;
    new wso2.wsf.WSRequest(callURL, "urn:getCertAliasOfPrimaryKeyStore", bodyXML, getCertAliasOfPrimaryKeyStoreCallback);
}

function getCertAliasOfPrimaryKeyStoreCallback() {
    var comboToLoad = document.getElementById('certAliasSelectBoxId');
    var data = this.req.responseXML;
    var rets = data.getElementsByTagName("return");
    var len = rets.length;
    var count;
    for (count = 0; count < len; count++) {
        comboToLoad.options[count] = new Option(rets[count].firstChild.nodeValue);
        comboToLoad.options[count].value = rets[count].firstChild.nodeValue;
    }

//    getProofKeyType();
}

function addTrustedService() {
    var eprObjId = document.getElementById('endpointAddressId');
    var caObjId = document.getElementById('certAliasSelectBoxId');
    var caselectedValue = caObjId[caObjId.selectedIndex].value;
    var eprValue = eprObjId.value;

    if (eprValue == null || eprValue.length == 0) {
        wso2.wsf.Util.alertMessage("Please select an endpoint address to trust.");
        return false;
    }

    var bodyXML = '<req:addTrustedService xmlns:req="http://org.apache.axis2/xsd">\n' +
                  '<serviceAddress>'+ eprValue+ '</serviceAddress>\n' +
                  '<certAlias>' + caselectedValue + '</certAlias>' +
                  '</req:addTrustedService>\n';

    var callURL = serverURL + "/" + "STSAdmin" ;
    new wso2.wsf.WSRequest(callURL,"urn:addTrustedService",bodyXML,function() {
        wso2.wsf.Util.alertMessage("Endpoint address to be trusted has successfully added");
        getTrustedServices();
    });

}

function setProofKeyType() {
    var pktObj = document.getElementById('proofKeyTypeSelectBoxId');
    var pktSelectedValue = pktObj[pktObj.selectedIndex].value;

    var bodyXML = '<req:setProofKeyType xmlns:req="http://org.apache.axis2/xsd">\n' +
                  '<keyType>'+ pktSelectedValue+ '</keyType>\n' +
                  '</req:setProofKeyType>\n';
    var callURL = serverURL + "/" + "STSAdmin" ;
    new wso2.wsf.WSRequest(callURL,"urn:setProofKeyType",bodyXML,function() {
        wso2.wsf.Util.alertMessage("Proof Key Type successfully added.");
        getTrustedServices();
    });
}

function getProofKeyType() {
    var bodyXML = '<req:getProofKeyType xmlns:req="http://org.apache.axis2/xsd">\n' +
                   '</req:getProofKeyType>\n';

    var callURL = serverURL + "/" + "STSAdmin" ;
    new wso2.wsf.WSRequest(callURL,"urn:getProofKeyType",bodyXML,getProofKeyTypeCallback);

}

function getProofKeyTypeCallback() {
    var comboToLoad = document.getElementById('proofKeyTypeSelectBoxId');
    var data = this.req.responseXML;
    var ret = data.getElementsByTagName("return")[0];

    var value = ret.firstChild.nodeValue;
    if (value == 'EncryptedKey') {
        comboToLoad[0] = new Option('EncryptedKey', 'EncryptedKey');
        comboToLoad[1] = new Option('BinarySecret', 'BinarySecret');

    } else if (value == 'BinarySecret') {
        comboToLoad[0] = new Option('BinarySecret', 'BinarySecret');
        comboToLoad[1] = new Option('EncryptedKey', 'EncryptedKey');
    }

}

/*
statistics.js contains scripts pertaining to handle WSO2 WSAS statistics data
*/

var showDivStatistics = false;

var showDivStatisticsTimeout;

var showDivInterval = 0;

var showGraphDivHome = false;
var showGraphDivInterval = 0;

// Memory
var graphUsedMemoryArrayObj;
var graphTotalMemoryArrayObj;

// Response Times

var graphMaxResponseTimeArrayObj;
var graphMinResponseTimeArrayObj;
var graphAvgResponsetimeArrayObj;


var REFRESH_GRAPHS = 12000;
var SHOW_STATS_REFRESHING_TIME = 6000;

/*initializing the statistics*/

function showStatisticsInitializer() {
    var tmpTransformationNode;

    if (window.XMLHttpRequest && !wso2.wsf.Util.isIE()) {
        tmpTransformationNode =
        document.implementation.createDocument("", "initializeStatistics", null);
    } else if (window.ActiveXObject) {
        tmpTransformationNode = new ActiveXObject("Microsoft.XmlDom");
        var sXml = "<initializeStatistics></initializeStatistics>";
        tmpTransformationNode.loadXML(sXml);
    }
    var objDiv = document.getElementById("divStatistics");
    wso2.wsf.Util.processXML(tmpTransformationNode, "statistics.xsl", objDiv);
    wso2.wsf.Util.showOnlyOneMain(objDiv);

}

function monitorSystemMenu(thisObj,index) {

    if (thisObj && index) {
        renderSelectedMenuItem(thisObj,index);
        gatherHistoryObject(thisObj.id, index);
    }

    showStatisticsInitializer();

    ///////////////////////
    //Buffer in action
    graphUsedMemoryArrayObj = new QueueForGraphs();
    graphTotalMemoryArrayObj = new QueueForGraphs();
    graphUsedMemoryArrayObj.init();
    graphTotalMemoryArrayObj.init();

    graphAvgResponsetimeArrayObj = new QueueForGraphs();

    graphAvgResponsetimeArrayObj.init();


    //////////////////////

    //Initial Firing
    monitorSystem();
    if (showDivInterval == 0) {
        showDivInterval = setInterval('monitorSystem()', SHOW_STATS_REFRESHING_TIME);
    }
    if (showGraphDivInterval == 0) {
        showGraphDivInterval = setInterval('refreshGraphs()', REFRESH_GRAPHS);
    }

}

function refreshGraphs() {
    if (document.getElementById("divStatistics").style.display == 'none') {
        clearInterval(showGraphDivInterval);
        showGraphDivInterval = 0;
        // this is to counter if focus to divHome is vanished.
        return false;

    }

    var graphObj = document.getElementById('divGraphMemUsageInnerFrame');


    graphObj.src = "extensions/core/graphs.html";
}


function monitorSystem(){

    var body_xml = ' <ns1:getStatus  xmlns:ns1="http://org.apache.axis2/xsd"/>\n';

    var callURL = serverURL + "/" + SERVER_ADMIN_STRING + "/" + "getStatus";

    if (document.getElementById("divStatistics").style.display == 'none' &&
        showDivStatistics) {
        showDivStatistics = false;
        clearInterval(showDivInterval);
        showDivInterval = 0;
        // this is to counter if focus to divStatistics is vanished.
        return false;

    }

    new wso2.wsf.WSRequest(callURL,"getStatus",body_xml,monitorSystemCallback);
}

function monitorSystemCallback() {

    showDivStatistics = true;

    try {

        transformationWithoutHistory(this.req.responseXML,"statistics.xsl", document.getElementById("showGlobalStatusTable"));

        var data = this.req.responseXML;
        var memoryUsage = data.getElementsByTagName('usedMemory')[0];
        var memoryUsageValue = memoryUsage.getElementsByTagName('value')[0];

        var allocatedMemory = data.getElementsByTagName('totalMemory')[0];

        graphUsedMemoryArrayObj.add(parseInt(memoryUsageValue.firstChild.nodeValue));
        graphTotalMemoryArrayObj.add(parseInt(allocatedMemory.getElementsByTagName('value')[0].firstChild.nodeValue));

        graphAvgResponsetimeArrayObj.add(parseInt(data.getElementsByTagName('avgResponseTime')[0].firstChild.nodeValue));

    } catch(e) {
        // if encounters an error just stop all refreshing methods
        stoppingRefreshingMethodsHook();
    } finally {

    }

}



/*
log.js contains scripts need to handle log information.
*/

var LOGGING_SERVICE_ADMIN = "LogViewAdmin"
// Adding some colors to the logs
//var TRACE_color = "#FFFFFFFF";
//var DEBUG_color = "#C6FFFF";
//var INFO_color = "#B4F3FF";
//var WARN_color = "#FEE3A1";
//var ERROR_color = "#F7B761";
//var FATAL_color = "#EA8823";
//
//var VIWE_LOGS_REFRESHING_TIME= 10000; //Default refreshing time is every 10 Sec
//
//function showViewLogs(thisObj,index) {
//
//    if (thisObj && index) {
//        renderSelectedMenuItem(thisObj,index);
//        gatherHistoryObject(thisObj.id, index);
//    }
//    //initial firing
//    viewLogs();
//
//}
//
//function viewLogs() {
//
//    var body_xml = '<ns1:getLogsRequest xmlns:ns1="http://logging.service.admin.wsas.wso2.org">' +
//                   '<amount>100</amount>' +
//                   '<layoutPattern></layoutPattern>' +
//                   '</ns1:getLogsRequest>';
//
//    var callURL = serverURL + "/" + LOGGING_SERVICE_STRING + "/" + "getLogs";
//    new wso2.wsf.WSRequest(callURL,"getLogs",body_xml,viewLogsCallback);
//
//}
//
//function viewLogsCallback() {
//
//    var objDiv = document.getElementById("viewLogs");
//    var data = this.req.responseXML;
//    var strHTML = '<h2>System Logs</h2>' +
//                  '<div id="formset"><form><fieldset>' +
//                  "<div style='overflow: auto; height: 480px'>"; //textarea cols="90" rows="30"
//    var rets = data.getElementsByTagName("return");
//    var len = rets.length;
//    var count;
//
//	var str_line_type = "";
//	var str_line_color = "";
//    for (count = 0; count < len; count++) {
//		str_line_type = rets[count].firstChild.nodeValue;
//		str_line_type = str_line_type.substring(0, 6);
//		str_line_color = getLogLineColor(str_line_type);
//        strHTML += "<p style='background-color: " + str_line_color + ";border:1px solid #D0D0D0;'>"+ rets[count].firstChild.nodeValue + "</p>";
//    }
//    strHTML += "</div></fieldset></form></div>"
//    objDiv.innerHTML = strHTML;
//    wso2.wsf.Util.showOnlyOneMain(objDiv);
//}
//
//function getLogLineColor(str_line_type){
//	if (str_line_type == "TRACE ") return TRACE_color;
//	if (str_line_type == "DEBUG ") return DEBUG_color;
//	if (str_line_type == " INFO ") return INFO_color;
//	if (str_line_type == " WARN ") return WARN_color;
//	if (str_line_type == "ERROR ") return ERROR_color;
//	if (str_line_type == "FATAL ") return FATAL_color;
//}
//

function viewLogs(thisObj,index) {

    if (thisObj && index) {
        renderSelectedMenuItem(thisObj, index);
        gatherHistoryObject(thisObj.id, index);
    }


    var body_xml = '<ns1:getLogsRequest xmlns:ns1="http://org.apache.axis2/xsd">' +
                   '</ns1:getLogsRequest>';
    var callURL = serverURL + "/" + LOGGING_SERVICE_ADMIN + "/" + "getLogs";
    new wso2.wsf.WSRequest(callURL, "getLogs", body_xml, viewLogsCallback);
}

function viewLogsCallback() {
    wso2.wsf.Util.callbackhelper(this.req.responseXML, "viewlog.xsl", document.getElementById("viewLogs"));
}


function viewSingleLogLevel() {
    var loglevel = document.getElementById("logLevelID");
    var loglevel_index = null;
    var loglevel_value = null;
    if (loglevel != null)
    {
        loglevel_index = loglevel.selectedIndex;
        if (loglevel_index != null) {
            loglevel_value = loglevel.options[loglevel_index].value;
        }
    }
    if (loglevel_value != null && loglevel_value != "") {
        var body_xml = '<ns1:getLogsForSingleLogLevel xmlns:ns1="http://org.apache.axis2/xsd">' +
                       '<type>' + loglevel_value + '</type>' +
                       '</ns1:getLogsForSingleLogLevel>';
        var callURL = serverURL + "/" + LOGGING_SERVICE_ADMIN + "/" + "getLogsForSingleLogLevel";
        new wso2.wsf.WSRequest(callURL, "getLogsForSingleLogLevel", body_xml, searchLogCallback);
    } else {
        return;
    }

}
function submitenter(e)
{
    var keycode;
    if (window.event) {
        keycode = window.event.keyCode;
    }
    else if (e) {
        keycode = e.which;
    }
    if (keycode == 13)
    {
        searchLog();
        return true;
    }
    else {
        return true;
    }
}
function searchLog() {
    var loglevel = document.getElementById("logLevelID");
    var loglevel_index = null;
    var loglevel_value = null;
    if (loglevel != null)
    {
        loglevel_index = loglevel.selectedIndex;
        if (loglevel_index != null) {
            loglevel_value = loglevel.options[loglevel_index].value;
        }
    }
    var keyword = document.getElementById("logkeyword");
    if (keyword != null && keyword != undefined && keyword.value != null && keyword.value != undefined) {
        if (keyword.value == "") {
            viewLogs();
        } else {
            var body_xml = '<ns1:searchLogRequest xmlns:ns1="http://org.apache.axis2/xsd">' +
                           '<type>' + loglevel_value + '</type>' +
                           '<kerword>' + keyword.value + '</kerword>' +
                           '</ns1:searchLogsRequest>';
            var callURL = serverURL + "/" + LOGGING_SERVICE_ADMIN + "/" + "searchLog";
            new wso2.wsf.WSRequest(callURL, "searchLog", body_xml, searchLogCallback);
        }
    } else {
        return;
    }
}
function searchLogCallback() {
    var objDiv = document.getElementById("viewLogs");
    var keyword = document.getElementById("logkeyword");
    var loglevel = document.getElementById("logLevelID");
    var data = getNodeFromPath("return", this.req.responseXML);
    var loglevel_index = null;
    var loglevel_value = null;
    if (loglevel != null)
    {
        loglevel_index = loglevel.selectedIndex;
        if (loglevel_index != null) {
            loglevel_value = loglevel.options[loglevel_index].value;
        }
    }
    if (loglevel_value != null && loglevel_value != "") {
        data.setAttribute("level", loglevel_value)
    }
    if (keyword != null && keyword.value != undefined) {
        data.setAttribute("keyword", keyword.value)
    }
    var logdiv = document.getElementById("logdiv");
    wso2.wsf.Util.processXML(data, "viewlog.xsl", objDiv);
    wso2.wsf.Util.showOnlyOneMain(objDiv);
}
function clearLogEntries() {
    var body_xml = '<ns1:clearLogsRequest xmlns:ns1="http://org.apache.axis2/xsd">' +
                   '</ns1:clearLogsRequest>';
    var callURL = serverURL + "/" + LOGGING_SERVICE_ADMIN + "/" + "clearLogs";
    new wso2.wsf.WSRequest(callURL, "clearLogs", body_xml, clearLogEntriesCallback);
}
function clearLogEntriesCallback() {
    wso2.wsf.Util.callbackhelper(this.req.responseXML, "viewlog.xsl", document.getElementById("viewLogs"));
}var lastUsedModuleId = "";
var lastUsedModuleVersion = "";
var moduleXSLTFileName = "modules.xsl";
var moduleConfigureXSLTFileName = "configure_module.xsl";

function engageModuleForSystem(moduleId, moduleVersion) {
    var engage = confirm("Do you really want to globally engage the " + moduleId + " module?");
    if (engage == true) {
        var body_xml = '<ns1:engageModuleForSystem xmlns:ns1="http://org.apache.axis2/xsd">' +
                       '<ns1:moduleId>' + moduleId + '</ns1:moduleId>' +
                       '<ns1:moduleVersion>' + moduleVersion + '</ns1:moduleVersion>' +
                       '</ns1:engageModuleForSystem>';

        var callURL = serverURL + "/" + MODULE_ADMIN_STRING;
        new wso2.wsf.WSRequest(callURL,"engageModuleForSystem",body_xml,engageModuleForSystemCallback);
    }
}

function engageModuleForSystemCallback() {

    var data = this.req.responseXML;
    var text = data.getElementsByTagName('return')[0];

    wso2.wsf.Util.alertMessage(text.firstChild.nodeValue);
    listModules();
}

function disengageModuleForSystem(moduleId, moduleVersion) {

    var disengage = confirm("Do you really want to globally disengage the " + moduleId +
                            " module?");
    if (disengage == true) {
        var body_xml = '<ns1:disengageModuleFromSystem xmlns:ns1="http://org.apache.axis2/xsd">' +
                       '<ns1:moduleId>' + moduleId + '</ns1:moduleId>' +
                       '<ns1:moduleVersion>' + moduleVersion + '</ns1:moduleVersion>' +
                       '</ns1:disengageModuleFromSystem>';

        var callURL = serverURL + "/" + MODULE_ADMIN_STRING;
        new wso2.wsf.WSRequest(callURL,"disengageModuleFromSystem",body_xml,disengageModuleForSystemCallback);
    }
}

function disengageModuleForSystemCallback() {
    wso2.wsf.Util.alertMessage("Module was globally disengaged successfuly.");
    listModules();
}


function getLastUsedModuleId() {
    return lastUsedModuleId;
}

function getLastUsedModuleVersion() {
    return lastUsedModuleVersion;
}

/* Will get and display the parameters for the given module id and version. */
function getModuleParameters(moduleId, moduleVersion) {
    lastUsedModuleId = moduleId;
    lastUsedModuleVersion = moduleVersion;
    //hand make the request
    var body_xml = '<ns1:getModuleParametersRequest xmlns:ns1="http://org.apache.axis2/xsd">' +
                   '<ns1:moduleId>' + moduleId + '</ns1:moduleId>' +
                   '<ns1:moduleVersion>' + moduleVersion + '</ns1:moduleVersion>' +
                   '</ns1:getModuleParametersRequest>';

    var callURL = serverURL + "/" + MODULE_ADMIN_STRING;
    new wso2.wsf.WSRequest(callURL,"getModuleParameters",body_xml,function(){
        wso2.wsf.Util.callbackhelper(this.req.responseXML,moduleXSLTFileName,document.getElementById("divGetModuleParameters"));
    });

}


/* List modules - Will create an html object for a list of modules and will attach it to divListModules */
function listModules(thisObj, index) {

    if (thisObj && index) {
        renderSelectedMenuItem(thisObj, index);
        gatherHistoryObject(thisObj.id, index);
    }

    var body_xml = '<ns1:listModules  xmlns:ns1="http://org.apache.axis2/xsd"/>\n';

    var callURL = serverURL + "/" + MODULE_ADMIN_STRING + "/" + "listModules";
    //    send("listModules", body_xml, moduleXSLTFileName, callURL, document.getElementById("divListModules"), false);
    new wso2.wsf.WSRequest(callURL,"listModules",body_xml,listModulesCallback);
}

function listModulesCallback() {

    wso2.wsf.Util.callbackhelper(this.req.responseXML,moduleXSLTFileName, document.getElementById("divListModules"));
    // Observing the globally engage modules
    listGloballyEngageModulesForObservation();
}

function getModuleInfo(moduleId, moduleVersion) {

    var body_xml = '<ns1:getModuleInfo  xmlns:ns1="http://org.apache.axis2/xsd">\n' +
                   '<ns1:moduleId>' + moduleId + '</ns1:moduleId>\n' +
                   '<ns1:moduleVersion>' + moduleVersion + '</ns1:moduleVersion>\n' +
                   '</ns1:getModuleInfo>\n';

    var callURL = serverURL + "/" + MODULE_ADMIN_STRING;
    new wso2.wsf.WSRequest(callURL,"getModuleInfo",body_xml,getModuleInfoCallback);
}

function getModuleInfoCallback() {

    wso2.wsf.Util.callbackhelper(this.req.responseXML,"configure_module.xsl", document.getElementById("divConfigureModule"));
}

/* This will iterate through the list of parameter names and parameter values and calls the server
	to update that parameter with the new values. */
var cur_module_number = 0;
var global_arrayOfNames = null;
var global_arrayOfValues = null;
function processModuleConfigUpdate(arrayOfNames, arrayOfValues) {

    processMultipleModuleConfigEntry(getLastUsedModuleId(), getLastUsedModuleVersion(), arrayOfNames, arrayOfValues);
}

/* This is called by processModuleConfigUpdate for each name value pair. This will do the actual server
	call to update the parameter in question */

function processMultipleModuleConfigEntry(moduleId, moduleVersion, parameterNamesObj,
                                          parameterValueObj) {
    var paramElements = '';
    for (var i = 0; i < parameterNamesObj.length; i++) {
        paramElements += '<parameter locked="false" name="' + parameterNamesObj[i] + '"><![CDATA[' +
                         parameterValueObj[i] + ']]></parameter>\n';
    }

    var body_xml = '<ns1:setModuleParameters xmlns:ns1="http://org.apache.axis2/xsd">' +
                   '<ns1:moduleId>' + moduleId + '</ns1:moduleId>' +
                   '<ns1:moduleVersion>' + moduleVersion + '</ns1:moduleVersion>' +
                   paramElements +
                   '</ns1:setModuleParameters>';

    var callURL = serverURL + "/" + MODULE_ADMIN_STRING;
    new wso2.wsf.WSRequest(callURL,"setModuleParameters",body_xml,processMultipleModuleConfigEntryCallback);

}

function processMultipleModuleConfigEntryCallback() {

    wso2.wsf.Util.alertMessage("Module parameters were successfully updated.");

    getModuleParametersForConfig(getLastUsedModuleId(), getLastUsedModuleVersion());
}

function processSingleModuleConfigEntry(moduleId, moduleVersion, itemName, itemValue, callback) {

    if (!parseParameterName(itemName)) {
        wso2.wsf.Util.alertMessage("Parameter name contains an invalid character");
        return false;
    }

    var body_xml = '<ns1:setModuleParameterRequest xmlns:ns1="http://org.apache.axis2/xsd">' +
                   '<ns1:moduleId>' + moduleId + '</ns1:moduleId>' +
                   '<ns1:moduleVersion>' + moduleVersion + '</ns1:moduleVersion>' +
                   '<parameter locked="false" name="' + itemName + '"><![CDATA[' + itemValue +
                   ']]></parameter>' +
                   '</ns1:setModuleParameterRequest>';

    var callURL = serverURL + "/" + MODULE_ADMIN_STRING;
    new wso2.wsf.WSRequest(callURL,"setModuleParameter",body_xml,callback);
}

/* Used to show the value passed to the function to the user. This is tipicaly used to
	display whether an update was successful, etc. */
function updateModuleInfoDisplay(message) {
    document.getElementById('moduleConfigUpdate').innerHTML = message;
}


//add a new module parameter
function addModuleParameter() {
    var newParam = wso2.wsf.Util.getUserInput();
    if (newParam != null) {
        processSingleModuleConfigEntry(
                getLastUsedModuleId(),
                getLastUsedModuleVersion(),
                newParam[0],
                newParam[1], getModuleParametersForConfig);
    }
}

//remove a new module parameter
function removeModuleParameter(button) {
        processSingleModuleConfigEntryRemoval(
                getLastUsedModuleId(),
                getLastUsedModuleVersion(),
                button.id, getModuleParametersForConfig);
    
}

function processSingleModuleConfigEntryRemoval(moduleId, moduleVersion, itemName, callback) {

    if (!parseParameterName(itemName)) {
        wso2.wsf.Util.alertMessage("Parameter name contains an invalid character");
        return false;
    }

    var body_xml = '<ns1:removeModuleParameterRequest xmlns:ns1="http://org.apache.axis2/xsd">' +
                   '<ns1:moduleId>' + moduleId + '</ns1:moduleId>' +
                   '<ns1:moduleVersion>' + moduleVersion + '</ns1:moduleVersion>' +
                   '<parameter locked="false" name="' + itemName + '"></parameter>' +
                   '</ns1:removeModuleParameterRequest>';

    var callURL = serverURL + "/" + MODULE_ADMIN_STRING;
    new wso2.wsf.WSRequest(callURL,"removeModuleParameter",body_xml,callback);
}

/* Will get the parameters for the given module. Will display the returned data in
	divGetModuleParametersForConfig. */
function getModuleParametersForConfig(moduleId, moduleVersion) {
    //set the last Used module Id and version.
    if (moduleId == null) {
        moduleId = lastUsedModuleId;
    } else {
        lastUsedModuleId = moduleId;
    }
    if (moduleVersion == null) {
        moduleVersion = lastUsedModuleVersion;
    } else {
        lastUsedModuleVersion = moduleVersion;
    }

    var body_xml = '<ns1:getModuleParametersRequest xmlns:ns1="http://org.apache.axis2/xsd">' +
                   '<ns1:moduleId>' + moduleId + '</ns1:moduleId>' +
                   '<ns1:moduleVersion>' + moduleVersion + '</ns1:moduleVersion>' +
                   '</ns1:getModuleParametersRequest>';

    var callURL = serverURL + "/" + MODULE_ADMIN_STRING;
    new wso2.wsf.WSRequest(callURL,"getModuleParameters",body_xml,getModuleParametersForConfigCallback);

}

function getModuleParametersForConfigCallback() {

    wso2.wsf.Util.callbackhelper(this.req.responseXML,"configure_module_parameters.xsl", document.getElementById("divGetModuleParametersForConfig"));
    showconfigureModuleHeader(document.getElementById('configureModuleHeader'));
}

/* This will remove a module from the system */
function removeModule(moduleId, moduleVersion) {
    var delete_module = confirm("Do you really want to remove this module from the system?");
    if (delete_module == true) {
        var body_xml = '<ns1:removeModule xmlns:ns1="http://org.apache.axis2/xsd">' +
                       '<ns1:moduleId>' + moduleId + '</ns1:moduleId>' +
                       '<ns1:moduleVersion>' + moduleVersion + '</ns1:moduleVersion>' +
                       '</ns1:removeModule>';

        var callURL = serverURL + "/" + MODULE_ADMIN_STRING;
        new wso2.wsf.WSRequest(callURL,"removeModule",body_xml,removeModuleCallback);
    }
}

function removeModuleCallback() {

    listModules();
    stopWaitAnimation();
    var restart = confirm("Module was removed successfuly from the repository." +
                          "\n The server needs to be restarted for this to take effect." +
                          "\n Restart now?");
    if (restart) {
        wso2.wsf.Util.restartServer();
    }
}


function listGloballyEngageModulesForObservation() {
    body_xml = '<req:listGloballyEngagesModulesRequest xmlns:req="http://org.apache.axis2/xsd">\n' +
               ' </req:listGloballyEngagesModulesRequest>\n';

    var callURL = serverURL + "/" + MODULE_ADMIN_STRING;
    new wso2.wsf.WSRequest(callURL,"listGloballyEngagesModules",body_xml,listGloballyEngageModulesForObservationCallback);

}

function listGloballyEngageModulesForObservationCallback() {

    wso2.wsf.Util.callbackhelper(this.req.responseXML,"list_engaged_modules_per_service.xsl", document.getElementById("listGloballyEngageModulesForObserve"), true);
    //    showgetModuleParameterHeader(document.getElementById('getModuleParameterHeader'));
}

////////////////////////////////////////////////////////////////////////////////
//                            <wsp:Policy> 				      //
////////////////////////////////////////////////////////////////////////////////


function getModulePolicies(moduleId, moduleVersion) {

    lastUsedModuleId = moduleId;
    lastUsedModuleVersion = moduleVersion;

    var body_xml = '<ns1:getPoliciesRequest xmlns:ns1="http://org.apache.axis2/xsd">' +
                   '<ns1:moduleId>' + moduleId + '</ns1:moduleId>' +
                   '<ns1:moduleVersion>' + moduleVersion + '</ns1:moduleVersion>' +
                   '</ns1:getPoliciesRequest>';

    var callURL = serverURL + "/" + MODULE_ADMIN_STRING;

    new wso2.wsf.WSRequest(callURL,"getPolicies",body_xml,getModulePoliciesCallback);
}

function getModulePoliciesCallback() {

    wso2.wsf.Util.callbackhelper(this.req.responseXML,"module_policies_edit.xsl", document.getElementById("divModules"));
    showlistPolicyModuleHeader(document.getElementById('modulePoliciesEditHeader'));
}

function updateModulePolicy(module_id, module_version, policy_value) {
    var body_xml = '<my:setPolicy xmlns:my="http://org.apache.axis2/xsd">' +
                   '<my:moduleId>' + module_id + '</my:moduleId>' +
                   '<my:moduleVersion>' + module_version + '</my:moduleVersion>' +
                   '<my:policyString><![CDATA[' + policy_value + ']]></my:policyString>' +
                   '</my:setPolicy>';

    var callURL = serverURL + "/" + MODULE_ADMIN_STRING;
    new wso2.wsf.WSRequest(callURL,"setPolicy",body_xml,updateModulePolicyCallback);
}

function updateModulePolicyCallback() {

    var restart = confirm("Module policy successfully updated." +
                          "\n The server needs to be restarted for the modified policy to take effect." +
                          "\n Restart now?");
    if (restart) {
        wso2.wsf.Util.restartServer();
    }
}

function getSequenceInfo(moduleId, moduleVersion) {

    lastUsedModuleId = moduleId;
    lastUsedModuleVersion = moduleVersion;

    var body_xml = '<my:getOutgoingSequenceData xmlns:my="http://org.apache.axis2/xsd">' +
                   '</my:getOutgoingSequenceData>';

    var callURL = serverURL + "/" + "Sandesha2Admin";
    new wso2.wsf.WSRequest(callURL,"urn:getOutgoingSequenceData",body_xml,getSequenceInfoCallback);

}

function getSequenceInfoCallback() {
    wso2.wsf.Util.callbackhelper(this.req.responseXML, "list_sandesha2_info.xsl", document.getElementById("divSandesha2Info"));
    showSandeshaModuleHeader(document.getElementById('sandesha2SequenceHeader'));
}
/*
This JS holds classes for transformation that is specifically wirtten to
support rampart configurations. This will be loaded as demanded.
*/

var rampartExtensionPath = "rampart";

function rampartSpecificTransformationWithoutHistory(xmlDoc,xslFile, objDiv, paramArray) {
    rampartSpecificTransformer(xmlDoc, xslFile, objDiv, false, paramArray);
    wso2.wsf.Util.showOnlyOneMain(objDiv, true);
}

function rampartSpecificTransformer(xml, xslFileName, objDiv, isAbsPath, paramArray) {

    var xsltTransformer = new wso2.wsf.XSLTHelper();
    var path = "extensions/core/xslt/" + rampartExtensionPath + "/" + xslFileName;
    if (paramArray) {
        xsltTransformer.transform(objDiv, xml, path, true, false, [["topLevelHeading",paramArray[0]]]);
    } else {
        xsltTransformer.transform(objDiv, xml, path, true);
    }

}

function mozillaSpecificXSLLoader(xslFileName) {
    /*xslProcessor variable is avaiable from wso2_adminui */
    xsltProcessor = new XSLTProcessor();
    var p = createXMLHttpRequest();
    var fullPath = URL + "/extensions/core/xslt/" + rampartExtensionPath + "/" + xslFileName;
    p.open("GET", fullPath, false);
    p.send(null);

    var xslRef = p.responseXML;
    xsltProcessor.importStylesheet(xslRef);
}

function ieSpecificXSLLoader(xml, fileName, objDiv, paramArray) {
    var fullPath = URL + "/extensions/core/xslt/" + rampartExtensionPath + "/" + fileName;
    transformXMLIE(xml, fullPath, objDiv, paramArray);
}

function transformXMLIE(xmlDoc, xslDocURL, objDiv, paramArray)
{
    // declare the local variables
    var xslDoc, docProcessor, docCache, DocRequest, docFragment;
    // try the following
    try
    {
        // instantiate and load the xsl document
        xslDoc = new ActiveXObject("MSXML2.FreeThreadedDOMDocument");
        xslDoc.async = false;
        xslDoc.load(xslDocURL);
        // prepare the xsl document for transformation
        docCache = new ActiveXObject("MSXML2.XSLTemplate");
        docCache.stylesheet = xslDoc;
        // instantiate the document processor and submit the xml document
        docProcessor = docCache.createProcessor();
        docProcessor.input = xmlDoc;
        // add parameters to the xsl document
        if (paramArray) {
            docProcessor.addParameter("topLevelHeading", paramArray[0], "");
        }
        // process the documents into html and submit to the passed div to the HMTL page
        docProcessor.transform();
        // divID.innerHTML = docProcessor.output;
        objDiv.innerHTML = "<div>" + docProcessor.output + "</div>";
    }
    // catch any errors from the above code
    catch(e) {
        alert("Encounterd an error  : " + e);
    }
}


var jarZipMainArcId;

var jarZipResourceObj;

function jarZipFileUploadExecutor(main, obj) {
    jarZipMainArcId = main;
    jarZipResourceObj = obj;
    getClassListFromArchive(jarZipMainArcId);

}

function showJarZipFileUploadScreen(xslFileName) {
    var tmpTransformationNode;
    if (window.XMLHttpRequest && !wso2.wsf.Util.isIE()) {
        tmpTransformationNode =
        document.implementation.createDocument("", "newJarZipTemplate", null);
    } else if (window.ActiveXObject) {
        tmpTransformationNode = new ActiveXObject("Microsoft.XmlDom");
        var sXml = "<newJarZipTemplate></newJarZipTemplate>";
        tmpTransformationNode.loadXML(sXml);
    }
    var objDiv = document.getElementById("divJarZipUpload");
    wso2.wsf.Util.processXML(tmpTransformationNode, xslFileName, objDiv);
    wso2.wsf.Util.showOnlyOneMain(objDiv);
}/*
crypto.js handles CryptoAdmin related Adminstration
*/

var CRYPTO_ADMIN = "CryptoAdmin";

var KEYSTORE_FOR_TRANSPORT;

var KEYSTORENAME_FOR_CERTIFICATE;

function getAllkeystoreNames() {
    var body_xml = '<ns1:getAllKeyStoreNamesRequest xmlns:ns1="http://org.apache.axis2/xsd">' +
                   '</ns1:getAllKeyStoreNamesRequest>';

    var callURL = serverURL + "/" + CRYPTO_ADMIN + "/" + "getAllKeyStoreNames";
    new wso2.wsf.WSRequest(callURL,"getAllKeyStoreNames",body_xml,getAllkeystoreNamesCallback);
}

function getAllkeystoreNamesCallback() {
    var data = this.req.responseXML;
    var returnStores = data.getElementsByTagName("return");

    if (returnStores.length == 1) {
        //do for only one
        KEYSTORE_FOR_TRANSPORT =
        data.getElementsByTagName("return")[0].firstChild.nodeValue;
        transportWizardStatus();
    } else {
        // for more
        wso2.wsf.Util.callbackhelper(this.req.responseXML,"list_keystore_props.xsl", document.getElementById("divAddListKeyStores"));
    }
}


function getPrivateKeys() {
    var body_xml = '<ns1:getPrivateKeysRequest xmlns:ns1="http://org.apache.axis2/xsd">' +
                   '<keyStoreFileId>' + KEYSTORE_UUID + '</keyStoreFileId>' +
                   '<storePass><![CDATA[' + KEYSTORE_PASSWORD + ']]></storePass>' +
                   '<keyStoreType>' + KEYSTORE_TYPE + '</keyStoreType>' +
                   '</ns1:getPrivateKeysRequest>';

    var callURL = serverURL + "/" + CRYPTO_ADMIN + "/" + "getPrivateKeys";
    new wso2.wsf.WSRequest(callURL,"getPrivateKeys",body_xml,getPrivateKeysCallback);

}

function getPrivateKeysCallback() {
        // if statement for check if there are 1 or more private keys
    var data = this.req.responseXML;
    var privateKeys = data.getElementsByTagName("return");

    if (privateKeys.length == 1) {
        ONLY_ONE_ALIAS = true;
        PRIVATE_KEY_ALIASE = data.getElementsByTagName("return")[0].firstChild.nodeValue;
        privateKeyPassword(data.getElementsByTagName("return")[0].firstChild.nodeValue);
        // Note: from keystore.js
    } else {
//        alert('xml   ' + xmlSerializerToString(data))
        var xslAbsPath = URL + "/extensions/core/xslt/list_keystore_props.xsl";
        var xsltHelperObj = new wso2.wsf.XSLTHelper();
        var divObject = document.getElementById("divListPrivetKeys");
        xsltHelperObj.transform(divObject, this.req.responseXML, xslAbsPath, true);
        wso2.wsf.Util.showOnlyOneMain(divObject);
    }

}

function addNewKeyStore() {

    var body_xml = '<ns1:addNewKeyStoreRequest xmlns:ns1="http://org.apache.axis2/xsd">' +
                   '<ksFilePathId>'+ KEYSTORE_UUID+'</ksFilePathId>'+
                   '<ksPassword><![CDATA['+ KEYSTORE_PASSWORD+ ']]></ksPassword>'+
                   '<pvtKeyAlias><![CDATA['+ PRIVATE_KEY_ALIASE +']]></pvtKeyAlias>'+
                   '<pvtKeyPassword><![CDATA[' + PRIVATE_KEY_PASSWORD + ']]></pvtKeyPassword>'+
                   '<keyStoreType>'+ KEYSTORE_TYPE+'</keyStoreType>'+
                   '<provider>' + PROVIDER + '</provider>'+
                   '</ns1:addNewKeyStoreRequest>';

    var callURL = serverURL + "/" + CRYPTO_ADMIN + "/" + "addNewKeyStore";
    new wso2.wsf.WSRequest(callURL,"addNewKeyStore",body_xml,addNewKeyStoreCallback);

}

function addNewKeyStoreCallback() {

    var data = this.req.responseXML;

    var returnDatum = data.getElementsByTagName("return")[0].firstChild.nodeValue;

    finalizeKeystoreWizard(returnDatum);


}

function showImportCertificate(keystoreName) {

    KEYSTORENAME_FOR_CERTIFICATE = keystoreName;

    var objDiv = document.getElementById("divImportCertificate");

    var strHTML =     "<h4><a href='#' onClick='javascript:keystoreSetting(); return false;'>Keystores</a>&nbsp;&gt;&nbsp;Import Certificate</h4>"+
                      "<fieldset style='border:none;'>" +
                      "<div id='formset'>" +
                      "<form method='post' name='certificateupload' action='fileupload/certificate' enctype='multipart/form-data' target='globalIFrame'>" +
                      "<fieldset>" +
                      "<legend>Import Certificate</legend>" +
                      "<div><label>Certificate<font color='red'>*</font>"+
                      "</label><input type='file' name='certificateFile' id='certificateFile' size='50'/></div>" +
                      "<br/>"+
                      "<div class='buttonrow'>" +
                      "<input type=\"submit\" onclick=\"return validateimportCertificate();\" value=\"Upload\"/>" +
                      "</div>" +
                      "</fieldset>" +
                      "</form>" +
                      "<form>"+
                      "<fieldset>" +
                      "<legend>Available Certificates</legend>" +
                      "<div id='importedCertificatesDivId' />"+
                      "</fieldset>"+
                      "</form>"+
                      "</div>" +
                      "</fieldset>";

        objDiv.innerHTML = strHTML;
        wso2.wsf.Util.showOnlyOneMain(objDiv);
        // show imported certificates
        getCertificates();

}

function getCertificates() {
    var body_xml = '<ns1:getCertificates xmlns:ns1="http://org.apache.axis2/xsd">' +
                   '<keyStoreName>'+KEYSTORENAME_FOR_CERTIFICATE+'</keyStoreName>'+
                   '</ns1:getCertificates>';

    var callURL = serverURL + "/" + CRYPTO_ADMIN + "/" + "getCertificates";
    new wso2.wsf.WSRequest(callURL,"getCertificates",body_xml,getCertificatesCallback);

}

function getCertificatesCallback() {

    transformationWithoutHistory(this.req.responseXML,"list_imported_certificates.xsl", document.getElementById("importedCertificatesDivId"));

}

function validateimportCertificate() {
    if (wso2.wsf.Util.trim(document.certificateupload.certificateFile.value) == "") {
        wso2.wsf.Util.alertWarning("Please select a certificate file.");
        return false;
    }
    /*setting the callback method*/
    FileExcutor.execute = certificateFileUpload;
    return true;
}

function certificateFileUpload(uuid) {

    var body_xml = '<ns1:importCertificate xmlns:ns1="http://org.apache.axis2/xsd">' +
                   '<keyStoreName>' + KEYSTORENAME_FOR_CERTIFICATE + '</keyStoreName>' +
                   '<certificatePathId>' + uuid + '</certificatePathId>' +
                   '</ns1:importCertificate>';

    var callURL = serverURL + "/" + CRYPTO_ADMIN + "/" +"importCertificate";
    new wso2.wsf.WSRequest(callURL,"importCertificate",body_xml,certificateFileUploadCallback);

}

function certificateFileUploadCallback() {

    var data = this.req.responseXML;
    var returnStatus = data.getElementsByTagName("return")[0].firstChild.nodeValue;

    wso2.wsf.Util.alertMessage(returnStatus);
    //calling the main
    keystoreSetting();

}

function getKeystoreInfo(keyStoreName) {
    var bodyXML = '<ns1:getKeystoreInfo xmlns:ns1="http://org.apache.axis2/xsd">' +
                  '<keyStoreName>' + keyStoreName + '</keyStoreName>' +
                  '</ns1:getKeystoreInfo>';

    var callURL = serverURL + "/" + CRYPTO_ADMIN;
    new wso2.wsf.WSRequest(callURL, "urn:getKeystoreInfo", bodyXML, getKeystoreInfoCallback);

}

function getKeystoreInfoCallback() {
   wso2.wsf.Util.callbackhelper(this.req.responseXML,"keystores.xsl", document.getElementById("divKeyStoreExplor"));
}


/*
Trees Navigator
*/

var openImg = new Image();
openImg.src = "extensions/core/images/tree_open.gif";
var closedImg = new Image();
closedImg.src = "extensions/core/images/tree_closed.gif";

var finallyUsedDiv;

function showTreeBranch(objMainDiv, objImg, txProtocolName) {
    if (objMainDiv == null && objImg == null && txProtocolName == null) {
        // this is used as the callback
        //custom transformation
        treeBranchTransformer(this.req.responseXML,"list_transport_info.xsl", finallyUsedDiv);

        return true;

    }
    // create new div obj

    swapFolder(objImg, objMainDiv, txProtocolName);
}

function swapFolder(objImg, objMainDiv, txProtocolName) {
    if (objImg.src.indexOf('tree_closed.gif') > -1) {
        objImg.src = openImg.src;
        var newObjDiv = document.createElement('div');
        finallyUsedDiv = newObjDiv;
        objMainDiv.appendChild(newObjDiv);
        getTransportDetails(txProtocolName);

    }
    else {
        objImg.src = closedImg.src;
        //removed the
        var genObjDiv = objMainDiv.getElementsByTagName('div')[0];
        objMainDiv.removeChild(genObjDiv);
    }
}

//Privately own method
function treeBranchTransformer(xmlObj,xsltFile, objDiv) {
//    alert('response  :  ' + xmlSerializerToString(data));
    wso2.wsf.Util.processXML(xmlObj, xsltFile, objDiv);
}

/*This js mainly concern with the data structures related to graphs*/

//////////////////////////////////////////////////////////////////////
//Buffer length

var BUFFER_LENGTH = 26;

function QueueForGraphs() {
    this.array = new Array();
}
function initQueue() {
    for (var i = 0 ; i < BUFFER_LENGTH ; i++) {
        this.array[i] = [i,0];
    }

}

function getData() {
    return this.array;
}

function addData(newValue) {

    //shift to left
    for(i = 0; i < BUFFER_LENGTH-1;i++) {
      this.array[i] = [i,this.array[i+1][1]];

    }
    //add the value to the last postion
    this.array[BUFFER_LENGTH-1] = [BUFFER_LENGTH-1,newValue];

}

QueueForGraphs.prototype.init = initQueue;
QueueForGraphs.prototype.get = getData;
QueueForGraphs.prototype.add = addData;



function test() {
var array = new Array();

var arrayObj = new QueueForGraphs(array);
arrayObj.init();
alert(arrayObj.get());
arrayObj.add(11);
alert(arrayObj.get());

arrayObj.add(12);
alert(arrayObj.get());
arrayObj.add(13);
alert(arrayObj.get());
arrayObj.add(14);
alert(arrayObj.get());
arrayObj.add(15);
alert(arrayObj.get());
arrayObj.add(16);
alert(arrayObj.get());

}
/*
keystore.js deals with Keystore Management
*/
var KEYSTORE_UUID;
var PRIVATE_KEY_ALIASE;
var PRIVATE_KEY_PASSWORD;
var PROVIDER;

var ONLY_ONE_ALIAS = false;

function keystoreSetting(thisObj,index){

    if (thisObj && index) {
        renderSelectedMenuItem(thisObj,index);
        gatherHistoryObject(thisObj.id, index);
    }

    var objDiv = document.getElementById("divKeystoreSetting");

    var strHTML =     "<h2>Keystore Management</h2>"+
                      "<fieldset style='border:none;'>" +
                      "<div id='formset'>"+
                      "<form>"+
                      "<fieldset>" +
                      "<legend>Available Keystores</legend>" +
                      "<div id='availableKeyStoreDivId' />"+
                      "</fieldset>"+
                      "</form>"+
                      "</div>"+
                      "<div id='formset'>" +
                      "<form method='post' name='keysotoreupload' action='fileupload/keystore' enctype='multipart/form-data' target='globalIFrame'>" +
                      "<fieldset>" +
                      "<legend>Add Keystore - Step 1: Upload Keystore file</legend>" +
                      "<div><label>Keystore File<font color='red'>*</font>"+
                      "</label><input type='file' name='keystoreFile' id='keystoreFile' size='50'/></div>" +
                      "<br/>"+
                      "<div><label>Keystore Password<font color='red'>*</font>" +
                      "</label><input type='password' id='ksPassword'/></div>" +
                      "<br/>"+
                      "<div><label>Provider" +
                      "</label><input type='text' id='provider'/></div>" +
                      "<br/>"+
                      "<div><label>Keystore Type</label>"+
                      "<select id='keystoreType'>"+
                      "<option value='jks'>JKS</option>"+
                      "<option value='pkcs12'>PKCS12</option>"+
                      "</select>"+
                      "</div>"+
                      "<br/>"+
                      "<div class='buttonrow'>" +
                      "<input type=\"submit\" onclick=\"return validateKeyStoreUpload();\" value=\"Next >\"/>" +
                      "</div>" +
                      "</fieldset>" +
                      "</form>" +
                      "</div>" +
                      "</fieldset>";

        objDiv.innerHTML = strHTML;
        wso2.wsf.Util.showOnlyOneMain(objDiv);

        // loading the existing keysotres
        getKeyStores();
}

function validateKeyStoreUpload(){
   if(wso2.wsf.Util.trim(document.keysotoreupload.keystoreFile.value) == ""){
       wso2.wsf.Util.alertWarning("Please select a keystore file.");
       return false;
   }
   var ksPassword = wso2.wsf.Util.trim(document.getElementById("ksPassword").value);
   if(ksPassword==""){
       wso2.wsf.Util.alertWarning("Please enter the Keystore password.");
       return false;
   }
   KEYSTORE_PASSWORD = ksPassword;
   var objComboKeystoreType = document.getElementById("keystoreType");
   var keystoreType = objComboKeystoreType[objComboKeystoreType.selectedIndex].text;
   if (keystoreType == null) {
        keystoreType = objComboKeystoreType[objComboKeystoreType.selectedIndex].value;
   }
   KEYSTORE_TYPE = keystoreType;
   PROVIDER = wso2.wsf.Util.trim(document.getElementById("provider").value);

   //pass the callback to FileExcutor.execute
   FileExcutor.execute = getKeystoreUUID;
   return true;
}

function getKeystoreUUID(uuid){
    KEYSTORE_UUID = uuid;
    getPrivateKeys();
}

function privateKeyPassword(privateKey) {
    var objDiv = document.getElementById("divListPrivetKeyPassword");
        /*"<h4><a href='#' onClick='javascript:showEndpoints(); return false;'>Endpoint Management</a>"+
                      "</a>&nbsp;&gt;&nbsp;Add Endpoint</h4>" +*/
        var strHTML = "<h2>Add Keystore Wizard</h2>"+
                      "<fieldset style='border:none;'>" +
                      "<div id='formset'>" +
                      "<form>" +
                      "<fieldset>" +
                      "<legend>Add Keystore - Step 2: Enter Password for Private Key <font color='blue'>'"+ privateKey+ "'</font></legend>" +
                      "<div><label>Private Key Password<font color='red'>*</font>" +
                      "</label><input type='password' id='pkPassword'/></div>" +
                      "<br/>"+
                      "<div class='buttonrow'>" +
                      "<input type='button' onclick='javascript:privateKPSBack();return false;' value='< Back'/>" +
                      "<input type='button' onclick='javascript:finishKeystoreSetting(document.getElementById(\"pkPassword\"));return false;' value='Next >'/>" +
                      "</div>" +
                      "</fieldset>" +
                      "</form>" +
                      "</div>" +
                      "</fieldset>";

        objDiv.innerHTML = strHTML;
        wso2.wsf.Util.showOnlyOneMain(objDiv);
}

function privateKPSBack() {
    if (ONLY_ONE_ALIAS) {
        ONLY_ONE_ALIAS = false;
       keystoreSetting();
    } else {
       getPrivateKeys();
    }
}

function selectedSpecificPrivatekey(objRadio) {
    var checkedRadioObjValue;
    var checkedRadioObj = false;
    for (var i = 0; objRadio.length; i++) {
        if (objRadio[i].checked) {
            checkedRadioObjValue = objRadio[i].value;
            PRIVATE_KEY_ALIASE = checkedRadioObjValue;
            checkedRadioObj = true;
            break;
        }

        if (objRadio[i] == (objRadio.length - 1)) {
            wso2.wsf.Util.alertWarning("Please select a private key.");
        }
    }
    if (checkedRadioObj) {
        checkedRadioObj = false;
        privateKeyPassword(checkedRadioObjValue);
    }
}

function finishKeystoreSetting(pass) {
    PRIVATE_KEY_PASSWORD = pass.value;
    addNewKeyStore();
}

function finalizeKeystoreWizard(msg) {
    var objDiv = document.getElementById("divFinishKeystoreSetting");
    /*"<h4><a href='#' onClick='javascript:showEndpoints(); return false;'>Endpoint Management</a>"+
  "</a>&nbsp;&gt;&nbsp;Add Endpoint</h4>" +*/
    var strHTML = "<h2>Add Keystore Wizard</h2>" +
                  "<fieldset style='border:none;'>" +
                  "<div id='formset'>" +
                  "<form>" +
                  "<fieldset>" +
                  "<legend>Add Keystore - Step 3: Keystore upload complete</legend>" +
                  "<div><p>"+msg+"</p></div>" +
                  "<div class='buttonrow'>" +
                  "<input type='button' onclick='javascript:keystoreSetting();return false;' value='Finish'/>" +
                  "</div>" +
                  "</fieldset>" +
                  "</form>" +
                  "</div>" +
                  "</fieldset>";

    objDiv.innerHTML = strHTML;
    wso2.wsf.Util.showOnlyOneMain(objDiv);
}

function deleteKeyStore(keyStoreName) {

    var ans = confirm("Do you really want to delete the Keystore  '" +
                      keyStoreName + "'");

    if (!ans) {
        return false;
    }

    var body_xml = '<ns1:deleteKeyStoreRequest xmlns:ns1="http://org.apache.axis2/xsd">' +
                   '<keyStoreName>' + keyStoreName + '</keyStoreName>' +
                   '</ns1:deleteKeyStoreRequest>';

    var callURL = serverURL + "/" + "CryptoAdmin";
    new wso2.wsf.WSRequest(callURL,"deleteKeyStore",body_xml,deleteKeyStoreCallback);


}

function deleteKeyStoreCallback() {

    wso2.wsf.Util.showResponseMessage(this.req.responseXML);
    //loading the firstpage
    keystoreSetting();
}

function getKeyStores() {
    var body_xml = '<ns1:getKeyStoresRequest xmlns:ns1="http://org.apache.axis2/xsd">' +
                   '</ns1:getKeyStoresRequest>';

    var callURL = serverURL + "/" + "CryptoAdmin";
    new wso2.wsf.WSRequest(callURL,"getKeyStores",body_xml,getKeyStoresCallback);
}

function getKeyStoresCallback() {
    transformationWithoutHistory(this.req.responseXML,"keystores.xsl", document.getElementById("availableKeyStoreDivId"));
}



wso2.wsas.service = {

    GLOBAL_SERVICE_ADMIN_STRING : "ServiceAdmin",
    
    listServiceGroups : function(callBack){
    	new_listServiceGroup(callBack);
    },
    
    listServiceData : function(callBack, serviceName){
    	new_listServiceData(callBack, serviceName)
    },

    loadFaultyServices : function(callBack){
    	new_loadFaultyServices(callBack);
    },
    
    listAllOperations : function(callBack, serviceName){
    	new_listAllOperations(callBack, serviceName);
    }
    
};/*This js will be dynamically loaded */

var CONFIGURATION_SCENARIO_GROUP = "configurationScenarioGroup";

var scenarioId;
var scenarioIdForWS;
var scenarioSummary;
var scenarioCategory;


/* This will execute the correct secnario based on the server information
   CheckboxExecutor.execute(); will set on specific scenario
*/

/*
Variable that holds the catagory information
*/

var utRelated;
// ut.related function
var keystoreRelated;
// keystore.related function
var utkeystoreRelated;

var utRelatedString = "ut.related";
var keystoreRelatedString = "keystore.related";
var utkeystoreRelatedString = "ut.keystore.related";
var systemString = "system";

/* vaiables that holds the functions of scenarios */
var DisableSecurity;

/* This variable is flaged if the scenario is selected or not*/
var isUserSelectedScenario = false;

function getScenarioId() {
    return scenarioId;
}

function getScenarioIdForWS() {
    return scenarioIdForWS;
}

function getScenarioSummary() {
    return scenarioSummary;
}

function getScenarioCategory() {
    return scenarioCategory;
}

function CheckboxExecutor() {
}

function validateRS(category, scenario, summary) {
    if (category && scenario && !isUserSelectedScenario) {
        // do the initital firing if needed
        isUserSelectedScenario = false;
        scenarioId = scenario;
        scenarioIdForWS = scenario;
        scenarioSummary = summary;
        scenarioCategory = category;
        checkboxExecutorHelper(category, scenario);
        validateRSCheckboxExecutorHelper();


    } else {
        var isChecked = false;
        isUserSelectedScenario = false;
        // This will stabilizes the back button
        var objs = document.getElementsByName(CONFIGURATION_SCENARIO_GROUP);
        if (objs != null) {
            var objsLength = objs.length;
            for (var i = 0; i < objsLength; i++) {
                if (objs[i].checked) {
                    isChecked = true;
                    break;
                }
            }

        } else {
            wso2.wsf.Util.alertWarning("Problem encountered in javascript");
            return false;
        }

        if (!isChecked) {
            wso2.wsf.Util.alertMessage("Please select a scenario");
            return false;
        }
        //Execute with proper params
        validateRSCheckboxExecutorHelper();

    }
}

/*
This function will not be closed for modification
*/
function setCheckboxExecutor(category, scenario, summary) {

    isUserSelectedScenario = true;
    scenarioId = scenario;
    scenarioIdForWS = scenario;
    scenarioSummary = summary;
    scenarioCategory = category;
    checkboxExecutorHelper(category, scenario);
    return true;
}

/*private*/
function checkboxExecutorHelper(category, scenario) {
    if (category == utRelatedString) {
        CheckboxExecutor.execute = utRelated;
    } else if (category == keystoreRelatedString) {
        CheckboxExecutor.execute = keystoreRelated;
    }else if (category == utkeystoreRelatedString) {
        CheckboxExecutor.execute = utkeystoreRelated;
    }else if (category == systemString) {
        CheckboxExecutor.execute = DisableSecurity;
    }
}

/* utilities */
function FunctionInitiator() {
}

/*
rootElementName = name of the root element
divObjectName = name of the intitial object name
scenarioXsl = location of the rampart xsls
startingFunction = function should start first
*/
function rampartScenarioInitiator(rootElementName, divObjName, scenarioXsl, startingFunction,
                                  paramArray) {

    var tmpTransformationNode;

    if (window.XMLHttpRequest && !wso2.wsf.Util.isIE()) {
        tmpTransformationNode =
        document.implementation.createDocument("", rootElementName, null);
    } else if (window.ActiveXObject) {
        tmpTransformationNode = new ActiveXObject("Microsoft.XmlDom");

        var sXml = "<" + rootElementName + "></" + rootElementName + ">";

        tmpTransformationNode.loadXML(sXml);
    }
    var objDiv = document.getElementById(divObjName);
    rampartSpecificTransformer(tmpTransformationNode, scenarioXsl, objDiv, false, paramArray);
    wso2.wsf.Util.showOnlyOneMain(objDiv);
    FunctionInitiator.execute = startingFunction;
    // Execute the first function
    FunctionInitiator.execute();

}

/*private*/
function validateRSCheckboxExecutorHelper() {
    if (getScenarioCategory() == utRelatedString) {
        CheckboxExecutor.execute();
    } else if (getScenarioCategory() == keystoreRelatedString) {
        CheckboxExecutor.execute("genericScenarioInitializer", "divKeystoreRelated", "scenario2.xsl", listTrustStores, [getScenarioSummary()]);
    } else if (getScenarioCategory() == utkeystoreRelatedString) {
        CheckboxExecutor.execute("genericScenarioInitializer", "divUtKeystoreRelated", "scenario3.xsl", utkeystoreRelatedStart, [getScenarioSummary()]);
    } else if (getScenarioCategory() == systemString) {
        CheckboxExecutor.execute();
    }
}

/* scenarios */
/* ==================== utRelated starts =================*/
utRelated = function() {
    utRelatedWSCall();
}

function utRelatedWSCall() {
    var body_xml = '<req:getSecurityAssignment xmlns:req="http://org.apache.axis2/xsd">\n' +
                   '<serviceId>' + getServiceSpecificName() + '</serviceId>\n' +
                   '<serviceVersion></serviceVersion>\n' +
                   '</req:getSecurityAssignment>\n';

    var callURL = serverURL + "/" + SECURITY_SCENARIO_CONFIG_ADMIN ;
    new wso2.wsf.WSRequest(callURL, "getSecurityAssignment", body_xml, utRelatedWSCallCallback);

}
function utRelatedWSCallCallback() {
    var xmlData = this.req.responseXML;
    rampartSpecificTransformer(xmlData, "scenario1.xsl", document.getElementById('divUtRelated'), false, [getScenarioSummary()]);
    wso2.wsf.Util.showOnlyOneMain(document.getElementById('divUtRelated'));
    showlistServiceUsersHeader(document.getElementById('listServiceUsersHeader'));


}

function assignUsersAndRoles() {
    var usersObjects = document.getElementsByName('assignUserToServiceName');
    var rolesObjects = document.getElementsByName('assignRoleToServiceName');

    var users = "";
    var roles = "";
    var usersChecked = false;
    var rolesChecked = false;

    for (var i = 0; i < usersObjects.length; i++) {
        if (usersObjects[i].checked) {
            users +=
            '<users><![CDATA[' + usersObjects[i].value +
            ']]></users>';
            usersChecked = true;
        }
    }

    for (var i = 0; i < rolesObjects.length; i++) {
        if (rolesObjects[i].checked) {
            roles +=
            '<roles><![CDATA[' + rolesObjects[i].value +
            ']]></roles>';
            rolesChecked = true;
        }
    }

    if (!usersChecked && !rolesChecked) {
        wso2.wsf.Util.alertMessage("Please select at least one user or a role");
        return false;
    }
    if (usersChecked && !rolesChecked) {
        roles = "<roles nillable=\"true\"></roles>";

    }
    if (!usersChecked && rolesChecked) {
        users = "<users nillable=\"true\"></users>";
    }


    var body_xml = '<ns1:assignUsersAndRoles xmlns:ns1="http://org.apache.axis2/xsd">\n' +
                   '<serviceName>' + getServiceSpecificName() + '</serviceName>' +
                   '<serviceVersion></serviceVersion>' +
                   '<scenarioId>' + getScenarioId() + '</scenarioId>' +
                   users +
                   roles +
                   '</ns1:assignUsersAndRoles>';
    var callURL = serverURL + "/" + SECURITY_SCENARIO_CONFIG_ADMIN ;
    new wso2.wsf.WSRequest(callURL, "assignUsersAndRoles", body_xml, assignUsersAndRolesCallback);

}

function assignUsersAndRolesCallback() {

    wso2.wsf.Util.alertMessage("Security scenario successfully applied");

    showSecurityConfigurationInfo();

}

function listUsers1() {
    var body_xml = '<req:getServiceUsersWithDescriptionRequest xmlns:req="http://org.apache.axis2/xsd">\n' +
                   '<req:serviceName>' + serviceSpecificName + '</req:serviceName>\n' +
                   '</req:getServiceUsersWithDescriptionRequest>\n';

    var callURL = serverURL + "/" + "ServiceAdmin" ;
    new wso2.wsf.WSRequest(callURL, "getServiceUsersWithDescription", body_xml, listUsersCallback1);
}

function listUsersCallback1() {

    transformationWithoutHistory(this.req.responseXML, "rampart/scenario1.xsl", document.getElementById("divServiceUNameToeknAuthUsers"));
    loadUsersComboBox1();
}

function loadUsersComboBox1() {
    var xsltFileName = "user.xsl";
    var body_xml = '<req:getUsersRequest xmlns:req="http://org.apache.axis2/xsd">\n' +
                   ' </req:getUsersRequest>\n';

    var callURL = serverURL + "/" + "UserAdmin" + "/" ;
    new wso2.wsf.WSRequest(callURL, body_xml, "getUsers", loadUsersCallback1);
}

function loadUsersCallback1() {

    var optionBoxHTML = "";
    var comboToLoad = document.getElementById('serviceUserName');
    var data = this.req.responseXML;
    var rets = data.getElementsByTagName("return");
    var len = rets.length;
    var count;
    for (count = 0; count < len; count++) {
        comboToLoad.options[count] = new Option(rets[count].firstChild.nodeValue);
        comboToLoad.options[count].value = rets[count].firstChild.nodeValue;
    }
    listRoles1();
}

function listRoles1() {
    var body_xml = '<req:getServiceRolesWithDescriptionRequest xmlns:req="http://org.apache.axis2/xsd">\n' +
                   '<req:serviceName>' + serviceSpecificName + '</req:serviceName>\n' +
                   '</req:getServiceRolesWithDescriptionRequest>\n';

    var callURL = serverURL + "/" + "ServiceAdmin" ;
    new wso2.wsf.WSRequest(callURL, "getServiceRolesWithDescription", body_xml, listRolesCallback1);

}

function listRolesCallback1() {

    transformationWithoutHistory(this.req.responseXML, "rampart/scenario1.xsl", document.getElementById("divServiceUNameToeknAuthRoles"));
    showlistServiceUsersHeader(document.getElementById('listServiceUsersHeader'));
    document.getElementById('divServiceUNameToeknAuthUsers').style.display = "inline";
    document.getElementById('listServiceUsersHeader').style.display = "inline";
    loadRolesComboBox1();

}


/* ================username and role assinging and deleting ===================  */

function assignUserToService(userName) {

    var un = userName[userName.selectedIndex].value;

    var body_xml = '<ns1:assignUserToService xmlns:ns1="http://org.apache.axis2/xsd">\n' +
                   '<serviceId>' + getServiceSpecificName() + '</serviceId>' +
                   '<serviceVersion></serviceVersion>' +
                   '<username>' + un + '</username>' +
                   '</ns1:assignUserToService>';
    var callURL = serverURL + "/" + SECURITY_SCENARIO_CONFIG_ADMIN ;
    new wso2.wsf.WSRequest(callURL, "assignUserToService", body_xml, assignUserToServiceCallback);
}

function assignUserToServiceCallback() {
    serviceUNameToeknAuth();
}

function assignRoleToService(role) {

    var rr = role[role.selectedIndex].value;

    var body_xml = '<ns1:assignRoleToService xmlns:ns1="http://org.apache.axis2/xsd">\n' +
                   '<serviceId>' + getServiceSpecificName() + '</serviceId>' +
                   '<serviceVersion></serviceVersion>' +
                   '<role>' + rr + '</role>' +
                   '</ns1:assignRoleToService>';

    var callURL = serverURL + "/" + SECURITY_SCENARIO_CONFIG_ADMIN ;
    new wso2.wsf.WSRequest(callURL, "assignRoleToService", body_xml, assignRoleToServiceCallback);
}

function assignRoleToServiceCallback() {
    serviceUNameToeknAuth();
}

function unassignUserFromService(userName) {
    var deleteIt = confirm("Do you really want to unassign user " + userName + " from " +
                           serviceSpecificName + " service?");
    if (deleteIt) {
        var body_xml = '<ns1:unassignUserFromService xmlns:ns1="http://org.apache.axis2/xsd">\n' +
                       '<serviceId>' + getServiceSpecificName() + '</serviceId>' +
                       '<serviceVersion></serviceVersion>' +
                       '<username>' + userName + '</username>' +
                       '</ns1:unassignUserFromService>';

        var callURL = serverURL + "/" + SECURITY_SCENARIO_CONFIG_ADMIN ;
        new wso2.wsf.WSRequest(callURL, "unassignUserFromService", body_xml, unassignUserRoleFromServiceCallback);
    }
}

function unassignRoleFromService(role) {
    var deleteIt = confirm("Do you really want to unassign role " + role + " from " +
                           serviceSpecificName + " service?");
    if (deleteIt) {
        var body_xml = '<ns1:unassignRoleFromService xmlns:ns1="http://org.apache.axis2/xsd">\n' +
                       '<serviceId>' + getServiceSpecificName() + '</serviceId>' +
                       '<serviceVersion></serviceVersion>' +
                       '<role>' + role + '</role>' +
                       '</ns1:unassignRoleFromService>';

        var callURL = serverURL + "/" + SECURITY_SCENARIO_CONFIG_ADMIN ;
        new wso2.wsf.WSRequest(callURL, "unassignRoleFromService", body_xml, unassignUserRoleFromServiceCallback);
    }
}

function unassignUserRoleFromServiceCallback() {
    utRelated();
}

/* =========== utRelated ends ==================*/

/* =========== keystoreRelated starts ================
 rootElementName
 divObjectName
 scenarioXsl
 startingFunction
 paramArray

*/
keystoreRelated =
function(rootElementName, divObjectName, scenarioXsl, startingFunction, paramArray) {
    rampartScenarioInitiator(rootElementName, divObjectName, scenarioXsl, startingFunction, paramArray);

}

function listTrustStores() {
    var body_xml = '<ns1:getServiceKeyStores xmlns:ns1="http://org.apache.axis2/xsd">\n' +
                   '<serviceName>' + getServiceSpecificName() + '</serviceName>\n' +
                   '</ns1:getServiceKeyStores>';
    var callURL = serverURL + "/" + CRYPTO_ADMIN_STRING ;
    new wso2.wsf.WSRequest(callURL, "getServiceKeyStores", body_xml, listTrustStoresCallback);
}

function listTrustStoresCallback() {

    /*var data = getBody(xhReq.responseXML);
    alert(xmlSerializerToString(data));*/

    rampartSpecificTransformationWithoutHistory(this.req.responseXML, "scenario2.xsl", document.getElementById("divAvailableCertifcateStores"));
    showlistServiceUsersHeader(document.getElementById('genericScenarioHeader'));
    document.getElementById('divButtonRawForGenericScenario').style.display = "inline";
}

function assignKeyStores() {

    var certificateStoresCheckboxObj = document.getElementsByName('trustedCertificateStoreNames');
    var privateKeystoreSelectObj = document.getElementById('privateKeystoreForServer');

    var privateKeystoreSelectObjValue = privateKeystoreSelectObj[privateKeystoreSelectObj.selectedIndex].value;

    if ((certificateStoresCheckboxObj == null) || (privateKeystoreSelectObj == null)) {
        wso2.wsf.Util.alertWarning("Either trusted certificate stores or private keystores not available ");
    }
    var trustedCertStores = "";
    var certificateStoresCheckboxObjLength = certificateStoresCheckboxObj.length;
    var isCertificateStoresCheckboxObj = false;
    for (var i = 0; i < certificateStoresCheckboxObjLength; i++) {
        if (certificateStoresCheckboxObj[i].checked) {
            trustedCertStores +=
            '<trustedCertStores>' + certificateStoresCheckboxObj[i].value +
            '</trustedCertStores>\n';
            isCertificateStoresCheckboxObj = true;
        }
    }

    if (!isCertificateStoresCheckboxObj) {
        wso2.wsf.Util.alertMessage("Please select at least one Trusted Certificate Store");
        return false;
    }

    var body_xml = '<ns1:assignKeyStores xmlns:ns1="http://org.apache.axis2/xsd">\n' +
                   '<serviceName>' + getServiceSpecificName() + '</serviceName>\n' +
                   '<scenarioId>' + getScenarioIdForWS() + '</scenarioId>\n' +
                   trustedCertStores +
                   '<privateKeyStore>' + privateKeystoreSelectObjValue + '</privateKeyStore>\n' +
                   '</ns1:assignKeyStores>\n';

    var callURL = serverURL + "/" + SECURITY_SCENARIO_CONFIG_ADMIN ;
    new wso2.wsf.WSRequest(callURL, "assignKeyStores", body_xml, assignKeyStoresCallback);

}

function assignKeyStoresCallback() {

    wso2.wsf.Util.alertMessage("Security scenario successfully applied");
    showSecurityConfigurationInfo();
}

/* =========== keystoreRelated ends ================= */


/* =========== UtKeystoreRelated starts ============= */

utkeystoreRelated =
function(rootElementName, divObjectName, scenarioXsl, startingFunction, paramArray) {
    rampartScenarioInitiator(rootElementName, divObjectName, scenarioXsl, startingFunction, paramArray);
}

function utkeystoreRelatedStart() {
    var body_xml = '<req:getUtKeystoreSecurityAssignment xmlns:req="http://org.apache.axis2/xsd">\n' +
                   '<serviceName>' + getServiceSpecificName() + '</serviceName>\n' +
                   '</req:getUtKeystoreSecurityAssignment>\n';

    var callURL = serverURL + "/" + SECURITY_SCENARIO_CONFIG_ADMIN ;
    new wso2.wsf.WSRequest(callURL, "urn:getUtKeystoreSecurityAssignment", body_xml, utkeystoreRelatedStartCallback);
}

function utkeystoreRelatedStartCallback() {
    rampartSpecificTransformationWithoutHistory(this.req.responseXML, "scenario3.xsl", document.getElementById("divAvailableUtKeystoreInternal"));
    showlistServiceUsersHeader(document.getElementById('genericScenarioHeader'));
    document.getElementById('divButtonRawForGenericScenario').style.display = "inline";
}

function assignUsersAndRolesAndKeystores() {
    var usersObjects = document.getElementsByName('assignUserToServiceName');
    var rolesObjects = document.getElementsByName('assignRoleToServiceName');

    var users = "";
    var roles = "";
    var usersChecked = false;
    var rolesChecked = false;

    for (var i = 0; i < usersObjects.length; i++) {
        if (usersObjects[i].checked) {
            users +=
            '<users><![CDATA[' + usersObjects[i].value +
            ']]></users>';
            usersChecked = true;
        }
    }

    for (var i = 0; i < rolesObjects.length; i++) {
        if (rolesObjects[i].checked) {
            roles +=
            '<roles><![CDATA[' + rolesObjects[i].value +
            ']]></roles>';
            rolesChecked = true;
        }
    }

    if (!usersChecked && !rolesChecked) {
        wso2.wsf.Util.alertMessage("Please select at least one user or a role");
        return false;
    }
    if (usersChecked && !rolesChecked) {
        roles = "<roles nillable=\"true\"></roles>";

    }
    if (!usersChecked && rolesChecked) {
        users = "<users nillable=\"true\"></users>";
    }

    var certificateStoresCheckboxObj = document.getElementsByName('trustedCertificateStoreNames');
    var privateKeystoreSelectObj = document.getElementById('privateKeystoreForServer');

    var privateKeystoreSelectObjValue = privateKeystoreSelectObj[privateKeystoreSelectObj.selectedIndex].value;

    if ((certificateStoresCheckboxObj == null) || (privateKeystoreSelectObj == null)) {
        wso2.wsf.Util.alertWarning("Either trusted certificate stores or private keystores not available ");
    }
    var trustedCertStores = "";
    var certificateStoresCheckboxObjLength = certificateStoresCheckboxObj.length;
    var isCertificateStoresCheckboxObj = false;
    for (var i = 0; i < certificateStoresCheckboxObjLength; i++) {
        if (certificateStoresCheckboxObj[i].checked) {
            trustedCertStores +=
            '<trustedCertStores>' + certificateStoresCheckboxObj[i].value +
            '</trustedCertStores>\n';
            isCertificateStoresCheckboxObj = true;
        }
    }

    if (!isCertificateStoresCheckboxObj) {
        wso2.wsf.Util.alertMessage("Please select at least one Trusted Certificate Store");
        return false;
    }

    var body_xml = '<ns1:assignUsersAndRolesAndKeyStores xmlns:ns1="http://org.apache.axis2/xsd">\n' +
                   '<serviceName>' + getServiceSpecificName() + '</serviceName>\n' +
                   '<serviceVersion></serviceVersion>\n' + 
                   '<scenarioId>' + getScenarioIdForWS() + '</scenarioId>\n' +
                   trustedCertStores +
                   '<privateKeyStore>' + privateKeystoreSelectObjValue + '</privateKeyStore>\n' +
                   users +
                   roles +
                   '</ns1:assignUsersAndRolesAndKeyStores>\n';

    var callURL = serverURL + "/" + SECURITY_SCENARIO_CONFIG_ADMIN ;
    new wso2.wsf.WSRequest(callURL, "urn:assignUsersAndRolesAndKeyStores", body_xml, assignKeyStoresCallback);
}

/* =========== UtKeystoreRelated ends =============== */

/* ============= disableSecurity ============== */
DisableSecurity = function() {
    var body_xml = '<ns1:disableSecurity xmlns:ns1="http://org.apache.axis2/xsd">\n' +
                   '<serviceName>' + getServiceSpecificName() + '</serviceName>' +
                   '</ns1:disableSecurity>';

    var callURL = serverURL + "/" + SECURITY_SCENARIO_CONFIG_ADMIN ;
    new wso2.wsf.WSRequest(callURL, "disableSecurity", body_xml, DisableSecurityCallback);
}

function DisableSecurityCallback() {

    wso2.wsf.Util.alertMessage("Security has been disabled for service [" +
                               getServiceSpecificName() + "]");
    showSecurityConfigurationInfo();
}

function rampartBackButton() {
    showSecurityConfigurationInfo();
}


/*
This file is solely dedicated to hold breadcrumbs.
Most of the methods linked with xslts.
*/

////////////// Services ////////////////

function showWizardUpdate(updateDiv){
  var _text="<h4><a href='#' onClick='javascript:showServiceInitializer(); return false;'>Services</a>&nbsp;&gt;&nbsp;Service Archive Generation </h4>";
  updateDiv.innerHTML=_text;
}

function showlistFaultyServices(_updateDiv) {
    var _text = "<h4><a href='#' onClick='javascript:showServiceInitializer(); return false;'>Services</a>&nbsp;&gt;&nbsp;Faulty Services</h4>";
    _updateDiv.innerHTML = _text;
}

///////////// Modules //////////////////

function showconfigureModuleHeader(_updateDiv) {
    var _text = "<h4><a href=\"#\" onClick=\"javascript:listModules(); return false;\">Modules</a>&nbsp;&gt;&nbsp;" +
                "<a href=\"#\" onClick=\"javascript:getModuleInfo('"+ getLastUsedModuleId() +"','"+getLastUsedModuleVersion()+"'); return false;\">"+ getLastUsedModuleId() + "</a>&nbsp;&gt;&nbsp;"+
                                           "Parameters</h4>";
    _updateDiv.innerHTML = _text;
}

function showgetModuleParameterHeader(_updateDiv) {
    var _text = "<h4 id='pageHeader'><a href=\"#\" onClick=\"javascript:listModules(); return false;\">Modules</a>&nbsp;&gt;&nbsp;" +
                                           "Module Information for "+ getLastUsedModuleId() + "</h4>";
    _updateDiv.innerHTML = _text;
}

function showSandeshaModuleHeader(_updateDiv) {
    var _text = "<h4><a href=\"#\" onClick=\"javascript:listModules(); return false;\">Modules</a>&nbsp;&gt;&nbsp;" +
                "<a href=\"#\" onClick=\"javascript:getModuleInfo('"+ getLastUsedModuleId() +"','"+getLastUsedModuleVersion()+"'); return false;\">"+ getLastUsedModuleId() + "</a>&nbsp;&gt;&nbsp;"+
                                           "Sandesha2 Runtime Information</h4>";
    _updateDiv.innerHTML = _text;

}

/////////// Dynamic Client /////////////

function showdynamicClientMetaInfo(_updateDiv) {
    var _text = "<h4><a href=\"#\" onClick=\"javascript:showServiceInitializer(); return false;\">Services</a>&nbsp;&gt;&nbsp;" +
                                   "<a href=\"#\" onClick=\"javascript:listServiceData('"+ getServiceSpecificName() +"'); return false;\">"+ getServiceSpecificName() + "</a>&nbsp;&gt;&nbsp;" + "Select Port" +"</h4>";
    _updateDiv.innerHTML = _text;
}

///////// Operations //////////////////

function showlistOperationParamEditHeader(_updateDiv) {
    var _text = "<h4><a href=\"#\" onClick=\"javascript:showServiceInitializer(); return false;\">Services</a>&nbsp;&gt;&nbsp;" +
                                   "<a href=\"#\" onClick=\"javascript:listServiceData('"+ getServiceSpecificName() +"'); return false;\">"+ getServiceSpecificName() + "</a>&nbsp;&gt;&nbsp;" +
                                   "<a href=\"#\" onClick=\"javascript:listAllOperations('"+ getServiceSpecificName() +"'); return false;\">Operation&nbsp;["+ getServiceOperationParameters() +"]&nbsp;</a>&nbsp;&gt;&nbsp;" + "Parameters" +"</h4>";
    _updateDiv.innerHTML = _text;
}

function showlistOperationParamAndStatisticsEditHeader(_updateDiv) {
    var _text = "<h4><a href=\"#\" onClick=\"javascript:showServiceInitializer(); return false;\">Services</a>&nbsp;&gt;&nbsp;" +
                                   "<a href=\"#\" onClick=\"javascript:listServiceData('"+ getServiceSpecificName() +"'); return false;\">"+ getServiceSpecificName() + "</a>&nbsp;&gt;&nbsp;" +
                                   "<a href=\"#\" onClick=\"javascript:listAllOperations('"+ getServiceSpecificName() +"'); return false;\">Operation&nbsp;["+ getServiceOperationParameters() +"]&nbsp;</a>&nbsp;&gt;&nbsp;" + "Operation Statistics &amp; Parameters  " +"</h4><p>&nbsp;</p>";
    _updateDiv.innerHTML = _text;
}

function showlistOperationsHeader(_updateDiv) {
    var _text = "<h4><a href=\"#\" onClick=\"javascript:showServiceInitializer(); return false;\">Services</a>&nbsp;&gt;&nbsp;" +
                                           "<a href=\"#\" onClick=\"javascript:listServiceData('"+ getServiceSpecificName() +"'); return false;\">"+ getServiceSpecificName() + "</a>&nbsp;&gt;&nbsp;" +"Operations" +"</h4>";
    _updateDiv.innerHTML = _text;
}

/////////// Parameters ////////////////

function showlistServiceGroupParamHeader(_updateDiv) {
    var _text = "<h4><a href=\"#\" onClick=\"javascript:showServiceInitializer(); return false;\">Services</a>&nbsp;&gt;&nbsp;" +"<a href=\"#\" onClick=\"javascript:showServiceGroupInfo('"+moduleServiceGroupName+"'); return false;\">ServiceGroup["+moduleServiceGroupName+"]</a>&nbsp;&gt;&nbsp;" +"Parameters</h4>";
    _updateDiv.innerHTML = _text;
}

function showlistServiceLevelParamHeader(_updateDiv) {
    var _text = "<h4><a href=\"#\" onClick=\"javascript:showServiceInitializer(); return false;\">Services</a>&nbsp;&gt;&nbsp;" +
								   "<a href=\"#\" onClick=\"javascript:listServiceData('"+ getServiceSpecificName() +"'); return false;\">"+ getServiceSpecificName() + "</a>&nbsp;&gt;&nbsp;" +
								   "Parameters" +"</h4>";
    _updateDiv.innerHTML = _text;
}

function showlistServiceParamHeader(_updateDiv) {
    var _text = "<h4><a href='#' onClick='javascript:showServiceInitializer(); return false;'>Services</a>&nbsp;&gt;&nbsp;" +
								   "<a href='#' onClick='javascript:listServiceData(\"" + getServiceSpecificName() +"\"); return false;'>" + getServiceSpecificName() + "</a>&nbsp;&gt;&nbsp;" +
								   "<a href='#' onClick='javascript:listAllOperations(\""+ getServiceSpecificName() +"\"); return false;'>Operation&nbsp;["+ getServiceOperationParameters() +"]&nbsp;</a>&nbsp;&gt;&nbsp;Parameters</h4>";
    _updateDiv.innerHTML = _text;
}

function showlistServiceParamEditHeader(_updateDiv) {
    var _text = "<h4><a href=\"#\" onClick=\"javascript:showServiceInitializer(); return false;\">Services</a>&nbsp;&gt;&nbsp;" +
                                   "<a href=\"#\" onClick=\"javascript:listServiceData('"+ getServiceSpecificName() +"'); return false;\">"+ getServiceSpecificName() + "</a>&nbsp;&gt;&nbsp;" + "Parameters" +"</h4>";
    _updateDiv.innerHTML = _text;
}

function showSTSHeader(_updateDiv) {
    var _text = "<h4><a href=\"#\" onClick=\"javascript:showServiceInitializer(); return false;\">Services</a>&nbsp;&gt;&nbsp;" +
                                   "<a href=\"#\" onClick=\"javascript:listServiceData('"+ getServiceSpecificName() +"'); return false;\">"+ getServiceSpecificName() + "</a>&nbsp;&gt;&nbsp;" + "STS Configuration" +"</h4>";
    _updateDiv.innerHTML = _text;
}

//////////// Policy Information ////////////

function showlistPolicyInfoEditHeader(_updateDiv) {
    var _text = "<h4><a href=\"#\" onClick=\"javascript:showServiceInitializer(); return false;\">Services</a>&nbsp;&gt;&nbsp;" +
                                   "<a href=\"#\" onClick=\"javascript:listServiceData('"+ getServiceSpecificName() +"'); return false;\">"+ getServiceSpecificName() + "</a>&nbsp;&gt;&nbsp;" + "Policy Info" +"</h4>";
    _updateDiv.innerHTML = _text;
}

function showlistPolicyModuleHeader(_updateDiv) {
    
    var _text = "<h4><a href=\"#\" onClick=\"javascript:listModules(); return false;\">Modules</a>&nbsp;&gt;&nbsp;" +
                "<a href=\"#\" onClick=\"javascript:getModuleInfo('"+ getLastUsedModuleId() +"','"+getLastUsedModuleVersion()+"'); return false;\">"+ getLastUsedModuleId() + "</a>&nbsp;&gt;&nbsp;"+
                                            "Module Policy</h4>";
    _updateDiv.innerHTML = _text;
}

/////////// Users and Roles ////////////////

function showlistServiceUsersHeader(_updateDiv) {
    var _text = "<h4><a href='#' onClick='javascript:showServiceInitializer(); return false;'>Services</a>&nbsp;&gt;&nbsp;" +
								   "<a href='#' onClick='javascript:listServiceData(\"" + getServiceSpecificName() +"\"); return false;'>"+ getServiceSpecificName() + "</a>&nbsp;&gt;&nbsp;" +
								   "<a href='#' onClick='javascript:showSecurityConfigurationInfo(); return false;'>Security Configuration</a>&nbsp;&gt;&nbsp;"+getScenarioId()+"</h4>";
    _updateDiv.innerHTML = _text;
}

/////////// Stubs /////////////

function showstubGenMetaInfo(_updateDiv) {
    var _text = "<h4><a href=\"#\" onClick=\"javascript:showServiceInitializer(); return false;\">Services</a>&nbsp;&gt;&nbsp;" +
                                   "<a href=\"#\" onClick=\"javascript:listServiceData('"+ getServiceSpecificName() +"'); return false;\">"+ getServiceSpecificName() + "</a>&nbsp;&gt;&nbsp;" + "Stub Generation" +"</h4>";
    _updateDiv.innerHTML = _text;
}

function showtryItDiv(_updateDiv) {
    var _text = "<h4><a href=\"#\" onClick=\"javascript:showServiceInitializer(); return false;\">Services</a>&nbsp;&gt;&nbsp;" +
                                           "<a href=\"#\" onClick=\"javascript:listServiceData('"+ getServiceSpecificName() +"'); return false;\">"+ getServiceSpecificName() + "</a>&nbsp;&gt;&nbsp;" +"Try Web Service" +"</h4>";
    _updateDiv.innerHTML = _text;
}

function showListTransportDiv(_updateDiv) {
    var _text = "<h4><a href='#' onClick='javascript:showServiceInitializer(); return false;'>Services</a>&nbsp;&gt;&nbsp;<a href='#' onClick='javascript:listServiceData(\"" + getServiceSpecificName() + "\"); return false;'>" + getServiceSpecificName() + "</a>" + "&nbsp;&gt;&nbsp;Transport Configuration" + "</h4>";
    _updateDiv.innerHTML = _text;

}

/////////// Timestamp /////////

function showTimeStampDiv(_updateDiv) {
    var _text = "<h4><a href='#' onClick='javascript:showServiceInitializer(); return false;'>Services</a>&nbsp;&gt;&nbsp;" +
                "<a href='#' onClick='javascript:listServiceData(\""+getServiceSpecificName()+"\"); return false;'>"+getServiceSpecificName()+"</a>" + "&nbsp;&gt;&nbsp;"+
                "<a href='#' onClick='javascript:showSecurityConfigurationInfo(); return false;'>Security Configuration</a>&nbsp;&gt;&nbsp;Timestamp</h4>";
    _updateDiv.innerHTML = _text;
}

///////// Rampart ////////////

function showConfigurationSecenarios(_updateDiv) {
    var _text = "<h4><a href='#' onClick='javascript:showServiceInitializer(); return false;'>Services</a>&nbsp;&gt;&nbsp;" +
                "<a href='#' onClick='javascript:listServiceData(\""+getServiceSpecificName()+"\"); return false;'>"+getServiceSpecificName()+"</a>" + "&nbsp;&gt;&nbsp;Security Configuration</h4>" +
                "<h2>Security Configuration&nbsp;</h2>";
    _updateDiv.innerHTML = _text;
}



///// Data Service //////

var newDataServiceMenuMessage = "This service is still not saved, hense this menu item is not available.";
function showDataServiceHeader(_updateDiv, stepIndex) {

    var step = "";
    if(stepIndex != null) {
        step = " - Step " + (parseInt(stepIndex) + 1) + ":";
    }
    
    var _text = "<h4><a href=\"#\" onClick=\"javascript:showServiceInitializer(); return false;\">Services</a>&nbsp;&gt;&nbsp;" +
                                           "<a href=\"#\" onClick=\"javascript:";
                                           if (!newDataService) {
                                           		_text += "listServiceData('"+ getServiceSpecificName() +"')";
                                           } else {
                                           		_text += "wso2.wsf.Util.alertInternal('" + newDataServiceMenuMessage + "', INFORMATION_MESSAGE)";
                                           }
                                           _text += "; return false;\">"+ getServiceSpecificName() + "</a>&nbsp;&gt;&nbsp;" + step + " Configure Data Service </h4>";

    _updateDiv.innerHTML = _text;
}

//TODO : note take this as given
function showNewDataServiceHeader(stepIndex) {
    var step = "";
    if(stepIndex != null) {
        step = " Step " + (parseInt(stepIndex) + 1) + ":";
    }
    return "<a href=\"#\" onClick=\"javascript:showServiceInitializer(); " +
                           "return false;\">Services</a>&nbsp;&gt;&nbsp;"+ step +" New Data Service";
}

function showDataServiceOperationsHeader(_updateDiv) {
    var _text = "<h4><a href=\"#\" onClick=\"javascript:showServiceInitializer(); return false;\">Services</a>&nbsp;&gt;&nbsp;" +
                                           "<a href=\"#\" onClick=\"javascript:";
                                           if (!newDataService) {
                                           		_text += "listServiceData('"+ getServiceSpecificName() +"')";
                                           } else {
                                           		_text += "wso2.wsf.Util.alertInternal('" + newDataServiceMenuMessage + "', INFORMATION_MESSAGE)";
                                           }
                                           _text += " return false;\">"+ getServiceSpecificName() + "</a>&nbsp;&gt;&nbsp;" +
                                           
                                           "<a href=\"#\" onClick=\"javascript:refreshDataServiceScreen(); return false;\">Configure Data Service</a>&nbsp;&gt;&nbsp;" +"Add Operation" +"</h4>";
    _updateDiv.innerHTML = _text;
}

function showDataServiceQueryHeader(_updateDiv) {
    var _text = "<h4><a href=\"#\" onClick=\"javascript:showServiceInitializer(); return false;\">Services</a>&nbsp;&gt;&nbsp;" +
                                           "<a href=\"#\" onClick=\"javascript:";
                                           if (!newDataService) {
                                           		_text += "listServiceData('"+ getServiceSpecificName() +"')";
                                           } else {
                                           		_text += "wso2.wsf.Util.alertInternal('" + newDataServiceMenuMessage + "', INFORMATION_MESSAGE)";
                                           }
                                           _text += "; return false;\">"+ getServiceSpecificName() + "</a>&nbsp;&gt;&nbsp;" +
                                           "<a href=\"#\" onClick=\"javascript:refreshDataServiceScreen(); return false;\">Configure Data Service</a>&nbsp;&gt;&nbsp;" +"Service Query" +"</h4>";
    _updateDiv.innerHTML = _text;
}

function showGeneratedConfigHeader(_updateDiv) {
    var _text = "<h4><a href=\"#\" onClick=\"javascript:showServiceInitializer(); return false;\">Services</a>&nbsp;&gt;&nbsp;" +
                                           "<a href=\"#\" onClick=\"javascript:";
                                           if (!newDataService) {
                                           		_text += "listServiceData('"+ getServiceSpecificName() +"')";
                                           } else {
                                           		_text += "wso2.wsf.Util.alertInternal('" + newDataServiceMenuMessage + "', INFORMATION_MESSAGE)";
                                           }
                                           _text +="; return false;\">"+ getServiceSpecificName() + "</a>&nbsp;&gt;&nbsp;" +
                                           "<a href=\"#\" onClick=\"javascript:refreshDataServiceScreen(); return false;\">Configure Data Service</a>&nbsp;&gt;&nbsp;" +"Review and Save" +"</h4>";
    _updateDiv.innerHTML = _text;
}

function showDataServiceOutputMappingHeader(_updateDiv) {
    var _text = "<h4><a href=\"#\" onClick=\"javascript:showServiceInitializer(); return false;\">Services</a>&nbsp;&gt;&nbsp;" +
                                           "<a href=\"#\" onClick=\"javascript:";
										   if (!newDataService) {
                                           		_text += "listServiceData('"+ getServiceSpecificName() +"')";
                                           } else {
                                           		_text += "wso2.wsf.Util.alertInternal('" + newDataServiceMenuMessage + "', INFORMATION_MESSAGE)";
                                           }
                                           _text += "; return false;\">"+ getServiceSpecificName() + "</a>&nbsp;&gt;&nbsp;" +
                                           "<a href=\"#\" onClick=\"javascript:refreshDataServiceScreen(); return false;\">Configure Data Service</a>&nbsp;&gt;&nbsp;" +"Add Output Mapping" +"</h4>";
    _updateDiv.innerHTML = _text;
}
var ejbProviderConfigObject = '';
var existingAppServerConfigs = 0;

function addApplicationServer(){
	var serverType = document.getElementById('serverType').value;
	var providerURL = document.getElementById('providerUrl').value;
	var jndiContextClass = document.getElementById('jndiContextClass').value;
	var jndiUserName = document.getElementById('userName').value;
	var password = document.getElementById('password').value;
	var confirmPassword = document.getElementById('confirmPassword').value;
		
	if(checkForExistingAppServerConfigurations(providerURL)){
		if(serverType == null || wso2.wsf.Util.trim(serverType) == ""){
	        wso2.wsf.Util.alertWarning("Please select an Application Server type.");
    	    return false;
    	}
	
		if(providerURL == null || wso2.wsf.Util.trim(providerURL) == ""){
	        wso2.wsf.Util.alertWarning("Please enter a valid provider url.");
        	return false;
    	}
		if(jndiContextClass == null || wso2.wsf.Util.trim(jndiContextClass) == ""){
	        wso2.wsf.Util.alertWarning("Please enter a valid JNDI Context class.");
    	    return false;
    	}
		if(password != null && wso2.wsf.Util.trim(password) != ""){
			if(jndiUserName == null || wso2.wsf.Util.trim(jndiUserName) == ""){
		        wso2.wsf.Util.alertWarning("Please enter username for the password provided.");
    	    	return false;			
			}		
			if(password != confirmPassword){
		        wso2.wsf.Util.alertWarning("Password and re-entered password do not match.");
    	    	return false;
			}
    	}	
	
		var ejbAppServer_xml = '';
    	ejbAppServer_xml +=
    		' <req:providerUrl>' + providerURL + '</req:providerUrl>\n';
    	ejbAppServer_xml +=
    		' <req:jndiContextClass>' + jndiContextClass +
    		'</req:jndiContextClass>\n';
    	ejbAppServer_xml +=
    		' <req:userName>' + jndiUserName + '</req:userName>\n';
    	ejbAppServer_xml +=
    		' <req:password>' + password + '</req:password>\n';
    	ejbAppServer_xml +=
    		' <req:appServerType>' + serverType + '</req:appServerType>\n';
	
		var body_xml = '<req:addApplicationServerRequest xmlns:req="http://org.apache.axis2/xsd">\n' +
   				  ejbAppServer_xml +
                  ' </req:addApplicationServerRequest>\n';

    	var callURL = serverURL + "/" + "EJBProviderAdmin" + "/" ;	
	    new wso2.wsf.WSRequest(callURL,"addApplicationServer",body_xml,ejbProviderConfigCallback);	
	}
}

function checkForExistingAppServerConfigurations(providerURL){
    var combo = document.getElementById('existingAppServerConfigurations');
    var count;
    for (count = 0; count < combo.length; count++) {
		if(providerURL == combo.options[count].value){
			wso2.wsf.Util.alertWarning("Configuration exists for provider URL "+combo.options[count].value +
			". Please select it from existing configuration section.");
			combo.selectedIndex = count;
			document.getElementById('existingAppServerConfigurations').disabled = false;
			//document.getElementById('appServerConfiguration1').checked = true;
			//document.getElementById('appServerConfiguration2').checked = false;			
			return false;
		}         
    }
	return true;
}

function addApplicationServerElement(){
    var combo = document.getElementById('existingAppServerConfigurations');
	if(combo.length == 0){
		wso2.wsf.Util.alertWarning("No existing configurations found.Please add Application " +
			"Server before continuing.");
		return false;
	}
	
	//This is the first reference to this variable.
	//Reinitialize
    ejbProviderConfigObject = '';
	var obj = document.getElementById('existingAppServerConfigurations');
    ejbProviderConfigObject +=
    ' <req:providerUrl>' + obj[obj.selectedIndex].value + '</req:providerUrl>\n';
	
    showEJBServiceWizardStep1();
}

function addEJBDetailsElement(){
    //var classes = document.getElementsByName("chkClasses");
    var selectedClasses = '';
    //var isClassSelected = false;
    //for (var i = 0; i < classes.length; i++) {
    //    if (classes[i].checked) {
    //        isClassSelected = true;
    //        selectedClasses += ' <req:serviceClasses>' + classes[i].value + '</req:serviceClasses>\n';
    //    }
    //}
	
	var remoteInterfaceClass = '';
	var homeInterfaceClass = '';
	var beanJNDIName = document.getElementById('beanJNDIName').value;
	
    var remoteInterfaces = document.getElementsByName("chkRemoteInterface");
	for (var a = 0; a < remoteInterfaces.length; a++){
		if(remoteInterfaces[a].checked){
			remoteInterfaceClass = remoteInterfaces[a].value;
		}
	}
	selectedClasses += ' <req:serviceClasses>' + remoteInterfaceClass + '</req:serviceClasses>\n';

    var homeInterfaces = document.getElementsByName("chkHomeInterface");
	for (var a = 0; a < homeInterfaces.length; a++){
		if(homeInterfaces[a].checked){
			homeInterfaceClass = homeInterfaces[a].value;
		}
	}

	//validation
	if(homeInterfaceClass == null || wso2.wsf.Util.trim(homeInterfaceClass) == ""){
        wso2.wsf.Util.alertWarning("Please enter Home Interface class.");
   	    return false;
   	}
	if(remoteInterfaceClass == null || wso2.wsf.Util.trim(remoteInterfaceClass) == ""){
        wso2.wsf.Util.alertWarning("Please enter Remote Interface class.");
   	    return false;
   	} 	
	if(beanJNDIName == null || wso2.wsf.Util.trim(beanJNDIName) == ""){
        wso2.wsf.Util.alertWarning("Please enter JNDI name of EJB.");
   	    return false;
   	}
	
	//selected classes should come first	
	ejbProviderConfigObject = selectedClasses + ejbProviderConfigObject;
    ejbProviderConfigObject +=
    ' <req:beanJNDIName>' + beanJNDIName + '</req:beanJNDIName>\n';
    ejbProviderConfigObject += ' <req:homeInterface>' + document.getElementById('homeInterface').value +
                        '</req:homeInterface>\n';
    ejbProviderConfigObject +=
    ' <req:remoteInterface>' + document.getElementById('remoteInterface').value +
    '</req:remoteInterface>\n';
	
	generateAARForSelectedEJBRemoteInterface();
    //showEJBServiceWizardStep3();
}

//function addServiceGroupDetailsElementAndDeploy(){
//    ejbProviderConfigObject += ' <req:serviceGroupId>' + document.getElementById('serviceGroupId').value +
//                        '</req:serviceGroupId>\n';
//    ejbProviderConfigObject +=
//    ' <req:addNewServiceGroup>' + document.getElementById('addNewServiceGroup').value +
//    '</req:addNewServiceGroup>\n';
//    generateAARForSelectedEJBRemoteInterface();
//}



//functions for ejb provider archive reader
function generateAARForSelectedEJBRemoteInterface() {
    var body_xml = '<req:createAndDeployEJBServiceRequest xmlns:req="http://org.apache.axis2/xsd">\n' +
                   '<req:archiveId>' + genFileKey + '</req:archiveId>\n' +
                   ejbProviderConfigObject +
                   '</req:createAndDeployEJBServiceRequest>\n';

    var callURL = serverURL + "/" + "ServiceAdmin" ;
    new wso2.wsf.WSRequest(callURL,"createAndDeployEJBService",body_xml,completeAARGenerationCB);
}



function deleteEJBConfiguration(beanJNDIName, jnpProviderUrl) {
    beanJNDIName = beanJNDIName.replace(/\xA7/g,"'");
    jnpProviderUrl = jnpProviderUrl.replace(/\xA7/g,"'");

    var deleteIt= confirm("Do you really want to delete EJB configuration for "+ beanJNDIName +"@" + jnpProviderUrl +"?");
    if (deleteIt) {
        var body_xml = '<req:deleteEJBConfigurationRequest xmlns:req="http://org.apache.axis2/xsd">\n' +
                       '<req:beanJNDIName>' + beanJNDIName + '</req:beanJNDIName>\n'+
                       '<req:jnpProviderUrl>' + jnpProviderUrl + '</req:jnpProviderUrl>\n'+
                       '</req:deleteEJBConfigurationRequest>\n';
	
	var xsltFileName = "ejb_provider_service.xsl";

        var callURL = serverURL + "/" + "EJBProviderAdmin" + "/" ;
        new wso2.wsf.WSRequest(callURL,"deleteEJBConfiguration",body_xml,ejbProviderConfigCallback);
    }
}


function ejbProviderConfigCallback() {
    ejbProviderConfig();
}


// loading service groups for combo
function loadServiceGroupsComboBox() {
    var body_xml = '<ns1:listServiceGroups  xmlns:ns1="http://org.apache.axis2/xsd">\n' +
                   ' </ns1:listServiceGroups>\n';

    var callURL = serverURL + "/" + SERVICE_GROUP_ADMIN_STRING + "/" + "listServiceGroups";
    new wso2.wsf.WSRequest(callURL,"listServiceGroups",body_xml,loadServiceGroupListCallback);

}



//load service group list callback.
function loadServiceGroupListCallback() {
    var comboToLoad = document.getElementById('serviceGroupSelectBox');
    var data = this.req.responseXML;
    var rets = data.getElementsByTagName("return");
    var len = rets.length;
    var count;

    for (count = 0; count < len; count++) {
        comboToLoad.options[count] = new Option(rets[count].getElementsByTagName("group_id").item(0).firstChild.nodeValue);
        comboToLoad.options[count].value = rets[count].getElementsByTagName("group_id").item(0).firstChild.nodeValue;
    }
    comboToLoad.options[count] = new Option('');
    comboToLoad.options[count].value = '';
    comboToLoad.selectedIndex = count;
}



function loadAppServersComboBox() {
    var body_xml = '<ns1:loadAppServersComboBox  xmlns:ns1="http://org.apache.axis2/xsd">\n' +
                   ' </ns1:loadAppServersComboBox>\n';

    var callURL = serverURL + "/" + "EJBProviderAdmin" + "/" ;
    new wso2.wsf.WSRequest(callURL,"getAppServerNameList",body_xml,loadAppServerListCallback);
}

function loadExistingAppServerConfigComboBox() {
    var body_xml = '<ns1:getEJBAppServerConfigurationsRequest  xmlns:ns1="http://org.apache.axis2/xsd">\n' +
                   ' </ns1:getEJBAppServerConfigurationsRequest>\n';

    var callURL = serverURL + "/" + "EJBProviderAdmin" + "/" ;
    //new wso2.wsf.WSRequest(callURL,"getEJBAppServerConfigurations",body_xml,loadAppServerConfigurationListCallback);
	new wso2.wsf.WSRequest(callURL,"getEJBAppServerConfigurations",body_xml,loadAppServerConfigurationListCallback);
}


function loadAppServerConfigurationListCallback() {
    var comboToLoad = document.getElementById('existingAppServerConfigurations');
    var data = this.req.responseXML;
    var rets = data.getElementsByTagName("return");
    var len = rets.length;
    var count;
    for (count = 0; count < len; count++) {
        comboToLoad.options[count] = new Option(rets[count].getElementsByTagName("appServerType").item(0).firstChild.nodeValue + ' - '+
													rets[count].getElementsByTagName("providerURL").item(0).firstChild.nodeValue);
													
        comboToLoad.options[count].value = rets[count].getElementsByTagName("providerURL").item(0).firstChild.nodeValue;
    }
    existingAppServerConfigs = comboToLoad.length;
    ejbProviderStep1DisableFields();
}




//load ejb application server list callback.
function loadAppServerListCallback() {
    var comboToLoad = document.getElementById('serverType');
    var data = this.req.responseXML;
    var rets = data.getElementsByTagName("return");
    var len = rets.length;
    var count;

    for (count = 0; count < len; count++) {
        comboToLoad.options[count] = new Option(rets[count].getElementsByTagName("serverName").item(0).firstChild.nodeValue);
        comboToLoad.options[count].value = rets[count].getElementsByTagName("serverId").item(0).firstChild.nodeValue;
    }
    comboToLoad.options[count] = new Option('--Application Server--');
    comboToLoad.options[count].value = '';
    comboToLoad.selectedIndex = count;
}



function setServiceGroupId(obj,document){
	var serviceGroupId = '';
	if( obj.name == 'serviceGroupSelectBox'){
		if(obj[obj.selectedIndex].value != ''){
			serviceGroupId = obj[obj.selectedIndex].value;
		}
	}else if( obj.name == 'newServiceGroupId'){
		serviceGroupId = obj.value;
		document.getElementById('serviceGroupSelectBox').value = '';
		document.getElementById('addNewServiceGroup').value = 'true';
	}
	document.getElementById('serviceGroupId').value = serviceGroupId;
}


function ejbProviderConfig() {
    var body_xml = '<req:getEJBConfigurationsRequest xmlns:req="http://org.apache.axis2/xsd">\n' +
                   ' </req:getEJBConfigurationsRequest>\n';

    var callURL = serverURL + "/" + "EJBProviderAdmin" + "/" ;
    new wso2.wsf.WSRequest(callURL,"getEJBConfigurations",body_xml,function(){
        wso2.wsf.Util.callbackhelper(this.req.responseXML,"ejb_provider_service.xsl",document.getElementById("divEJBProvider"));
    });
}

function showEJBServiceWizardStep1() {
    var tmpTransformationNode;
    if (window.XMLHttpRequest && !wso2.wsf.Util.isIE()) {
        tmpTransformationNode =
        document.implementation.createDocument("", "ejbDetailsTemplate", null);
    } else if (window.ActiveXObject) {
        tmpTransformationNode = new ActiveXObject("Microsoft.XmlDom");
        var sXml = "<ejbDetailsTemplate></ejbDetailsTemplate>";
        tmpTransformationNode.loadXML(sXml);
    }
    var objDiv = document.getElementById("divEJBProvider_step1");
    wso2.wsf.Util.processXML(tmpTransformationNode, "ejb_provider_wizard_step1.xsl", objDiv);
    wso2.wsf.Util.showOnlyOneMain(objDiv);
}


function showEJBServiceWizardStep2() {
    var tmpTransformationNode;
    if (window.XMLHttpRequest && !wso2.wsf.Util.isIE()) {
        tmpTransformationNode =
        document.implementation.createDocument("", "ejbDetailsTemplate", null);
    } else if (window.ActiveXObject) {
        tmpTransformationNode = new ActiveXObject("Microsoft.XmlDom");
        var sXml = "<ejbDetailsTemplate></ejbDetailsTemplate>";
        tmpTransformationNode.loadXML(sXml);
    }
    var objDiv = document.getElementById("divEJBProvider_step2");
    wso2.wsf.Util.processXML(tmpTransformationNode, "ejb_provider_wizard_step2.xsl", objDiv);
    wso2.wsf.Util.showOnlyOneMain(objDiv);
}

function showEJBServiceWizardStep3() {
    var tmpTransformationNode;
    if (window.XMLHttpRequest && !wso2.wsf.Util.isIE()) {
        tmpTransformationNode =
        document.implementation.createDocument("", "serviceGroupTemplate", null);
    } else if (window.ActiveXObject) {
        tmpTransformationNode = new ActiveXObject("Microsoft.XmlDom");
        var sXml = "<serviceGroupTemplate></serviceGroupTemplate>";
        tmpTransformationNode.loadXML(sXml);
    }
    var objDiv = document.getElementById("divEJBProvider_step3");
    wso2.wsf.Util.processXML(tmpTransformationNode, "ejb_provider_wizard_step3.xsl", objDiv);
    wso2.wsf.Util.showOnlyOneMain(objDiv);
}




function setDefaultServerValues(obj,document){
    	var selectedValue = obj[obj.selectedIndex].value;
	if(selectedValue == 'jboss'){
	    document.getElementById('providerUrl').value = 'jnp://localhost:1099';
	    document.getElementById('jndiContextClass').value = 'org.jnp.interfaces.NamingContextFactory';
	}else if (selectedValue == 'geronimo'){
	    document.getElementById('providerUrl').value = 'localhost:4201';
	    document.getElementById('jndiContextClass').value = 'org.openejb.client.JNDIContext';
	}else if (selectedValue == 'weblogic'){
	    document.getElementById('providerUrl').value = 't3://localhost:7001';
	    document.getElementById('jndiContextClass').value = 'weblogic.jndi.WLInitialContextFactory';
	}else{
	    document.getElementById('providerUrl').value = '';
	    document.getElementById('jndiContextClass').value = '';
	}
}

function toggleEJBAppServerConfigurationEditScreen(value){
	if(value == 'addNewEJBServer'){
		//disable existing
		document.getElementById('existingAppServerConfigurations').disabled = true;
		//enable add new
		document.getElementById('serverType').disabled = false;
		document.getElementById('providerUrl').disabled = false;
		document.getElementById('jndiContextClass').disabled = false;
		document.getElementById('userName').disabled = false;
		document.getElementById('password').disabled = false;
		document.getElementById('confirmPassword').disabled = false;
		document.getElementById('addApplicationServerButton').disabled = false;
		document.addEJBApplicationServerForm.appServerConfiguration1.checked = false;
		document.addEJBApplicationServerForm.appServerConfiguration2.checked = true;
		document.getElementById('ejbStep0NextButton').disabled = true;
	}else if (value == 'existingEJBServer'){
		//enable existing
		document.getElementById('existingAppServerConfigurations').disabled = false;
		//disable add new
		document.getElementById('serverType').disabled = true;
		document.getElementById('providerUrl').disabled = true;
		document.getElementById('jndiContextClass').disabled = true;
		document.getElementById('userName').disabled = true;
		document.getElementById('password').disabled = true;
		document.getElementById('confirmPassword').disabled = true;
		document.getElementById('addApplicationServerButton').disabled = true;
		document.addEJBApplicationServerForm.appServerConfiguration1.checked = true;
		document.addEJBApplicationServerForm.appServerConfiguration2.checked = false;
		if (existingAppServerConfigs > 0) {
			document.getElementById('ejbStep0NextButton').disabled = false;
		}
	}
}

function ejbProviderStep1DisableFields(){
	//disable all text/combo boxes at the screen load
	var radio2 = document.getElementById('appServerConfiguration2');
	if(existingAppServerConfigs != 0 && radio2.checked == false) {
		document.getElementById('serverType').disabled = true;
		document.getElementById('providerUrl').disabled = true;
		document.getElementById('jndiContextClass').disabled = true;
		document.getElementById('userName').disabled = true;
		document.getElementById('password').disabled = true;
		document.getElementById('confirmPassword').disabled = true;
		document.getElementById('addApplicationServerButton').disabled = true;
	
	} else if (existingAppServerConfigs != 0 && radio2.checked == true) {
		toggleEJBAppServerConfigurationEditScreen('existingEJBServer');
	} else if (existingAppServerConfigs == 0) {
		var radio = document.getElementById('appServerConfiguration1');
		radio.disabled=true;
		document.getElementById('existingAppServerConfigurations').disabled = true;
		if (existingAppServerConfigs == 0) {
			document.getElementById('ejbStep0NextButton').disabled = true;
		}
	} else if (radio2.checked == true) {
		document.getElementById('existingAppServerConfigurations').disabled = true;
	}
	
}

function setRemoteInterfaceClass(value){
	document.getElementById('remoteInterface').value = value;
}

function setHomeInterfaceClass(value){
	document.getElementById('homeInterface').value = value;
}/*
system.js is contains scripts to handle home, system
*/

var ADMIN_SERVER_URL = "ServerAdmin";
var SHOW_HOME_REFRESH_TIME = 6000;

var showDivHome = false;
var showDivHomeTimeout;
var showHomeInterval = 0;
var javaVersion;

function showHomeMenu(thisObj, index) {

    renderHomeMenuExplicitly();
    //Initial Firing
    if (showHomeInterval == 0) {
        showHome();
        showHomeInterval = setInterval('showHome()', SHOW_HOME_REFRESH_TIME);
    }
}

function showGeneralHome() {
    renderGeneralHomeMenueExplicitly();
    var divId = document.getElementById('divGeneralHome');
    if (divId) {
        wso2.wsf.Util.showOnlyOneMain(divId);
    }
}

function showHome() {

    var body_xml = ' <ns1:getStatus  xmlns:ns1="http://org.apache.axis2/xsd"/>\n';
    var callURL = serverURL + "/" + SERVER_ADMIN_STRING + "/" + "getStatus";

    if (document.getElementById("divHome").style.display == 'none' &&
        showDivHome) {
        showDivHome = false;
        clearInterval(showHomeInterval);
        showHomeInterval = 0;
        // this is to counter if focus to divHome is vanished.
        return false;

    }

    new wso2.wsf.WSRequest(callURL,"getStatus",body_xml,showHomeCallback);

}

function showHomeCallback() {
//    stopWaitAnimation();
    javaVersion = this.req.responseXML.getElementsByTagName("javaVersion")[0].firstChild.nodeValue;
    wso2.wsf.Util.callbackhelper(this.req.responseXML,"system_status.xsl", document.getElementById("divHome"));
    showDivHome = true;
    // tivially at this point divHome is inline
}

function manageSystem(thisObj, index) {

    if (thisObj && index) {
        renderSelectedMenuItem(thisObj,index);
        gatherHistoryObject(thisObj.id, index);
    }

    var body_xml = ' <ns1:getServerData xmlns:ns1="http://org.apache.axis2/xsd"/>\n';

    var callURL = serverURL + "/" + SERVER_ADMIN_STRING ;
    new wso2.wsf.WSRequest(callURL,"getServerData",body_xml,manageSystem["callback"]);

}

manageSystem["callback"] = function() {
    wso2.wsf.Util.callbackhelper(this.req.responseXML,"system_info.xsl",document.getElementById("divManageSystem"));
}

function saveServer() {
    var body_xml = '<req:saveRequest xmlns:req="http://org.apache.axis2/xsd"/>\n';

    var callURL = serverURL + "/" + ADMIN_SERVER_URL ;
    new wso2.wsf.WSRequest(callURL, "save", body_xml, function() {
        wso2.wsf.Util.alertMessage("Server state was saved successfuly");
    });
}

function storeCurMenu(thisObj, index) {
    if (thisObj && index) {
        renderSelectedMenuItem(thisObj,index);
        gatherHistoryObject(thisObj.id, index);
    }
}

function wsasPing() {
    var bodyXML = '<req:ping xmlns:req="http://org.apache.axis2/xsd"/>\n';
    var callURL = serverURL + "/" + "GlobalAdmin" ;
    var req = new WSRequest();
    var options = new Object();
    options["useBindng"] = "SOAP 1.1";
    options["action"] = "urn:ping";

    try {
        req.open(options, callURL, false);
        req.send(bodyXML);
        var response = req.responseText;
        if (!response){
            return false;
        }
        if (response.length == 0) {
            return false;
        }
        if (response.indexOf("true") > -1) {
            return true;
        }
    }catch(e) {
        return false;
    }

}/*
services.js is manipulate the service related scripts.
*/


/////////////////////////////////////////
// Globle variables services

var serviceSpecificName = "";
var lastUsedServiceId = "";
////////////////////////////////////////

////////////////////////////////////////
// Globle variable for operation


var serviceOperationParameters = "";
var OPERATION_ADMIN_SERVER_URL = "OperationAdmin";
var lastOperationUsed = "";

////////////////////////////////////////


////////////////////////////////////////
// Module Specific

var moduleSpanToUse = "";
var moduleComboName = "";

var setModuleVersion = "";
var setModuleName = "";
var MODULE_ADMIN_STRING = "ModuleAdmin";
var MODULE_ADMIN_SERVER_URL = "ModuleAdmin";
var setOperationName = "";
///////////////////////////////////////


//////////////////////////////////////
// Policy specific

var lastUsedServiceVersion = "";


////////////////////////////////////


//////////////////////////////////////////
// stub generation

var genFileKey = "";
var mainservicPortComboValue = "";
var mainServiceBindingName = "";

///////////////////////////////////////////

var defaultHttpPort;
var defaultBrowserHost;
var SERVICE_REFRESH_TIME = 10000;

// This holds thread's id, which is positive
var listServiceDataRequestInterval = 0;
var showListServiceDataDiv = false;

var listServiceGroupsRequestInterval = 0;
var showListServcieGroupDiv = false;
//////////////////////////////////////////

var operationNameForEngagedOperationHandlers;

// getters and setters

function getServiceSpecificName() {
    return serviceSpecificName;
}

function getServiceOperationParameters() {
    return serviceOperationParameters;
}


function listServiceGroups() {
    var body_xml = '<ns1:listServiceGroups  xmlns:ns1="http://org.apache.axis2/xsd">\n' +
                   ' </ns1:listServiceGroups>\n';

    var callURL = serverURL + "/" + SERVICE_GROUP_ADMIN_STRING + "/" + "listServiceGroups";

    if (document.getElementById("divListServiceGroups").style.display == 'none' &&
        showListServcieGroupDiv) {
        showListServcieGroupDiv = false;
        clearInterval(listServiceGroupsRequestInterval);
        listServiceGroupsRequestInterval = 0;
        // this is to counter if focus to divHome is vanished.
        return false;

    }
    new wso2.wsf.WSRequest(callURL, "listServiceGroups", body_xml, listServiceGroupsCallback);
}

function listServiceGroupsCallback() {
    showListServcieGroupDiv = true;
    //    wso2.wsf.Util.callbackhelper(this.req.responseXML,("list_services.xsl", document.getElementById("divListServiceGroups"));
    transformationWithoutHistory(this.req.responseXML,"list_services_info.xsl", document.getElementById("listServicesInformation"),[["resourceHTTPEPR",HTTP_URL + "/"]]);
    //showing the non refreshing Div
    document.getElementById('formsetWrapper').style.display = 'inline';
    loadFaultyServices();

}

function loadFaultyServices() {
    var body_xml = '<req:getNumberOfFaultyServicesRequest xmlns:req="http://org.apache.axis2/xsd">\n' +
                   ' </req:getNumberOfFaultyServicesRequest>\n';

    var callURL = serverURL + "/" + "ServiceAdmin" ;
    new wso2.wsf.WSRequest(callURL, "getNumberOfFaultyServices", body_xml, loadFaultyServicesCallback);
}

function loadFaultyServicesCallback() {

    var obj = document.getElementById('faultyServices');

    var data = this.req.responseXML;
    var intValue = data.getElementsByTagName("return")[0].firstChild.nodeValue;

    if (intValue == '0') {
        obj.style.display = 'none';
    } else {
        obj.style.display = 'inline';
        obj.innerHTML =
        '<h4><a href="#" onClick="javascript:listFaultyArchives(); return false;"><b><i>[' +
        intValue + '] faulty service(s)</a></i></b></h4>';
    }

}

function deleteServiceGroupCallBack() {

    wso2.wsf.Util.cursorWait();
    setTimeout("showAARGenerationCompleteMsg('The Service Group has been successfully deleted. This page will be refreshed shortly.')",
            1000);

}

function deleteServiceGroup(serviceGroupName) {
    var delete_to = confirm("Do you really want to delete [" + serviceGroupName + "] ?");
    if (delete_to == true) {
        /* stopping the refreshing first */
        stoppingRefreshingMethodsHook();
        var body_xml = '<req:deleteServiceGroupRequest xmlns:req="http://org.apache.axis2/xsd">\n' +
                       ' <req:serviceGroupName>' + serviceGroupName + '</req:serviceGroupName>\n' +
                       ' </req:deleteServiceGroupRequest>\n';

        var callURL = serverURL + "/" + "ServiceGroupAdmin" ;
        new wso2.wsf.WSRequest(callURL, "deleteServiceGroup", body_xml, deleteServiceGroupCallBack);
    } else {
        //        alertMessage("Aborted Deletion !");
        return false;
    }
}
function showAARGenerationCompleteMsg(msg) {
    wso2.wsf.Util.cursorClear();
    wso2.wsf.Util.alertMessage(msg);
    showServiceInitializer();
}

function listServiceDataRefresh(serviceName) {
    /*stopping the refreshing first */
    stoppingRefreshingMethodsHook();

    serviceSpecificName = serviceName;
    listServiceData(serviceName);

    if (listServiceDataRequestInterval == 0) {
        listServiceDataRequestInterval = setInterval(function() {
            listServiceData(getServiceSpecificName());
        }, SERVICE_REFRESH_TIME);
    }


}

function listGeneralServiceData(serviceName) {
    var bodyXML = '<req:getServiceData xmlns:req="http://org.apache.axis2/xsd">\n' +
                   ' <req:serviceName>' + serviceName + '</req:serviceName>\n' +
                   ' </req:getServiceData>\n';
    var callURL = wso2.wsf.Util.getServerURL() + "/" + "GeneralServices";
    new wso2.wsf.WSRequest(callURL, "urn:getServiceData", bodyXML, listGeneralServiceDataCallback);

}

function listGeneralServiceDataCallback() {
    //todo
    wso2.wsf.Util.callbackhelper(this.req.responseXML,"list_general_services_main_info.xsl" , document.getElementById("divServicesGeneralDescription"));

}

function listServiceData(serviceName) {
    var body_xml = '<req:getServiceDataRequest xmlns:req="http://org.apache.axis2/xsd">\n' +
                   ' <req:serviceName>' + serviceName + '</req:serviceName>\n' +
                   ' </req:getServiceDataRequest>\n';

    var callURL = serverURL + "/" + "ServiceAdmin" + "/" ;

    if (document.getElementById("divListServiceData").style.display == 'none' &&
        showListServiceDataDiv) {
        showListServiceDataDiv = false;
        clearInterval(listServiceDataRequestInterval);
        listServiceDataRequestInterval = 0;
        // this is to counter if focus to divHome is vanished.
        return false;

    }

    new wso2.wsf.WSRequest(callURL, "getServiceData", body_xml, listServiceDataCallback);

}

/**
 * Configure service level MTOM handling
 */
function configServiceMTOM(flag,serviceName) {
    stoppingRefreshingMethodsHook();

    var body_xml = '<req:configureMTOM xmlns:req="http://org.apache.axis2/xsd">\n' +
                   '<flag>' + flag + '</flag>\n' +
                   '<serviceName>' + serviceName + '</serviceName>\n' +
                   '</req:configureMTOM>\n';

    var callURL = serverURL + "/" + "ServiceAdmin" + "/" ;

    new wso2.wsf.WSRequest(callURL, "urn:configureMTOM", body_xml, configServiceMTOMCallback);
}

function configServiceMTOMCallback() {

    listServiceDataRefresh(serviceSpecificName);

}

function listServiceDataCallback() {

    showListServiceDataDiv = true;
    wso2.wsf.Util.callbackhelper(this.req.responseXML,"list_service_main_info.xsl", document.getElementById("divListServiceData"));

}

function activationOfService(serviceStatus) {
    var body_xml = '';
    var callURL = serverURL + "/" + "ServiceAdmin" ;
    var soapAction = "";
    if (serviceStatus == true) {
        body_xml = '<req:startServiceRequest xmlns:req="http://org.apache.axis2/xsd">\n' +
                   ' <req:serviceName>' + serviceSpecificName + '</req:serviceName>\n' +
                   ' </req:startServiceRequest>\n';
        soapAction = "startService";
    }
    if (serviceStatus == false) {
        body_xml = '<req:stopServiceRequest xmlns:req="http://org.apache.axis2/xsd">\n' +
                   ' <req:serviceName>' + serviceSpecificName + '</req:serviceName>\n' +
                   ' </req:stopServiceRequest>\n';
        soapAction = "stopService";

    }
    new wso2.wsf.WSRequest(callURL, soapAction, body_xml, activationOfServiceCallback);
}

function activationOfServiceCallback() {

    wso2.wsf.Util.cursorWait();
    setTimeout("showlistSericeData()", 1000);
}


function showlistSericeData() {
    wso2.wsf.Util.cursorClear();
    listServiceData(serviceSpecificName);
    var obj = document.getElementById("divListServiceData");
    wso2.wsf.Util.showOnlyOneMain(obj);
}

function listAllOperations(serviceName) {

    /*stopping the refreshing first */
    stoppingRefreshingMethodsHook();

    serviceSpecificName = serviceName;
    lastUsedServiceId = serviceName;
    // need to see the output to write the xsl
    var xsltFileName = "";
    var body_xml = '<ns1:listAllOperations xmlns:ns1="http://org.apache.axis2/xsd">\n' +
                   ' <arg0>' + serviceName + '</arg0>\n' +
                   ' <arg1>' + serviceName + '</arg1>\n' +
                   ' </ns1:listAllOperations>\n';

    var callURL = serverURL + "/" + "OperationAdmin" + "/" + "listAllOperations";
    new wso2.wsf.WSRequest(callURL, "listAllOperations", body_xml, listAllOperationsCallback);
}

function listAllOperationsCallback() {

    wso2.wsf.Util.callbackhelper(this.req.responseXML,"list_operations.xsl", document.getElementById("divListAllOperations"));
    showlistOperationsHeader(document.getElementById('listOperationsHeader'));
}


/**
 * configure opeation level mtom
 */
function configOperationMTOM(flag,operation){
    var body_xml = '<ns1:configureMTOM xmlns:ns1="http://org.apache.axis2/xsd">\n' +
                   '<flag>' + flag + '</flag>\n' +
                   '<serviceName>' + serviceSpecificName + '</serviceName>\n' +
                   '<operationName>' + operation + '</operationName>\n' +
                   '</ns1:configureMTOM>\n';

    var callURL = serverURL + "/" + "OperationAdmin" + "/";
    new wso2.wsf.WSRequest(callURL, "urn:configureMTOM", body_xml, configOperationMTOMCallback);

}

function configOperationMTOMCallback() {

    listAllOperations(serviceSpecificName);

}

function engageModulePerService(serviceName) {

    /*stopping the refreshing first */
    stoppingRefreshingMethodsHook();

    lastUsedServiceId = serviceName;
    var objDiv = document.getElementById("divEngageModule");
    var strHTML = "<h4><a href='#' onClick='javascript:showServiceInitializer(); return false;'>Services</a>&nbsp;&gt;&nbsp;<a href='#' onClick='javascript:listServiceData(\"" +
                  serviceName + "\"); return false;'>" + serviceName +
                  "</a>&nbsp;&gt;&nbsp;Engage Modules</h4>" +
                  "<fieldset style='border: none;'>" +
                  "<div id='formset'>" +
                  "<form>" +
                  "<fieldset>" +
                  "<legend>Engage module to service " + serviceName + "</legend>" +
                  "<div><label>Module</label><span id='engageModulePerServiceCombo'></span></div>" +
                  "<div class='buttonrow'><input type='button' onclick='javascript:engageModulePerServiceExec(\"" +
                  serviceName +
                  "\", document.getElementById(\"cmbEngageModulePerServiceCombo\").value);' value='Engage'/></div>" +
                  "</fieldset>" +
                  "</form>" +
                  "<div id='modulesPerServiceOnly' style='display:inline; position: relative; top: 20px;'></div>" +
                  "<div id='modulesEngagedOnParent' style='display:inline; position: relative; top: 20px;'></div>" +
                  "<div id='globleModulesOnService' style='display:inline; position: relative; top: 20px;'></div>" +
                  "</div>" +
                  "</fieldset>";

    var body_xml = '<req:listServiceModulesRequest xmlns:req="http://org.apache.axis2/xsd">\n' +
                   ' <req:serviceName>' + serviceName + '</req:serviceName>\n' +
                   ' </req:listServiceModulesRequest>\n';

    objDiv.innerHTML = strHTML;
    wso2.wsf.Util.showOnlyOneMain(objDiv);

    var callURL = serverURL + "/" + "ModuleAdmin" + "/" ;
    new wso2.wsf.WSRequest(callURL, "listServiceModules", body_xml, engageModulePerServiceCombo);

    // get Globalling engaged Modules

}

function engageModulePerServiceCombo() {

    var xsltFileName = "list_engaged_modules_per_service.xsl";
    var objDiv = document.getElementById("modulesPerServiceOnly");
    var data = this.req.responseXML;
    wso2.wsf.Util.processXML(data, xsltFileName, objDiv);
    //alert("Callback fired");
    //    getGlobalModuleCombo(document.getElementById("engageModulePerServiceCombo"), "cmbEngageModulePerServiceCombo");
    getGlobalModuleComboService(document.getElementById("engageModulePerServiceCombo"), "cmbEngageModulePerServiceCombo");


}

function getGlobalModuleComboService(cmbSpan, cmbName) {
    moduleSpanToUse = cmbSpan;
    moduleComboName = cmbName;
    //    alert("Global module getting function called");

    var body_xml = '<ns1:listModules  xmlns:ns1="http://org.apache.axis2/xsd"/>\n';

    var callURL = serverURL + "/" + MODULE_ADMIN_STRING + "/" + "listModules";
    new wso2.wsf.WSRequest(callURL, "listModules", body_xml, getGlobalModuleComboPerServiceCallback);

}

function getGlobalModuleComboPerServiceCallback() {

    var data = this.req.responseXML;

    //    alert("XSL = " + (new XMLSerializer()).serializeToString(data));

    var strHTML = "<select id='" + moduleComboName + "'>";
    var rets = data.getElementsByTagName("return");
    var len = rets.length;
    var count;
    var moduleVersion;
    for (count = 0; count < len; count++) {
        if (rets[count].getElementsByTagName("moduleVersion")[0].firstChild != null) {
            moduleVersion =
            rets[count].getElementsByTagName("moduleVersion")[0].firstChild.nodeValue;
        } else {
            moduleVersion = "";
        }
        displayModuleVersion = (moduleVersion == "" ? "" : ("-" + moduleVersion));
        strHTML +=
        "<option value='" + rets[count].getElementsByTagName("moduleId")[0].firstChild.nodeValue +
        '||' + moduleVersion + "'>" +
        rets[count].getElementsByTagName("modulename")[0].firstChild.nodeValue +
        displayModuleVersion + "</option>\n";
    }
    strHTML += "</select>"

    moduleSpanToUse.innerHTML = strHTML;

    //globally engage

    body_xml = '<req:listGloballyEngagesModulesRequest xmlns:req="http://org.apache.axis2/xsd">\n' +
               ' </req:listGloballyEngagesModulesRequest>\n';
    callURL = serverURL + "/" + "ModuleAdmin" + "/";
    new wso2.wsf.WSRequest(callURL, "listGloballyEngagesModules", body_xml, listGloballyEngageModulesPerServiceCallback);
}

function listGloballyEngageModulesPerServiceCallback() {

    var xsltFileName = "list_engaged_modules_per_service.xsl";
    var objDiv = document.getElementById("globleModulesOnService");
    var data = this.req.responseXML;
    wso2.wsf.Util.processXML(data, xsltFileName, objDiv);

    // Engaged Modules this service's parent

    var body_xml = '<req:listServicesParentEngagedModulesRequest xmlns:req="http://org.apache.axis2/xsd">\n' +
                   '<serviceName>' + lastUsedServiceId + '</serviceName>\n' +
                   '</req:listServicesParentEngagedModulesRequest>\n';
    callURL = serverURL + "/" + "ModuleAdmin" + "/";

    new wso2.wsf.WSRequest(callURL, "listServicesParentEngagedModules", body_xml, listServicesParentEngagedModulesCallback);

}

function listServicesParentEngagedModulesCallback() {

    var xsltFileName = "list_engaged_modules_per_service.xsl";
    var objDiv = document.getElementById("modulesEngagedOnParent");
    var data = this.req.responseXML;
    wso2.wsf.Util.processXML(data, xsltFileName, objDiv);

}


function engageModulePerServiceExec(serviceName, moduleName) {
    var moduleVersion = moduleName.substring(moduleName.indexOf('||') + 2, moduleName.length);
    lastUsedServiceId = serviceName;
    setModuleVersion = moduleVersion;
    moduleName = moduleName.substring(0, moduleName.indexOf('||'));
    //	alert("engageModulePerServiceExec Called with serviceName = " +serviceName + " || moduleName = " + moduleName + " ||| moduleVersion = " + moduleVersion);
    setModuleName = moduleName;
    var body_xml = '<req:engageModuleForServiceRequest xmlns:req="http://org.apache.axis2/xsd">\n' +
                   ' <req:moduleId>' + moduleName + '</req:moduleId>\n' +
                   ' <req:moduleVersion>' + moduleVersion + '</req:moduleVersion>\n' +
                   ' <req:serviceId>' + serviceName + '</req:serviceId>\n' +
                   ' <req:serviceVersion></req:serviceVersion>\n' +
                   ' </req:engageModuleForServiceRequest>\n';

    var callURL = serverURL + "/" + "ModuleAdmin" + "/" ;
    new wso2.wsf.WSRequest(callURL, "engageModuleForService", body_xml, engageModulePerServiceCallBack);


}

function engageModulePerServiceCallBack() {

    var data = this.req.responseXML;
    var text = data.getElementsByTagName('return')[0];

    wso2.wsf.Util.alertMessage(text.firstChild.nodeValue);

    setTimeout(function() {
        engageModulePerService(lastUsedServiceId);
    }, 1000);
    //    engageModulePerService(lastUsedServiceId);
}


function getServiceSpecficParametersForConfig(serviceName,serviceType) {
    /*stopping the refreshing first */
    stoppingRefreshingMethodsHook();

    if (serviceName == null) {
        serviceName = lastUsedServiceId;
    } else {
        lastUsedServiceId = serviceName;
        serviceSpecificName = serviceName;
    }
    var body_xml = '<req:getDeclaredServiceParametersRequest xmlns:req="http://org.apache.axis2/xsd">\n' +
                   ' <req:serviceId>' + serviceName + '</req:serviceId>\n' +
                   ' <req:serviceVersion>' + serviceName + '</req:serviceVersion>\n' +
                   ' </req:getDeclaredServiceParametersRequest>\n';

    var callURL = serverURL + "/" + "ServiceAdmin" ;

	if(serviceType != 'ejb_service' || serviceType == null){
    	new wso2.wsf.WSRequest(callURL, "getDeclaredServiceParameters", body_xml, getServiceSpecficParametersForConfigCallback);
	}else {
    	new wso2.wsf.WSRequest(callURL, "getDeclaredServiceParameters", body_xml, getServiceSpecficParametersForEJBConfigCallback);
	}
}

function getServiceSpecficParametersForConfigEJB(serviceName,serviceType) {
    /*stopping the refreshing first */
    stoppingRefreshingMethodsHook();

    if (serviceName == null) {
        serviceName = lastUsedServiceId;
    } else {
        lastUsedServiceId = serviceName;
        serviceSpecificName = serviceName;
    }
    var body_xml = '<req:getDeclaredServiceParametersRequest xmlns:req="http://org.apache.axis2/xsd">\n' +
                   ' <req:serviceId>' + serviceName + '</req:serviceId>\n' +
                   ' <req:serviceVersion>' + serviceName + '</req:serviceVersion>\n' +
                   ' </req:getDeclaredServiceParametersRequest>\n';

    var callURL = serverURL + "/" + "ServiceAdmin" ;

	if(serviceType == 'Normal' || serviceType == null){
    	new wso2.wsf.WSRequest(callURL, "getDeclaredServiceParameters", body_xml, getServiceSpecficParametersForConfigCallback);
	}else if(serviceType == 'ejb_service'){
    	new wso2.wsf.WSRequest(callURL, "getDeclaredServiceParameters", body_xml, getServiceSpecficParametersForEJBConfigCallback);
	}
}

function getServiceSpecficParametersForConfigCallback() {

    wso2.wsf.Util.callbackhelper(this.req.responseXML,"list_service_param_edit.xsl", document.getElementById("divGetServiceSpecficParametersForConfig"));
    showlistServiceParamEditHeader(document.getElementById('listServiceParamEditHeader'));
}
function getServiceSpecficParametersForEJBConfigCallback() {

    wso2.wsf.Util.callbackhelper(this.req.responseXML,"list_service_param_edit_ejb_service.xsl", document.getElementById("divGetServiceSpecficParametersForConfig"));
    showlistServiceParamEditHeader(document.getElementById('listServiceParamEditHeader'));
}


function arrangeEJBServiceParams(pArr, vArr) {
	var pA=new Array();
	var vA=new Array();
	
	pA[0]='remoteInterfaceName';
	for(var index=0; index<pArr.length; index++) {
		if (pArr[index]=='remoteInterfaceName') {
			vA[0]=vArr[index];
			pArr.splice(index, 1);
			vArr.splice(index, 1);
			break;
		}
	}
	pA[1]='homeInterfaceName';
	for(var index=0; index<pArr.length; index++) {
		if (pArr[index]=='homeInterfaceName') {
			vA[1]=vArr[index];
			pArr.splice(index, 1);
			vArr.splice(index, 1);
			break;
		}
	}
	pA[2]='beanJndiName';
	for(var index=0; index<pArr.length; index++) {
		if (pArr[index]=='beanJndiName') {
			vA[2]=vArr[index];
			pArr.splice(index, 1);
			vArr.splice(index, 1);
			break;
		}
	}
	pA[3]='jndiUser';
	for(var index=0; index<pArr.length; index++) {
		if (pArr[index]=='jndiUser') {
			vA[3]=vArr[index];
			pArr.splice(index, 1);
			vArr.splice(index, 1);
			break;
		}
	}
	
	pA[4]='jndiPassword';
	for(var index=0; index<pArr.length; index++) {
		if (pArr[index]=='jndiPassword') {
			vA[4]=vArr[index];
			pArr.splice(index, 1);
			vArr.splice(index, 1);
			break;
		}
	}
	for(var index=0, i=5; index<pArr.length; index++,i++) {
		pA[i] = pArr[index];
		vA[i] = vArr[index];
	}
	var str='';
	var label;
	for(var index=0; index<pA.length; index++) {
		if(pA[index]=='remoteInterfaceName') {
			label='Remote Interface Name';
		}
		else if (pA[index]=='homeInterfaceName') {
			label='Home Interface Name';
		}
		else if (pA[index]=='beanJndiName') {
			label='Bean JNDI Name';
		}
		else if (pA[index]=='jndiUser') {
			label='JNDI User';
		}
		else if (pA[index]=='jndiPassword') {
			label='JNDI Password';
		}
		else if (pA[index]=='serviceType') {
			label='Service Type';
		}
		else if (pA[index]=='jndiContextClass') {
			label='JNDI Context Class';
		}
		else if (pA[index]=='providerUrl') {
			label='Provider URL';
		}
		else if (pA[index]=='ServiceClass') {
			label='Service Class';
		}
		str = str +  '<div style="clear:both;"><label style="width: 25%">' + label + '</label>';
		str = str + '<input type="text" size="50" value="' + vA[index] + '"';
		str += ' id="' + pA[index] + '"';
		str += 'tabindex="'+index + '"';
		if (pA[index]=='serviceType' || pA[index] == 'ServiceClass'){
			str += ' disabled=true ';
		}
		str = str + '></input></div>';
		
	}
	document.getElementById('param_div').innerHTML=str;
}


////////////////////////////////////////////////////////////////////////////////
//                            <wsp:Policy> 				      //
////////////////////////////////////////////////////////////////////////////////


function getServiceSpecificPoliciesForConfig(serviceId, serviceVersion) {

    /*stopping the refreshing first */
    stoppingRefreshingMethodsHook();

    lastUsedServiceId = serviceId;
    lastUsedServiceVersion = serviceVersion;

    serviceSpecificName = serviceId;
    // is this necessary ?

    var xsltFileName = "list_service_policies_edit.xsl";
    var body_xml = '<ns1:getPoliciesRequest xmlns:ns1="http://org.apache.axis2/xsd">' +
                   '<ns1:serviceId>' + serviceId + '</ns1:serviceId>' +
                   '<ns1:serviceVersion>' + serviceVersion + '</ns1:serviceVersion>' +
                   '</ns1:getPoliciesRequest>';

    var callURL = serverURL + "/" + "ServiceAdmin";

    new wso2.wsf.WSRequest(callURL, "getPolicies", body_xml, getServiceSpecificPoliciesForConfigCallBack);

}


function getServiceSpecificPoliciesForConfigCallBack() {

    wso2.wsf.Util.callbackhelper(this.req.responseXML,"list_service_policies_edit.xsl", document.getElementById("divServices"));
    showlistPolicyInfoEditHeader(document.getElementById('listPolicyInfoEditHeader'));
}

function setServiceSpecificPolicyFromConfig(serviceId, serviceVersion, policyValue) {
    var body_xml = '<my:setPolicy xmlns:my="http://org.apache.axis2/xsd">' +
                   '<my:serviceId>' + serviceId + '</my:serviceId>' +
                   '<my:version>' + serviceVersion + '</my:version>' +
                   '<my:policyString><![CDATA[' + policyValue + ']]></my:policyString>' +
                   '</my:setPolicy>';

    var callURL = serverURL + "/" + "ServiceAdmin";
    new wso2.wsf.WSRequest(callURL, "setPolicy", body_xml, function() {
        wso2.wsf.Util.alertMessage("Service policy successfully updated.");
    });
}


/////////////////////////////////////////////////////// Policy Ends


/*
@deprecated
*/
function isServiceWSDLAvailable(callback) {

    /*stopping the refreshing first */
    stoppingRefreshingMethodsHook();

    var body_xml = '<req:isWSDLAvailable xmlns:req="http://org.apache.axis2/xsd">\n' +
                   '<req:serviceName>' + getServiceSpecificName() + '</req:serviceName>\n' +
                   ' </req:isWSDLAvailable>\n';

    var callURL = serverURL + "/" + "WSDLInfoService" + "/" ;
    new wso2.wsf.WSRequest(callURL, "isWSDLAvailable", body_xml, callback);

}

function isServiceWSDLAvailableTryItCallback() {

    var data = this.req.responseXML;
    //One click Jar download
    isServiceWSDLAvailableHelperTryIt(data);


}
function isServiceWSDLAvailableOneClickJarDownloadCallback() {

    var data = this.req.responseXML;
    //One click Jar download
    isServiceWSDLAvailableHelperGenerateClient(data);


}

function isServiceWSDLAvailableHelperGenerateClient(data) {
    var rets = data.getElementsByTagName("return")[0];
    var returnTextValue = rets.firstChild.nodeValue;
    if (returnTextValue == 'true') {
        //process
        stubGenerationMetaInfo();
    } else if (returnTextValue == 'false') {
        // no proecessing
        wso2.wsf.Util.alertMessage("Client generation could not continue due to WSDL not being available or\n" +
                     " the message receiver not being RPCMessageReceiver.");

    } else {
        wso2.wsf.Util.alertWarning(lable + "  Operations Could not be continued");

    }

}

function isServiceWSDLAvailableHelperTryIt(data) {
    var rets = data.getElementsByTagName("return")[0];
    var returnTextValue = rets.firstChild.nodeValue;
    if (returnTextValue == 'true') {
        //process
        dynamicClientGeneration();
    } else if (returnTextValue == 'false') {
        // no proecessing
        wso2.wsf.Util.alertMessage("DHTML generation could not continue due to WSDL not being available or\n" +
                     " the message receiver not being RPCMessageReceiver.");

    } else {
        wso2.wsf.Util.alertWarning(lable + "  Operations Couldnot be continued");

    }

}

function stubGenerationMetaInfo(wv) {
    if (!wv) {
        wv = "1.1";
    }

    var wsdlLocation;
    if (wv == "1.1") {
        wsdlLocation = HTTP_URL + '/' + getServiceSpecificName() + '?wsdl';
    } else {
       wsdlLocation = HTTP_URL + '/' + getServiceSpecificName() + '?wsdl2';
    }

    var buttonObj = document.getElementById('dynamicClientButtonId');
    if (buttonObj != null) {
        buttonObj.disabled=true;
    }

    var body_xml = '<req:listServicesAndPortsRequest xmlns:req="http://org.apache.axis2/xsd">\n' +
                   '<serviceName>' + getServiceSpecificName() + '</serviceName>\n' +
                   '<wsdlVersion>' + wv + '</wsdlVersion>\n'+
                   '<wsdlLocation>' + wsdlLocation+ '</wsdlLocation>\n' +
                   '</req:listServicesAndPortsRequest>\n';

    var callURL = serverURL + "/" + "WSDLInfoService" + "/" ;
    wso2.wsf.Util.cursorWait();
    new wso2.wsf.WSRequest(callURL, "listServicesAndPorts", body_xml, stubGenerationMetaInfoCallback);
}

function stubGenerationMetaInfoCallback() {

    wso2.wsf.Util.callbackhelper(this.req.responseXML,"stub_meta_info.xsl", document.getElementById("divStubGeneration"));
    showstubGenMetaInfo(document.getElementById('stubGenMetaInfo'));
}

function stubGenerationSOAPRequest(packageNameObj, invocationStyleObj,
                                   generateTestCasesObj, databindingMethodObj,
                                   unpackClassesObj, serviceBindingName,
                                   serviceBindingPortObj, unwrapObj, wsdlVersionObj) {
    var packageName = packageNameObj.value;
    var serviceName = serviceSpecificName;
    var invocationStyle = invocationStyleObj[invocationStyleObj.selectedIndex].value;
    var generateTestCases = generateTestCasesObj[generateTestCasesObj.selectedIndex].value;
    var databindingMethod = databindingMethodObj[databindingMethodObj.selectedIndex].value;
    var unpackClasses = unpackClassesObj[unpackClassesObj.selectedIndex].value;
    var serviceBindingPort = serviceBindingPortObj[serviceBindingPortObj.selectedIndex].value;
    var unwrap = unwrapObj[unwrapObj.selectedIndex].value;
    var wsdlVersion = wsdlVersionObj[wsdlVersionObj.selectedIndex].value;

    var pattern = /^[a-zA-Z](([a-zA-Z_]+)([a-zA-Z0-9_]?)\.?)+[a-z0-9_]$/;
    if (packageName == null || wso2.wsf.Util.trim(packageName) == '') {
        wso2.wsf.Util.alertWarning("Package name is mandatory");
        return;
    }
    if (!pattern.test(packageName)) {
        wso2.wsf.Util.alertWarning("Package name is not valid under Java package naming conventions");
        return;
    }

    var wsdlLocation;
    if (wsdlVersion == "1.1") {
        wsdlLocation = HTTP_URL + '/' + serviceName + '?wsdl';
    } else {
       wsdlLocation = HTTP_URL + '/' + serviceName + '?wsdl2';
    }

    var buttonObj = document.getElementById('dynamicClientButtonId');
    if (buttonObj != null) {
        buttonObj.disabled = true;
    }

    var body_xml = ' <req:generateRequest xmlns:req="http://wsdl2code.service.admin.wsas.wso2.org">\n' +
                   ' <service>' + serviceName + '</service>\n' +
                   ' <packageName>' + packageName + '</packageName>\n' +
                   ' <invocationStyle>' + invocationStyle + '</invocationStyle>\n' +
                   ' <generateTestCase>' + generateTestCases + '</generateTestCase>\n' +
                   ' <databindingMethod>' + databindingMethod + '</databindingMethod>\n' +
                   ' <unpackClasses>' + unpackClasses + '</unpackClasses>\n' +
                   ' <serviceBindingName>' + serviceBindingName + '</serviceBindingName>\n' +
                   ' <servicePortName>' + serviceBindingPort + '</servicePortName>\n' +
                   ' <unwrap>' + unwrap + '</unwrap>\n' +
                   ' <wsdlVersion>' + wsdlVersion + '</wsdlVersion>\n' +
                   ' <wsdlLocation>' + wsdlLocation + '</wsdlLocation>\n' +
                   ' </req:generateRequest>\n';

    var callURL = serverURL + "/" + "JavaClientGeneratorService" ;
    wso2.wsf.Util.cursorWait();
    new wso2.wsf.WSRequest(callURL, "generate", body_xml, generateCallBack);
}

function generateCallBack() {

    //response will be a link and it will call the download dialog
    var data = this.req.responseXML;

    var responseTextValue = data.getElementsByTagName("return")[0].firstChild.nodeValue;

    var buttonObj = document.getElementById('dynamicClientButtonId');
    if (buttonObj != null) {
        buttonObj.disabled = false;
    }

    window.location = URL + responseTextValue;
}


function loadUsersComboBox() {
    var xsltFileName = "user.xsl";
    var body_xml = '<req:getUsersRequest xmlns:req="http://org.apache.axis2/xsd">\n' +
                   ' </req:getUsersRequest>\n';

    var callURL = serverURL + "/" + "UserAdmin" + "/" ;
    new wso2.wsf.WSRequest(callURL, "getUsers", body_xml, loadUsersCallback);
}

function loadRolesComboBox() {
    //    var xsltFileName = "role.xsl";
    var body_xml = '<req:getRoleNamesAndDescriptionsRequest xmlns:req="http://org.apache.axis2/xsd">\n' +
                   ' </req:getRoleNamesAndDescriptionsRequest>\n';

    var callURL = serverURL + "/" + "UserAdmin" + "/" ;
    new wso2.wsf.WSRequest(callURL, "getRoleNamesAndDescriptions", body_xml, loadRolesComboBoxCallback);
}

function loadRolesComboBoxCallback() {

    var comboToLoad = document.getElementById('serviceRoleName');
    var data = this.req.responseXML;
    //    alert((new XMLSerializer()).serializeToString(data));
    var rets = data.getElementsByTagName("return");
    var len = rets.length;
    var count;
    for (count = 0; count < len; count++) {
        var roleCollection = rets[count].getElementsByTagName("role");
        comboToLoad.options[count] = new Option(roleCollection[0].firstChild.nodeValue);
        comboToLoad.options[count].value = roleCollection[0].firstChild.nodeValue;
    }
    wso2.wsf.Util.showOnlyOneMain(document.getElementById("divListRoles"));
}

function loadUsersCallback() {

    var comboToLoad = document.getElementById('serviceUserName');
    var data = this.req.responseXML;
    var rets = data.getElementsByTagName("return");
    var len = rets.length;
    var count;
    for (count = 0; count < len; count++) {
        comboToLoad.options[count] = new Option(rets[count].firstChild.nodeValue);
        comboToLoad.options[count].value = rets[count].firstChild.nodeValue;
    }
}

/* @depricated */
function serviceUNameToeknAuth() {
    listUsers1();
}


function loadRolesComboBox1() {
    //    var xsltFileName = "role.xsl";
    var body_xml = '<req:getRoleNamesAndDescriptionsRequest xmlns:req="http://org.apache.axis2/xsd">\n' +
                   ' </req:getRoleNamesAndDescriptionsRequest>\n';

    var callURL = serverURL + "/" + "UserAdmin" + "/" ;
    new wso2.wsf.WSRequest(callURL, "getRoleNamesAndDescriptions", body_xml, loadRolesComboBoxCallback1);
}

function loadRolesComboBoxCallback1() {

    var comboToLoad = document.getElementById('serviceRoleName');
    var data = this.req.responseXML;
    //    alert((new XMLSerializer()).serializeToString(data));
    var rets = data.getElementsByTagName("return");
    var len = rets.length;
    var count;
    for (count = 0; count < len; count++) {
        var roleCollection = rets[count].getElementsByTagName("role");
        comboToLoad.options[count] = new Option(roleCollection[0].firstChild.nodeValue);
        comboToLoad.options[count].value = roleCollection[0].firstChild.nodeValue;
    }
    //showOnlyOneMain(document.getElementById("divListRoles"));
}


function getOperationSpecficParameters(operation) {
    serviceOperationParameters = operation;

    showOperationSpecificStatistics();
}

//@private
function getOperationSpecficParameters0() {

    var body_xml = '<req:getDeclaredOperationParametersRequest xmlns:req="http://org.apache.axis2/xsd">\n' +
                   '<serviceName>' + getServiceSpecificName() + '</serviceName>\n' +
                   '<operationName>' + getServiceOperationParameters() + '</operationName>\n' +
                   '</req:getDeclaredOperationParametersRequest>\n';

    var callURL = serverURL + "/" + "OperationAdmin" + "/" ;
    new wso2.wsf.WSRequest(callURL, "getDeclaredOperationParameters", body_xml, getOperationSpecficParameters0Callback);

}

function getOperationSpecficParameters0Callback() {

    transformationWithoutHistory(this.req.responseXML,"list_service_param.xsl", document.getElementById("listOperationsParameters"));

}

function showOperationSpecificStatistics() {
    var body_xml = '<req:getOperationStatisticsRequest xmlns:req="http://org.apache.axis2/xsd">\n' +
                   '<serviceName>' + getServiceSpecificName() + '</serviceName>\n' +
                   '<operationName>' + getServiceOperationParameters() + '</operationName>\n' +
                   '</req:getOperationStatisticsRequest>\n';

    var callURL = serverURL + "/" + "OperationAdmin" + "/" ;
    new wso2.wsf.WSRequest(callURL, "getOperationStatistics", body_xml, showOperationSpecificStatisticsCallback);

}

function showOperationSpecificStatisticsCallback() {

    wso2.wsf.Util.callbackhelper(this.req.responseXML,"show_param_statistics.xsl", document.getElementById("divGetOperationSpecficParameters"));

    showlistOperationParamAndStatisticsEditHeader(document.getElementById('listServiceParamHeader'));

    getOperationSpecficParameters0();

}


function getServiceGroupSpecificParameters(group) {
    var body_xml = '<req:getDeclaredServiceGroupParametersRequest xmlns:req="http://org.apache.axis2/xsd">\n' +
                   ' <req:service_group_id>' + group + '</req:service_group_id>\n' +
                   ' <req:group_version></req:group_version>\n' +
                   ' </req:getDeclaredServiceGroupParametersRequest>\n';

    var callURL = serverURL + "/" + "ServiceGroupAdmin" + "/" ;
    new wso2.wsf.WSRequest(callURL, "getDeclaredServiceGroupParameters", body_xml, function() {
        wso2.wsf.Util.callbackhelper(this.req.responseXML,"list_service_group_param.xsl", document.getElementById("divServiceGroupParams"));
    });

}

function getOperationSpecficParametersForConfig(operation) {
    if (operation == null) {
        operation = serviceOperationParameters;
    } else {
        serviceOperationParameters = operation;
    }
    var body_xml = '<req:getDeclaredOperationParametersRequest xmlns:req="http://org.apache.axis2/xsd">\n' +
                   ' <req:serviceId>' + getServiceSpecificName() + '</req:serviceId>\n' +
                   ' <req:operationId>' + operation + '</req:operationId>\n' +
                   ' </req:getDeclaredOperationParametersRequest>\n';

    var callURL = serverURL + "/" + OPERATION_ADMIN_SERVER_URL ;
    new wso2.wsf.WSRequest(callURL, "getDeclaredOperationParameters", body_xml, getOperationSpecficParametersForConfigCallback);

}

function getOperationSpecficParametersForConfigCallback() {

    wso2.wsf.Util.callbackhelper(this.req.responseXML,"list_operation_params_edit.xsl",
            document.getElementById("divGetOperationSpecficParametersForConfig"));
    showlistOperationParamEditHeader(document.getElementById('listOperationParamEditHeader'));
}


var cur_module_number_ser = 0;
var global_arrayOfNames_ser = null;
var global_arrayOfValues_ser = null;
//operation parameter update procedure
//loop through the two arrays and pass through each and every parameter

//display the messages for the modules
function updateServiceOperationInfoDisplay(message) {
    document.getElementById('operationConfigUpdate').innerHTML = message;
}

//add operation specific parameter
function addOperationParameter() {
    var newParam = wso2.wsf.Util.getUserInput();
    if (newParam != null) {
        processSingleOperationParameterConfigEntry(
                lastUsedServiceId,
                serviceOperationParameters,
                newParam[0],
                newParam[1], getOperationSpecficParametersForConfig);
    }
}

//remove operation specific parameter
function removeOperationParameter(button) {
    processSingleOperationParameterConfigEntryRemoval(
            lastUsedServiceId,
            serviceOperationParameters,
            button.id, getOperationSpecficParametersForConfig);

}

//add a single operation parameter entry
function processSingleOperationParameterConfigEntryRemoval(
        serviceId,
        operationId,
        parameterName, operation_callback) {

    if (!parseParameterName(parameterName)) {
        wso2.wsf.Util.alertMessage("Parameter name contains an invalid character");
        return false;
    }

    var body_xml = '<ns1:removeOperationParameterRequest xmlns:ns1="http://org.apache.axis2/xsd">' +
                   '<ns1:serviceId>' + serviceId + '</ns1:serviceId>' +
                   '<ns1:operationId>' + operationId + '</ns1:operationId>' +
                   '<ns1:group_version></ns1:group_version>' +
                   '<parameter locked="false" name="' + parameterName + '"></parameter>' +
                   '</ns1:removeOperationParameterRequest>';

    var callURL = serverURL + "/" + OPERATION_ADMIN_SERVER_URL;
    new wso2.wsf.WSRequest(callURL, "removeOperationParameter", body_xml, operation_callback);
}

function processMultipleOperationParameterConfigEntry(serviceId,
                                                      operationId,
                                                      parameterNamesObj,
                                                      parameterValueObj) {
    var paramElements = '';
    for (var i = 0; i < parameterNamesObj.length; i++) {
        paramElements += '<parameter locked="false" name="' + parameterNamesObj[i] + '"><![CDATA[' +
                         parameterValueObj[i] + ']]></parameter>\n';
    }
    var body_xml = '<ns1:setOperationParameters xmlns:ns1="http://org.apache.axis2/xsd">' +
                   '<ns1:serviceId>' + serviceId + '</ns1:serviceId>' +
                   '<ns1:operationId>' + operationId + '</ns1:operationId>' +
                   '<ns1:groupVersion></ns1:groupVersion>' +
                   paramElements +
                   '</ns1:setOperationParameters>';

    var callURL = serverURL + "/" + OPERATION_ADMIN_SERVER_URL;
    new wso2.wsf.WSRequest(callURL, "setOperationParameters", body_xml, processMultipleOperationParameterConfigEntryCallback);


}

function processMultipleOperationParameterConfigEntryCallback() {

    wso2.wsf.Util.alertMessage("Operation parameters were successfully updated.");

    getOperationSpecficParametersForConfig(getServiceOperationParameters());

}

//add a single operation parameter entry
function processSingleOperationParameterConfigEntry(
        serviceId,
        operationId,
        parameterName,
        parameterValue, operation_callback) {

    if (!parseParameterName(parameterName)) {
        wso2.wsf.Util.alertMessage("Parameter name contains an invalid character");
        return false;
    }

    var body_xml = '<ns1:setOperationParameterRequest xmlns:ns1="http://org.apache.axis2/xsd">' +
                   '<ns1:serviceId>' + serviceId + '</ns1:serviceId>' +
                   '<ns1:operationId>' + operationId + '</ns1:operationId>' +
                   '<ns1:group_version></ns1:group_version>' +
                   '<parameter locked="false" name="' + parameterName + '"><![CDATA[' +
                   parameterValue + ']]></parameter>' +
                   '</ns1:setOperationParameterRequest>';

    var callURL = serverURL + "/" + OPERATION_ADMIN_SERVER_URL;

    new wso2.wsf.WSRequest(callURL, "setOperationParameter", body_xml, operation_callback);
}
//end of  processSingleOperationParameterConfigEntry
function engageModulePerOperation(operationName) {
    lastOperationUsed = operationName;
    var objDiv = document.getElementById("divEngageModulePerOperation");
    var strHTML = "<h4><a href='#' onClick='javascript:showServiceInitializer(); return false;'>Services</a>&nbsp;&gt;&nbsp;<a href='#' onClick='javascript:listServiceData(\"" +
                  getServiceSpecificName() + "\"); return false;'>" + getServiceSpecificName() +
                  "</a>" + "&nbsp;&gt;&nbsp;<a href='#' onClick='javascript:listAllOperations(\"" +
                  getServiceSpecificName() + "\"); return false;'>Operation[" + lastOperationUsed +
                  "]</a>&nbsp;&gt;&nbsp;Engage Module" + "</h4>" +
                  "<fieldset style='border: none;'>" +
                  "<div id='formset'>" +
                  "<form>" +
                  "<fieldset>" +
                  "<legend>Engage module to operation <font color='blue'>" + operationName +
                  "</font></legend>" +
                  "<div><label>Module</label><span id='engageModulePerOperationCombo'></span></div>" +
                  "<div class='buttonrow'><input type='button' onclick='javascript:engageModulePerOperationExec(\"" +
                  operationName +
                  "\", document.getElementById(\"cmbEngageModulePerOperationCombo\").value);' value='Engage'/></div>" +
                  "</fieldset>" +
                  "</form>" +
                  "<div id='modulesPerOperation' style='display:inline; position: relative; top: 20px;'></div>" +
                  "<div id='modulesPerService' style='display:inline; position: relative; top: 20px;'></div>" +
                  "<div id='modulesPerServiceParentEngagedModules' style='display:inline; position: relative; top: 20px;'></div>" +
                  "<div id='globleModules' style='display:inline; position: relative; top: 20px;'></div>" +
                  "</div></fieldset>";

    var body_xml = '<req:listOperationModulesRequest xmlns:req="http://org.apache.axis2/xsd">\n' +
                   ' <req:serviceId>' + getServiceSpecificName() + '</req:serviceId>\n' +
                   ' <req:operationId>' + operationName + '</req:operationId>\n' +
                   ' </req:listOperationModulesRequest>\n';

    objDiv.innerHTML = strHTML;
    wso2.wsf.Util.showOnlyOneMain(objDiv);

    var callURL = serverURL + "/" + MODULE_ADMIN_SERVER_URL ;
    new wso2.wsf.WSRequest(callURL, "listOperationModules", body_xml, engageModulePerOperationCombo);

}

function engageModulePerOperationCombo() {

    var xsltFileName = "list_engaged_modules_per_operation.xsl";
    var objDiv = document.getElementById("modulesPerOperation");
    var data = this.req.responseXML;
    wso2.wsf.Util.processXML(data, xsltFileName, objDiv);

    var body_xml = '<req:listServiceModulesRequest xmlns:req="http://org.apache.axis2/xsd">\n' +
                   ' <req:serviceName>' + getServiceSpecificName() + '</req:serviceName>\n' +
                   ' </req:listServiceModulesRequest>\n';

    var callURL = serverURL + "/" + "ModuleAdmin" + "/" ;
    new wso2.wsf.WSRequest(callURL, "listServiceModules", body_xml, engageModullePerOperationComboCallback);
}

function engageModullePerOperationComboCallback() {

    var xsltFileName = "list_engaged_modules_per_operation.xsl";
    var objDiv = document.getElementById("modulesPerService");
    var data = this.req.responseXML;
    wso2.wsf.Util.processXML(data, xsltFileName, objDiv);

    getGlobalModuleCombo(document.getElementById("engageModulePerOperationCombo"), "cmbEngageModulePerOperationCombo");
}

function getGlobalModuleCombo(cmbSpan, cmbName) {
    moduleSpanToUse = cmbSpan;
    moduleComboName = cmbName;
    //    alert("Global module getting function called");

    var body_xml = '<ns1:listModules  xmlns:ns1="http://org.apache.axis2/xsd"/>\n';

    var callURL = serverURL + "/" + MODULE_ADMIN_STRING + "/" + "listModules";
    new wso2.wsf.WSRequest(callURL, "listModules", body_xml, getGlobalModuleComboCallback);

}

function getGlobalModuleComboCallback() {

    var data = this.req.responseXML;

    //    alert("XSL = " + (new XMLSerializer()).serializeToString(data));

    var strHTML = "<select id='" + moduleComboName + "'>";
    var rets = data.getElementsByTagName("return");
    var len = rets.length;
    var count;
    var moduleVersion;
    for (count = 0; count < len; count++) {
        if (rets[count].getElementsByTagName("moduleVersion")[0].firstChild != null) {
            moduleVersion =
            rets[count].getElementsByTagName("moduleVersion")[0].firstChild.nodeValue;
        } else {
            moduleVersion = "";
        }
        displayModuleVersion = (moduleVersion == "" ? "":("-" + moduleVersion));
        strHTML += "<option value='" +
                   rets[count].getElementsByTagName("moduleId")[0].firstChild.nodeValue + '||' +
                   moduleVersion + "'>" +
                   rets[count].getElementsByTagName("modulename")[0].firstChild.nodeValue +
                   displayModuleVersion + "</option>\n";
    }
    strHTML += "</select>"
    moduleSpanToUse.innerHTML = strHTML;

    //globally engage

    body_xml = '<req:listGloballyEngagesModulesRequest xmlns:req="http://org.apache.axis2/xsd">\n' +
               ' </req:listGloballyEngagesModulesRequest>\n';

    callURL = serverURL + "/" + "ModuleAdmin" + "/";
    new wso2.wsf.WSRequest(callURL, "listGloballyEngagesModules", body_xml, listGloballyEngageModulesCallback);

}

function listGloballyEngageModulesCallback() {

    var xsltFileName = "list_engaged_modules_per_service.xsl";
    var objDiv = document.getElementById("globleModules");
    var data = this.req.responseXML;
    wso2.wsf.Util.processXML(data, xsltFileName, objDiv);

    //Operation's Parent's Parent module Listing

    var body_xml = '<req:listOperationsParentParentEngagedModulesRequest xmlns:req="http://org.apache.axis2/xsd">\n' +
                   '<serviceName>' + getServiceSpecificName() + '</serviceName>\n' +
                   '<operationName>' + lastOperationUsed + '</operationName>\n' +
                   '</req:listOperationsParentParentEngagedModulesRequest>\n';

    callURL = serverURL + "/" + "ModuleAdmin" + "/";
    new wso2.wsf.WSRequest(callURL, "listOperationsParentParentEngagedModules", body_xml, listOperationsParentParentEngagedModulesCallback);


}

function listOperationsParentParentEngagedModulesCallback() {

    var xsltFileName = "list_engaged_modules_per_service.xsl";
    var objDiv = document.getElementById("modulesPerServiceParentEngagedModules");
    var data = this.req.responseXML;
    wso2.wsf.Util.processXML(data, xsltFileName, objDiv);


}

function engageModulePerOperationExec(operationName, moduleName) {
    var moduleVersion = moduleName.substring(moduleName.indexOf('||') + 2, moduleName.length);
    moduleName = moduleName.substring(0, moduleName.indexOf('||'));
    setOperationName = operationName;

    var body_xml = '<req:engageModuleForOperationRequest xmlns:req="http://org.apache.axis2/xsd">\n' +
                   ' <req:moduleId>' + moduleName + '</req:moduleId>\n' +
                   ' <req:moduleVersion>' + moduleVersion + '</req:moduleVersion>\n' +
                   ' <req:serviceId>' + getServiceSpecificName() + '</req:serviceId>\n' +
                   ' <req:serviceVersion></req:serviceVersion>\n' +
                   ' <req:operationId>' + operationName + '</req:operationId>\n' +
                   ' </req:engageModuleForOperationRequest>\n';

    var callURL = serverURL + "/" + "ModuleAdmin" + "/" ;
    new wso2.wsf.WSRequest(callURL,"engageModuleForOperation",body_xml,engageModulePerOperationCallBack);


}
function engageModulePerOperationCallBack() {

    var data = this.req.responseXML;
    var text = data.getElementsByTagName('return')[0];

    wso2.wsf.Util.alertMessage(text.firstChild.nodeValue);

    engageModulePerOperation(lastOperationUsed);
}

// disengaging modules from operation
function disengageModuelfromOperationExec(moduleName, moduleVersion) {
    var body_xml = '<req:disengageModuleFromOperationRequest xmlns:req="http://org.apache.axis2/xsd">\n' +
                   ' <req:moduleId>' + moduleName + '</req:moduleId>\n' +
                   ' <req:moduleVersion>' + moduleVersion + '</req:moduleVersion>\n' +
                   ' <req:serviceId>' + getServiceSpecificName() + '</req:serviceId>\n' +
                   ' <req:serviceVersion></req:serviceVersion>\n' +
                   ' <req:operationId>' + lastOperationUsed + '</req:operationId>\n' +
                   ' </req:disengageModuleFromOperationRequest>\n';

    var callURL = serverURL + "/" + "ModuleAdmin" + "/" ;
    new wso2.wsf.WSRequest(callURL,"disengageModuleFromOperation",body_xml,disengageModuleFromOperationCallBack);
}

function disengageModuleFromOperationCallBack() {

    wso2.wsf.Util.alertMessage("Module was disengaged from operation successfully.");
    engageModulePerOperation(lastOperationUsed);
}

// disengaging modules from operation
function disengageModuelfromServiceExec(moduleName, moduleVersion) {
    // gettting all the values from engageModulePerOperationExec
    var body_xml = '<req:disengageModuleFromService xmlns:req="http://org.apache.axis2/xsd">\n' +
                   ' <req:moduleId>' + moduleName + '</req:moduleId>\n' +
                   ' <req:moduleVersion>' + moduleVersion + '</req:moduleVersion>\n' +
                   ' <req:serviceId>' + getServiceSpecificName() + '</req:serviceId>\n' +
                   ' <req:serviceVersion></req:serviceVersion>\n' +
                   ' </req:disengageModuleFromService>\n';

    var callURL = serverURL + "/" + "ModuleAdmin" + "/" ;
    new wso2.wsf.WSRequest(callURL,"disengageModuleFromService",body_xml,disengageModuelfromServiceCallBack);
}

function disengageModuelfromServiceCallBack() {

    wso2.wsf.Util.alertMessage("Module was disengaged from service successfully.");
    setTimeout(function() {
        engageModulePerService(getServiceSpecificName());
    }, 1000);
    //    engageModulePerService(getServiceSpecificName());

}
function addServiceSpecificParameters() {
    var newParam = wso2.wsf.Util.getUserInput();
    if (newParam != null) {
        processServiceOperationParameterConfigEntry(
                lastUsedServiceId,
                serviceSpecificName,
                newParam[0],
                newParam[1], getServiceSpecficParametersForConfig);
    }
 }

function removeServiceSpecificParameter(button) {
    processServiceOperationParameterConfigEntryRemoval(
            lastUsedServiceId,
            serviceSpecificName,
            button.id, getServiceSpecficParametersForConfig);
}

function removeEJBServiceSpecificParameter(button) {
    processServiceOperationParameterConfigEntryRemoval(
            lastUsedServiceId,
            serviceSpecificName,
            button.id.substring(3), getServiceSpecficParametersForConfig);
}

//remove a single operation parameter entry
function processServiceOperationParameterConfigEntryRemoval(
        serviceId,
        serviceVersion,
        parameterName, service_callback) {

    if (!parseParameterName(parameterName)) {
        wso2.wsf.Util.alertMessage("Parameter name contains an invalid character");
        return false;
    }


    var body_xml = '<ns1:removeServiceSpecificParameterRequest xmlns:ns1="http://org.apache.axis2/xsd">' +
                   '<ns1:serviceId>' + serviceId + '</ns1:serviceId>' +
                   '<ns1:serviceVersion>' + serviceId + '</ns1:serviceVersion>' +
                   '<parameter locked="false" name="' + parameterName + '"></parameter>' +
                   '</ns1:removeServiceSpecificParameterRequest>';

    var callURL = serverURL + "/" + "ServiceAdmin";
    //update the information in operation display page
    new wso2.wsf.WSRequest(callURL,"removeServiceSpecificParameter",body_xml,service_callback);
}
//end of  processSingleOperationParameterConfigEntry

function processMultipleServiceOperationParameterConfigEntry(serviceId,
                                                             parameterNamesObj,
                                                             parameterValueObj) {
    var paramElements = '';
    for (var i = 0; i < parameterNamesObj.length; i++) {
        paramElements += '<parameter locked="false" name="' + parameterNamesObj[i] + '"><![CDATA[' +
                         parameterValueObj[i] + ']]></parameter>\n';
    }
    var body_xml = '<ns1:setServiceParameters xmlns:ns1="http://org.apache.axis2/xsd">' +
                   '<ns1:serviceId>' + serviceId + '</ns1:serviceId>' +
                   '<ns1:serviceVersion>' + serviceId + '</ns1:serviceVersion>' +
                   paramElements +
                   '</ns1:setServiceParameters>';

    var callURL = serverURL + "/" + "ServiceAdmin";

    new wso2.wsf.WSRequest(callURL,"setServiceParameters",body_xml,processMultipleServiceOperationParameterConfigEntryCallback);


}

function processMultipleServiceOperationParameterConfigEntryEJB(serviceId,
                                                             parameterNamesObj,
                                                             parameterValueObj) {
    var paramElements = '';
    for (var i = 0; i < parameterNamesObj.length; i++) {
        paramElements += '<parameter locked="false" name="' + parameterNamesObj[i] + '"><![CDATA[' +
                         parameterValueObj[i] + ']]></parameter>\n';
    }
    var body_xml = '<ns1:setServiceParameters xmlns:ns1="http://org.apache.axis2/xsd">' +
                   '<ns1:serviceId>' + serviceId + '</ns1:serviceId>' +
                   '<ns1:serviceVersion>' + serviceId + '</ns1:serviceVersion>' +
                   paramElements +
                   '</ns1:setServiceParameters>';

    var callURL = serverURL + "/" + "ServiceAdmin";

    new wso2.wsf.WSRequest(callURL,"setServiceParameters",body_xml,processMultipleServiceOperationParameterConfigEntryEJBCallback);


}

function processMultipleServiceOperationParameterConfigEntryCallback() {

    wso2.wsf.Util.alertMessage("Service parameters were successfully updated.");
    getServiceSpecficParametersForConfig(lastUsedServiceId);

}

function processMultipleServiceOperationParameterConfigEntryEJBCallback() {

    wso2.wsf.Util.alertMessage("Service parameters were successfully updated.");
	getServiceSpecficParametersForConfig(lastUsedServiceId, 'ejb_service');

}

//add a single operation parameter entry
function processServiceOperationParameterConfigEntry(
        serviceId,
        serviceVersion,
        parameterName,
        parameterValue, service_callback) {

    if (!parseParameterName(parameterName)) {
        wso2.wsf.Util.alertMessage("Parameter name contains an invalid character");
        return false;
    }


    var body_xml = '<ns1:setServiceParameterRequest xmlns:ns1="http://org.apache.axis2/xsd">' +
                   '<ns1:serviceId>' + serviceId + '</ns1:serviceId>' +
                   '<ns1:serviceVersion>' + serviceId + '</ns1:serviceVersion>' +
                   '<parameter locked="false" name="' + parameterName + '"><![CDATA[' +
                   parameterValue + ']]></parameter>' +
                   '</ns1:setServiceParameterRequest>';

    var callURL = serverURL + "/" + "ServiceAdmin";
    //update the information in operation display page
    new wso2.wsf.WSRequest(callURL,"setServiceParameter",body_xml,service_callback);
}
//end of  processSingleOperationParameterConfigEntry

//display the messages for the modules
function updateServiceInfoDisplay(message) {
    document.getElementById('serviceConfigUpdate').innerHTML = message;
}

function processOperationParameterConfigUpdate(arrayOfNames, arrayOfValues) {

    processMultipleOperationParameterConfigEntry(lastUsedServiceId, serviceOperationParameters, arrayOfNames, arrayOfValues);

}
function processServiceOperationParameterConfigUpdate(arrayOfNames, arrayOfValues) {
	processMultipleServiceOperationParameterConfigEntry(lastUsedServiceId, arrayOfNames, arrayOfValues);
}

function processServiceOperationParameterConfigUpdateEJB(arrayOfNames, arrayOfValues) {
	processMultipleServiceOperationParameterConfigEntryEJB(lastUsedServiceId, arrayOfNames, arrayOfValues);
}

function completeServiceFileUpload(msg) {
    wso2.wsf.Util.cursorWait();
    if (msg) {
        showAARGenerationCompleteMsg(msg);
    } else {
        showAARGenerationCompleteMsg("Archive was successfully uploaded.\n" +
                                     "This page will be auto refreshed shortly.");
    }
}

function serviceParameters(serviceId, serviceVersion) {
    lastUsedServiceId = serviceId;
    lastUsedServiceVersion = serviceVersion;

    var body_xml = '<req:getServiceParametersRequest xmlns:req="http://org.apache.axis2/xsd">\n' +
                   ' <req:serviceId>' + serviceId + '</req:serviceId>\n' +
                   ' <req:serviceVersion>' + serviceVersion + '</req:serviceVersion>\n' +
                   ' </req:getServiceParametersRequest>\n';


    var callURL = serverURL + "/" + "ServiceAdmin" + "/" ;
    new wso2.wsf.WSRequest(callURL,"getServiceParameters",function() {
        wso2.wsf.Util.callbackhelper(this.req.responseXML,"list_service_param.xsl",document.getElementById("divServiceParameters"));
    });

}

//faulty services

function listFaultyArchives() {
    var body_xml = '<req:getFaultyServiceArchivesRequest xmlns:req="http://org.apache.axis2/xsd">\n' +
                   ' </req:getFaultyServiceArchivesRequest>\n';

    var callURL = serverURL + "/" + "ServiceAdmin" ;
    new wso2.wsf.WSRequest(callURL,"getFaultyServiceArchives",body_xml,function(){
        wso2.wsf.Util.callbackhelper(this.req.responseXML,"service_faults.xsl",document.getElementById("divFaultyServices"));
    });


}

function deleteFaultyService(faultServicePath) {
    var delete_to = confirm("Do you really want to Delete this Faulty Service ?");
    if (delete_to == true) {
        var body_xml = '<req:deleteFaultyServiceArchiveRequest xmlns:req="http://org.apache.axis2/xsd">\n' +
                       ' <req:archiveName>' + faultServicePath + '</req:archiveName>\n' +
                       ' </req:deleteFaultyServiceArchiveRequest>\n';

        var callURL = serverURL + "/" + "ServiceAdmin" ;
        new wso2.wsf.WSRequest(callURL,"deleteFaultyServiceArchive",body_xml,deleteFaultyServiceCallback);
    } else {
        //        alertMessage("Aborted Deletion.")
        return false;
    }

}

function deleteFaultyServiceCallback() {

    wso2.wsf.Util.cursorWait();
    setTimeout("showAARGenerationCompleteMsg('The Faulty Service has been successfully deleted')",
            1000);
}


// Stub generation
function getClassListFromArchive(archiveId) {
    genFileKey = archiveId;

    var dynamicServiceObj = document.getElementById('divDynamicService');
    wso2.wsf.Util.showOnlyOneMain(dynamicServiceObj);

    var body_xml = '<req:getClassNamesRequest xmlns:req="http://org.apache.axis2/xsd">\n' +
                   ' <req:archiveId>' + genFileKey + '</req:archiveId>\n' +
                   ' </req:getClassNamesRequest>\n';

    var callURL = serverURL + "/" + "ServiceAdmin" ;
    new wso2.wsf.WSRequest(callURL, "getClassNames", body_xml, function() {
        var xslAbsPath = URL + "/extensions/core/xslt/class_selection_wizard.xsl";
        wso2.wsf.Util.callbackhelper(this.req.responseXML, xslAbsPath, document.getElementById("divDynamicService"), false, true);
    });
}

/*Depricated TODO : Remove this method after the QA. Commented out for the time being */
function generateAARSelectClasses() {
    var classes = document.getElementsByName("chkClasses");
    var arrayString = '';
    var isClassSelected = false;
    for (var i = 0; i < classes.length; i++) {
        if (classes[i].checked) {
            isClassSelected = true;
            arrayString += ' <req:serviceClasses>' + classes[i].value + '</req:serviceClasses>\n';
        }
    }
    if (!isClassSelected) {
        wso2.wsf.Util.alertWarning("Please select at least one service class");
        return;
    }

    var body_xml = '<req:createAndDeployServiceRequest xmlns:req="http://org.apache.axis2/xsd">\n' +
                   '<req:archiveId>' + genFileKey + '</req:archiveId>\n' +
                   arrayString +
                   '</req:createAndDeployServiceRequest>\n';

    //    alert(body_xml);
    var callURL = serverURL + "/" + "ServiceAdmin" ;
    new wso2.wsf.WSRequest(callURL,"createAndDeployService",body_xml,completeAARGenerationCB);
}

function generateAARWithSelectedClassesAndMethods(classObj, checkSuffix) {
    var startEle = '<req:createAndDeployServiceWithMethods xmlns:req="http://org.apache.axis2/xsd">\n';
    startEle += '<archiveId>' + genFileKey + '</archiveId>\n';
    for (var clazz in classObj) {
//        alert("clazz: " + clazz + " and " + "classObj[clazz]: " + classObj[clazz]);
        startEle += '<data>\n';
        startEle += '<className><![CDATA[' + classObj[clazz] + ']]></className>\n';
        var checkBoxes = document.getElementsByName(checkSuffix + clazz);
        for (var i = 0 ; i < checkBoxes.length; i++) {
            /*Sending the excluded set*/
            if (!checkBoxes[i].checked) {
                startEle += '<methods>\n';
                startEle += '<methodName><![CDATA[' + checkBoxes[i].value + ']]></methodName>\n';
                startEle += '<overload>false</overload>\n';
                startEle += '</methods>\n';
            }
        }
        startEle += '</data>\n';
    }
    for (var k in jarZipResourceObj) {
        startEle += '<resourceId>'+jarZipResourceObj[k]+'</resourceId>\n';
    }
    startEle += '</req:createAndDeployServiceWithMethods>';
//    alert('startEle == >' + startEle);
    var callURL = serverURL + "/" + "ServiceAdmin" ;
    wso2.wsf.Util.cursorWait();
    new wso2.wsf.WSRequest(callURL,"urn:createAndDeployService",startEle,completeAARGenerationCB);

}

function completeAARGenerationCB() {
    showAARGenerationCompleteMsg("Service configurtaion was successfully uploaded.\n" +
                                 "This page will be auto refreshed shortly.");
}

function pojoArcStepOne() {
    var classes = document.getElementsByName("chkClasses");
    var arrayString = '';
    var isClassSelected = false;
    for (var i = 0; i < classes.length; i++) {
        if (classes[i].checked) {
            isClassSelected = true;
            arrayString += ' <req:serviceClasses>' + classes[i].value + '</req:serviceClasses>\n';
        }
    }
    if (!isClassSelected) {
        wso2.wsf.Util.alertWarning("Please select at least one service class");
        return;
    }

    //Add the resources

    var resources = '';
    for (var k in jarZipResourceObj) {
        resources += '<resourcesId>' +jarZipResourceObj[k]+ '</resourcesId>\n';
    }

    var body_xml = '<req:listMethodsForClass xmlns:req="http://org.apache.axis2/xsd">\n' +
                   arrayString +
                   resources +
                   '</req:listMethodsForClass>\n';

    //    alert(body_xml);
    var callURL = serverURL + "/" + "ServiceAdmin" ;
    new wso2.wsf.WSRequest(callURL,"urn:listMethodsForClass",body_xml,selectOperationsForServices);

}

//TODO
// TODO
// TODO
// TODO
function selectOperationsForServices() {
    wso2.wsf.Util.callbackhelper(this.req.responseXML,"class_method_selection_wizard.xsl",document.getElementById("divClassMethod"));
}


function selectAll(checkboxes, select) {
    for (var i = 0; i < checkboxes.length; i++) {
        checkboxes[i].checked = select;
    }
}

function dynamicClientGeneration() {

    /*var body_xml =  '<req:generateAjaxClient xmlns:req="http://services.codegen.wsas.wso2.org">\n' +
             '<serviceName>' + getServiceSpecificName() + '</serviceName>\n' +
             '</req:generateAjaxClient>\n';

var callURL = serverURL + "/" + "AjaxClientGeneratorService" ;
cursorWait();
send("generateAjaxClient", body_xml, "", callURL, "", false, dynamicClientGenerationCallBack);*/

    /*stopping the refreshing first */
    stoppingRefreshingMethodsHook();

    var body_xml = '<req:generate xmlns:req="http://org.apache.axis2/xsd">\n' +
                   '<serviceName>' + getServiceSpecificName() + '</serviceName>\n' +
                   '</req:generate>\n';

    var callURL = serverURL + "/" + "DynamicCodeGeneratorService" ;
    wso2.wsf.Util.cursorWait();
    new wso2.wsf.WSRequest(callURL,"generate",body_xml,dynamicClientGenerationCallBack);
}

function dynamicClientGenerationCallBack() {

    //response will be a link and it will call the download dialog
    var data = this.req.responseXML;

    var rets = data.getElementsByTagName("return");

    //    alert('return value' + rets[0].firstChild.nodeValue);
    //    dynamicClientResponseVisibility(URL + rets[0].firstChild.nodeValue);
    //    window.location = URL + rets[0].firstChild.nodeValue;
    wso2.wsf.Util.cursorClear();

    dynamicClientResponseVisibilityAllBrowsers(data);
}


function dynamicClientGenerationMetaInfo() {
    var xsltFileName = "";
    var body_xml = '<req:listServicesAndPortsRequest xmlns:req="http://org.apache.axis2/xsd">\n' +
                   '<req:serviceName>' + getServiceSpecificName() + '</req:serviceName>\n' +
                   ' </req:listServicesAndPortsRequest>\n';

    var callURL = serverURL + "/" + "WSDLInfoService" + "/" ;
    new wso2.wsf.WSRequest(callURL,"listServicesAndPorts",body_xml,dynamicClientGenerationMetaInfoCallback);

}

function dynamicClientGenerationMetaInfoCallback() {

    wso2.wsf.Util.callbackhelper(this.req.responseXML,"dynamic_client_meta_info.xsl", document.getElementById("divDynamicClientGeneration"));
    showdynamicClientMetaInfo(document.getElementById('dynamicClientMetaInfo'));
}


function dynamicClientResponseVisibility(url) {
    var objDiv = document.getElementById("divDynamicClientResponse");
    var headerElement = "<h3><a href='#' onClick='javascript:showServiceInitializer(); return false;'>Services</a>&nbsp;&gt;&nbsp;<a href='#' onClick='javascript:listServiceData(\"" +
                        getServiceSpecificName() + "\"); return false;'>" +
                        getServiceSpecificName() + "</a>" + "&nbsp;&gt;&nbsp;Dynamic Client" +
                        "</h3>";
    var dynamicClientInnerFrame = "<div style=\"height:600px;position:relative;\"><form>" +
                                  "<iframe id=\"divDynamicClientResponseInnerFrame\" frameborder=\"0\"  style=\"width:70%;height:100%;position:absolute;\" scrolling=\"auto\"></iframe>" +
                                  "</div>";
    var temp = "<p/>";
    objDiv.innerHTML = headerElement + dynamicClientInnerFrame + temp;
    document.getElementById("divDynamicClientResponseInnerFrame").src = url;

    wso2.wsf.Util.showOnlyOneMain(objDiv);
}


function dynamicClientResponseVisibilityAllBrowsers(data) {

    var xsltFileName = "try_it.xsl";
    var objDiv = document.getElementById('divTryit');
    wso2.wsf.Util.processXML(data, xsltFileName, objDiv);
    wso2.wsf.Util.showOnlyOneMain(objDiv);

}

function wsdlForDynamicClient() {
    window.open("/" + SERVICE_PATH + '/' + getServiceSpecificName() + '?wsdl');
}

function readOnlyServices(thisObj, index) {
    if (thisObj && index) {
        renderSelectedMenuItem(thisObj, index);
        gatherHistoryObject(thisObj.id, index);
    }
    var body_xml = '<ns1:listServiceGroups  xmlns:ns1="http://org.apache.axis2/xsd">\n' +
                   ' </ns1:listServiceGroups>\n';

    var relCallURL = wso2.wsf.Util.getServerURL() + "/GeneralServices";
    new wso2.wsf.WSRequest(relCallURL, "urn:listServiceGroups", body_xml, readOnlyServicesCallback);


}

function readOnlyServicesCallback() {
    var divObject = document.getElementById("divServicesGeneral");
    var xsltHelperObj = new wso2.wsf.XSLTHelper();
    var relXslPath = "extensions/core/xslt/list_general_services.xsl";
    xsltHelperObj.transform(divObject, this.req.responseXML, relXslPath, true, false, [["resourceHTTPEPR",HTTP_URL + "/"]]);
    wso2.wsf.Util.showOnlyOneMain(divObject);

}


function startServices(thisObj, index) {

    if (thisObj && index) {
        renderSelectedMenuItem(thisObj, index);
        gatherHistoryObject(thisObj.id, index);
    }

    showServiceInitializer();
}

function showServiceInitializer() {

    var tmpTransformationNode;

    /* The checking for the existance for window.XMLHttpRequest to figure out the browser
     and the functionality was dropped since the new version of IE has this object. */
    if (wso2.wsf.Util.isIE()) {
        tmpTransformationNode = new ActiveXObject("Microsoft.XmlDom");
        var sXml = "<initializeService></initializeService>";
        tmpTransformationNode.loadXML(sXml);
    } else {
        tmpTransformationNode =
        document.implementation.createDocument("", "initializeService", null);
    }

    var jv ="1.5";
    if (javaVersion.indexOf("1.4") > -1) {
        jv = "1.4";
    }
    var divObject = document.getElementById("divListServiceGroups");
    var xsltHelperObj = new wso2.wsf.XSLTHelper();
    xsltHelperObj.transform(divObject, tmpTransformationNode, "list_services.xsl", false, false, [["conditionalJavaversion",jv],["javaVersion",javaVersion]]);
    wso2.wsf.Util.showOnlyOneMain(document.getElementById("divListServiceGroups"));


    listServiceGroups();
    if (listServiceGroupsRequestInterval == 0) {
        listServiceGroupsRequestInterval = setInterval('listServiceGroups()', SERVICE_REFRESH_TIME);
    }
}

function openWindowHTTP(value) {
    window.open(HTTP_URL + "/" + value);
}


function getExposedTransports(serviceId) {

    /*stopping the refreshing first */
    stoppingRefreshingMethodsHook();

    var body_xml = '<req:getExposedTransportsRequest xmlns:req="http://org.apache.axis2/xsd">\n' +
                   '<serviceId>' + serviceId + '</serviceId>\n' +
                   '</req:getExposedTransportsRequest>\n';

    var callURL = serverURL + "/" + "ServiceAdmin" ;
    new wso2.wsf.WSRequest(callURL,"getExposedTransports",body_xml,getExposedTransportsCallback);

}

function getExposedTransportsCallback() {

    //        alert("Response" + (new XMLSerializer()).serializeToString(getBody(xhReq.responseXML)));
    wso2.wsf.Util.callbackhelper(this.req.responseXML,"list_transport.xsl", document.getElementById("divListTransports"));

    // breadcrumbs setting
    showListTransportDiv(document.getElementById('breadcumbsgetExposedTransportsHeader'));

    listSystemTransports();

}

function listSystemTransports() {

    var body_xml = '<req:listTransportsRequest xmlns:req="http://org.apache.axis2/xsd">\n' +
                   '</req:listTransportsRequest>\n';

    var callURL = serverURL + "/" + "TransportAdmin" ;
    new wso2.wsf.WSRequest(callURL,"listTransports",body_xml,listSystemTransportsCallback);

}

function listSystemTransportsCallback() {
    //    alert("Response" + (new XMLSerializer()).serializeToString(getBody(xhReq.responseXML)));

    var txSelectionCombo = document.getElementById('transportSelectionCombo');

    var data = this.req.responseXML;

    var protocols = data.getElementsByTagName('protocol');

    for (var i = 0; i < protocols.length; i++) {
        txSelectionCombo.options[i] = new
        Option(protocols[i].firstChild.nodeValue);
        txSelectionCombo.options[i].value = protocols[i].firstChild.nodeValue;
    }

}

function addNewTransportForService(obj) {
    //selecting the value from combo
    var protocol = obj[obj.selectedIndex].value;

    var body_xml = '<req:exposeServiceViaTransportRequest xmlns:req="http://org.apache.axis2/xsd">\n' +
                   '<serviceId>' + getServiceSpecificName() + '</serviceId>\n' +
                   '<transportProtocol>' + protocol + '</transportProtocol>\n' +
                   '</req:exposeServiceViaTransportRequest>\n';

    var callURL = serverURL + "/" + "ServiceAdmin" ;
    new wso2.wsf.WSRequest(callURL,"addTransportBinding",body_xml,addNewTransportForServiceCallback);
}

function addNewTransportForServiceCallback() {

    wso2.wsf.Util.showResponseMessage(this.req.responseXML);
    getExposedTransports(getServiceSpecificName());
}

function removeTransportBinding(protocol) {

    var conf = confirm("Do you want to remove the " + protocol +
                       " transport binding for this service?");
    if (!conf) {
        return true;
    }
    var body_xml = '<req:removeTransportBindingRequest xmlns:req="http://org.apache.axis2/xsd">\n' +
                   '<serviceId>' + getServiceSpecificName() + '</serviceId>\n' +
                   '<transportProtocol>' + protocol + '</transportProtocol>\n' +
                   '</req:removeTransportBindingRequest>\n';

    var callURL = serverURL + "/" + "ServiceAdmin" ;
    new wso2.wsf.WSRequest(callURL,"removeTransportBinding",body_xml,removeTransportBindingCallback);
}

function removeTransportBindingCallback() {

    wso2.wsf.Util.showResponseMessage(this.req.responseXML);
    getExposedTransports(getServiceSpecificName());
}

function openExtraWindowHTTPForWebResources(firstValue, lastValue) {

    /*stopping the refreshing first */
    stoppingRefreshingMethodsHook();

    window.open(URL + '/' + firstValue + "/" + lastValue);
}

var SPRING_BEANS_UUID;
var SPRING_CONTEXT_UUID;
function getSpringBeansFromArchive(springBeansUUID, springContextUUID) {
    SPRING_BEANS_UUID = springBeansUUID;
    SPRING_CONTEXT_UUID = springContextUUID;
    var body_xml = '<req:getSpringBeanNames xmlns:req="http://org.apache.axis2/xsd">\n' +
                   '<springContextId>' + springContextUUID + '</springContextId>\n' +
                   '<springBeanId>' + springBeansUUID + '</springBeanId>\n' +
                   '</req:getSpringBeanNames>\n';

    var callURL = serverURL + "/" + "ServiceAdmin" ;
    new wso2.wsf.WSRequest(callURL,"getSpringBeanNames",body_xml,getSpringBeansFromArchiveCallback);

}

function getSpringBeansFromArchiveCallback() {
    var xslAbsPath = URL + "/extensions/core/xslt/spring_beans_selection_wizard.xsl";
    wso2.wsf.Util.callbackhelper(this.req.responseXML,xslAbsPath, document.getElementById("divBeanGenerationWizard"),false,true);
}

function generateBeansForAARSelectClasses(uuid) {
    var classes = document.getElementsByName("chkBeans");
    var arrayString = '';
    var isClassSelected = false;
    for (var i = 0; i < classes.length; i++) {
        if (classes[i].checked) {
            isClassSelected = true;
            arrayString += ' <beanClasses>' + classes[i].value + '</beanClasses>\n';
        }
    }
    if (!isClassSelected) {
        wso2.wsf.Util.alertWarning("Please select at least one Spring bean");
        return;
    }

    var body_xml = '<req:createAndDeploySpringBean xmlns:req="http://org.apache.axis2/xsd">\n' +
                   '<springContextId>' + uuid + '</springContextId>\n' +
                   '<springBeanId>' + SPRING_BEANS_UUID + '</springBeanId>\n' +
                   arrayString +
                   '</req:createAndDeploySpringBean>\n';

    //    alert(body_xml);
    var callURL = serverURL + "/" + "ServiceAdmin" ;
    new wso2.wsf.WSRequest(callURL,"createAndDeploySpringBean",body_xml,completeAARGenerationCB);
}

function codegenUnwrappingSelectorHelper(obj) {
    var uwSelect = document.getElementById('unwrap');
    uwSelect.options.length = 0;
    var selection = obj.options[obj.selectedIndex].value;
    if (selection == "none" || selection == "xmlbeans") {
        uwSelect.options[0] = new Option('False','false');
    } else {
        uwSelect.options[0] = new Option('False','false');
        uwSelect.options[1] = new Option('True','true');
    }
}

function getEJBRemoteInterfaceClassListFromArchive(archiveId) {
    genFileKey = archiveId;

    var dynamicServiceObj = document.getElementById('divDynamicService');
    wso2.wsf.Util.showOnlyOneMain(dynamicServiceObj);

    var body_xml = '<req:getClassNamesRequest xmlns:req="http://org.apache.axis2/xsd">\n' +
                   ' <req:archiveId>' + genFileKey + '</req:archiveId>\n' +
                   ' </req:getClassNamesRequest>\n';

    var callURL = serverURL + "/" + "ServiceAdmin" ;
    new wso2.wsf.WSRequest(callURL, "getClassNames", body_xml, function() {
        var xslAbsPath = URL + "/extensions/core/xslt/ejb_provider_wizard_step2.xsl";
        wso2.wsf.Util.callbackhelper(this.req.responseXML, xslAbsPath, document.getElementById("divDynamicService"), false, true);

    });
}

//functions to call different type of service creation screens
/**
 * @param xslFileName name of the xsl file.
 */
function showPOJOArchieveUploadScreen(xslFileName) {
    var tmpTransformationNode;
    if (window.XMLHttpRequest && !wso2.wsf.Util.isIE()) {
        tmpTransformationNode =
        document.implementation.createDocument("", "serviceUploadTemplate", null);
    } else if (window.ActiveXObject) {
        tmpTransformationNode = new ActiveXObject("Microsoft.XmlDom");
        var sXml = "<serviceUploadTemplate></serviceUploadTemplate>";
        tmpTransformationNode.loadXML(sXml);
    }
    var objDiv = document.getElementById("divNewPOJOService");
    wso2.wsf.Util.processXML(tmpTransformationNode, xslFileName, objDiv);
    wso2.wsf.Util.showOnlyOneMain(objDiv);
}


function showSpringArchieveUploadScreen() {
    var tmpTransformationNode;
    if (window.XMLHttpRequest && !wso2.wsf.Util.isIE()) {
        tmpTransformationNode =
        document.implementation.createDocument("", "springServiceUploadTemplate", null);
    } else if (window.ActiveXObject) {
        tmpTransformationNode = new ActiveXObject("Microsoft.XmlDom");
        var sXml = "<springServiceUploadTemplate></springServiceUploadTemplate>";
        tmpTransformationNode.loadXML(sXml);
    }
    var objDiv = document.getElementById("divNewSpringService");
    wso2.wsf.Util.processXML(tmpTransformationNode, "add_new_spring_service.xsl", objDiv);
    wso2.wsf.Util.showOnlyOneMain(objDiv);
}

function sortOperationsByName() {
	var table = document.getElementById("published_operations_table");
	var tBody = document.getElementById("published_operations_table_body");
	var rows = tBody.childNodes;
	for(var index = 0; index < row.length; index ++) {
			
	}
}

/**
 * This method will be used, when wsdd need to upload to create an Axis1 service ontop of Axis2
 * environment.
 */
function showAxis1WSDDUploadScreen() {
    var tmpTransformationNode;
    if (window.XMLHttpRequest && !wso2.wsf.Util.isIE()) {
        tmpTransformationNode =
        document.implementation.createDocument("", "wsddUploadTemplate", null);
    } else if (window.ActiveXObject) {
        tmpTransformationNode = new ActiveXObject("Microsoft.XmlDom");
        var sXml = "<wsddUploadTemplate></wsddUploadTemplate>";
        tmpTransformationNode.loadXML(sXml);
    }
    var objDiv = document.getElementById("divNewAxis1Service");
    wso2.wsf.Util.processXML(tmpTransformationNode, "add_new_axis1_service.xsl", objDiv);
    wso2.wsf.Util.showOnlyOneMain(objDiv);

}

/**
 * This method will dynamically add a file uplod input element to the given objDiv.
 * @param objDiv
 */
function addLibraryFileuplod(objDiv) {
    var blankLabelElem = document.createElement('label');
    blankLabelElem.innerHTML = "&nbsp;";
    var elem = document.createElement('input');
    var brElem = document.createElement('br');
    var nameAttr = document.createAttribute('name');
    nameAttr.value = "jarResource";
    var sizeAttr = document.createAttribute('size');
    sizeAttr.value = "50";
    var typeAttr = document.createAttribute('type');
    typeAttr.value = "file";
    elem.attributes.setNamedItem(nameAttr);
    elem.attributes.setNamedItem(sizeAttr);
    elem.attributes.setNamedItem(typeAttr);
    objDiv.appendChild(brElem);
    objDiv.appendChild(blankLabelElem);
    objDiv.appendChild(elem);
}
