@echo off

REM ---------------------------------------------------------------------------
REM  Copyright 2005,2006 WSO2, Inc. http://www.wso2.org
REM
REM  Licensed under the Apache License, Version 2.0 (the "License");
REM  you may not use this file except in compliance with the License.
REM  You may obtain a copy of the License at
REM
REM      http://www.apache.org/licenses/LICENSE-2.0  
REM
REM  Unless required by applicable law or agreed to in writing, software
REM  distributed under the License is distributed on an "AS IS" BASIS,
REM  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
REM  See the License for the specific language governing permissions and
REM  limitations under the License.

rem ---------------------------------------------------------------------------
rem Main Script for the WSO2 Web Services Application Server v2.2-RC1
rem
rem Environment Variable Prequisites
rem
rem   WSO2WSAS_HOME   Home of WSO2 WSAS installation. If not set I will  try
rem                   to figure it out.
rem
rem   JAVA_HOME       Must point at your Java Development Kit installation.
rem
rem   JAVA_OPTS       (Optional) Java runtime options used when the commands
rem                   is executed. 
rem ---------------------------------------------------------------------------

rem ----- if JAVA_HOME is not set we're not happy ------------------------------
:checkJava

if "%JAVA_HOME%" == "" goto noJavaHome
if not exist "%JAVA_HOME%\bin\java.exe" goto noJavaHome
goto checkServer

:noJavaHome
echo "You must set the JAVA_HOME variable before running WSO2 WSAS."
goto end

rem ----- Only set WSO2WSAS_HOME if not already set ----------------------------
:checkServer
rem %~sdp0 is expanded pathname of the current script under NT with spaces in the path removed
if "%WSO2WSAS_HOME%"=="" set WSO2WSAS_HOME=%~sdp0..
SET curDrive=%cd:~0,1%
SET wsasDrive=%WSO2WSAS_HOME:~0,1%
if not "%curDrive%" == "%wsasDrive%" %wsasDrive%:

rem find WSO2WSAS_HOME if it does not exist due to either an invalid value passed
rem by the user or the %0 problem on Windows 9x
if not exist "%WSO2WSAS_HOME%\bin\version.txt" goto noServerHome

set AXIS2_HOME=%WSO2WSAS_HOME%
goto updateClasspath

:noServerHome
echo WSO2WSAS_HOME is set incorrectly or WSO2 WSAS could not be located. Please set WSO2WSAS_HOME.
goto end

rem ----- update classpath -----------------------------------------------------
:updateClasspath

setlocal EnableDelayedExpansion
cd %WSO2WSAS_HOME%
set WSO2WSAS_CLASSPATH=.\conf
FOR %%C in ("%WSO2WSAS_HOME%\lib\*.jar") DO set WSO2WSAS_CLASSPATH=!WSO2WSAS_CLASSPATH!;".\lib\%%~nC%%~xC"

set WSO2WSAS_CLASSPATH="%JAVA_HOME%\lib\tools.jar";%WSO2WSAS_CLASSPATH%;

rem ----- Process the input command -------------------------------------------

rem Slurp the command line arguments. This loop allows for an unlimited number
rem of arguments (up to the command line limit, anyway).

set CMD=RUN

:setupArgs
if ""%1""=="""" goto doneStart
if ""%1""==""-start""   goto commandLifecycle
if ""%1""==""--start""   goto commandLifecycle
if ""%1""==""start""   goto commandLifecycle

if ""%1""==""-run""     goto commandLifecycle
if ""%1""==""--run""     goto commandLifecycle
if ""%1""==""run""     goto commandLifecycle

if ""%1""==""-restart"" goto commandLifecycle
if ""%1""==""--restart"" goto commandLifecycle
if ""%1""==""restart"" goto commandLifecycle

if ""%1""==""-stop""    goto commandLifecycle
if ""%1""==""--stop""    goto commandLifecycle
if ""%1""==""stop""    goto commandLifecycle

if ""%1""==""debug""    goto commandDebug
if ""%1""==""-debug""   goto commandDebug
if ""%1""==""--debug""  goto commandDebug

if ""%1""==""version"" goto commandVersion
if ""%1""==""-version"" goto commandVersion
if ""%1""==""--version"" goto commandVersion

if ""%1""==""help""     goto getHelp
if ""%1""==""-help""    goto getHelp
if ""%1""==""--help""   goto getHelp
if ""%1""==""?""        goto getHelp
if ""%1""==""-?""       goto getHelp

shift
goto setupArgs

rem ----- commandVersion -------------------------------------------------------
:commandVersion
shift
echo WSO2 WSAS v2.2-RC1
goto end

rem ----- commandDebug ---------------------------------------------------------
:commandDebug
shift
set DEBUG_PORT=%1
if "%DEBUG_PORT%"=="" goto noDebugPort
set JAVA_OPTS=-Xdebug -Xnoagent -Djava.compiler=NONE -Xrunjdwp:transport=dt_socket,server=y,suspend=n,address=%DEBUG_PORT%
goto findJdk

:noDebugPort
echo Please specify the debug port after the --debug option
goto end

rem ----- commandLifecycle -----------------------------------------------------
:commandLifecycle
set CMD=%1
goto findJdk

rem ----- getHelp --------------------------------------------------------------
:getHelp
  echo Usage: wso2wsas.bat [command]
  echo command:
  echo   --start        Start WSO2 WSAS as a background process
  echo   --run          Run WSO2 WSAS
  echo   --restart      Restart WSO2 WSAS
  echo   --stop         Stop WSO2 WSAS
  echo   --debug        Start WSO2 WSAS in remote debugging mode. You need to specify the debugging port after this argument.
  echo   --version      What version of WSO2 WSAS are you running?
goto end

rem ----- doneStart ------------------------------------------------------------
rem This label provides a place for the argument list loop to break out
rem and for NT handling to skip to.

:doneStart
if "%OS%"=="Windows_NT" @setlocal
if "%OS%"=="WINNT" @setlocal

rem ---------- Handle the SSL Issue with proper JDK version --------------------
rem find the version of the jdk
:findJdk

"%JAVA_HOME%\bin\java" -version 2>&1 | findstr "1.4" >NUL
IF ERRORLEVEL 1 goto checkJdk15
goto jdk14

:checkJdk15
"%JAVA_HOME%\bin\java" -version 2>&1 | findstr "1.5" >NUL
IF ERRORLEVEL 1 goto checkJdk16
goto jdk15

:checkJdk16
"%JAVA_HOME%\bin\java" -version 2>&1 | findstr "1.6" >NUL
IF ERRORLEVEL 1 goto unknownJdk
goto jdk16

:unknownJdk
echo Starting WSO2 Web Services Application Server v2.2-RC1 (in unsupported JDK)
echo [ERROR] WSO2 WSAS is supported only on JDK 1.4 and higher
goto end

:jdk14
  set WSO2WSAS_CLASSPATH="%WSO2WSAS_HOME%\lib\bcprov-jdk13-132.jar";%WSO2WSAS_CLASSPATH%
	goto runServer
:jdk15
  set WSO2WSAS_CLASSPATH="%WSO2WSAS_HOME%\lib\bcprov-jdk15-132.jar";%WSO2WSAS_CLASSPATH%
	goto runServer
:jdk16
  echo [WARNING] WSO2 WSAS has not been fully tested on JDK 1.6
  set WSO2WSAS_CLASSPATH="%WSO2WSAS_HOME%\lib\bcprov-jdk15-132.jar";%WSO2WSAS_CLASSPATH%
	goto runServer

rem ----------------- Execute The Requested Command ----------------------------

:runServer
cd %WSO2WSAS_HOME%

rem ---------- Add jar files inside patches folder to classpath ----------------
FOR %%C in ("%WSO2WSAS_HOME%\lib\patches\*.jar") DO set WSO2WSAS_PATCH_CLASSPATH=!WSO2WSAS_PATCH_CLASSPATH!;".\lib\patches\%%~nC%%~xC"

set WSO2WSAS_CLASSPATH=.\lib\patches;%WSO2WSAS_PATCH_CLASSPATH%;.\conf;%WSO2WSAS_CLASSPATH%


set JAVA_ENDORSED=".\lib\endorsed";"%JAVA_HOME%\jre\lib\endorsed";"%JAVA_HOME%\lib\endorsed"

if ""%1""==""-start""   goto startNewPrompt
if ""%1""==""--start""   goto startNewPrompt
if ""%1""==""start""   goto startNewPrompt

"%JAVA_HOME%\bin\java" -server  -Xms512m -Xmx1024m -Dcom.sun.management.jmxremote -classpath %WSO2WSAS_CLASSPATH% %JAVA_OPTS% -Djava.endorsed.dirs=%JAVA_ENDORSED% -Dwso2wsas.home="%WSO2WSAS_HOME%" -Djava.io.tmpdir="%WSO2WSAS_HOME%\tmp" -Dwso2wsas.server.xml=%WSO2WSAS_HOME%\conf\server.xml org.wso2.wsas.Main %CMD%

:end
goto endlocal

:startNewPrompt
rem start "Web Services Application Server" 
"%JAVA_HOME%\bin\java" -server -Xms512m -Xmx1024m -Dcom.sun.management.jmxremote -classpath %WSO2WSAS_CLASSPATH% %JAVA_OPTS% -Djava.endorsed.dirs=%JAVA_ENDORSED% -Djava.io.tmpdir="%WSO2WSAS_HOME%\tmp" -Dwso2wsas.home="%WSO2WSAS_HOME%" -Dwso2wsas.server.xml=%WSO2WSAS_HOME%\conf\server.xml org.wso2.wsas.Main %CMD%
if not "%curDrive%" == "%wsasDrive%" %curDrive%:

:endlocal


