#!/bin/sh
# ----------------------------------------------------------------------------
#  Copyright 2005,2006 WSO2, Inc. http://www.wso2.org
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.

# ----------------------------------------------------------------------------
# Startup Script for WSO2 WSAS
#
# Environment Variable Prequisites
#
#   WSO2WSAS_HOME   Home of WSO2 WSAS installation. If not set I will  try
#                   to figure it out.
#
#   JAVA_HOME       Must point at your Java Development Kit installation.
#
#   JAVA_OPTS       (Optional) Java runtime options used when the commands
#                   is executed.
#
# NOTE: Borrowed generously from Apache Tomcat startup scripts.
# -----------------------------------------------------------------------------

DARWIN_TOOLS=""
# OS specific support.  $var _must_ be set to either true or false.
cygwin=false;
darwin=false;
os400=false;
mingw=false;
case "`uname`" in
CYGWIN*) cygwin=true;;
MINGW*) mingw=true;;
OS400*) os400=true;;
Darwin*) darwin=true
        if [ -z "$JAVA_VERSION" ] ; then
             JAVA_VERSION="CurrentJDK"
           else
             echo "Using Java version: $JAVA_VERSION"
           fi
           if [ -z "$JAVA_HOME" ] ; then
             JAVA_HOME=/System/Library/Frameworks/JavaVM.framework/Versions/${JAVA_VERSION}/Home
             DARWIN_TOOLS=$JAVA_HOME/Classes/Classes.jar
           fi
           ;;
esac

# resolve links - $0 may be a softlink
PRG="$0"

while [ -h "$PRG" ]; do
  ls=`ls -ld "$PRG"`
  link=`expr "$ls" : '.*-> \(.*\)$'`
  if expr "$link" : '.*/.*' > /dev/null; then
    PRG="$link"
  else
    PRG=`dirname "$PRG"`/"$link"
  fi
done

# Get standard environment variables
PRGDIR=`dirname "$PRG"`

# Only set WSO2WSAS_HOME if not already set
[ -z "$WSO2WSAS_HOME" ] && WSO2WSAS_HOME=`cd "$PRGDIR/.." ; pwd`

# Set AXIS2_HOME. Needed for One Click JAR Download
AXIS2_HOME=$WSO2WSAS_HOME

# For Cygwin, ensure paths are in UNIX format before anything is touched
if $cygwin; then
  [ -n "$JAVA_HOME" ] && JAVA_HOME=`cygpath --unix "$JAVA_HOME"`
  [ -n "$WSO2WSAS_HOME" ] && WSO2WSAS_HOME=`cygpath --unix "$WSO2WSAS_HOME"`
  [ -n "$AXIS2_HOME" ] && WSO2WSAS_HOME=`cygpath --unix "$WSO2WSAS_HOME"`
  [ -n "$CLASSPATH" ] && CLASSPATH=`cygpath --path --unix "$CLASSPATH"`
fi

# For OS400
if $os400; then
  # Set job priority to standard for interactive (interactive - 6) by using
  # the interactive priority - 6, the helper threads that respond to requests
  # will be running at the same priority as interactive jobs.
  COMMAND='chgjob job('$JOBNAME') runpty(6)'
  system $COMMAND

  # Enable multi threading
  QIBM_MULTI_THREADED=Y
  export QIBM_MULTI_THREADED
fi

# For Migwn, ensure paths are in UNIX format before anything is touched
if $mingw ; then
  [ -n "$WSO2WSAS_HOME" ] &&
    WSO2WSAS_HOME="`(cd "$WSO2WSAS_HOME"; pwd)`"
  [ -n "$JAVA_HOME" ] &&
    JAVA_HOME="`(cd "$JAVA_HOME"; pwd)`"
  [ -n "$AXIS2_HOME" ] &&
    WSO2WSAS_HOME="`(cd "$WSO2WSAS_HOME"; pwd)`"
  # TODO classpath?
fi

if [ -z "$JAVACMD" ] ; then
  if [ -n "$JAVA_HOME"  ] ; then
    if [ -x "$JAVA_HOME/jre/sh/java" ] ; then
      # IBM's JDK on AIX uses strange locations for the executables
      JAVACMD="$JAVA_HOME/jre/sh/java"
    else
      JAVACMD="$JAVA_HOME/bin/java"
    fi
  else
    JAVACMD=java
  fi
fi

if [ ! -x "$JAVACMD" ] ; then
  echo "Error: JAVA_HOME is not defined correctly."
  echo " WSO2 WSAS cannot execute $JAVACMD"
  exit 1
fi

# if JAVA_HOME is not set we're not happy
if [ -z "$JAVA_HOME" ]; then
  echo "You must set the JAVA_HOME variable before running WSO2 WSAS."
  exit 1
fi

# update classpath
WSO2WSAS_CLASSPATH=""
for f in "$WSO2WSAS_HOME"/lib/*.jar
do
  WSO2WSAS_CLASSPATH="$WSO2WSAS_CLASSPATH":$f
done
WSO2WSAS_CLASSPATH="$JAVA_HOME/lib/tools.jar":"$WSO2WSAS_CLASSPATH":"$CLASSPATH":"$DARWIN_TOOLS"

# For Cygwin, switch paths to Windows format before running java
if $cygwin; then
  JAVA_HOME=`cygpath --absolute --windows "$JAVA_HOME"`
  WSO2WSAS_HOME=`cygpath --absolute --windows "$WSO2WSAS_HOME"`
  AXIS2_HOME=`cygpath --absolute --windows "$WSO2WSAS_HOME"`
  CLASSPATH=`cygpath --path --windows "$CLASSPATH"`
  JAVA_ENDORSED_DIRS=`cygpath --path --windows "$JAVA_ENDORSED_DIRS"`
fi

# ---------- Handle the SSL Issue with proper JDK version --------------------
jdk_15=`$JAVA_HOME/bin/java -version 2>&1 | grep 1.5`
jdk_16=`$JAVA_HOME/bin/java -version 2>&1 | grep 1.6`
jdk_14=`$JAVA_HOME/bin/java -version 2>&1 | grep 1.4`

if [ "$jdk_15" ]; then
   echo " Starting WSO2 Web Services Application Server v2.2-RC1 (in JDK 1.5)"
   WSO2WSAS_CLASSPATH="$WSO2WSAS_HOME/lib/bcprov-jdk15-132.jar":$WSO2WSAS_CLASSPATH
elif [ "$jdk_14" ]; then
   echo " Starting WSO2 Web Services Application Server v2.2-RC1 (in JDK 1.4)"
   WSO2WSAS_CLASSPATH="$WSO2WSAS_HOME/lib/bcprov-jdk13-132.jar":$WSO2WSAS_CLASSPATH
elif [ "$jdk_16" ]; then
   echo " Starting WSO2 Web Services Application Server v2.2-RC1 (in JDK 1.6)"
   echo " [WARNING] WSO2 WSAS has not been fully tested on JDK 1.6"
   WSO2WSAS_CLASSPATH="$WSO2WSAS_HOME/lib/bcprov-jdk15-132.jar":$WSO2WSAS_CLASSPATH
else
   echo " Starting WSO2 Web Services Application Server v2.2-RC1 (in unsupported JDK)"
   echo " [ERROR] WSO2 WSAS is supported only on JDK 1.4 and higher"
   exit 1
fi

#---------- Add jar files inside patches folder to classpath ------------------
WSO2WSAS_PATCH_CLASSPATH=""
for f in "$WSO2WSAS_HOME"/lib/patches/*.jar
do
  WSO2WSAS_PATCH_CLASSPATH="$WSO2WSAS_PATCH_CLASSPATH":$f
done

WSO2WSAS_CLASSPATH="$WSO2WSAS_HOME/lib/patches":"$WSO2WSAS_PATCH_CLASSPATH":"$WSO2WSAS_HOME/conf":"$WSO2WSAS_CLASSPATH"

# ----- Execute The Requested Command -----------------------------------------

cd "$WSO2WSAS_HOME"
echo " Using WSO2WSAS_HOME:   $WSO2WSAS_HOME"
echo " Using JAVA_HOME:       $JAVA_HOME"
echo " Start signal posted to WSO2 WSAS."
echo " Please check the server's log file for startup status."

exec "$JAVACMD" \
$JAVA_OPTS \
-server \
-Xms512m -Xmx1024m \
-Dcom.sun.management.jmxremote \
-classpath "$WSO2WSAS_CLASSPATH" \
-Djava.endorsed.dirs="$WSO2WSAS_HOME/lib/endorsed":"$JAVA_HOME/jre/lib/endorsed":"$JAVA_HOME/lib/endorsed" \
-Djava.io.tmpdir="$WSO2WSAS_HOME/tmp" \
-Dwso2wsas.home="$WSO2WSAS_HOME" -Dwso2wsas.server.xml="$WSO2WSAS_HOME/conf/server.xml" org.wso2.wsas.Main \
start  >> "$WSO2WSAS_HOME"/logs/wsas.out 2>&1 &
