@echo off

rem ---------------------------------------------------------------------------
rem Scipt for changing the password of a WSO2 WSAS user
rem
rem Environment Variable Prequisites
rem
rem
rem   WSO2WSAS_HOME  	Home of WSO2 WSAS installation. If not set I will  try
rem                    			to figure it out.
rem   JAVA_HOME       Must point at your Java Development Kit installation.
rem
rem   JAVA_OPTS       (Optional) Java runtime options 
rem  NOTE: Borrowed generously from Apache Tomcat startup scripts.
rem ---------------------------------------------------------------------------

rem if JAVA_HOME is not set we're not happy
set CURRENT_DIR=%cd%

rem Make sure prerequisite environment variables are set
if not "%JAVA_HOME%" == "" goto gotJavaHome
echo The JAVA_HOME environment variable is not defined
echo This environment variable is needed to run this program
goto end
:gotJavaHome
if not exist "%JAVA_HOME%\bin\java.exe" goto noJavaHome
goto okJavaHome
:noJavaHome
echo The JAVA_HOME environment variable is not defined correctly
echo This environment variable is needed to run this program
echo NB: JAVA_HOME should point to a JDK/JRE
goto end
:okJavaHome

set CURRENT_DIR = %cd%
rem check the WSO2WSAS_HOME environment variable
if not "%WSO2WSAS_HOME%" == "" goto gotHome
set WSO2WSAS_HOME=%CURRENT_DIR%
if exist "%WSO2WSAS_HOME\bin\admin.bat" goto okHome

rem guess the home. Jump one directory up to check if that is the home
cd ..
set WSO2WSAS_HOME=%cd%
cd %CURRENT_DIR% >> NULL

:gotHome
if not exist "%WSO2WSAS_HOME%\bin\admin.bat" goto pathError

SET curDrive=%cd:~0,1%
SET wsasDrive=%WSO2WSAS_HOME:~0,1%
if not "%curDrive%" == "%wsasDrive%" %wsasDrive%:

goto okHome

set WSO2WSAS_HOME=%~dp0..
if exist "%WSO2WSAS_HOME%\bin\admin.bat" goto okHome

:pathError
echo The WSO2WSAS_HOME environment variable is not defined correctly
echo This environment variable is needed to run this program
goto end

:okHome
setlocal EnableDelayedExpansion

rem loop through the libs and add them to the class path
cd %WSO2WSAS_HOME%\bin
set WSO2WSAS_CLASSPATH=%WSO2WSAS_HOME%
FOR %%C in ("%WSO2WSAS_HOME%\lib\*.jar") DO set WSO2WSAS_CLASSPATH=!WSO2WSAS_CLASSPATH!;../lib/%%~nC%%~xC
set WSO2WSAS_CLASSPATH=%WSO2WSAS_HOME%\conf;%WSO2WSAS_CLASSPATH%
rem ----- Execute The Requested Command ---------------------------------------
set _RUNJAVA="%JAVA_HOME%\bin\java"

%_RUNJAVA% %JAVA_OPTS% -cp "%WSO2WSAS_CLASSPATH%" org.wso2.wsas.clustering.NodeManagerClient %*
endlocal
if not "%curDrive%" == "%wsasDrive%" %curDrive%:
:end