/*
 * Decompiled with CFR 0.152.
 */
package mx4j.server.interceptor;

import java.util.HashMap;
import javax.management.ListenerNotFoundException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import mx4j.server.MBeanMetaData;
import mx4j.server.interceptor.DefaultMBeanServerInterceptor;

public class NotificationListenerMBeanServerInterceptor
extends DefaultMBeanServerInterceptor {
    private HashMap m_listeners = new HashMap();

    public String getType() {
        return "notificationlistener";
    }

    public void addNotificationListener(MBeanMetaData metadata, NotificationListener listener, NotificationFilter filter, Object handback) {
        if (!this.isEnabled()) {
            super.addNotificationListener(metadata, listener, filter, handback);
        }
        ListenerWrapper wrapper = listener == null ? null : new ListenerWrapper(listener, metadata.name);
        super.addNotificationListener(metadata, wrapper, filter, handback);
        HashMap hashMap = this.m_listeners;
        synchronized (hashMap) {
            this.m_listeners.put(listener, wrapper);
        }
    }

    public void removeNotificationListener(MBeanMetaData metadata, NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        if (!this.isEnabled()) {
            super.removeNotificationListener(metadata, listener, filter, handback);
        }
        HashMap hashMap = this.m_listeners;
        synchronized (hashMap) {
            ListenerWrapper wrapper = (ListenerWrapper)this.m_listeners.get(listener);
            if (wrapper == null) {
                throw new ListenerNotFoundException("Listener not found: " + listener);
            }
            super.removeNotificationListener(metadata, wrapper, filter, handback);
            this.m_listeners.remove(listener);
        }
    }

    private static class ListenerWrapper
    implements NotificationListener {
        private NotificationListener m_listener;
        private ObjectName m_objectName;

        private ListenerWrapper(NotificationListener listener, ObjectName name) {
            this.m_listener = listener;
            this.m_objectName = name;
        }

        public void handleNotification(Notification notification, Object handback) {
            Object source = notification.getSource();
            try {
                notification.setSource(this.m_objectName);
                this.m_listener.handleNotification(notification, handback);
                Object var5_4 = null;
                notification.setSource(source);
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                notification.setSource(source);
                throw throwable;
            }
        }
    }
}

