/*
 * Decompiled with CFR 0.152.
 */
package mx4j.loading;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.management.ObjectName;

public class MLetTag {
    private String m_code;
    private String m_object;
    private ArrayList m_archives = new ArrayList();
    private String m_codebase;
    private ObjectName m_name;
    private String m_version;
    private ArrayList m_types = new ArrayList();
    private ArrayList m_values = new ArrayList();

    public URL[] getURLs(String defaultCodeBase) {
        ArrayList archives = this.getArchives();
        ArrayList<URL> urls = new ArrayList<URL>();
        int i = 0;
        while (i < archives.size()) {
            String archive = (String)archives.get(i);
            URL url = this.createArchiveURL(defaultCodeBase, archive);
            if (url != null) {
                urls.add(url);
            }
            ++i;
        }
        return urls.toArray(new URL[urls.size()]);
    }

    private URL createArchiveURL(String defaultCodebase, String archive) {
        String codebase = this.getCodeBase();
        String url = (codebase == null ? defaultCodebase : codebase) + archive;
        try {
            return new URL(url);
        }
        catch (MalformedURLException ignored) {
            File f = new File(url);
            if (f.exists()) {
                try {
                    return f.toURL();
                }
                catch (MalformedURLException ignored2) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    private String getCodeBase() {
        return this.m_codebase;
    }

    private ArrayList getArchives() {
        return this.m_archives;
    }

    public String getCode() {
        return this.m_code;
    }

    public ObjectName getObjectName() {
        return this.m_name;
    }

    public String getObject() {
        return this.m_object;
    }

    public String[] getSignature() {
        return this.m_types == null ? new String[]{} : this.m_types.toArray(new String[this.m_types.size()]);
    }

    public Object[] getArguments() {
        return this.m_values == null ? new Object[]{} : this.m_values.toArray(new Object[this.m_values.size()]);
    }

    void setArchive(String archive) {
        StringTokenizer tokenizer = new StringTokenizer(archive, ",");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken().trim();
            if (token.length() <= 0) continue;
            token.replace('\\', '/');
            this.m_archives.add(token);
        }
    }

    void setCode(String code) {
        this.m_code = code;
    }

    void setCodeBase(String codebase) {
        if (!(codebase = codebase.replace('\\', '/')).endsWith("/")) {
            codebase = codebase + "/";
        }
        this.m_codebase = codebase;
    }

    void setName(ObjectName name) {
        this.m_name = name;
    }

    void setObject(String object) {
        this.m_object = object;
    }

    void setVersion(String version) {
        this.m_version = version;
    }

    void addArg(String type, Object value) {
        this.m_types.add(type);
        this.m_values.add(value);
    }
}

