/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsf.ide.consumption.ui.preferences;

import java.io.File;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.wso2.wsf.ide.core.context.WSASEmitterContext;
import org.wso2.wsf.ide.core.context.WSASEmitterDefaults;
import org.wso2.wsf.ide.core.plugin.WebServiceWSASCorePlugin;
import org.wso2.wsf.ide.core.plugin.data.ServerModel;
import org.wso2.wsf.ide.core.plugin.messages.WSASCoreUIMessages;
import org.wso2.wsf.ide.core.utils.RuntimePropertyUtils;
import org.wso2.wsf.ide.core.utils.WSASCoreUtils;

public class WSASRuntimePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button browseButton;
    private Text wsasPath;
    private Text debugHostText;
    private Text debugPortText;
    private Label statusLabel;
    private IStatus status = Status.OK_STATUS;
    private boolean webappExist = false;
    private String statusBanner = null;
    WSASEmitterContext context;
    Combo serviceDatabindingCombo;
    Button generateServerSideInterfaceCheckBoxButton;
    Button generateAllCheckBoxButton;
    Combo clientDatabindingCombo;
    Button syncAndAsyncRadioButton;
    Button syncOnlyRadioButton;
    Button asyncOnlyRadioButton;
    Combo aarExtensionCombo;
    Button clientGenerateAllCheckBoxButton;
    Button clientUnpackClassesCheckBoxButton;
    Button clientTestCaseCheckBoxButton;

    protected Control createContents(Composite superparent) {
        this.status = Status.OK_STATUS;
        this.context = WebServiceWSASCorePlugin.getDefault().getWSASEmitterContext();
        final Composite mainComp = new Composite(superparent, 0);
        mainComp.setLayout((Layout)new GridLayout());
        mainComp.setLayoutData((Object)new GridData(1808));
        TabFolder wsasPreferenceTab = new TabFolder(mainComp, 0);
        wsasPreferenceTab.setLayoutData((Object)new GridData(1808));
        TabItem runtimeInstalLocationItem = new TabItem(wsasPreferenceTab, 0);
        runtimeInstalLocationItem.setText(WSASCoreUIMessages.WSAS_RUNTIME);
        runtimeInstalLocationItem.setToolTipText(WSASCoreUIMessages.WSAS_RUNTIME_TOOLTIP);
        Composite runtimeGroup = new Composite((Composite)wsasPreferenceTab, 0);
        runtimeInstalLocationItem.setControl((Control)runtimeGroup);
        runtimeGroup.setToolTipText(WSASCoreUIMessages.WSAS_RUNTIME_TOOLTIP);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 10;
        runtimeGroup.setLayout((Layout)layout);
        runtimeGroup.setLayoutData((Object)new GridData(1808));
        Label label = new Label(runtimeGroup, 0);
        label.setText(WSASCoreUIMessages.WSAS_LOCATION);
        this.wsasPath = new Text(runtimeGroup, 2048);
        String serverPath = null;
        if (this.context.getWSASRuntimeLocation() != null) {
            serverPath = this.context.getWSASRuntimeLocation();
            this.wsasPath.setText(serverPath);
        }
        this.webappExist = this.runtimeExist(serverPath);
        GridData gd = new GridData(768);
        gd.minimumWidth = 40;
        this.wsasPath.setLayoutData((Object)gd);
        this.wsasPath.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WSASRuntimePreferencePage.this.context.setWSASRuntimeLocation(WSASRuntimePreferencePage.this.wsasPath.getText());
                WSASRuntimePreferencePage.this.webappExist = WSASRuntimePreferencePage.this.runtimeExist(WSASRuntimePreferencePage.this.wsasPath.getText());
                WSASRuntimePreferencePage.this.context.setCorrectWSASPathSet(WSASRuntimePreferencePage.this.webappExist);
                WSASRuntimePreferencePage.this.status = RuntimePropertyUtils.writeServerPathToPropertiesFile((String)WSASRuntimePreferencePage.this.wsasPath.getText());
                if (WSASRuntimePreferencePage.this.webappExist) {
                    WSASRuntimePreferencePage.this.status = Status.OK_STATUS;
                    WSASRuntimePreferencePage.this.statusUpdate(true);
                    System.setProperty("wso2wsas.home", WSASRuntimePreferencePage.this.wsasPath.getText());
                    System.out.println(System.getProperty("wso2wsas.home"));
                } else {
                    WSASRuntimePreferencePage.this.status = Status.CANCEL_STATUS;
                    WSASRuntimePreferencePage.this.statusUpdate(false);
                }
            }
        });
        this.browseButton = new Button(runtimeGroup, 0);
        this.browseButton.setText(WSASCoreUIMessages.LABEL_BROUSE);
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WSASRuntimePreferencePage.this.handleBrowse(mainComp.getShell());
            }
        });
        if (this.wsasPath.getText().equals(WSASCoreUIMessages.NULL)) {
            this.status = new Status(4, "id", 0, WSASCoreUIMessages.ERROR_INVALID_WSAS_SERVER_LOCATION, null);
        }
        Label separator = new Label(runtimeGroup, 0);
        gd = new GridData();
        gd.horizontalSpan = 3;
        separator.setText(" ");
        separator.setLayoutData((Object)gd);
        this.statusLabel = new Label(runtimeGroup, 0x1000008);
        this.statusLabel.setAlignment(0x1000000);
        gd = new GridData();
        gd.horizontalSpan = 3;
        gd.horizontalAlignment = 2;
        this.statusLabel.setLayoutData((Object)gd);
        this.statusBanner = this.wsasPath.getText().equals("") ? WSASCoreUIMessages.LABEL_WSAS_RUNTIME_NOT_EXIT : (!this.wsasPath.getText().equals("") && !this.webappExist ? WSASCoreUIMessages.LABEL_WSAS_RUNTIME_LOAD_ERROR : WSASCoreUIMessages.LABEL_WSAS_RUNTIME_LOAD);
        this.statusLabel.setText(this.statusBanner);
        this.webappExist = this.runtimeExist(this.wsasPath.getText());
        Label seperatorLabel = new Label(runtimeGroup, 258);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        gd.verticalIndent = 10;
        seperatorLabel.setLayoutData((Object)gd);
        Label fillLabel61 = new Label(runtimeGroup, 256);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        gd.verticalIndent = 10;
        fillLabel61.setLayoutData((Object)gd);
        Label runtimeConfigurationLabel = new Label(runtimeGroup, 0);
        runtimeConfigurationLabel.setText(WSASCoreUIMessages.WSAS_RUNTIME_CONFIGURATION);
        gd = new GridData();
        gd.horizontalSpan = 3;
        runtimeConfigurationLabel.setLayoutData((Object)gd);
        Label fillLabel62 = new Label(runtimeGroup, 256);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        gd.verticalIndent = 10;
        fillLabel62.setLayoutData((Object)gd);
        Label debugHostLabel = new Label(runtimeGroup, 0);
        debugHostLabel.setText(WSASCoreUIMessages.WSAS_DEBUG_HOST);
        this.debugHostText = new Text(runtimeGroup, 0);
        this.debugHostText.setText("localhost");
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        gd.minimumWidth = 100;
        this.debugHostText.setLayoutData((Object)gd);
        this.debugHostText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WSASRuntimePreferencePage.this.context.setDebugHost(WSASRuntimePreferencePage.this.debugHostText.getText());
            }
        });
        Label fillLabel63 = new Label(runtimeGroup, 256);
        fillLabel63.setText("");
        Label debugPortLabel = new Label(runtimeGroup, 0);
        debugPortLabel.setText(WSASCoreUIMessages.WSAS_DEBUG_PORT);
        this.debugPortText = new Text(runtimeGroup, 0);
        this.debugPortText.setText("8088");
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        gd.minimumWidth = 100;
        this.debugPortText.setLayoutData((Object)gd);
        this.debugPortText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WSASRuntimePreferencePage.this.context.setDebuPort(WSASRuntimePreferencePage.this.debugPortText.getText());
            }
        });
        TabItem codegenPreferencesItem = new TabItem(wsasPreferenceTab, 0);
        codegenPreferencesItem.setText(WSASCoreUIMessages.WSAS_PREFERENCES);
        codegenPreferencesItem.setToolTipText(WSASCoreUIMessages.WSAS_PREFERENCES_TOOLTIP);
        Composite codegenGroup = new Composite((Composite)wsasPreferenceTab, 0);
        codegenPreferencesItem.setControl((Control)codegenGroup);
        codegenGroup.setToolTipText(WSASCoreUIMessages.WSAS_PREFERENCES_TOOLTIP);
        layout = new GridLayout();
        codegenGroup.setLayout((Layout)layout);
        layout.numColumns = 2;
        layout.marginHeight = 10;
        gd = new GridData(1808);
        codegenGroup.setLayoutData((Object)gd);
        Text serviceCodegenLabel = new Text(codegenGroup, 8);
        serviceCodegenLabel.setText(WSASCoreUIMessages.LABEL_WEB_SERVICE_CODEGEN);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        serviceCodegenLabel.setLayoutData((Object)gd);
        Label databindingLabel = new Label(codegenGroup, 0);
        databindingLabel.setText(WSASCoreUIMessages.LABEL_DATABINDING);
        String[] databindingItems = new String[]{this.context.getServiceDatabinding().toUpperCase()};
        this.serviceDatabindingCombo = new Combo(codegenGroup, 2060);
        this.serviceDatabindingCombo.setItems(databindingItems);
        this.serviceDatabindingCombo.select(0);
        this.context.setServiceDatabinding(this.serviceDatabindingCombo.getItem(0));
        this.serviceDatabindingCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WSASRuntimePreferencePage.this.context.setServiceDatabinding(WSASRuntimePreferencePage.this.serviceDatabindingCombo.getItem(WSASRuntimePreferencePage.this.serviceDatabindingCombo.getSelectionIndex()));
            }
        });
        this.generateServerSideInterfaceCheckBoxButton = new Button(codegenGroup, 32);
        this.generateServerSideInterfaceCheckBoxButton.setText(WSASCoreUIMessages.LABEL_GENERATE_SERVERSIDE_INTERFACE);
        this.generateServerSideInterfaceCheckBoxButton.setSelection(this.context.isServiceInterfaceSkeleton());
        this.generateServerSideInterfaceCheckBoxButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WSASRuntimePreferencePage.this.context.setServiceInterfaceSkeleton(WSASRuntimePreferencePage.this.generateServerSideInterfaceCheckBoxButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.generateServerSideInterfaceCheckBoxButton.setLayoutData((Object)gd);
        this.generateAllCheckBoxButton = new Button(codegenGroup, 32);
        this.generateAllCheckBoxButton.setSelection(this.context.isServiceGenerateAll());
        this.generateAllCheckBoxButton.setText(WSASCoreUIMessages.LABEL_GENERATE_ALL);
        this.generateAllCheckBoxButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WSASRuntimePreferencePage.this.context.setServiceGenerateAll(WSASRuntimePreferencePage.this.generateAllCheckBoxButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.generateAllCheckBoxButton.setLayoutData((Object)gd);
        Label seperatorLabel0 = new Label(codegenGroup, 258);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.verticalIndent = 5;
        seperatorLabel0.setLayoutData((Object)gd);
        Text clientCodegenLabel = new Text(codegenGroup, 8);
        clientCodegenLabel.setText(WSASCoreUIMessages.LABEL_WEB_SERVICE_CLIENT_CODEGEN);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.verticalIndent = 5;
        clientCodegenLabel.setLayoutData((Object)gd);
        Label clientLabel = new Label(codegenGroup, 256);
        clientLabel.setText(WSASCoreUIMessages.LABEL_CLIENT_SIDE);
        this.syncAndAsyncRadioButton = new Button(codegenGroup, 16);
        this.syncAndAsyncRadioButton.setText(WSASCoreUIMessages.LABEL_SYNC_AND_ASYNC);
        this.syncAndAsyncRadioButton.setVisible(true);
        this.syncAndAsyncRadioButton.setSelection(!(this.context.isSync() || this.context.isAsync()) ? true : this.context.isSync() && this.context.isAsync());
        this.syncAndAsyncRadioButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WSASRuntimePreferencePage.this.context.setAsync(WSASRuntimePreferencePage.this.syncAndAsyncRadioButton.getSelection());
                WSASRuntimePreferencePage.this.context.setSync(WSASRuntimePreferencePage.this.syncAndAsyncRadioButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        new Label(codegenGroup, 0);
        this.syncOnlyRadioButton = new Button(codegenGroup, 16);
        this.syncOnlyRadioButton.setText(WSASCoreUIMessages.LABEL_SYNC);
        this.syncOnlyRadioButton.setSelection(this.context.isSync() && !this.context.isAsync());
        this.syncOnlyRadioButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WSASRuntimePreferencePage.this.context.setAsync(!WSASRuntimePreferencePage.this.syncOnlyRadioButton.getSelection());
                WSASRuntimePreferencePage.this.context.setSync(WSASRuntimePreferencePage.this.syncOnlyRadioButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        new Label(codegenGroup, 0);
        this.asyncOnlyRadioButton = new Button(codegenGroup, 16);
        this.asyncOnlyRadioButton.setText(WSASCoreUIMessages.LABEL_ASYNC);
        this.asyncOnlyRadioButton.setSelection(this.context.isAsync() && !this.context.isSync());
        this.asyncOnlyRadioButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WSASRuntimePreferencePage.this.context.setAsync(WSASRuntimePreferencePage.this.asyncOnlyRadioButton.getSelection());
                WSASRuntimePreferencePage.this.context.setSync(!WSASRuntimePreferencePage.this.asyncOnlyRadioButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label clientDatabindingLabel = new Label(codegenGroup, 0);
        clientDatabindingLabel.setText(WSASCoreUIMessages.LABEL_DATABINDING);
        this.clientDatabindingCombo = new Combo(codegenGroup, 2060);
        this.clientDatabindingCombo.setItems(databindingItems);
        this.clientDatabindingCombo.select(0);
        this.context.setClientDatabinding(this.clientDatabindingCombo.getItem(0));
        this.clientDatabindingCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WSASRuntimePreferencePage.this.context.setClientDatabinding(WSASRuntimePreferencePage.this.clientDatabindingCombo.getItem(WSASRuntimePreferencePage.this.clientDatabindingCombo.getSelectionIndex()));
            }
        });
        this.clientUnpackClassesCheckBoxButton = new Button(codegenGroup, 32);
        this.clientUnpackClassesCheckBoxButton.setSelection(this.context.isClientUnpackClasses());
        this.clientUnpackClassesCheckBoxButton.setText(WSASCoreUIMessages.LABEL_UNPACK_CLASSES);
        this.clientUnpackClassesCheckBoxButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WSASRuntimePreferencePage.this.context.setClientUnpackClasses(WSASRuntimePreferencePage.this.clientUnpackClassesCheckBoxButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.clientUnpackClassesCheckBoxButton.setLayoutData((Object)gd);
        this.clientTestCaseCheckBoxButton = new Button(codegenGroup, 32);
        this.clientTestCaseCheckBoxButton.setText(WSASCoreUIMessages.LABEL_GENERATE_TESTCASE_CAPTION);
        this.clientTestCaseCheckBoxButton.setSelection(this.context.isClientTestCase());
        this.clientTestCaseCheckBoxButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WSASRuntimePreferencePage.this.context.setClientTestCase(WSASRuntimePreferencePage.this.clientTestCaseCheckBoxButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.clientTestCaseCheckBoxButton.setLayoutData((Object)gd);
        this.clientGenerateAllCheckBoxButton = new Button(codegenGroup, 32);
        this.clientGenerateAllCheckBoxButton.setSelection(this.context.isClientGenerateAll());
        this.clientGenerateAllCheckBoxButton.setText(WSASCoreUIMessages.LABEL_GENERATE_ALL);
        this.clientGenerateAllCheckBoxButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WSASRuntimePreferencePage.this.context.setClientGenerateAll(WSASRuntimePreferencePage.this.clientGenerateAllCheckBoxButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.clientGenerateAllCheckBoxButton.setLayoutData((Object)gd);
        Label seperatorLabel11 = new Label(codegenGroup, 258);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.verticalIndent = 5;
        seperatorLabel11.setLayoutData((Object)gd);
        Text aarLabel = new Text(codegenGroup, 8);
        aarLabel.setText(WSASCoreUIMessages.LABEL_WEB_SERVICE_AAR);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.verticalIndent = 5;
        aarLabel.setLayoutData((Object)gd);
        Label aarExtentionLabel = new Label(codegenGroup, 0);
        aarExtentionLabel.setText(WSASCoreUIMessages.LABEL_AAR_EXTENTION);
        String[] aarExtentionItems = new String[]{WSASCoreUIMessages.AAR};
        this.aarExtensionCombo = new Combo(codegenGroup, 2060);
        this.aarExtensionCombo.setItems(aarExtentionItems);
        this.aarExtensionCombo.select(0);
        this.context.setAarExtention(this.aarExtensionCombo.getItem(0));
        this.aarExtensionCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = WSASRuntimePreferencePage.this.aarExtensionCombo.getSelectionIndex();
                WSASRuntimePreferencePage.this.context.setAarExtention(WSASRuntimePreferencePage.this.aarExtensionCombo.getItem(index));
            }
        });
        wsasPreferenceTab.setEnabled(true);
        wsasPreferenceTab.setVisible(true);
        return mainComp;
    }

    public void init(IWorkbench workbench) {
    }

    private void handleBrowse(Shell parent) {
        DirectoryDialog fileDialog = new DirectoryDialog(parent);
        String fileName = fileDialog.open();
        if (fileName != null) {
            this.wsasPath.setText(fileName);
            ServerModel.setWsasServerPath((String)this.wsasPath.getText());
            boolean status = this.runtimeExist(this.wsasPath.getText());
            this.statusUpdate(status);
        }
    }

    private void statusUpdate(boolean status) {
        if (this.statusLabel != null) {
            if (!this.wsasPath.getText().equals("")) {
                if (status) {
                    this.statusLabel.setText(WSASCoreUIMessages.LABEL_WSAS_RUNTIME_LOAD);
                    this.setErrorMessage(null);
                } else {
                    this.statusLabel.setText(WSASCoreUIMessages.LABEL_WSAS_RUNTIME_LOAD_ERROR);
                }
            } else {
                this.statusLabel.setText(WSASCoreUIMessages.LABEL_WSAS_RUNTIME_NOT_EXIT);
            }
        }
    }

    private boolean runtimeExist(String path) {
        File wsasHomeDir = new File(path);
        if (wsasHomeDir.isDirectory()) {
            String wsasLibPath = WSASCoreUtils.addAnotherNodeToPath((String)wsasHomeDir.getAbsolutePath(), (String)WSASCoreUIMessages.DIR_LIB);
            String wsasWebappPath = WSASCoreUtils.addAnotherNodeToPath((String)wsasHomeDir.getAbsolutePath(), (String)WSASCoreUIMessages.DIR_CONF);
            if (new File(wsasLibPath).isDirectory() && new File(wsasWebappPath).isDirectory()) {
                this.statusUpdate(true);
                return true;
            }
            String wsasWarPath = WSASCoreUtils.addAnotherNodeToPath((String)path, (String)"wsas.war");
            if (new File(wsasWarPath).isFile()) {
                this.statusUpdate(true);
                return true;
            }
            this.statusUpdate(false);
            return false;
        }
        this.statusUpdate(false);
        return false;
    }

    protected void performApply() {
        super.performApply();
    }

    public boolean performCancel() {
        return super.performCancel();
    }

    protected void performDefaults() {
        super.performDefaults();
        this.initializeDefaults();
    }

    public boolean performOk() {
        return super.performOk();
    }

    private void initializeDefaults() {
        this.serviceDatabindingCombo.select(0);
        this.generateAllCheckBoxButton.setSelection(WSASEmitterDefaults.isServiceGenerateAll());
        this.generateServerSideInterfaceCheckBoxButton.setSelection(WSASEmitterDefaults.isServiceInterfaceSkeleton());
        this.syncAndAsyncRadioButton.setSelection(!(WSASEmitterDefaults.isClientSync() || WSASEmitterDefaults.isClientAsync()) ? true : WSASEmitterDefaults.isClientSync() && WSASEmitterDefaults.isClientAsync());
        this.syncOnlyRadioButton.setSelection(WSASEmitterDefaults.isClientSync() && !WSASEmitterDefaults.isClientAsync());
        this.asyncOnlyRadioButton.setSelection(WSASEmitterDefaults.isClientAsync() && !WSASEmitterDefaults.isClientSync());
        this.clientTestCaseCheckBoxButton.setSelection(WSASEmitterDefaults.isClientTestCase());
        this.clientGenerateAllCheckBoxButton.setSelection(WSASEmitterDefaults.isClientTestCase());
        this.clientUnpackClassesCheckBoxButton.setSelection(WSASEmitterDefaults.isClientUnpackClasses());
        this.aarExtensionCombo.select(0);
    }
}

