/*
 * Decompiled with CFR 0.152.
 */
package org.apache.woden.internal.wsdl20.extensions.soap;

import java.net.URI;
import org.apache.woden.internal.wsdl20.extensions.ComponentExtensionsImpl;
import org.apache.woden.internal.wsdl20.extensions.http.HTTPConstants;
import org.apache.woden.internal.wsdl20.extensions.soap.SOAPConstants;
import org.apache.woden.wsdl20.Binding;
import org.apache.woden.wsdl20.NestedComponent;
import org.apache.woden.wsdl20.extensions.ComponentExtensions;
import org.apache.woden.wsdl20.extensions.ExtensionElement;
import org.apache.woden.wsdl20.extensions.http.HTTPLocation;
import org.apache.woden.wsdl20.extensions.soap.SOAPBindingExtensions;
import org.apache.woden.wsdl20.extensions.soap.SOAPBindingOperationExtensions;
import org.apache.woden.wsdl20.extensions.soap.SOAPModule;
import org.apache.woden.wsdl20.xml.WSDLElement;
import org.apache.woden.xml.StringAttr;
import org.apache.woden.xml.URIAttr;

public class SOAPBindingOperationExtensionsImpl
extends ComponentExtensionsImpl
implements SOAPBindingOperationExtensions {
    public URI getSoapMep() {
        URIAttr mep = (URIAttr)this.fParentElement.getExtensionAttribute(SOAPConstants.Q_ATTR_SOAP_MEP);
        return mep != null ? mep.getURI() : null;
    }

    public URI getSoapAction() {
        URIAttr action = (URIAttr)this.fParentElement.getExtensionAttribute(SOAPConstants.Q_ATTR_SOAP_ACTION);
        return action != null ? action.getURI() : null;
    }

    public SOAPModule[] getSoapModules() {
        ExtensionElement[] extEls = this.fParentElement.getExtensionElementsOfType(SOAPConstants.Q_ELEM_SOAP_MODULE);
        int len = extEls.length;
        SOAPModule[] soapMods = new SOAPModule[len];
        System.arraycopy(extEls, 0, soapMods, 0, len);
        return soapMods;
    }

    public HTTPLocation getHttpLocation() {
        Binding binding = (Binding)((NestedComponent)this.fParent).getParent();
        SOAPBindingExtensions soapBindExt = (SOAPBindingExtensions)binding.getComponentExtensionsForNamespace(ComponentExtensions.NS_URI_SOAP);
        String version = soapBindExt.getSoapVersion();
        URI protocol = soapBindExt.getSoapUnderlyingProtocol();
        if (protocol == null) {
            return null;
        }
        if ("1.2".equals(version) && protocol.toString().equals("http://www.w3.org/2003/05/soap/bindings/HTTP/") || "1.1".equals(version) && protocol.toString().equals("http://www.w3.org/2006/01/soap11/bindings/HTTP/")) {
            StringAttr httpLoc = (StringAttr)((WSDLElement)this.fParent).getExtensionAttribute(HTTPConstants.Q_ATTR_LOCATION);
            return httpLoc != null ? new HTTPLocation(httpLoc.getString()) : null;
        }
        return null;
    }

    public String getHttpQueryParameterSeparator() {
        Binding binding = (Binding)((NestedComponent)this.fParent).getParent();
        SOAPBindingExtensions soapBindExt = (SOAPBindingExtensions)binding.getComponentExtensionsForNamespace(ComponentExtensions.NS_URI_SOAP);
        String version = soapBindExt.getSoapVersion();
        URI protocol = soapBindExt.getSoapUnderlyingProtocol();
        if (protocol == null) {
            return null;
        }
        if ("1.2".equals(version) && protocol.toString().equals("http://www.w3.org/2003/05/soap/bindings/HTTP/") || "1.1".equals(version) && protocol.toString().equals("http://www.w3.org/2006/01/soap11/bindings/HTTP/")) {
            StringAttr separator = (StringAttr)((WSDLElement)this.fParent).getExtensionAttribute(HTTPConstants.Q_ATTR_QUERY_PARAMETER_SEPARATOR);
            return separator != null ? separator.getString() : null;
        }
        return null;
    }

    public String getHttpContentEncodingDefault() {
        Binding binding = (Binding)((NestedComponent)this.fParent).getParent();
        SOAPBindingExtensions soapBindExt = (SOAPBindingExtensions)binding.getComponentExtensionsForNamespace(ComponentExtensions.NS_URI_SOAP);
        String version = soapBindExt.getSoapVersion();
        URI protocol = soapBindExt.getSoapUnderlyingProtocol();
        if (protocol == null) {
            return null;
        }
        if ("1.2".equals(version) && protocol.toString().equals("http://www.w3.org/2003/05/soap/bindings/HTTP/") || "1.1".equals(version) && protocol.toString().equals("http://www.w3.org/2006/01/soap11/bindings/HTTP/")) {
            StringAttr ceDef = (StringAttr)((WSDLElement)this.fParent).getExtensionAttribute(HTTPConstants.Q_ATTR_CONTENT_ENCODING_DEFAULT);
            return ceDef != null ? ceDef.getString() : null;
        }
        return null;
    }
}

