/*
 * Decompiled with CFR 0.152.
 */
package org.apache.woden.internal.wsdl20.extensions.http;

import org.apache.woden.internal.wsdl20.extensions.ComponentExtensionsImpl;
import org.apache.woden.internal.wsdl20.extensions.ExtensionConstants;
import org.apache.woden.internal.wsdl20.extensions.http.HTTPConstants;
import org.apache.woden.wsdl20.Binding;
import org.apache.woden.wsdl20.BindingOperation;
import org.apache.woden.wsdl20.InterfaceOperation;
import org.apache.woden.wsdl20.extensions.InterfaceOperationExtensions;
import org.apache.woden.wsdl20.extensions.http.HTTPBindingExtensions;
import org.apache.woden.wsdl20.extensions.http.HTTPBindingOperationExtensions;
import org.apache.woden.wsdl20.extensions.http.HTTPLocation;
import org.apache.woden.wsdl20.xml.WSDLElement;
import org.apache.woden.xml.BooleanAttr;
import org.apache.woden.xml.StringAttr;

public class HTTPBindingOperationExtensionsImpl
extends ComponentExtensionsImpl
implements HTTPBindingOperationExtensions {
    public HTTPLocation getHttpLocation() {
        StringAttr httpLoc = (StringAttr)((WSDLElement)this.fParent).getExtensionAttribute(HTTPConstants.Q_ATTR_LOCATION);
        return httpLoc != null ? new HTTPLocation(httpLoc.getString()) : null;
    }

    public Boolean isHttpLocationIgnoreUncited() {
        BooleanAttr ignoreUncited = (BooleanAttr)((WSDLElement)this.fParent).getExtensionAttribute(HTTPConstants.Q_ATTR_IGNORE_UNCITED);
        return ignoreUncited != null ? ignoreUncited.getBoolean() : new Boolean(false);
    }

    public String getHttpMethod() {
        StringAttr methodAttr = (StringAttr)((WSDLElement)this.fParent).getExtensionAttribute(HTTPConstants.Q_ATTR_METHOD);
        if (methodAttr != null) {
            return methodAttr.getString();
        }
        return null;
    }

    public String getHttpInputSerialization() {
        StringAttr serialization = (StringAttr)((WSDLElement)this.fParent).getExtensionAttribute(HTTPConstants.Q_ATTR_INPUT_SERIALIZATION);
        if (serialization != null) {
            return serialization.getString();
        }
        String method = this.determineHttpMethod();
        if (method.equals("GET") || method.equals("DELETE")) {
            return "application/x-www-form-urlencoded";
        }
        return "application/xml";
    }

    public String getHttpOutputSerialization() {
        StringAttr serialization = (StringAttr)((WSDLElement)this.fParent).getExtensionAttribute(HTTPConstants.Q_ATTR_OUTPUT_SERIALIZATION);
        return serialization != null ? serialization.getString() : "application/xml";
    }

    public String getHttpFaultSerialization() {
        StringAttr serialization = (StringAttr)((WSDLElement)this.fParent).getExtensionAttribute(HTTPConstants.Q_ATTR_FAULT_SERIALIZATION);
        return serialization != null ? serialization.getString() : "application/xml";
    }

    public String getHttpQueryParameterSeparator() {
        StringAttr separator = (StringAttr)((WSDLElement)this.fParent).getExtensionAttribute(HTTPConstants.Q_ATTR_QUERY_PARAMETER_SEPARATOR);
        return separator != null ? separator.getString() : null;
    }

    public String getHttpContentEncodingDefault() {
        StringAttr contEncodingDef = (StringAttr)((WSDLElement)this.fParent).getExtensionAttribute(HTTPConstants.Q_ATTR_CONTENT_ENCODING_DEFAULT);
        return contEncodingDef != null ? contEncodingDef.getString() : null;
    }

    private String determineHttpMethod() {
        InterfaceOperationExtensions intOperExts;
        String method = this.getHttpMethod();
        if (method != null) {
            return method;
        }
        Binding binding = (Binding)((BindingOperation)this.fParent).getParent();
        HTTPBindingExtensions httpBindExts = (HTTPBindingExtensions)binding.getComponentExtensionsForNamespace(HTTPConstants.NS_URI_HTTP);
        String methodDef = httpBindExts.getHttpMethodDefault();
        if (methodDef != null) {
            return methodDef;
        }
        InterfaceOperation intOper = ((BindingOperation)this.fParent).getInterfaceOperation();
        if (intOper != null && (intOperExts = (InterfaceOperationExtensions)intOper.getComponentExtensionsForNamespace(ExtensionConstants.NS_URI_WSDL_EXTENSIONS)) != null && intOperExts.isSafety()) {
            return "GET";
        }
        return "POST";
    }
}

