/*
 * Decompiled with CFR 0.152.
 */
package org.apache.woden.internal.wsdl20.extensions.http;

import org.apache.woden.internal.wsdl20.extensions.ComponentExtensionsImpl;
import org.apache.woden.internal.wsdl20.extensions.http.HTTPConstants;
import org.apache.woden.internal.xml.IntOrTokenAnyAttrImpl;
import org.apache.woden.wsdl20.extensions.ExtensionElement;
import org.apache.woden.wsdl20.extensions.http.HTTPBindingFaultExtensions;
import org.apache.woden.wsdl20.extensions.http.HTTPErrorStatusCode;
import org.apache.woden.wsdl20.extensions.http.HTTPHeader;
import org.apache.woden.wsdl20.xml.WSDLElement;
import org.apache.woden.xml.StringAttr;

public class HTTPBindingFaultExtensionsImpl
extends ComponentExtensionsImpl
implements HTTPBindingFaultExtensions {
    public HTTPErrorStatusCode getHttpErrorStatusCode() {
        IntOrTokenAnyAttrImpl code = (IntOrTokenAnyAttrImpl)((WSDLElement)this.fParent).getExtensionAttribute(HTTPConstants.Q_ATTR_CODE);
        if (code == null) {
            return HTTPErrorStatusCode.ANY;
        }
        if (code.isToken()) {
            return HTTPErrorStatusCode.ANY;
        }
        if (code.isInt()) {
            return new HTTPErrorStatusCode(code.getInt());
        }
        return null;
    }

    public String getHttpContentEncoding() {
        String ce = null;
        StringAttr contEncoding = (StringAttr)((WSDLElement)this.fParent).getExtensionAttribute(HTTPConstants.Q_ATTR_CONTENT_ENCODING);
        if (contEncoding != null) {
            ce = contEncoding.getString();
        }
        return ce;
    }

    public HTTPHeader[] getHttpHeaders() {
        ExtensionElement[] extEls = ((WSDLElement)this.fParent).getExtensionElementsOfType(HTTPConstants.Q_ELEM_HTTP_HEADER);
        int len = extEls.length;
        HTTPHeader[] httpHeaders = new HTTPHeader[len];
        System.arraycopy(extEls, 0, httpHeaders, 0, len);
        return httpHeaders;
    }
}

