/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.xkms2.service;

import java.util.Properties;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.wso2.xkms2.ResultType;
import org.wso2.xkms2.XKMSException;
import org.wso2.xkms2.core.XKMSRequestData;
import org.wso2.xkms2.core.XKMSServiceExecutor;
import org.wso2.xkms2.service.XKMSServerCrypto;

public class DefaultXKMSExecutor
implements XKMSServiceExecutor {
    XKMSServerCrypto crypto = null;

    public ResultType execute(XKMSRequestData data, MessageContext messageContext) throws XKMSException, AxisFault {
        this.createXKMSServerCrypto(data);
        ResultType result = this.crypto.process(data);
        return result;
    }

    public String[] getAssociatedElemenTypes() {
        return new String[]{"RegisterRequest", "ReissueRequest", "RecoverRequest", "LocateRequest", "ValidateRequest"};
    }

    public void init(ServiceContext serviceContext) throws AxisFault {
    }

    private void createXKMSServerCrypto(XKMSRequestData data) throws XKMSException {
        if (this.crypto == null) {
            Properties properties = new Properties();
            MessageContext msgCtx = data.getMessageContext();
            properties.put("org.wso2.xkms2.service.crypto.authen.code", this.getParameterValue("org.wso2.xkms2.service.crypto.authen.code", msgCtx));
            properties.put("org.wso2.xkms2.service.crypto.keystore.location", this.getParameterValue("org.wso2.xkms2.service.crypto.keystore.location", msgCtx));
            properties.put("org.wso2.xkms2.service.crypto.keystore.password", this.getParameterValue("org.wso2.xkms2.service.crypto.keystore.password", msgCtx));
            properties.put("org.wso2.xkms2.service.crypto.default.private.key.password", this.getParameterValue("org.wso2.xkms2.service.crypto.default.private.key.password", msgCtx));
            properties.put("org.wso2.xkms2.service.crypto.issuer.cert.aliase", this.getParameterValue("org.wso2.xkms2.service.crypto.issuer.cert.aliase", msgCtx));
            properties.put("org.wso2.xkms2.service.crypto.issuer.key.password", this.getParameterValue("org.wso2.xkms2.service.crypto.issuer.key.password", msgCtx));
            properties.put("org.wso2.xkms2.service.crypto.default.private.key.password", this.getParameterValue("org.wso2.xkms2.service.crypto.default.private.key.password", msgCtx));
            properties.put("org.wso2.xkms2.service.crypto.server.cert.aliase", this.getParameterValue("org.wso2.xkms2.service.crypto.server.cert.aliase", msgCtx));
            properties.put("org.wso2.xkms2.service.crypto.server.key.password", this.getParameterValue("org.wso2.xkms2.service.crypto.server.key.password", msgCtx));
            properties.put("org.wso2.xkms2.service.crypto.default.expriy.interval", this.getParameterValue("org.wso2.xkms2.service.crypto.default.expriy.interval", msgCtx));
            String parameterValue = this.getParameterValue("org.wso2.xkms2.service.crypto.persistence.enabled", msgCtx);
            if (parameterValue != null) {
                properties.put("org.wso2.xkms2.service.crypto.persistence.enabled", parameterValue);
            }
            AxisService axisService = msgCtx.getAxisService();
            ClassLoader loader = axisService.getClassLoader();
            this.crypto = new XKMSServerCrypto(properties, loader);
        }
    }

    private String getParameterValue(String key, MessageContext msgCtx) {
        Parameter param = msgCtx.getParameter(key);
        if (param != null) {
            return (String)param.getValue();
        }
        return null;
    }
}

