/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.xkms2.core;

import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.impl.dom.DOOMAbstractFactory;
import org.apache.axiom.om.impl.dom.DocumentImpl;
import org.apache.axiom.om.impl.dom.factory.OMDOMFactory;
import org.apache.axiom.om.util.UUIDGenerator;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.w3c.dom.Document;
import org.wso2.xkms2.FindBuilder;
import org.wso2.xkms2.LocateResult;
import org.wso2.xkms2.RecoverResult;
import org.wso2.xkms2.RegisterResult;
import org.wso2.xkms2.ReissueResult;
import org.wso2.xkms2.RequestAbstractType;
import org.wso2.xkms2.ResponseMechanism;
import org.wso2.xkms2.ResultType;
import org.wso2.xkms2.RevokeResult;
import org.wso2.xkms2.ValidateResult;
import org.wso2.xkms2.XKMSElement;
import org.wso2.xkms2.XKMSException;
import org.wso2.xkms2.builder.ElementBuilder;
import org.wso2.xkms2.builder.RequestAbstractTypeBuilder;
import org.wso2.xkms2.core.XKMSRequestData;
import org.wso2.xkms2.core.XKMSServiceExecutor;
import org.wso2.xkms2.core.XKMSServiceExecutorManager;
import org.wso2.xkms2.util.XKMSUtil;

public class ProtocolExchange {
    public OMElement exchangeServer(MessageContext inMsgCtx) throws AxisFault, XKMSException {
        BuildElementHelper buildElementHelper = this.buildElement(inMsgCtx);
        XKMSElement xkmsElementObj = buildElementHelper.getXkmsElement();
        ElementBuilder builder = buildElementHelper.getBuilder();
        QName qName = buildElementHelper.getQName();
        RequestAbstractTypeBuilder requestATBuider = (RequestAbstractTypeBuilder)builder;
        RequestAbstractType requestAbstractType = requestATBuider.getRequestAbstractType();
        List responseMechanismList = requestAbstractType.getResponseMechanism();
        ResponseMechanism[] responseMechanisms = responseMechanismList != null ? responseMechanismList.toArray(new ResponseMechanism[responseMechanismList.size()]) : null;
        OMFactory fac = DOOMAbstractFactory.getOMFactory();
        OMDOMFactory omDomFac = (OMDOMFactory)fac;
        DocumentImpl doc = omDomFac.getDocument();
        XKMSRequestData requestData = new XKMSRequestData();
        requestData.setMessageContext(inMsgCtx);
        requestData.setRequest((RequestAbstractType)xkmsElementObj);
        requestData.setDocument((Document)doc);
        if (responseMechanisms == null || responseMechanisms.length == 0) {
            XKMSServiceExecutor xkmsServiceExecutor = XKMSServiceExecutorManager.get(qName.getLocalPart());
            ResultType result = xkmsServiceExecutor.execute(requestData, inMsgCtx);
            return this.getAsOMElement(result, fac);
        }
        throw new UnsupportedOperationException("TODO ");
    }

    public XKMSElement exchangeClient(MessageContext inMsgCtx) throws XKMSException {
        BuildElementHelper buildElementHelper = this.buildElement(inMsgCtx);
        XKMSElement xkmsElementObj = buildElementHelper.getXkmsElement();
        return xkmsElementObj;
    }

    private BuildElementHelper buildElement(MessageContext msgCtx) throws XKMSException {
        SOAPEnvelope env = msgCtx.getEnvelope();
        OMElement llomElement = env.getBody().getFirstElement();
        XKMSUtil.DOOMElementMetadata doomMetadata = XKMSUtil.getDOOMElement(llomElement);
        OMElement xkmsElement = doomMetadata.getElement();
        QName qName = xkmsElement.getQName();
        ElementBuilder builder = FindBuilder.find(qName.getLocalPart());
        XKMSElement xkmsObj = builder.buildElement(xkmsElement);
        return new BuildElementHelper(qName, xkmsObj, builder);
    }

    public String generateRequestId() {
        return UUIDGenerator.getUUID();
    }

    private OMElement getAsOMElement(ResultType resultType, OMFactory factory) throws XKMSException {
        if (resultType instanceof RegisterResult) {
            return ((RegisterResult)resultType).serialize(factory);
        }
        if (resultType instanceof ReissueResult) {
            return ((ReissueResult)resultType).serialize(factory);
        }
        if (resultType instanceof RecoverResult) {
            try {
                ((RecoverResult)resultType).serialize(factory);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            return ((RecoverResult)resultType).serialize(factory);
        }
        if (resultType instanceof RevokeResult) {
            return ((RevokeResult)resultType).serialize(factory);
        }
        if (resultType instanceof LocateResult) {
            return ((LocateResult)resultType).serialize(factory);
        }
        if (resultType instanceof ValidateResult) {
            return ((ValidateResult)resultType).serialize(factory);
        }
        return null;
    }

    private class BuildElementHelper {
        private QName qName;
        private XKMSElement xkmsElement;
        private ElementBuilder builder;

        BuildElementHelper(QName qName, XKMSElement xkmsElement, ElementBuilder builder) {
            this.qName = qName;
            this.xkmsElement = xkmsElement;
            this.builder = builder;
        }

        public QName getQName() {
            return this.qName;
        }

        public XKMSElement getXkmsElement() {
            return this.xkmsElement;
        }

        public ElementBuilder getBuilder() {
            return this.builder;
        }
    }
}

