/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.xkms2.client;

import java.util.List;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.dom.DOOMAbstractFactory;
import org.apache.axiom.om.util.UUIDGenerator;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.OperationClient;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.MessageContext;
import org.apache.xml.security.keys.KeyInfo;
import org.wso2.xkms2.KISSRequest;
import org.wso2.xkms2.KeyUsage;
import org.wso2.xkms2.LocateResult;
import org.wso2.xkms2.QueryKeyBinding;
import org.wso2.xkms2.RespondWith;
import org.wso2.xkms2.UseKeyWith;
import org.wso2.xkms2.XKMSElement;
import org.wso2.xkms2.XKMSException;
import org.wso2.xkms2.core.ProtocolExchange;
import org.wso2.xkms2.util.XKMSUtil;

public class XKMSStubHelper {
    public static void populateRequest(EndpointReference xkmsEndpointReference, RespondWith[] respondWiths, KeyUsage[] keyUsages, KeyInfo keyInfo, UseKeyWith[] useKeyWiths, KISSRequest kissRequest) {
        int j;
        kissRequest.setId(UUIDGenerator.getUUID());
        kissRequest.setServiceURI(xkmsEndpointReference.getAddress());
        if (respondWiths != null) {
            for (int j2 = 0; j2 < respondWiths.length; ++j2) {
                kissRequest.addRespondWith(respondWiths[j2]);
            }
        }
        QueryKeyBinding queryKeyBinding = new QueryKeyBinding();
        kissRequest.setQueryKeyBinding(queryKeyBinding);
        if (keyUsages != null) {
            for (j = 0; j < keyUsages.length; ++j) {
                queryKeyBinding.addKeyUsage(keyUsages[j]);
            }
        } else {
            queryKeyBinding.addKeyUsage(KeyUsage.ENCRYPTION);
            queryKeyBinding.addKeyUsage(KeyUsage.EXCHANGE);
            queryKeyBinding.addKeyUsage(KeyUsage.SIGNATURE);
        }
        if (keyInfo != null) {
            queryKeyBinding.setKeyInfo(keyInfo);
        }
        if (useKeyWiths != null) {
            for (j = 0; j < useKeyWiths.length; ++j) {
                queryKeyBinding.addUseKeyWith(useKeyWiths[j]);
            }
        }
    }

    public static List elementHelper(KeyInfo keyInfo, UseKeyWith[] useKeyWiths, RespondWith[] respondWiths, KeyUsage[] keyUsages, ServiceClient serviceClient, KISSRequest request) throws XKMSException {
        ProtocolExchange protocolExchange = new ProtocolExchange();
        try {
            XKMSStubHelper.populateRequest(serviceClient.getOptions().getTo(), respondWiths, keyUsages, keyInfo, useKeyWiths, request);
            OMFactory fac = DOOMAbstractFactory.getOMFactory();
            OMElement omElement = request.serialize(fac);
            omElement = XKMSUtil.getOMElement(omElement);
            MessageContext inMsgCtx = XKMSStubHelper.sendReceive(omElement, serviceClient);
            XKMSElement xkmsElement = protocolExchange.exchangeClient(inMsgCtx);
            LocateResult locateResult = (LocateResult)xkmsElement;
            return locateResult.getUnverifiedKeyBindingList();
        }
        catch (AxisFault e) {
            e.printStackTrace();
            throw new XKMSException(e);
        }
    }

    private static MessageContext sendReceive(OMElement llomElement, ServiceClient serviceClient) throws AxisFault {
        MessageContext messageContext = new MessageContext();
        XKMSStubHelper.fillSOAPEnvelope(messageContext, llomElement, serviceClient);
        OperationClient operationClient = serviceClient.createClient(ServiceClient.ANON_OUT_IN_OP);
        operationClient.addMessageContext(messageContext);
        operationClient.execute(true);
        MessageContext response = operationClient.getMessageContext("In");
        if (serviceClient.getOptions().isCallTransportCleanup()) {
            response.getEnvelope().build();
            serviceClient.cleanupTransport();
            return response;
        }
        return response;
    }

    private static void fillSOAPEnvelope(MessageContext messageContext, OMElement xmlPayload, ServiceClient serviceClient) throws AxisFault {
        messageContext.setServiceContext(serviceClient.getServiceContext());
        SOAPFactory soapFactory = XKMSStubHelper.getSOAPFactory(serviceClient.getOptions());
        SOAPEnvelope envelope = soapFactory.getDefaultEnvelope();
        if (xmlPayload != null) {
            envelope.getBody().addChild((OMNode)xmlPayload);
        }
        serviceClient.addHeadersToEnvelope(envelope);
        messageContext.setEnvelope(envelope);
    }

    private static SOAPFactory getSOAPFactory(Options options) {
        String soapVersionURI = options.getSoapVersionURI();
        if ("http://www.w3.org/2003/05/soap-envelope".equals(soapVersionURI)) {
            return OMAbstractFactory.getSOAP12Factory();
        }
        return OMAbstractFactory.getSOAP11Factory();
    }
}

