/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.xkms2.builder;

import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.Base64;
import org.wso2.xkms2.RevokeKeyBinding;
import org.wso2.xkms2.RevokeRequest;
import org.wso2.xkms2.XKMS2Constants;
import org.wso2.xkms2.XKMSElement;
import org.wso2.xkms2.XKMSException;
import org.wso2.xkms2.builder.KRSSRequestBuilder;
import org.wso2.xkms2.builder.RevokeKeyBindingBuilder;

public class RevokeRequestBuilder
extends KRSSRequestBuilder {
    public static final RevokeRequestBuilder INSTANCE = new RevokeRequestBuilder();

    private RevokeRequestBuilder() {
    }

    public XKMSElement buildElement(OMElement element) throws XKMSException {
        RevokeRequest revokeRequest = new RevokeRequest();
        super.buildElement(element, revokeRequest);
        OMElement revokeKeyBindingElement = element.getFirstChildWithName(XKMS2Constants.Q_ELEM_REVOKE_KEY_BINDING);
        if (revokeKeyBindingElement == null) {
            throw new XKMSException("RevokeKeyBinding element not found");
        }
        revokeRequest.setRevokeKeyBinding((RevokeKeyBinding)RevokeKeyBindingBuilder.INSTANCE.buildElement(revokeKeyBindingElement));
        if (revokeRequest.getAuthentication() == null) {
            OMElement revocationCodeElem = element.getFirstChildWithName(XKMS2Constants.Q_ELEM_REVOCATION_CODE);
            if (revocationCodeElem != null) {
                revokeRequest.setRevocationCode(Base64.decode((String)revocationCodeElem.getText()));
            } else {
                throw new XKMSException("Neither Authentication nor RevocationCode found");
            }
        }
        return revokeRequest;
    }
}

