/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.xkms2.builder;

import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.wso2.xkms2.MessageAbstractType;
import org.wso2.xkms2.PendingNotification;
import org.wso2.xkms2.RequestAbstractType;
import org.wso2.xkms2.RespondWith;
import org.wso2.xkms2.ResponseMechanism;
import org.wso2.xkms2.XKMSException;
import org.wso2.xkms2.builder.MessageAbstractTypeBuilder;

public abstract class RequestAbstractTypeBuilder
extends MessageAbstractTypeBuilder {
    private RequestAbstractType requestAbstractType;

    public RequestAbstractType getRequestAbstractType() {
        return this.requestAbstractType;
    }

    public void buildElement(OMElement element, MessageAbstractType messageAbstractType) throws XKMSException {
        OMElement responseLimitEle;
        OMElement originalRequestIdEle;
        OMElement e;
        super.buildElement(element, messageAbstractType);
        this.requestAbstractType = (RequestAbstractType)messageAbstractType;
        Iterator iterator = element.getChildrenWithName(new QName("http://www.w3.org/2002/03/xkms#", "ResponseMechanism"));
        while (iterator.hasNext()) {
            e = (OMElement)iterator.next();
            this.requestAbstractType.addResponseMechanism(ResponseMechanism.validate(e.getText()));
        }
        iterator = element.getChildrenWithName(new QName("http://www.w3.org/2002/03/xkms#", "RespondWith"));
        while (iterator.hasNext()) {
            e = (OMElement)iterator.next();
            this.requestAbstractType.addRespondWith(RespondWith.valueOf(e.getText()));
        }
        OMElement pendingNotificationEle = element.getFirstChildWithName(new QName("http://www.w3.org/2002/03/xkms#", "PendingNotification"));
        if (pendingNotificationEle != null) {
            PendingNotification pendingNotification = new PendingNotification();
            OMAttribute mechanismAttr = pendingNotificationEle.getAttribute(new QName("Mechanism"));
            if (mechanismAttr == null) {
                throw new XKMSException("Mechanism attribute is not found");
            }
            String text = mechanismAttr.getAttributeValue();
            if (text == null) {
                throw new XKMSException("Value of the Mechanism attribute is not found");
            }
            pendingNotification.setMechanism(text);
            OMAttribute identifierAttr = pendingNotificationEle.getAttribute(new QName("Identifier"));
            if (identifierAttr == null) {
                throw new XKMSException("Identifier attribute is not found");
            }
            text = identifierAttr.getAttributeValue();
            if (text == null) {
                throw new XKMSException("Value of the Identifier attribute is not found");
            }
            pendingNotification.setMechanism(text);
            this.requestAbstractType.setPendingNotification(pendingNotification);
        }
        if ((originalRequestIdEle = element.getFirstChildWithName(new QName("http://www.w3.org/2002/03/xkms#", "OriginalRequestId"))) != null) {
            this.requestAbstractType.setOriginalRequestId(originalRequestIdEle.getText());
        }
        if ((responseLimitEle = element.getFirstChildWithName(new QName("http://www.w3.org/2002/03/xkms#", "ResponseLimit"))) != null) {
            this.requestAbstractType.setResponseLimit(Integer.parseInt(responseLimitEle.getText()));
        }
    }
}

