/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.xkms2.builder;

import java.text.ParseException;
import java.util.Calendar;
import org.apache.axiom.om.OMElement;
import org.apache.ws.security.util.XmlSchemaDateFormat;
import org.wso2.xkms2.PrototypeKeyBinding;
import org.wso2.xkms2.ValidityInterval;
import org.wso2.xkms2.XKMS2Constants;
import org.wso2.xkms2.XKMSElement;
import org.wso2.xkms2.XKMSException;
import org.wso2.xkms2.builder.ElementBuilder;
import org.wso2.xkms2.builder.KeyBindingAbstractTypeBuilder;

public class PrototypeKeyBindingBuilder
extends KeyBindingAbstractTypeBuilder
implements ElementBuilder {
    public static final PrototypeKeyBindingBuilder INSTANCE = new PrototypeKeyBindingBuilder();
    private PrototypeKeyBinding prototypeKeyBinding;

    public static PrototypeKeyBindingBuilder getInstance() {
        return INSTANCE;
    }

    private PrototypeKeyBindingBuilder() {
    }

    public XKMSElement buildElement(OMElement element) throws XKMSException {
        OMElement revokCodeIdentifierElem;
        this.prototypeKeyBinding = new PrototypeKeyBinding();
        super.buildElement(element, this.prototypeKeyBinding);
        OMElement validityIntervalEle = element.getFirstChildWithName(XKMS2Constants.ELE_VALIDITY_INTERVAL);
        if (validityIntervalEle != null) {
            this.processValidityInterval(validityIntervalEle);
        }
        if ((revokCodeIdentifierElem = element.getFirstChildWithName(XKMS2Constants.ELEM_REVOCATION_CODE_IDENTIFIER)) != null) {
            this.processRevocationCodeIdeintifer(revokCodeIdentifierElem);
        }
        return this.prototypeKeyBinding;
    }

    private void processValidityInterval(OMElement validityIntervalElem) throws XKMSException {
        ValidityInterval validityInterval = new ValidityInterval();
        String strNotBefore = validityIntervalElem.getAttributeValue(XKMS2Constants.Q_ATTR_NOT_BEFORE);
        String strNotOnOrAfter = validityIntervalElem.getAttributeValue(XKMS2Constants.Q_ATTR_NOT_ON_OR_AFTER);
        XmlSchemaDateFormat zulu = new XmlSchemaDateFormat();
        try {
            Calendar calendar;
            if (strNotBefore != null) {
                calendar = Calendar.getInstance();
                calendar.setTime(zulu.parse(strNotBefore));
                validityInterval.setNotBefore(calendar);
            }
            if (strNotOnOrAfter != null) {
                calendar = Calendar.getInstance();
                calendar.setTime(zulu.parse(strNotOnOrAfter));
                validityInterval.setNotOnOrAfter(calendar);
            }
        }
        catch (ParseException xkmse) {
            throw new XKMSException(xkmse);
        }
        this.prototypeKeyBinding.setValidityInterval(validityInterval);
    }

    private void processRevocationCodeIdeintifer(OMElement revocationCodeIdentifierElem) {
        String encoded = revocationCodeIdentifierElem.getText();
        this.prototypeKeyBinding.setRevocationCodeIdentifier(encoded.getBytes());
    }
}

