/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.xkms2;

import java.security.Key;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.xml.security.signature.XMLSignature;
import org.w3c.dom.Element;
import org.wso2.xkms2.Authentication;
import org.wso2.xkms2.KRSSRequest;
import org.wso2.xkms2.ReissueKeyBinding;
import org.wso2.xkms2.XKMS2Constants;
import org.wso2.xkms2.XKMSException;
import org.wso2.xkms2.util.XKMSUtil;

public class ReissueRequest
extends KRSSRequest {
    private ReissueKeyBinding reissueKeyBinding;
    private XMLSignature proofOfPossession;
    private Key popKey;

    public XMLSignature getProofOfPocession() {
        return this.proofOfPossession;
    }

    public void setProofOfPocession(XMLSignature proofOfPocession) {
        this.proofOfPossession = proofOfPocession;
    }

    public void setProofOfPossessionKey(Key popKey) {
        this.popKey = popKey;
    }

    public Key getProofOfPossessionKey() {
        return this.popKey;
    }

    public ReissueKeyBinding getReissueKeyBinding() {
        return this.reissueKeyBinding;
    }

    public void setReissueKeyBinding(ReissueKeyBinding reissueKeyBinding) {
        this.reissueKeyBinding = reissueKeyBinding;
    }

    public OMElement serialize(OMFactory factory) throws XKMSException {
        Key key;
        OMElement reissueRequestElem = factory.createOMElement(XKMS2Constants.Q_ELEM_REISSUE_REQUEST);
        super.serialize(factory, reissueRequestElem);
        if (this.reissueKeyBinding == null) {
            throw new XKMSException("ReissueKeyBinding not found");
        }
        reissueRequestElem.addChild((OMNode)this.reissueKeyBinding.serialize(factory));
        OMElement reissueKeyBindingElement = reissueRequestElem.getFirstChildWithName(XKMS2Constants.Q_ELEM_REISSUE_KEY_BINDING);
        Authentication authentication = this.getAuthentication();
        if (authentication.getKeyBindingAuthentication() == null && (key = authentication.getKeyBindingAuthenticationKey()) != null) {
            XMLSignature keyBindingAuthSignature = XKMSUtil.sign(key, (Element)reissueKeyBindingElement);
            authentication.setKeyBindingAuthentication(keyBindingAuthSignature);
        }
        reissueRequestElem.addChild((OMNode)authentication.serialize(factory));
        if (this.proofOfPossession == null && this.popKey != null) {
            this.proofOfPossession = XKMSUtil.sign(this.popKey, (Element)reissueKeyBindingElement);
        }
        if (this.proofOfPossession != null) {
            OMElement proofOfPossessionElement = factory.createOMElement(XKMS2Constants.Q_ELEM_PROOF_OF_POSSESSION, (OMContainer)reissueRequestElem);
            XKMSUtil.appendChild(this.proofOfPossession.getElement(), proofOfPossessionElement);
        }
        return reissueRequestElem;
    }
}

