/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.xkms2;

import java.security.Key;
import java.security.cert.X509Certificate;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.xml.security.signature.XMLSignature;
import org.w3c.dom.Element;
import org.wso2.xkms2.Authentication;
import org.wso2.xkms2.KRSSRequest;
import org.wso2.xkms2.PrototypeKeyBinding;
import org.wso2.xkms2.XKMS2Constants;
import org.wso2.xkms2.XKMSException;
import org.wso2.xkms2.util.XKMSUtil;

public class RegisterRequest
extends KRSSRequest {
    private PrototypeKeyBinding prototypeKeyBinding;
    private XMLSignature proofOfPossesion;
    private Key popKey;

    public void setProofOfPossesion(XMLSignature proofOfPossession) {
        this.proofOfPossesion = proofOfPossession;
    }

    public void setProofOfPocessionKey(Key popKey) {
        this.popKey = popKey;
    }

    public Key getProofOfPocessionKey() {
        return this.popKey;
    }

    public XMLSignature getProofOfPossession() {
        return this.proofOfPossesion;
    }

    public void setPrototypeKeyBinding(PrototypeKeyBinding prototypeKeyBinding) {
        this.prototypeKeyBinding = prototypeKeyBinding;
    }

    public PrototypeKeyBinding getPrototypeKeyBinding() {
        return this.prototypeKeyBinding;
    }

    public OMElement serialize(OMFactory factory) throws XKMSException {
        Key key;
        OMElement regRequestElement = factory.createOMElement(XKMS2Constants.Q_ELEM_REGISTER_REQUEST);
        regRequestElement.declareNamespace("http://www.w3.org/2000/09/xmldsig#", "ds");
        super.serialize(factory, regRequestElement);
        if (this.prototypeKeyBinding == null) {
            throw new XKMSException("PrototypeKeyBinding element is null");
        }
        regRequestElement.addChild((OMNode)this.prototypeKeyBinding.serialize(factory));
        OMElement prototypeKeyBindingElement = regRequestElement.getFirstChildWithName(XKMS2Constants.Q_ELEM_PROTOTYPE_KEY_BINDING);
        Authentication authentication = this.getAuthentication();
        if (authentication.getKeyBindingAuthentication() == null && (key = authentication.getKeyBindingAuthenticationKey()) != null) {
            XMLSignature keyBindingAuthSignature = XKMSUtil.sign(key, (Element)prototypeKeyBindingElement);
            authentication.setKeyBindingAuthentication(keyBindingAuthSignature);
        }
        regRequestElement.addChild((OMNode)authentication.serialize(factory));
        if (this.proofOfPossesion == null && this.popKey != null) {
            this.proofOfPossesion = XKMSUtil.sign(this.popKey, (Element)prototypeKeyBindingElement);
        }
        if (this.proofOfPossesion != null) {
            OMElement proofOfPossessionElement = factory.createOMElement(XKMS2Constants.Q_ELEM_PROOF_OF_POSSESSION, (OMContainer)regRequestElement);
            XKMSUtil.appendChild(this.proofOfPossesion.getElement(), proofOfPossessionElement);
        }
        Key signKey = this.getSignKey();
        X509Certificate signCert = this.getSignCert();
        if (signKey != null && signCert != null) {
            try {
                XKMSUtil.sign(this.getSignKey(), this.getSignCert(), (Element)regRequestElement);
            }
            catch (XKMSException e) {
                throw new XKMSException("An exception was thrown when signing the message", (Throwable)e);
            }
        }
        return regRequestElement;
    }
}

