/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.xkms2;

import java.security.Key;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xml.security.utils.IdResolver;
import org.w3c.dom.Element;
import org.wso2.xkms2.Authentication;
import org.wso2.xkms2.KRSSRequest;
import org.wso2.xkms2.RecoverKeyBinding;
import org.wso2.xkms2.XKMS2Constants;
import org.wso2.xkms2.XKMSException;

public class RecoverRequest
extends KRSSRequest {
    private RecoverKeyBinding recoverKeyBinding = null;

    public RecoverKeyBinding getRecoverKeyBinding() {
        return this.recoverKeyBinding;
    }

    public void setRecoverKeyBinding(RecoverKeyBinding recoverKeyBinding) {
        this.recoverKeyBinding = recoverKeyBinding;
    }

    public OMElement serialize(OMFactory factory) throws XKMSException {
        Key key;
        OMElement recoverRequestElem = factory.createOMElement(XKMS2Constants.Q_ELEM_RECOVER_REQUEST);
        super.serialize(factory, recoverRequestElem);
        if (this.recoverKeyBinding == null) {
            throw new XKMSException("RecoverKeyBinding is not found");
        }
        recoverRequestElem.addChild((OMNode)this.recoverKeyBinding.serialize(factory));
        OMElement prototypeKeyBindingElement = recoverRequestElem.getFirstChildWithName(XKMS2Constants.Q_ELEM_RECOVER_KEY_BINDING);
        String prototypeKeyBindingRefId = "#" + this.recoverKeyBinding.getId();
        Authentication authentication = this.getAuthentication();
        if (authentication.getKeyBindingAuthentication() == null && (key = authentication.getKeyBindingAuthenticationKey()) != null) {
            try {
                IdResolver.registerElementById((Element)((Element)prototypeKeyBindingElement), (String)this.recoverKeyBinding.getId());
                XMLSignature keyBindingAuthSignature = new XMLSignature(((Element)prototypeKeyBindingElement).getOwnerDocument(), "", "http://www.w3.org/2000/09/xmldsig#hmac-sha1", "http://www.w3.org/2001/10/xml-exc-c14n#");
                Transforms transforms = new Transforms(((Element)prototypeKeyBindingElement).getOwnerDocument());
                transforms.addTransform("http://www.w3.org/2001/10/xml-exc-c14n#");
                keyBindingAuthSignature.addDocument(prototypeKeyBindingRefId, transforms, "http://www.w3.org/2000/09/xmldsig#sha1");
                keyBindingAuthSignature.sign(key);
                authentication.setKeyBindingAuthentication(keyBindingAuthSignature);
            }
            catch (XMLSecurityException xse) {
                throw new XKMSException(xse);
            }
        }
        recoverRequestElem.addChild((OMNode)authentication.serialize(factory));
        return recoverRequestElem;
    }
}

