/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.xkms2;

import java.util.Calendar;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.wso2.xkms2.KeyBindingAbstractType;
import org.wso2.xkms2.ValidityInterval;
import org.wso2.xkms2.XKMS2Constants;
import org.wso2.xkms2.XKMSException;
import org.wso2.xkms2.util.XKMSUtil;

public class PrototypeKeyBinding
extends KeyBindingAbstractType {
    private byte[] revocationCodeIdentifier;
    private ValidityInterval validityInterval;

    public void setRevocationCodeIdentifier(String passPhrase) {
        throw new UnsupportedOperationException();
    }

    public void setRevocationCodeIdentifier(byte[] revocationCodeIdentifier) {
        this.revocationCodeIdentifier = revocationCodeIdentifier;
    }

    public byte[] getRevocationCodeIdentifier() {
        return this.revocationCodeIdentifier;
    }

    public void setValidityInterval(ValidityInterval validityInterval) {
        this.validityInterval = validityInterval;
    }

    public void setValidityInterval(Calendar notBefore, Calendar notOnOrAfter) {
        this.validityInterval = new ValidityInterval(notBefore, notOnOrAfter);
    }

    public ValidityInterval getValidityInterval() {
        return this.validityInterval;
    }

    public void serialize(OMFactory factory, OMElement container) throws XKMSException {
        container.addChild((OMNode)this.serialize(factory));
    }

    public OMElement serialize(OMFactory factory) throws XKMSException {
        OMElement keybindingElement = factory.createOMElement(XKMS2Constants.Q_ELEM_PROTOTYPE_KEY_BINDING);
        super.serialize(factory, keybindingElement);
        if (this.revocationCodeIdentifier != null) {
            OMElement revocationCodeIdentifierElement = factory.createOMElement(XKMS2Constants.ELEM_REVOCATION_CODE_IDENTIFIER, (OMContainer)keybindingElement);
            XKMSUtil.appendAsTest(this.revocationCodeIdentifier, revocationCodeIdentifierElement);
        }
        if (this.validityInterval != null) {
            OMElement validityIntervalElement = factory.createOMElement(XKMS2Constants.ELEM_VALIDITY_INTERVAL, (OMContainer)keybindingElement);
            Calendar notBefore = this.validityInterval.getNotBefore();
            Calendar notOnOrAfter = this.validityInterval.getOnOrAfter();
            if (notBefore != null) {
                validityIntervalElement.addAttribute("NotBefore", XKMSUtil.getTimeDate(notBefore.getTime()), null);
            }
            if (notOnOrAfter != null) {
                validityIntervalElement.addAttribute("NotOnOrAfter", XKMSUtil.getTimeDate(notOnOrAfter.getTime()), null);
            }
        }
        return keybindingElement;
    }
}

