/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.xkms2;

import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.xml.security.encryption.XMLCipher;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.wso2.xkms2.ElementSerializable;
import org.wso2.xkms2.RSAKeyPair;
import org.wso2.xkms2.XKMS2Constants;
import org.wso2.xkms2.XKMSElement;
import org.wso2.xkms2.XKMSException;
import org.wso2.xkms2.builder.RSAKeyPairTypeBuilder;

public class PrivateKey
implements XKMSElement,
ElementSerializable {
    private Element encryptedData;
    private RSAKeyPair rsaKeyPair;
    private Key key;

    public void setRSAKeyPair(KeyPair keyPair) {
        PublicKey public1 = keyPair.getPublic();
        java.security.PrivateKey private1 = keyPair.getPrivate();
        PublicKey publicKey = public1;
        if (!(publicKey instanceof RSAPublicKey) || !(private1 instanceof RSAPrivateCrtKey)) {
            throw new IllegalArgumentException("KeyPair contains invalid key types. RSAPublicKey and RSAPrivateCrtKey are expected instead of " + publicKey.getClass().getName() + " and " + private1.getClass().getName());
        }
        RSAPublicKey crtPubKey = (RSAPublicKey)public1;
        RSAPrivateCrtKey crtPriKey = (RSAPrivateCrtKey)private1;
        this.rsaKeyPair = new RSAKeyPair();
        this.rsaKeyPair.setModulus(crtPubKey.getModulus().toByteArray());
        this.rsaKeyPair.setExponent(crtPriKey.getPublicExponent().toByteArray());
        this.rsaKeyPair.setP(crtPriKey.getPrimeP().toByteArray());
        this.rsaKeyPair.setQ(crtPriKey.getPrimeQ().toByteArray());
        this.rsaKeyPair.setDP(crtPriKey.getPrimeExponentP().toByteArray());
        this.rsaKeyPair.setDQ(crtPriKey.getPrimeExponentQ().toByteArray());
        this.rsaKeyPair.setInverseQ(crtPriKey.getCrtCoefficient().toByteArray());
        this.rsaKeyPair.setD(crtPriKey.getPrivateExponent().toByteArray());
    }

    public KeyPair getRSAKeyPair() {
        KeyFactory factory;
        if (this.rsaKeyPair == null) {
            if (this.encryptedData != null && this.key != null) {
                try {
                    this.decryptData(this.key, this.encryptedData.getOwnerDocument());
                }
                catch (XKMSException e) {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
            } else {
                return null;
            }
        }
        RSAPublicKeySpec rsaPublicKeySpec = new RSAPublicKeySpec(new BigInteger(this.rsaKeyPair.getModulus()), new BigInteger(this.rsaKeyPair.getExponent()));
        RSAPrivateCrtKeySpec rsaPrivateCrtKeySpec = new RSAPrivateCrtKeySpec(new BigInteger(this.rsaKeyPair.getModulus()), new BigInteger(this.rsaKeyPair.getExponent()), new BigInteger(this.rsaKeyPair.getD()), new BigInteger(this.rsaKeyPair.getP()), new BigInteger(this.rsaKeyPair.getQ()), new BigInteger(this.rsaKeyPair.getDP()), new BigInteger(this.rsaKeyPair.getDQ()), new BigInteger(this.rsaKeyPair.getInverseQ()));
        try {
            factory = KeyFactory.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        try {
            PublicKey public1 = factory.generatePublic(rsaPublicKeySpec);
            java.security.PrivateKey private1 = factory.generatePrivate(rsaPrivateCrtKeySpec);
            return new KeyPair(public1, private1);
        }
        catch (InvalidKeySpecException e) {
            throw new RuntimeException(e);
        }
    }

    public Element getEncryptedData() {
        return this.encryptedData;
    }

    public void setEncryptedData(Element encryptedData) {
        this.encryptedData = encryptedData;
    }

    public void setKey(Key key) {
        this.key = key;
    }

    public Key getKey() {
        return this.key;
    }

    public void createEncryptedData(String algorithm, Key key, Element element) throws XKMSException {
        try {
            Document doc = element.getOwnerDocument();
            XMLCipher xmlCipher = XMLCipher.getInstance((String)algorithm);
            xmlCipher.init(1, key);
            xmlCipher.doFinal(doc, element, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new XKMSException(e);
        }
    }

    public void decryptData(Key key, Document doc) throws XKMSException {
        try {
            XMLCipher xmlCipher = XMLCipher.getInstance();
            xmlCipher.init(2, key);
            xmlCipher.doFinal(doc, this.encryptedData, true);
            OMElement rsaKeyPairElem = ((OMElement)this.encryptedData).getFirstChildWithName(XKMS2Constants.Q_ELEM_RSA_KEY_PAIR);
            this.rsaKeyPair = (RSAKeyPair)RSAKeyPairTypeBuilder.INSTANCE.buildElement(rsaKeyPairElem);
            this.encryptedData = null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new XKMSException(ex);
        }
    }

    public OMElement serialize(OMFactory factory) throws XKMSException {
        OMElement privateKeyElement = factory.createOMElement(XKMS2Constants.Q_ELEM_PRIVATE_KEY);
        if (this.key == null || this.rsaKeyPair == null) {
            throw new XKMSException("Either Encryption Key or RSAKeyPair is null");
        }
        Document doc = ((Element)privateKeyElement).getOwnerDocument();
        Element rsaKeyPairElem = this.rsaKeyPair.build(doc);
        ((Element)privateKeyElement).appendChild(rsaKeyPairElem);
        this.createEncryptedData("http://www.w3.org/2001/04/xmlenc#tripledes-cbc", this.key, (Element)privateKeyElement);
        return privateKeyElement;
    }
}

