/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.soap.impl.dom;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.impl.dom.ElementImpl;
import org.apache.axiom.soap.RolePlayer;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axiom.soap.SOAPProcessingException;
import org.apache.axiom.soap.impl.dom.SOAPElement;
import org.apache.axiom.soap.impl.dom.SOAPEnvelopeImpl;

public abstract class SOAPHeaderImpl
extends SOAPElement
implements SOAPHeader {
    public SOAPHeaderImpl(SOAPEnvelope envelope, SOAPFactory factory) throws SOAPProcessingException {
        super((OMElement)envelope, "Header", true, factory);
    }

    public SOAPHeaderImpl(SOAPEnvelope envelope, OMXMLParserWrapper builder, SOAPFactory factory) {
        super((OMElement)envelope, "Header", builder, factory);
    }

    public abstract SOAPHeaderBlock addHeaderBlock(String var1, OMNamespace var2) throws OMException;

    public Iterator getHeadersToProcess(RolePlayer rolePlayer) {
        return null;
    }

    public Iterator getHeadersToProcess(RolePlayer rolePlayer, String namespace) {
        return null;
    }

    public Iterator examineHeaderBlocks(String paramRole) {
        if (paramRole == null || paramRole.trim().length() == 0) {
            return this.examineAllHeaderBlocks();
        }
        ArrayList<SOAPHeaderBlock> elements = new ArrayList<SOAPHeaderBlock>();
        Iterator iter = this.examineAllHeaderBlocks();
        while (iter.hasNext()) {
            SOAPHeaderBlock headerBlock = (SOAPHeaderBlock)iter.next();
            if (headerBlock.getRole() == null || headerBlock.getRole().trim().length() <= 0 || !headerBlock.getRole().equals(paramRole)) continue;
            elements.add(headerBlock);
        }
        return elements.iterator();
    }

    public abstract Iterator extractHeaderBlocks(String var1);

    public Iterator examineMustUnderstandHeaderBlocks(String actor) {
        Iterator headerBlocksIter = this.getChildren();
        ArrayList<SOAPHeaderBlock> mustUnderstandHeadersWithGivenActor = new ArrayList<SOAPHeaderBlock>();
        while (headerBlocksIter.hasNext()) {
            Object o = headerBlocksIter.next();
            if (!(o instanceof SOAPHeaderBlock)) continue;
            SOAPHeaderBlock soapHeaderBlock = (SOAPHeaderBlock)o;
            String role = soapHeaderBlock.getRole();
            boolean mustUnderstand = soapHeaderBlock.getMustUnderstand();
            if (role == null || !role.equals(actor) || !mustUnderstand) continue;
            mustUnderstandHeadersWithGivenActor.add(soapHeaderBlock);
        }
        return mustUnderstandHeadersWithGivenActor.iterator();
    }

    public Iterator examineAllHeaderBlocks() {
        return this.getChildrenWithName(null);
    }

    public Iterator extractAllHeaderBlocks() {
        ArrayList<OMNode> result = new ArrayList<OMNode>();
        Iterator iter = this.getChildrenWithName(null);
        while (iter.hasNext()) {
            result.add(((ElementImpl)iter.next()).detach());
        }
        return result.iterator();
    }

    public ArrayList getHeaderBlocksWithNSURI(String nsURI) {
        ArrayList<OMElement> headers = null;
        OMElement header = this.getFirstElement();
        if (header != null) {
            headers = new ArrayList<OMElement>();
        }
        for (OMElement node = header; node != null; node = node.getNextOMSibling()) {
            if (node.getType() != 1 || !nsURI.equals((header = node).getNamespace().getNamespaceURI())) continue;
            headers.add(header);
        }
        return headers;
    }

    protected void checkParent(OMElement parent) throws SOAPProcessingException {
        if (!(parent instanceof SOAPEnvelopeImpl)) {
            throw new SOAPProcessingException("Expecting an implementation of SOAP Envelope as the parent. But received some other implementation");
        }
    }
}

