/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.commons.tcpmon;

import java.util.ResourceBundle;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.apache.ws.commons.tcpmon.AdminPane;
import org.apache.ws.commons.tcpmon.Listener;

public class TCPMon
extends JFrame {
    private JTabbedPane notebook = new JTabbedPane();
    static final int STATE_COLUMN = 0;
    static final int OUTHOST_COLUMN = 3;
    static final int REQ_COLUMN = 4;
    static final int ELAPSED_COLUMN = 5;
    static final String DEFAULT_HOST = "127.0.0.1";
    static final int DEFAULT_PORT = 8888;
    private static ResourceBundle messages = null;

    public TCPMon(int listenPort, String targetHost, int targetPort, boolean embedded) {
        super(TCPMon.getMessage("httptracer00", "TCPMon"));
        this.getContentPane().add(this.notebook);
        new AdminPane(this.notebook, TCPMon.getMessage("admin00", "Admin"));
        if (listenPort != 0) {
            Listener l = null;
            l = targetHost == null ? new Listener(this.notebook, null, listenPort, targetHost, targetPort, true, null) : new Listener(this.notebook, null, listenPort, targetHost, targetPort, false, null);
            this.notebook.setSelectedIndex(1);
            l.HTTPProxyHost = System.getProperty("http.proxyHost");
            if (l.HTTPProxyHost != null && l.HTTPProxyHost.equals("")) {
                l.HTTPProxyHost = null;
            }
            if (l.HTTPProxyHost != null) {
                String tmp = System.getProperty("http.proxyPort");
                if (tmp != null && tmp.equals("")) {
                    tmp = null;
                }
                l.HTTPProxyPort = tmp == null ? 80 : Integer.parseInt(tmp);
            }
        }
        if (!embedded) {
            this.setDefaultCloseOperation(3);
        }
        this.pack();
        this.setSize(1000, 700);
        this.setVisible(true);
    }

    public TCPMon(int listenPort, String targetHost, int targetPort) {
        this(listenPort, targetHost, targetPort, false);
    }

    private static void setupLookAndFeel(boolean nativeLookAndFeel) throws Exception {
        String lafProperty;
        String classname = UIManager.getCrossPlatformLookAndFeelClassName();
        if (nativeLookAndFeel) {
            classname = UIManager.getSystemLookAndFeelClassName();
        }
        if ((lafProperty = System.getProperty("httptracer.laf", "")).length() > 0) {
            classname = lafProperty;
        }
        try {
            UIManager.setLookAndFeel(classname);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (UnsupportedLookAndFeelException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        try {
            TCPMon.setupLookAndFeel(true);
            if (args.length == 3) {
                int p1 = Integer.parseInt(args[0]);
                int p2 = Integer.parseInt(args[2]);
                new TCPMon(p1, args[1], p2);
            } else if (args.length == 1) {
                int p1 = Integer.parseInt(args[0]);
                new TCPMon(p1, null, 0);
            } else if (args.length != 0) {
                System.err.println(TCPMon.getMessage("usage00", "Usage:") + " TCPMon [listenPort targetHost targetPort]\n");
            } else {
                new TCPMon(0, null, 0);
            }
        }
        catch (Throwable exp) {
            exp.printStackTrace();
        }
    }

    public static String getMessage(String key, String defaultMsg) {
        try {
            if (messages == null) {
                TCPMon.initializeMessages();
            }
            return messages.getString(key);
        }
        catch (Throwable t) {
            return defaultMsg;
        }
    }

    private static void initializeMessages() {
        messages = ResourceBundle.getBundle("org.apache.ws.commons.tcpmon.tcpmon");
    }
}

