/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.commons.tcpmon;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import org.apache.ws.commons.tcpmon.Connection;
import org.apache.ws.commons.tcpmon.SlowLinkSimulator;
import org.apache.ws.commons.tcpmon.SocketWaiter;
import org.apache.ws.commons.tcpmon.TCPMon;

class Listener
extends JPanel {
    public Socket inputSocket = null;
    public Socket outputSocket = null;
    public JTextField portField = null;
    public JTextField hostField = null;
    public JTextField tPortField = null;
    public JCheckBox isProxyBox = null;
    public JButton stopButton = null;
    public JButton removeButton = null;
    public JButton removeAllButton = null;
    public JCheckBox xmlFormatBox = null;
    public JButton saveButton = null;
    public JButton resendButton = null;
    public JButton switchButton = null;
    public JButton closeButton = null;
    public JTable connectionTable = null;
    public DefaultTableModel tableModel = null;
    public JSplitPane outPane = null;
    public ServerSocket sSocket = null;
    public SocketWaiter sw = null;
    public JPanel leftPanel = null;
    public JPanel rightPanel = null;
    public JTabbedPane notebook = null;
    public String HTTPProxyHost = null;
    public int HTTPProxyPort = 80;
    public int delayBytes = 0;
    public int delayTime = 0;
    public SlowLinkSimulator slowLink;
    public final Vector connections = new Vector();

    public Listener(JTabbedPane _notebook, String name, int listenPort, String host, int targetPort, boolean isProxy, SlowLinkSimulator slowLink) {
        this.notebook = _notebook;
        if (name == null) {
            name = TCPMon.getMessage("port01", "Port") + " " + listenPort;
        }
        this.slowLink = slowLink != null ? slowLink : new SlowLinkSimulator(0, 0);
        this.setLayout(new BorderLayout());
        JPanel top = new JPanel();
        top.setLayout(new BoxLayout(top, 0));
        top.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        final String start = TCPMon.getMessage("start00", "Start");
        this.stopButton = new JButton(start);
        top.add(this.stopButton);
        top.add(Box.createRigidArea(new Dimension(5, 0)));
        top.add(new JLabel("  " + TCPMon.getMessage("listenPort01", "Listen Port:") + " ", 4));
        this.portField = new JTextField("" + listenPort, 4);
        top.add(this.portField);
        top.add(new JLabel("  " + TCPMon.getMessage("host00", "Host:"), 4));
        this.hostField = new JTextField(host, 30);
        top.add(this.hostField);
        top.add(new JLabel("  " + TCPMon.getMessage("port02", "Port:") + " ", 4));
        this.tPortField = new JTextField("" + targetPort, 4);
        top.add(this.tPortField);
        top.add(Box.createRigidArea(new Dimension(5, 0)));
        this.isProxyBox = new JCheckBox(TCPMon.getMessage("proxy00", "Proxy"));
        top.add(this.isProxyBox);
        this.isProxyBox.addChangeListener(new BasicButtonListener(this.isProxyBox){

            public void stateChanged(ChangeEvent event) {
                JCheckBox box = (JCheckBox)event.getSource();
                boolean state = box.isSelected();
                Listener.this.tPortField.setEnabled(!state);
                Listener.this.hostField.setEnabled(!state);
            }
        });
        this.isProxyBox.setSelected(isProxy);
        this.portField.setEditable(false);
        this.portField.setMaximumSize(new Dimension(50, Short.MAX_VALUE));
        this.hostField.setEditable(false);
        this.hostField.setMaximumSize(new Dimension(85, Short.MAX_VALUE));
        this.tPortField.setEditable(false);
        this.tPortField.setMaximumSize(new Dimension(50, Short.MAX_VALUE));
        this.stopButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (TCPMon.getMessage("stop00", "Stop").equals(event.getActionCommand())) {
                    Listener.this.stop();
                }
                if (start.equals(event.getActionCommand())) {
                    Listener.this.start();
                }
            }
        });
        this.add((Component)top, "North");
        this.tableModel = new DefaultTableModel(new String[]{TCPMon.getMessage("state00", "State"), TCPMon.getMessage("time00", "Time"), TCPMon.getMessage("requestHost00", "Request Host"), TCPMon.getMessage("targetHost", "Target Host"), TCPMon.getMessage("request00", "Request..."), TCPMon.getMessage("elapsed00", "Elapsed Time")}, 0);
        this.tableModel.addRow(new Object[]{"---", TCPMon.getMessage("mostRecent00", "Most Recent"), "---", "---", "---", "---"});
        this.connectionTable = new JTable(1, 2);
        this.connectionTable.setModel(this.tableModel);
        this.connectionTable.setSelectionMode(2);
        TableColumn col = this.connectionTable.getColumnModel().getColumn(0);
        col.setMaxWidth(col.getPreferredWidth() / 2);
        col = this.connectionTable.getColumnModel().getColumn(4);
        col.setPreferredWidth(col.getPreferredWidth() * 2);
        ListSelectionModel sel = this.connectionTable.getSelectionModel();
        sel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent event) {
                if (event.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel m = (ListSelectionModel)event.getSource();
                int divLoc = Listener.this.outPane.getDividerLocation();
                if (m.isSelectionEmpty()) {
                    Listener.this.setLeft(new JLabel(" " + TCPMon.getMessage("wait00", "Waiting for Connection...")));
                    Listener.this.setRight(new JLabel(""));
                    Listener.this.removeButton.setEnabled(false);
                    Listener.this.removeAllButton.setEnabled(false);
                    Listener.this.saveButton.setEnabled(false);
                    Listener.this.resendButton.setEnabled(false);
                } else {
                    int row = m.getLeadSelectionIndex();
                    if (row == 0) {
                        if (Listener.this.connections.size() == 0) {
                            Listener.this.setLeft(new JLabel(" " + TCPMon.getMessage("wait00", "Waiting for connection...")));
                            Listener.this.setRight(new JLabel(""));
                            Listener.this.removeButton.setEnabled(false);
                            Listener.this.removeAllButton.setEnabled(false);
                            Listener.this.saveButton.setEnabled(false);
                            Listener.this.resendButton.setEnabled(false);
                        } else {
                            Connection conn = (Connection)Listener.this.connections.lastElement();
                            Listener.this.setLeft(conn.inputScroll);
                            Listener.this.setRight(conn.outputScroll);
                            Listener.this.removeButton.setEnabled(false);
                            Listener.this.removeAllButton.setEnabled(true);
                            Listener.this.saveButton.setEnabled(true);
                            Listener.this.resendButton.setEnabled(true);
                        }
                    } else {
                        Connection conn = (Connection)Listener.this.connections.get(row - 1);
                        Listener.this.setLeft(conn.inputScroll);
                        Listener.this.setRight(conn.outputScroll);
                        Listener.this.removeButton.setEnabled(true);
                        Listener.this.removeAllButton.setEnabled(true);
                        Listener.this.saveButton.setEnabled(true);
                        Listener.this.resendButton.setEnabled(true);
                    }
                }
                Listener.this.outPane.setDividerLocation(divLoc);
            }
        });
        JPanel tablePane = new JPanel();
        tablePane.setLayout(new BorderLayout());
        JScrollPane tableScrollPane = new JScrollPane(this.connectionTable);
        tablePane.add((Component)tableScrollPane, "Center");
        JPanel buttons = new JPanel();
        buttons.setLayout(new BoxLayout(buttons, 0));
        buttons.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        final String removeSelected = TCPMon.getMessage("removeSelected00", "Remove Selected");
        this.removeButton = new JButton(removeSelected);
        buttons.add(this.removeButton);
        buttons.add(Box.createRigidArea(new Dimension(5, 0)));
        final String removeAll = TCPMon.getMessage("removeAll00", "Remove All");
        this.removeAllButton = new JButton(removeAll);
        buttons.add(this.removeAllButton);
        tablePane.add((Component)buttons, "South");
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (removeSelected.equals(event.getActionCommand())) {
                    Listener.this.remove();
                }
            }
        });
        this.removeAllButton.setEnabled(false);
        this.removeAllButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (removeAll.equals(event.getActionCommand())) {
                    Listener.this.removeAll();
                }
            }
        });
        JPanel pane2 = new JPanel();
        pane2.setLayout(new BorderLayout());
        this.leftPanel = new JPanel();
        this.leftPanel.setAlignmentX(0.0f);
        this.leftPanel.setLayout(new BoxLayout(this.leftPanel, 1));
        this.leftPanel.add(new JLabel("  " + TCPMon.getMessage("request01", "Request")));
        this.leftPanel.add(new JLabel(" " + TCPMon.getMessage("wait01", "Waiting for connection")));
        this.rightPanel = new JPanel();
        this.rightPanel.setLayout(new BoxLayout(this.rightPanel, 1));
        this.rightPanel.add(new JLabel("  " + TCPMon.getMessage("response00", "Response")));
        this.rightPanel.add(new JLabel(""));
        this.outPane = new JSplitPane(0, this.leftPanel, this.rightPanel);
        this.outPane.setDividerSize(4);
        pane2.add((Component)this.outPane, "Center");
        JPanel bottomButtons = new JPanel();
        bottomButtons.setLayout(new BoxLayout(bottomButtons, 0));
        bottomButtons.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.xmlFormatBox = new JCheckBox(TCPMon.getMessage("xmlFormat00", "XML Format"));
        bottomButtons.add(this.xmlFormatBox);
        bottomButtons.add(Box.createRigidArea(new Dimension(5, 0)));
        final String save = TCPMon.getMessage("save00", "Save");
        this.saveButton = new JButton(save);
        bottomButtons.add(this.saveButton);
        bottomButtons.add(Box.createRigidArea(new Dimension(5, 0)));
        final String resend = TCPMon.getMessage("resend00", "Resend");
        this.resendButton = new JButton(resend);
        bottomButtons.add(this.resendButton);
        bottomButtons.add(Box.createRigidArea(new Dimension(5, 0)));
        final String switchStr = TCPMon.getMessage("switch00", "Switch Layout");
        this.switchButton = new JButton(switchStr);
        bottomButtons.add(this.switchButton);
        bottomButtons.add(Box.createHorizontalGlue());
        final String close = TCPMon.getMessage("close00", "Close");
        this.closeButton = new JButton(close);
        bottomButtons.add(this.closeButton);
        pane2.add((Component)bottomButtons, "South");
        this.saveButton.setEnabled(false);
        this.saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (save.equals(event.getActionCommand())) {
                    Listener.this.save();
                }
            }
        });
        this.resendButton.setEnabled(false);
        this.resendButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (resend.equals(event.getActionCommand())) {
                    Listener.this.resend();
                }
            }
        });
        this.switchButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (switchStr.equals(event.getActionCommand())) {
                    int v = Listener.this.outPane.getOrientation();
                    if (v == 0) {
                        Listener.this.outPane.setOrientation(1);
                    } else {
                        Listener.this.outPane.setOrientation(0);
                    }
                    Listener.this.outPane.setDividerLocation(0.5);
                }
            }
        });
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (close.equals(event.getActionCommand())) {
                    Listener.this.close();
                }
            }
        });
        JSplitPane pane1 = new JSplitPane(0);
        pane1.setDividerSize(4);
        pane1.setTopComponent(tablePane);
        pane1.setBottomComponent(pane2);
        pane1.setDividerLocation(150);
        this.add((Component)pane1, "Center");
        sel.setSelectionInterval(0, 0);
        this.outPane.setDividerLocation(150);
        this.notebook.addTab(name, this);
        this.start();
    }

    public void setLeft(Component left) {
        this.leftPanel.removeAll();
        this.leftPanel.add(left);
    }

    public void setRight(Component right) {
        this.rightPanel.removeAll();
        this.rightPanel.add(right);
    }

    public void start() {
        int port = Integer.parseInt(this.portField.getText());
        this.portField.setText("" + port);
        int i = this.notebook.indexOfComponent(this);
        this.notebook.setTitleAt(i, TCPMon.getMessage("port01", "Port") + " " + port);
        int tmp = Integer.parseInt(this.tPortField.getText());
        this.tPortField.setText("" + tmp);
        this.sw = new SocketWaiter(this, port);
        this.stopButton.setText(TCPMon.getMessage("stop00", "Stop"));
        this.portField.setEditable(false);
        this.hostField.setEditable(false);
        this.tPortField.setEditable(false);
        this.isProxyBox.setEnabled(false);
    }

    public void close() {
        this.stop();
        this.notebook.remove(this);
    }

    public void stop() {
        try {
            for (int i = 0; i < this.connections.size(); ++i) {
                Connection conn = (Connection)this.connections.get(i);
                conn.halt();
            }
            this.sw.halt();
            this.stopButton.setText(TCPMon.getMessage("start00", "Start"));
            this.portField.setEditable(true);
            this.hostField.setEditable(true);
            this.tPortField.setEditable(true);
            this.isProxyBox.setEnabled(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void remove() {
        int top;
        ListSelectionModel lsm = this.connectionTable.getSelectionModel();
        int bot = lsm.getMinSelectionIndex();
        for (int i = top = lsm.getMaxSelectionIndex(); i >= bot; --i) {
            ((Connection)this.connections.get(i - 1)).remove();
        }
        if (bot > this.connections.size()) {
            bot = this.connections.size();
        }
        lsm.setSelectionInterval(bot, bot);
    }

    public void removeAll() {
        ListSelectionModel lsm = this.connectionTable.getSelectionModel();
        lsm.clearSelection();
        while (this.connections.size() > 0) {
            ((Connection)this.connections.get(0)).remove();
        }
        lsm.setSelectionInterval(0, 0);
    }

    public void save() {
        JFileChooser dialog = new JFileChooser(".");
        int rc = dialog.showSaveDialog(this);
        if (rc == 0) {
            try {
                File file = dialog.getSelectedFile();
                FileOutputStream out = new FileOutputStream(file);
                ListSelectionModel lsm = this.connectionTable.getSelectionModel();
                rc = lsm.getLeadSelectionIndex();
                int n = 0;
                Iterator i = this.connections.iterator();
                while (i.hasNext()) {
                    Connection conn = (Connection)i.next();
                    if (lsm.isSelectedIndex(n + 1) || !i.hasNext() && lsm.getLeadSelectionIndex() == 0) {
                        rc = Integer.parseInt(this.portField.getText());
                        out.write("\n==============\n".getBytes());
                        out.write((TCPMon.getMessage("listenPort01", "Listen Port:") + " " + rc + "\n").getBytes());
                        out.write((TCPMon.getMessage("targetHost01", "Target Host:") + " " + this.hostField.getText() + "\n").getBytes());
                        rc = Integer.parseInt(this.tPortField.getText());
                        out.write((TCPMon.getMessage("targetPort01", "Target Port:") + " " + rc + "\n").getBytes());
                        out.write(("==== " + TCPMon.getMessage("request01", "Request") + " ====\n").getBytes());
                        out.write(conn.inputText.getText().getBytes());
                        out.write(("==== " + TCPMon.getMessage("response00", "Response") + " ====\n").getBytes());
                        out.write(conn.outputText.getText().getBytes());
                        out.write("\n==============\n".getBytes());
                    }
                    ++n;
                }
                out.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void resend() {
        try {
            ListSelectionModel lsm = this.connectionTable.getSelectionModel();
            int rc = lsm.getLeadSelectionIndex();
            if (rc == 0) {
                rc = this.connections.size();
            }
            Connection conn = (Connection)this.connections.get(rc - 1);
            if (rc > 0) {
                lsm.clearSelection();
                lsm.setSelectionInterval(0, 0);
            }
            ByteArrayInputStream in = null;
            String text = conn.inputText.getText();
            if (text.startsWith("POST ") || text.startsWith("GET ")) {
                String headers;
                int pos1;
                int pos3 = text.indexOf("\n\n");
                if (pos3 == -1) {
                    pos3 = text.indexOf("\r\n\r\n");
                    if (pos3 != -1) {
                        pos3 += 4;
                    }
                } else {
                    pos3 += 2;
                }
                if ((pos1 = (headers = text.substring(0, pos3)).indexOf("Content-Length:")) != -1) {
                    int newLen = text.length() - pos3;
                    int pos2 = headers.indexOf("\n", pos1);
                    System.err.println("CL: " + newLen);
                    System.err.println("Hdrs: '" + headers + "'");
                    System.err.println("subTEXT: '" + text.substring(pos3, pos3 + newLen) + "'");
                    text = headers.substring(0, pos1) + "Content-Length: " + newLen + "\n" + headers.substring(pos2 + 1) + text.substring(pos3);
                    System.err.println("\nTEXT: '" + text + "'");
                }
            }
            in = new ByteArrayInputStream(text.getBytes());
            new Connection(this, in);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

