/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.admin.service.util;

import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.InOnlyAxisOperation;
import org.apache.axis2.description.ModuleConfiguration;
import org.apache.axis2.description.OutOnlyAxisOperation;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.PolicyInclude;
import org.apache.axis2.description.TwoChannelAxisOperation;
import org.apache.axis2.description.java2wsdl.TypeTable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyReference;
import org.apache.neethi.PolicyRegistry;
import org.wso2.utils.ArchiveManipulator;
import org.wso2.utils.FileManipulator;
import org.wso2.utils.NetworkUtils;
import org.wso2.utils.ServerConfiguration;
import org.wso2.wsas.util.PolicyUtil;
import org.wso2.wsas.util.SystemFilter;
import org.wso2.wsas.util.WsasUtils;

public class ServiceArchiveCreator {
    private static Log log = LogFactory.getLog((Class)ServiceArchiveCreator.class);

    public static String createArchive(ConfigurationContext configurationContext, String serviceGroupName) throws AxisFault {
        String axis2Repo = ServerConfiguration.getInstance().getFirstProperty("Axis2Config.RepositoryLocation");
        if (WsasUtils.isURL((String)axis2Repo)) {
            String message = "Archive creation is not supported with a URL based Axis2 repository. The repository in use is " + axis2Repo;
            log.error((Object)message);
            throw new AxisFault(message);
        }
        String uuid = String.valueOf((double)System.currentTimeMillis() + Math.random());
        AxisServiceGroup axisServiceGroup = configurationContext.getAxisConfiguration().getServiceGroup(serviceGroupName);
        if (axisServiceGroup == null) {
            String error = "Service group " + serviceGroupName + " not found!";
            log.error((Object)error);
            throw new AxisFault(error);
        }
        if (serviceGroupName.indexOf(".jar") > -1 || serviceGroupName.indexOf(".class") > -1) {
            String message = "Archive creation not supported for " + serviceGroupName;
            log.error((Object)message);
            throw new AxisFault(message);
        }
        URL axisServiceGroupURL = null;
        Iterator iterator = axisServiceGroup.getServices();
        while (iterator.hasNext()) {
            AxisService as = (AxisService)iterator.next();
            if (axisServiceGroupURL == null) {
                axisServiceGroupURL = as.getFileName();
            }
            ArrayList parameters = as.getParameters();
            Iterator iterator1 = parameters.iterator();
            while (iterator1.hasNext()) {
                Parameter parameter = (Parameter)iterator1.next();
                String name = parameter.getName();
                Object obj = parameter.getValue();
                String value = "";
                if (obj != null) {
                    value = obj.toString();
                }
                if (!name.equals("serviceType") || !value.equals("axis1_service") && !value.equals("data_service")) continue;
                String message = "WSO2 Web Services Application Server does not support creating archive for " + value;
                log.error((Object)message);
                throw new AxisFault(message);
            }
        }
        if (axisServiceGroupURL == null) {
            String error = ServiceArchiveCreator.class.getName() + " AxisServiceGroup " + serviceGroupName + " location couldn't be found.";
            log.error((Object)error);
            throw new AxisFault(error);
        }
        String workdir = (String)configurationContext.getProperty("WORK_DIR");
        File f = new File(workdir + File.separator + "dump_aar" + File.separator + uuid);
        f.mkdirs();
        try {
            File[] files;
            File file = new File(axisServiceGroupURL.getPath());
            ArchiveManipulator am = new ArchiveManipulator();
            if (file.isDirectory()) {
                FileManipulator fm = new FileManipulator();
                fm.copyDir(file, f);
            } else {
                am.extract(axisServiceGroupURL.getPath(), f.getAbsolutePath());
            }
            File servicesF = new File(f.getAbsolutePath() + File.separator + "META-INF", "services.xml");
            servicesF.mkdirs();
            File absoluteSf = servicesF.getAbsoluteFile();
            if (absoluteSf.exists()) {
                absoluteSf.delete();
            }
            absoluteSf.createNewFile();
            OMElement axisServiceGroupXMLInfoset = ServiceArchiveCreator.createServiceGroupXMLInfoset(axisServiceGroup);
            FileOutputStream os = new FileOutputStream(absoluteSf);
            axisServiceGroupXMLInfoset.serializeAndConsume((OutputStream)os);
            File[] oldWsdls = f.listFiles(new FileFilter(){

                public boolean accept(File fw) {
                    return fw.getName().endsWith(".wsdl");
                }
            });
            if (oldWsdls != null) {
                for (int i = 0; i < oldWsdls.length; ++i) {
                    File oldWsdl = oldWsdls[i];
                    if (!oldWsdl.exists()) continue;
                    oldWsdl.delete();
                }
            }
            Iterator iterator2 = axisServiceGroup.getServices();
            while (iterator2.hasNext()) {
                AxisService axisService = (AxisService)iterator2.next();
                File wsdlF = new File(f.getAbsolutePath() + File.separator + "META-INF", axisService.getName() + ".wsdl");
                FileOutputStream wbOut = new FileOutputStream(wsdlF);
                axisService.printWSDL((OutputStream)wbOut, NetworkUtils.getLocalHostname());
            }
            File fout = new File(workdir + File.separator + "dump_aar_output" + File.separator + uuid);
            fout.mkdirs();
            String outAARFilename = fout.getAbsolutePath() + File.separator + serviceGroupName + ".aar";
            am.archiveDir(outAARFilename, f.getPath());
            Hashtable<String, String> fileResourcesMap = (Hashtable<String, String>)configurationContext.getProperty("file.resource.map");
            if (fileResourcesMap == null) {
                fileResourcesMap = new Hashtable<String, String>();
                configurationContext.setProperty("file.resource.map", fileResourcesMap);
            }
            if ((files = fout.listFiles(new FileFilter(){

                public boolean accept(File f) {
                    return f.getName().endsWith(".aar");
                }
            })) != null && files[0] != null && files[0].getAbsoluteFile() != null) {
                fileResourcesMap.put(uuid, files[0].getAbsoluteFile().getAbsolutePath());
            }
            return "/filedownload?id=" + uuid;
        }
        catch (Exception e) {
            log.error((Object)("Exception occurred while trying to create service archive for service group " + serviceGroupName), (Throwable)e);
            throw AxisFault.makeFault((Throwable)e);
        }
    }

    private static OMElement createServicesXMLInfoset(AxisService axisService) {
        Iterator iterator;
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace ns = fac.createOMNamespace("", "");
        OMElement serviceEle = ServiceArchiveCreator.createOMElement(fac, ns, "service");
        OMAttribute nameAttr = ServiceArchiveCreator.createOMAttribute(fac, ns, "name", axisService.getName());
        OMAttribute wsAddAttr = ServiceArchiveCreator.createOMAttribute(fac, ns, "wsaddressing", axisService.getWSAddressingFlag());
        OMAttribute targetNsAttr = ServiceArchiveCreator.createOMAttribute(fac, ns, "targetNamespace", axisService.getTargetNamespace());
        OMAttribute scopeAttr = ServiceArchiveCreator.createOMAttribute(fac, ns, "scope", axisService.getScope());
        serviceEle.addAttribute(nameAttr);
        serviceEle.addAttribute(wsAddAttr);
        serviceEle.addAttribute(targetNsAttr);
        serviceEle.addAttribute(scopeAttr);
        OMElement discEle = ServiceArchiveCreator.createOMElement(fac, ns, "Description", axisService.getDocumentation());
        serviceEle.addChild((OMNode)discEle);
        OMElement schemaEle = ServiceArchiveCreator.createOMElement(fac, ns, "schema");
        OMAttribute schemaNsAttr = ServiceArchiveCreator.createOMAttribute(fac, ns, "schemaNamespace", axisService.getSchematargetNamespace());
        OMAttribute schemaEleQualifiedAttr = ServiceArchiveCreator.createOMAttribute(fac, ns, "elementFormDefaultQualified", axisService.isElementFormDefault() ? "true" : "false");
        schemaEle.addAttribute(schemaNsAttr);
        schemaEle.addAttribute(schemaEleQualifiedAttr);
        serviceEle.addChild((OMNode)schemaEle);
        Map p2nMap = axisService.getP2nMap();
        if (p2nMap != null) {
            Set entrySet = p2nMap.entrySet();
            iterator = entrySet.iterator();
            while (iterator.hasNext()) {
                Map.Entry me = iterator.next();
                String packageKey = (String)me.getKey();
                String namesapceValue = (String)me.getValue();
                OMElement mapping = ServiceArchiveCreator.createOMElement(fac, ns, "mapping");
                OMAttribute packageAttr = ServiceArchiveCreator.createOMAttribute(fac, ns, "package", packageKey);
                OMAttribute namespaceAttr = ServiceArchiveCreator.createOMAttribute(fac, ns, "namespace", namesapceValue);
                mapping.addAttribute(packageAttr);
                mapping.addAttribute(namespaceAttr);
                schemaEle.addChild((OMNode)mapping);
            }
        }
        if (!axisService.isEnableAllTransports()) {
            OMElement transportsEle = ServiceArchiveCreator.createOMElement(fac, ns, "transports");
            serviceEle.addChild((OMNode)transportsEle);
            iterator = axisService.getExposedTransports().iterator();
            while (iterator.hasNext()) {
                String t = (String)((Object)iterator.next());
                OMElement transportEle = ServiceArchiveCreator.createOMElement(fac, ns, "transport", t);
                transportsEle.addChild((OMNode)transportEle);
            }
        }
        Iterator iterator2 = axisService.getOperations();
        while (iterator2.hasNext()) {
            String[] faultActions;
            String outputAction;
            AxisOperation operation = (AxisOperation)iterator2.next();
            if (operation.isControlOperation()) continue;
            OMElement operationEle = ServiceArchiveCreator.createOMElement(fac, ns, "operation");
            serviceEle.addChild((OMNode)operationEle);
            OMAttribute opNameAttr = ServiceArchiveCreator.createOMAttribute(fac, ns, "name", operation.getName().getLocalPart());
            OMAttribute opMEPAttr = ServiceArchiveCreator.createOMAttribute(fac, ns, "mep", operation.getMessageExchangePattern());
            operationEle.addAttribute(opNameAttr);
            operationEle.addAttribute(opMEPAttr);
            OMElement opMREle = ServiceArchiveCreator.createOMElement(fac, ns, "messageReceiver");
            operationEle.addChild((OMNode)opMREle);
            OMAttribute opMRClassAttr = ServiceArchiveCreator.createOMAttribute(fac, ns, "class", operation.getMessageReceiver().getClass().getName());
            opMREle.addAttribute(opMRClassAttr);
            ArrayList mappingList = operation.getWSAMappingList();
            if (mappingList != null) {
                for (int i = 0; i < mappingList.size(); ++i) {
                    OMElement mappingEle = ServiceArchiveCreator.createOMElement(fac, ns, "actionMapping", (String)mappingList.get(i));
                    operationEle.addChild((OMNode)mappingEle);
                }
            }
            if ((outputAction = operation.getOutputAction()) != null) {
                OMElement outputActionMappingEle = ServiceArchiveCreator.createOMElement(fac, ns, "outputActionMapping", outputAction);
                operationEle.addChild((OMNode)outputActionMappingEle);
            }
            if ((faultActions = operation.getFaultActionNames()) != null) {
                for (int i = 0; i < faultActions.length; ++i) {
                    OMElement faultActionEle = ServiceArchiveCreator.createOMElement(fac, ns, "faultActionMapping");
                    operationEle.addChild((OMNode)faultActionEle);
                    OMAttribute faultActionAttr = ServiceArchiveCreator.createOMAttribute(fac, ns, "faultName", faultActions[i]);
                    faultActionEle.addAttribute(faultActionAttr);
                }
            }
            ArrayList operationParameterList = operation.getParameters();
            ServiceArchiveCreator.serializeParameterList(operationParameterList, operationEle, fac, ns);
            Collection operationLevelEngagedModulesCollection = operation.getEngagedModules();
            Collection axisServiceLevelEngagedModuleCollection = axisService.getEngagedModules();
            ArrayList<AxisModule> aoOnlyModuleList = new ArrayList<AxisModule>();
            Iterator iterator1 = operationLevelEngagedModulesCollection.iterator();
            while (iterator1.hasNext()) {
                AxisModule axisModule = (AxisModule)iterator1.next();
                if (axisServiceLevelEngagedModuleCollection.contains(axisModule)) continue;
                aoOnlyModuleList.add(axisModule);
            }
            ServiceArchiveCreator.serializeModules(aoOnlyModuleList, operationEle, fac, ns, (AxisDescription)operation);
            Map axisMessagesMap = new AxisMessageLookup().lookup(operation);
            Set axisMessagesSet = axisMessagesMap.entrySet();
            Iterator iterator12 = axisMessagesSet.iterator();
            while (iterator12.hasNext()) {
                Map.Entry me = iterator12.next();
                String lableKey = (String)me.getKey();
                AxisMessage axisMessage = (AxisMessage)me.getValue();
                OMElement axisMessageEle = ServiceArchiveCreator.createOMElement(fac, ns, "message");
                OMAttribute axisMessageLableAttr = ServiceArchiveCreator.createOMAttribute(fac, ns, "label", lableKey);
                axisMessageEle.addAttribute(axisMessageLableAttr);
                ArrayList axisMessageParameterList = axisMessage.getParameters();
                ServiceArchiveCreator.serializeParameterList(axisMessageParameterList, axisMessageEle, fac, ns);
                PolicyInclude policyInclude = operation.getPolicyInclude();
                PolicyRegistry registry = policyInclude.getPolicyRegistry();
                ArrayList policyList = policyInclude.getPolicyElements(5);
                if (policyList.isEmpty()) continue;
                ServiceArchiveCreator.serializePolicyIncludes(axisMessageEle, policyList, registry);
            }
            PolicyInclude policyInclude = operation.getPolicyInclude();
            PolicyRegistry registry = policyInclude.getPolicyRegistry();
            ArrayList policyList = policyInclude.getPolicyElements(4);
            if (policyList.isEmpty()) continue;
            ServiceArchiveCreator.serializePolicyIncludes(operationEle, policyList, registry);
        }
        ArrayList serviceParameterList = axisService.getParameters();
        ServiceArchiveCreator.serializeParameterList(serviceParameterList, serviceEle, fac, ns);
        Collection serviceEngagedModuleCollection = axisService.getEngagedModules();
        AxisDescription parent = axisService.getParent();
        AxisServiceGroup asg = (AxisServiceGroup)parent;
        Collection asgEngagedModulesCollection = asg.getEngagedModules();
        ArrayList<AxisModule> asOnlyModuleList = new ArrayList<AxisModule>();
        Iterator iterator3 = serviceEngagedModuleCollection.iterator();
        while (iterator3.hasNext()) {
            AxisModule axisModule = (AxisModule)iterator3.next();
            if (asgEngagedModulesCollection.contains(axisModule.getName())) continue;
            asOnlyModuleList.add(axisModule);
        }
        ServiceArchiveCreator.serializeModules(asOnlyModuleList, serviceEle, fac, ns, (AxisDescription)axisService);
        if (axisService.isCustomWsdl()) {
            OMElement package2QName = ServiceArchiveCreator.createOMElement(fac, ns, "packageMapping");
            serviceEle.addChild((OMNode)package2QName);
            TypeTable typeTable = axisService.getTypeTable();
            if (typeTable != null) {
                Map complexSchemaMap = typeTable.getComplexSchemaMap();
                Set complexSchemaSet = complexSchemaMap.entrySet();
                Iterator iterator4 = complexSchemaSet.iterator();
                while (iterator4.hasNext()) {
                    Map.Entry me = iterator4.next();
                    String packageKey = (String)me.getKey();
                    QName qName = (QName)me.getValue();
                    OMElement mapping = ServiceArchiveCreator.createOMElement(fac, ns, "mapping");
                    OMAttribute packageAttr = ServiceArchiveCreator.createOMAttribute(fac, ns, "packageName", packageKey);
                    OMAttribute qNameAttr = ServiceArchiveCreator.createOMAttribute(fac, ns, "qName", qName.getNamespaceURI());
                    mapping.addAttribute(packageAttr);
                    mapping.addAttribute(qNameAttr);
                    package2QName.addChild((OMNode)mapping);
                }
            }
        }
        PolicyInclude policyInclude = axisService.getPolicyInclude();
        PolicyRegistry registry = policyInclude.getPolicyRegistry();
        ArrayList policyList = policyInclude.getPolicyElements(3);
        if (!policyList.isEmpty()) {
            ServiceArchiveCreator.serializePolicyIncludes(serviceEle, policyList, registry);
        }
        return serviceEle;
    }

    protected static OMElement createServiceGroupXMLInfoset(AxisServiceGroup axisServiceGroup) {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace ns = fac.createOMNamespace("", "");
        OMElement serviceGroupEle = ServiceArchiveCreator.createOMElement(fac, ns, "serviceGroup");
        ArrayList parameterList = axisServiceGroup.getParameters();
        ServiceArchiveCreator.serializeParameterList(parameterList, serviceGroupEle, fac, ns);
        Collection axisServiceGroupModuleCollection = axisServiceGroup.getEngagedModules();
        ServiceArchiveCreator.serializeModules(axisServiceGroupModuleCollection, serviceGroupEle, fac, ns, (AxisDescription)axisServiceGroup);
        Iterator iterator = axisServiceGroup.getServices();
        while (iterator.hasNext()) {
            AxisService axisService = (AxisService)iterator.next();
            OMElement axisServiceEle = ServiceArchiveCreator.createServicesXMLInfoset(axisService);
            serviceGroupEle.addChild((OMNode)axisServiceEle);
        }
        return serviceGroupEle;
    }

    protected static void serializePolicyIncludes(OMElement parent, List policyList, PolicyRegistry policyRegistry) {
        Iterator iterator = policyList.iterator();
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            if (obj instanceof Policy) {
                Policy policy = (Policy)obj;
                parent.addChild((OMNode)PolicyUtil.getPolicyAsOMElement((Policy)policy));
                continue;
            }
            if (!(obj instanceof PolicyReference)) continue;
            PolicyReference policyReference = (PolicyReference)obj;
            Policy policy = policyRegistry.lookup(policyReference.getURI());
            if (policy == null) {
                log.error((Object)((class$org$wso2$wsas$admin$service$util$ServiceArchiveCreator == null ? ServiceArchiveCreator.class$("org.wso2.wsas.admin.service.util.ServiceArchiveCreator") : class$org$wso2$wsas$admin$service$util$ServiceArchiveCreator).getName() + "policy object couldn't be NULL"));
                continue;
            }
            OMElement e = PolicyUtil.getPolicyAsOMElement((Policy)policy);
            parent.addChild((OMNode)e);
        }
    }

    protected static void serializeModules(Collection moduleCollection, OMElement parent, OMFactory fac, OMNamespace ns, AxisDescription axisDesc) {
        if (moduleCollection != null) {
            Iterator iterator = moduleCollection.iterator();
            while (iterator.hasNext()) {
                ModuleConfiguration moduleConfig;
                AxisModule axisModule = (AxisModule)iterator.next();
                String moduleName = axisModule.getName();
                if (SystemFilter.isFilteredOutModule((String)moduleName) || axisDesc.getParent().isEngaged(axisModule)) continue;
                OMElement moduleEle = ServiceArchiveCreator.createOMElement(fac, ns, "module");
                OMAttribute moduleRefAttr = ServiceArchiveCreator.createOMAttribute(fac, ns, "ref", moduleName);
                moduleEle.addAttribute(moduleRefAttr);
                parent.addChild((OMNode)moduleEle);
                if (axisDesc instanceof AxisService) {
                    moduleConfig = ((AxisService)axisDesc).getModuleConfig(moduleName);
                } else if (axisDesc instanceof AxisOperation) {
                    moduleConfig = ((AxisOperation)axisDesc).getModuleConfig(moduleName);
                } else if (axisDesc instanceof AxisServiceGroup) {
                    moduleConfig = ((AxisServiceGroup)axisDesc).getModuleConfig(moduleName);
                } else {
                    return;
                }
                if (moduleConfig == null) continue;
                OMElement moduleConfigEle = ServiceArchiveCreator.createOMElement(fac, ns, "moduleConfig");
                OMAttribute moduleConfigNameAttr = ServiceArchiveCreator.createOMAttribute(fac, ns, "name", moduleConfig.getModuleName());
                moduleConfigEle.addAttribute(moduleConfigNameAttr);
                parent.addChild((OMNode)moduleConfigEle);
                ArrayList paramsList = moduleConfig.getParameters();
                ServiceArchiveCreator.serializeParameterList(paramsList, moduleConfigEle, fac, ns);
            }
        }
    }

    protected static void serializeParameterList(List parameterList, OMElement parent, OMFactory fac, OMNamespace ns) {
        if (parameterList != null) {
            for (int j = 0; j < parameterList.size(); ++j) {
                Parameter parm = (Parameter)parameterList.get(j);
                ServiceArchiveCreator.serializeParameter(parm, parent, fac, ns);
            }
        }
    }

    protected static void serializeParameter(Parameter param, OMElement parent, OMFactory fac, OMNamespace ns) {
        int paramType = param.getParameterType();
        if (paramType != 0) {
            OMElement paramEle = ServiceArchiveCreator.createOMElement(fac, ns, "parameter");
            parent.addChild((OMNode)paramEle);
            OMAttribute paramNameAttr = ServiceArchiveCreator.createOMAttribute(fac, ns, "name", param.getName());
            OMAttribute paramLokedAttr = ServiceArchiveCreator.createOMAttribute(fac, ns, "locked", param.isLocked() ? "true" : "false");
            paramEle.addAttribute(paramNameAttr);
            paramEle.addAttribute(paramLokedAttr);
            if (paramType == 2) {
                paramEle.addChild((OMNode)((OMElement)param.getValue()));
            } else if (paramType == 1) {
                paramEle.setText(param.getValue().toString());
            }
        }
    }

    protected static OMElement createOMElement(OMFactory fac, OMNamespace ns, String localName) {
        return fac.createOMElement(localName, ns);
    }

    protected static OMElement createOMElement(OMFactory fac, OMNamespace ns, String localName, String text) {
        OMElement omElement = fac.createOMElement(localName, ns);
        omElement.setText(text);
        return omElement;
    }

    protected static OMAttribute createOMAttribute(OMFactory fac, OMNamespace ns, String localName, String value) {
        return fac.createOMAttribute(localName, ns, value);
    }

    protected static class AxisMessageLookup {
        protected AxisMessageLookup() {
        }

        protected Map lookup(AxisOperation axisOperation) {
            HashMap<String, AxisMessage> axisMessageMap = new HashMap<String, AxisMessage>();
            if (axisOperation instanceof InOnlyAxisOperation) {
                axisMessageMap.put("In", axisOperation.getMessage("In"));
                return axisMessageMap;
            }
            if (axisOperation instanceof OutOnlyAxisOperation) {
                axisMessageMap.put("Out", axisOperation.getMessage("Out"));
                return axisMessageMap;
            }
            if (axisOperation instanceof TwoChannelAxisOperation) {
                axisMessageMap.put("In", axisOperation.getMessage("In"));
                axisMessageMap.put("Out", axisOperation.getMessage("Out"));
                return axisMessageMap;
            }
            return axisMessageMap;
        }
    }
}

