/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.admin.service.util;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.utils.ServerConfiguration;
import org.wso2.utils.security.CryptoUtil;
import org.wso2.wsas.persistence.PersistenceManager;
import org.wso2.wsas.persistence.dataobject.ServiceUserDO;
import org.wso2.wsas.persistence.dataobject.ServiceUserRoleDO;

public class AdminAuthenticator {
    private static final Log log = LogFactory.getLog((Class)AdminAuthenticator.class);

    public boolean authenticate(String userName, String password) {
        PersistenceManager pm = new PersistenceManager();
        ServiceUserDO admin = pm.getUser(userName);
        if (admin == null) {
            return false;
        }
        boolean adminRole = false;
        ServiceUserRoleDO[] serviceUserRoleDOs = pm.getUserSpecificRoles(userName);
        for (int i = 0; i < serviceUserRoleDOs.length; ++i) {
            if (serviceUserRoleDOs[i].getRole().equals("admin")) {
                adminRole = true;
            }
            if (i != serviceUserRoleDOs.length - 1 || adminRole) continue;
            return false;
        }
        try {
            ServerConfiguration config = ServerConfiguration.getInstance();
            CryptoUtil cryptoUtil = new CryptoUtil(new File(config.getFirstProperty("Security.KeyStore.Location")).getAbsolutePath(), config.getFirstProperty("Security.KeyStore.Password"), config.getFirstProperty("Security.KeyStore.KeyAlias"), config.getFirstProperty("Security.KeyStore.KeyPassword"), config.getFirstProperty("Security.KeyStore.Type"));
            return new String(cryptoUtil.base64DecodeAndDecrypt(admin.getPassword())).equals(password);
        }
        catch (Exception e) {
            log.error((Object)"Exception occurred during authentication", (Throwable)e);
            return false;
        }
    }
}

