/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.admin.service.logging;

import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Layout;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.spi.LoggingEvent;
import org.wso2.utils.MemoryAppender;
import org.wso2.wsas.admin.service.logging.GetLogsRequest;
import org.wso2.wsas.admin.service.logging.GetLogsResponse;
import org.wso2.wsas.admin.service.logging.LoggingServiceSkeletonInterface;

public class LoggingService
implements LoggingServiceSkeletonInterface {
    private static final String DEFAULT_LOGGING_PATTERN = "%5p [%d - %t] %x %c - %m";
    private static final int DEFAULT_NO_OF_LOGS = 100;
    private static Log log = LogFactory.getLog((Class)LoggingService.class);

    public GetLogsResponse getLogs(GetLogsRequest req) {
        GetLogsResponse resp = new GetLogsResponse();
        try {
            Layout layout;
            MemoryAppender memAppender = (MemoryAppender)MessageContext.getCurrentMessageContext().getConfigurationContext().getProperty("MemoryAppender");
            if (memAppender == null || memAppender.getCircularQueue() == null || memAppender.getCircularQueue().getObjects(req.getAmount()) == null || memAppender.getCircularQueue().getObjects(req.getAmount()).length == 0) {
                resp.set_return(new String[]{"--- No Log Entries Found. You may try increasing the log level ---"});
                return resp;
            }
            Object[] objects = req.getAmount() < 1 ? memAppender.getCircularQueue().getObjects(100) : memAppender.getCircularQueue().getObjects(req.getAmount());
            String[] result = new String[objects.length];
            String layoutPattern = req.getLayoutPattern();
            if (layoutPattern == null || layoutPattern.trim().length() == 0) {
                layout = memAppender.getLayout();
                if (layout == null) {
                    layout = new PatternLayout(DEFAULT_LOGGING_PATTERN);
                }
            } else {
                layout = new PatternLayout(layoutPattern);
            }
            for (int i = 0; i < objects.length; ++i) {
                LoggingEvent logEvt = (LoggingEvent)objects[i];
                result[i] = layout.format(logEvt);
            }
            resp.set_return(result);
            return resp;
        }
        catch (Exception e) {
            log.error((Object)"Could not retrieve logs", (Throwable)e);
            resp.set_return(new String[]{"--- Cannot retrieve log entries due to a system error ---"});
            return resp;
        }
    }
}

