/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.admin.service.logging;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.axis2.AxisFault;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.apache.log4j.net.SyslogAppender;
import org.wso2.wsas.admin.service.util.AppenderData;
import org.wso2.wsas.admin.service.util.LogData;
import org.wso2.wsas.admin.service.util.LoggerData;
import org.wso2.wsas.persistence.PersistenceManager;
import org.wso2.wsas.persistence.dataobject.AppenderDO;
import org.wso2.wsas.persistence.dataobject.LoggerDO;
import org.wso2.wsas.util.LoggingUtil;

public class LoggingAdmin {
    private static final Log log = LogFactory.getLog((Class)LoggingAdmin.class);
    private PersistenceManager pm = new PersistenceManager();

    public void updateSystemLog(String logLevel, String logPattern, boolean persist) {
        HashSet appenderSet = new HashSet();
        Logger rootLogger = Logger.getRootLogger();
        rootLogger.setLevel(Level.toLevel((String)logLevel));
        if (persist) {
            this.pm.updateConfigurationProperty("wso2wsas.system.log.level", logLevel);
            this.pm.updateConfigurationProperty("wso2wsas.system.log.pattern", logPattern);
        }
        this.addAppendersToSet(rootLogger.getAllAppenders(), appenderSet);
        Enumeration loggers = LogManager.getCurrentLoggers();
        while (loggers.hasMoreElements()) {
            Logger logger = (Logger)loggers.nextElement();
            if (logger.getLevel() == null) continue;
            this.addAppendersToSet(logger.getAllAppenders(), appenderSet);
            if (logLevel == null || logLevel.trim().length() == 0) continue;
            LoggerDO loggerDO = this.pm.getLoggerDO(logger.getName());
            logger.setLevel(Level.toLevel((String)logLevel));
            if (!persist) continue;
            this.pm.updateLoggerData(loggerDO.getName(), logLevel, loggerDO.getAdditivity());
        }
        Iterator iter = appenderSet.iterator();
        while (iter.hasNext()) {
            Appender appender = (Appender)iter.next();
            AppenderDO appenderDO = this.pm.getAppenderDO(appender.getName());
            if (appender.getLayout() == null || !(appender.getLayout() instanceof PatternLayout)) continue;
            if (logPattern != null && logPattern.trim().length() != 0) {
                ((PatternLayout)appender.getLayout()).setConversionPattern(logPattern);
                if (persist) {
                    this.pm.updateAppenderData(appenderDO.getName(), logPattern, logLevel, appenderDO.getLogFileName(), appenderDO.getSysLogHost(), appenderDO.getFacility(), appenderDO.getIsFileAppender(), appenderDO.getIsSysLogAppender());
                }
            }
            if (!(appender instanceof AppenderSkeleton)) continue;
            AppenderSkeleton appenderSkeleton = (AppenderSkeleton)appender;
            appenderSkeleton.setThreshold((Priority)Level.toLevel((String)logLevel));
            appenderSkeleton.activateOptions();
        }
        LoggingUtil.setSystemLoggingParameters((String)logLevel, (String)logPattern);
    }

    public AppenderData getAppenderData(String appenderName) {
        Appender targetAppender;
        block1: {
            Logger logger;
            Logger rootLogger = Logger.getRootLogger();
            targetAppender = this.getAppenderInLoggerWithName(rootLogger, appenderName);
            if (targetAppender != null) break block1;
            Enumeration loggers = LogManager.getCurrentLoggers();
            while (loggers.hasMoreElements() && (targetAppender = this.getAppenderInLoggerWithName(logger = (Logger)loggers.nextElement(), appenderName)) == null) {
            }
        }
        return this.toAppenderData(targetAppender);
    }

    private AppenderData toAppenderData(Appender targetAppender) {
        AppenderData appenderData = null;
        if (targetAppender != null) {
            AppenderSkeleton appender;
            appenderData = new AppenderData();
            appenderData.setName(targetAppender.getName());
            Layout layout = targetAppender.getLayout();
            if (layout instanceof PatternLayout) {
                appenderData.setPattern(((PatternLayout)layout).getConversionPattern());
            }
            if (targetAppender instanceof AppenderSkeleton) {
                appender = (AppenderSkeleton)targetAppender;
                Priority priority = appender.getThreshold();
                if (priority != null) {
                    appenderData.setThreshold(priority.toString());
                } else {
                    appender.setThreshold((Priority)Level.toLevel((int)10000));
                    appenderData.setThreshold("DEBUG");
                }
            }
            if (targetAppender instanceof SyslogAppender) {
                appender = (SyslogAppender)targetAppender;
                appenderData.setIsSysLogAppender(true);
                appenderData.setFacility(appender.getFacility());
                appenderData.setSysLogHost(appender.getSyslogHost());
            } else if (targetAppender instanceof FileAppender) {
                appenderData.setIsFileAppender(true);
                appenderData.setLogFile(((FileAppender)targetAppender).getFile());
            }
        }
        return appenderData;
    }

    private Appender getAppenderInLoggerWithName(Logger logger, String appenderName) {
        Enumeration appenders = logger.getAllAppenders();
        Appender targetAppender = null;
        while (appenders.hasMoreElements()) {
            Appender appender = (Appender)appenders.nextElement();
            if (!appender.getName().equals(appenderName)) continue;
            targetAppender = appender;
            break;
        }
        return targetAppender;
    }

    public LoggerData getLoggerData(String loggerName) {
        Logger logger = LogManager.getLogger((String)loggerName);
        String parentName = logger.getParent() == null ? "empty" : logger.getParent().getName();
        return new LoggerData(logger.getName(), logger.getEffectiveLevel().toString(), logger.getAdditivity(), parentName);
    }

    public void updateAllAppenderData(String appenderName, String appenderPattern, String threshold, String logFileName, String sysLogHost, String facility, boolean persist) throws AxisFault {
        AppenderDO appenderDO = this.pm.getAppenderDO(appenderName);
        if (appenderDO.getIsFileAppender()) {
            File logFile = new File(logFileName = logFileName.replace('\\', '/'));
            if (!logFile.isAbsolute()) {
                if (logFileName.startsWith("./")) {
                    logFileName = logFileName.substring(2);
                }
                logFileName = (System.getProperty("wso2wsas.home") + "/" + logFileName).replace('\\', '/');
                logFile = new File(logFileName);
            }
            if (!logFile.exists()) {
                String dirName;
                File dir;
                int lastIndex = logFileName.lastIndexOf("/");
                String msg = "Cannot create logfile " + logFileName + ". Please verify that the logging directory exists, log file name is " + "valid and that you have read-write access to this file.";
                if (lastIndex != -1 && !(dir = new File(dirName = logFileName.substring(0, lastIndex))).exists() && !dir.mkdirs()) {
                    throw new AxisFault(msg);
                }
                try {
                    if (!logFile.createNewFile()) {
                        throw new AxisFault(msg);
                    }
                }
                catch (IOException e) {
                    throw new AxisFault(msg);
                }
            }
            if (persist) {
                this.pm.updateAppenderData(appenderName, appenderPattern, threshold, logFileName, null, null, true, false);
            }
        } else if (appenderDO.getIsSysLogAppender()) {
            if (persist) {
                this.pm.updateAppenderData(appenderName, appenderPattern, threshold, null, sysLogHost, facility, false, true);
            }
        } else if (persist) {
            this.pm.updateAppenderData(appenderName, appenderPattern, threshold, null, null, null, false, false);
        }
        HashSet appenderSet = new HashSet();
        Logger rootLogger = Logger.getRootLogger();
        this.addAppendersToSet(rootLogger.getAllAppenders(), appenderSet);
        Enumeration loggers = LogManager.getCurrentLoggers();
        while (loggers.hasMoreElements()) {
            Logger logger = (Logger)loggers.nextElement();
            if (logger.getLevel() == null) continue;
            this.addAppendersToSet(logger.getAllAppenders(), appenderSet);
        }
        Appender appender = null;
        Iterator iter = appenderSet.iterator();
        while (iter.hasNext() && !(appender = (Appender)iter.next()).getName().equals(appenderName)) {
        }
        if (appender != null) {
            if (appender.getLayout() != null && appender.getLayout() instanceof PatternLayout) {
                ((PatternLayout)appender.getLayout()).setConversionPattern(appenderPattern);
            }
            if (appender instanceof FileAppender) {
                ((FileAppender)appender).setFile(logFileName);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("change the logfile of the appender ==> " + appender.getName() + " to " + logFileName));
                }
                ((FileAppender)appender).activateOptions();
            }
            if (appender instanceof SyslogAppender) {
                SyslogAppender syslogAppender = (SyslogAppender)appender;
                syslogAppender.setSyslogHost(sysLogHost);
                syslogAppender.setFacility(facility);
            }
            if (appender instanceof AppenderSkeleton) {
                AppenderSkeleton appenderSkeleton = (AppenderSkeleton)appender;
                appenderSkeleton.setThreshold((Priority)Level.toLevel((String)threshold));
                appenderSkeleton.activateOptions();
            }
        }
    }

    public void updateLoggerData(String loggerName, String loggerLevel, boolean additivity, boolean persist) {
        Logger logger;
        if (persist) {
            this.pm.updateLoggerData(loggerName, loggerLevel, additivity);
        }
        if ((logger = LogManager.getLogger((String)loggerName)) != null) {
            logger.setLevel(Level.toLevel((String)loggerLevel));
            logger.setAdditivity(additivity);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Set the log level of logger ==>" + logger.getName() + " to " + logger.getLevel().toString()));
            }
        }
    }

    public LogData getSystemLog() {
        LogData logData = new LogData();
        logData.setLogLevel(LoggingUtil.getSystemLogLevel());
        logData.setLogPattern(LoggingUtil.getSystemLogPattern());
        AppenderData[] appenderData = this.getAllAppenderData();
        if (appenderData.length > 0) {
            logData.setAppenderData(appenderData);
            logData.setSelectedAppenderData(appenderData[0]);
        }
        return logData;
    }

    public void restoreDefaults() throws AxisFault {
        LoggingUtil.restoreDefaults();
        LoggingUtil.loadDefaultConfiguration();
    }

    private AppenderData[] getAllAppenderData() {
        HashSet appenderSet = new HashSet();
        Logger rootLogger = Logger.getRootLogger();
        Enumeration appenders = rootLogger.getAllAppenders();
        this.addAppendersToSet(appenders, appenderSet);
        Enumeration loggers = LogManager.getCurrentLoggers();
        while (loggers.hasMoreElements()) {
            Logger logger = (Logger)loggers.nextElement();
            this.addAppendersToSet(logger.getAllAppenders(), appenderSet);
        }
        AppenderData[] appenderDataArray = new AppenderData[appenderSet.size()];
        int i = 0;
        Iterator iterator = appenderSet.iterator();
        while (iterator.hasNext()) {
            appenderDataArray[i] = this.toAppenderData((Appender)iterator.next());
            ++i;
        }
        Arrays.sort(appenderDataArray, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                AppenderData a = (AppenderData)arg0;
                AppenderData b = (AppenderData)arg1;
                return a.getName().compareTo(b.getName());
            }
        });
        return appenderDataArray;
    }

    public LoggerData[] getAllLoggerData(String logNameFilter, boolean beginsWith) {
        Enumeration loggers = LogManager.getCurrentLoggers();
        ArrayList<LoggerData> list = new ArrayList<LoggerData>();
        while (loggers.hasMoreElements()) {
            Logger logger = (Logger)loggers.nextElement();
            if (!(logNameFilter != null && beginsWith && logger.getName().startsWith(logNameFilter) || logNameFilter != null && !beginsWith && logger.getName().indexOf(logNameFilter) != -1 || logNameFilter == null) && logNameFilter.trim().length() != 0) continue;
            String parentName = logger.getParent() == null ? "-" : logger.getParent().getName();
            LoggerData loggerData = new LoggerData(logger.getName(), logger.getEffectiveLevel().toString(), logger.getAdditivity(), parentName);
            list.add(loggerData);
        }
        Collections.sort(list, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                LoggerData a = (LoggerData)arg0;
                LoggerData b = (LoggerData)arg1;
                return a.getName().compareTo(b.getName());
            }
        });
        Logger rootLogger = LogManager.getRootLogger();
        if (logNameFilter != null && beginsWith && rootLogger.getName().startsWith(logNameFilter) || logNameFilter != null && !beginsWith && rootLogger.getName().indexOf(logNameFilter) != -1 || logNameFilter == null || logNameFilter.trim().length() == 0) {
            LoggerData loggerData = new LoggerData(rootLogger.getName(), rootLogger.getEffectiveLevel().toString(), rootLogger.getAdditivity(), "-");
            list.add(0, loggerData);
        }
        return list.toArray(new LoggerData[list.size()]);
    }

    private void addAppendersToSet(Enumeration appenders, Set appenderSet) {
        while (appenders.hasMoreElements()) {
            Appender appender = (Appender)appenders.nextElement();
            appenderSet.add(appender);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Add appender ==> " + appender.getName() + " to appender set"));
        }
    }
}

