/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.admin.service;

import java.io.File;
import org.apache.axis2.AxisFault;
import org.wso2.utils.AbstractAdmin;
import org.wso2.utils.ServerConfiguration;
import org.wso2.utils.ServerException;
import org.wso2.utils.security.CryptoException;
import org.wso2.utils.security.CryptoUtil;
import org.wso2.wsas.admin.service.util.RoleData;
import org.wso2.wsas.admin.service.util.UserData;
import org.wso2.wsas.persistence.PersistenceManager;
import org.wso2.wsas.persistence.dataobject.ServiceUserDO;
import org.wso2.wsas.persistence.dataobject.ServiceUserRoleDO;
import org.wso2.wsas.persistence.exception.ServiceUserAlreadyExistsException;
import org.wso2.wsas.persistence.exception.ServiceUserNotFoundException;
import org.wso2.wsas.persistence.exception.UserRoleAlreadyExistsException;

public class UserAdmin
extends AbstractAdmin {
    private PersistenceManager pm = new PersistenceManager();

    public void addAdmin(String userName, String password) throws AxisFault {
        try {
            if (userName == null || userName.trim().length() == 0) {
                throw new AxisFault("Username cannot be null or empty");
            }
            if (password == null || password.trim().length() == 0) {
                throw new AxisFault("Password cannot be null or empty");
            }
            ServiceUserDO admin = new ServiceUserDO();
            admin.setUsername(userName);
            ServerConfiguration config = ServerConfiguration.getInstance();
            CryptoUtil cryptoUtil = new CryptoUtil(new File(config.getFirstProperty("Security.KeyStore.Location")).getAbsolutePath(), config.getFirstProperty("Security.KeyStore.Password"), config.getFirstProperty("Security.KeyStore.KeyAlias"), config.getFirstProperty("Security.KeyStore.KeyPassword"), config.getFirstProperty("Security.KeyStore.Type"));
            admin.setPassword(cryptoUtil.encryptAndBase64Encode(password.getBytes()));
            ServiceUserRoleDO userRole = new ServiceUserRoleDO();
            userRole.setRole("admin");
            this.pm.addUser(admin);
        }
        catch (CryptoException e) {
            throw AxisFault.makeFault((Throwable)e);
        }
        catch (ServiceUserAlreadyExistsException e) {
            throw new AxisFault("Admin with username " + userName + " already exists");
        }
    }

    public void editAdmin(String userName, String password) throws AxisFault {
        try {
            if (userName == null || userName.trim().length() == 0) {
                throw new AxisFault("Username cannot be null or empty");
            }
            if (password == null || password.trim().length() == 0) {
                throw new AxisFault("Password cannot be null or empty");
            }
            ServiceUserDO admin = new ServiceUserDO();
            admin.setUsername(userName);
            ServerConfiguration config = ServerConfiguration.getInstance();
            CryptoUtil cryptoUtil = new CryptoUtil(new File(config.getFirstProperty("Security.KeyStore.Location")).getAbsolutePath(), config.getFirstProperty("Security.KeyStore.Password"), config.getFirstProperty("Security.KeyStore.KeyAlias"), config.getFirstProperty("Security.KeyStore.KeyPassword"), config.getFirstProperty("Security.KeyStore.Type"));
            admin.setPassword(cryptoUtil.encryptAndBase64Encode(password.getBytes()));
            ServiceUserRoleDO userRole = new ServiceUserRoleDO();
            userRole.setRole("admin");
            this.pm.updateUser(admin);
        }
        catch (Exception e) {
            throw AxisFault.makeFault((Throwable)e);
        }
    }

    public boolean editUserPassword(String oldPassword, String username, String password) throws Exception {
        if (username == null || username.trim().length() == 0) {
            return false;
        }
        if (password == null || password.trim().length() == 0) {
            return false;
        }
        if (oldPassword == null || oldPassword.trim().length() == 0) {
            return false;
        }
        if (username.equals("admin") && password.equals("admin")) {
            throw new Exception("This password is not allowed for Administrator 'admin'");
        }
        ServiceUserDO serviceUserDO = this.pm.getUser(username);
        if (serviceUserDO == null) {
            return false;
        }
        ServerConfiguration config = ServerConfiguration.getInstance();
        CryptoUtil cryptoUtil = new CryptoUtil(new File(config.getFirstProperty("Security.KeyStore.Location")).getAbsolutePath(), config.getFirstProperty("Security.KeyStore.Password"), config.getFirstProperty("Security.KeyStore.KeyAlias"), config.getFirstProperty("Security.KeyStore.KeyPassword"), config.getFirstProperty("Security.KeyStore.Type"));
        String origOldPwd = new String(cryptoUtil.base64DecodeAndDecrypt(serviceUserDO.getPassword()));
        if (!origOldPwd.equals(oldPassword)) {
            return false;
        }
        serviceUserDO.setPassword(cryptoUtil.encryptAndBase64Encode(password.getBytes()));
        this.pm.updateUser(serviceUserDO);
        return true;
    }

    public boolean changeUserPassword(String username, String password) throws Exception {
        if (username == null || username.trim().length() == 0) {
            return false;
        }
        if (password == null || password.trim().length() == 0) {
            return false;
        }
        if (username.equals("admin") && password.equals("admin")) {
            throw new Exception("This password is not allowed for Administrator 'admin'");
        }
        ServiceUserDO serviceUserDO = this.pm.getUser(username);
        if (serviceUserDO == null) {
            return false;
        }
        ServerConfiguration config = ServerConfiguration.getInstance();
        CryptoUtil cryptoUtil = new CryptoUtil(new File(config.getFirstProperty("Security.KeyStore.Location")).getAbsolutePath(), config.getFirstProperty("Security.KeyStore.Password"), config.getFirstProperty("Security.KeyStore.KeyAlias"), config.getFirstProperty("Security.KeyStore.KeyPassword"), config.getFirstProperty("Security.KeyStore.Type"));
        serviceUserDO.setPassword(cryptoUtil.encryptAndBase64Encode(password.getBytes()));
        this.pm.updateUser(serviceUserDO);
        return true;
    }

    public boolean editUserRole(String username, String role) throws Exception {
        if (username == null || username.trim().length() == 0) {
            return false;
        }
        ServiceUserDO serviceUserDO = this.pm.getUser(username);
        if (serviceUserDO == null) {
            return false;
        }
        this.pm.updateUser(serviceUserDO);
        return true;
    }

    public void removeUser(String username) throws AxisFault {
        if (username == null || username.trim().length() == 0) {
            throw new AxisFault("Username cannot be null or empty");
        }
        ServiceUserDO serviceUserDO = this.pm.getUser(username);
        if (serviceUserDO == null) {
            throw new AxisFault("Invalid user , does not exist in the system" + username);
        }
        try {
            this.pm.removeUser(username);
        }
        catch (ServiceUserNotFoundException e) {
            throw new AxisFault(e.getMessage());
        }
    }

    public void assignRoleToUser(String username, String role) throws AxisFault {
        try {
            ServiceUserDO serviceUserDO = this.pm.getUser(username);
            if (serviceUserDO != null) {
                ServiceUserRoleDO roleDO = this.pm.getUserRole(role);
                if (serviceUserDO.getRoles().contains(roleDO)) {
                    throw new AxisFault("User '" + username + "' already has role '" + role + "'.");
                }
                this.pm.addRole(username, roleDO);
            }
        }
        catch (Exception e) {
            throw AxisFault.makeFault((Throwable)e);
        }
    }

    public String addUser(String username, String password, String role, String description) throws AxisFault {
        if (username == null || username.trim().length() == 0) {
            return "Username cannot be null or empty";
        }
        if (password == null || password.trim().length() == 0) {
            return "Password cannot be null or empty";
        }
        if (role == null || role.trim().length() == 0) {
            return "User Role cannot be null or empty";
        }
        try {
            ServiceUserDO serviceUserDO = new ServiceUserDO();
            serviceUserDO.setUsername(username);
            ServerConfiguration config = ServerConfiguration.getInstance();
            CryptoUtil cryptoUtil = new CryptoUtil(new File(config.getFirstProperty("Security.KeyStore.Location")).getAbsolutePath(), config.getFirstProperty("Security.KeyStore.Password"), config.getFirstProperty("Security.KeyStore.KeyAlias"), config.getFirstProperty("Security.KeyStore.KeyPassword"), config.getFirstProperty("Security.KeyStore.Type"));
            serviceUserDO.setPassword(cryptoUtil.encryptAndBase64Encode(password.getBytes()));
            serviceUserDO.setDescription(description);
            this.pm.addUser(serviceUserDO);
            ServiceUserRoleDO roleDO = this.pm.getUserRole(role);
            this.pm.addRole(username, roleDO);
        }
        catch (ServiceUserAlreadyExistsException e) {
            return "User with username " + username + " already exists!";
        }
        catch (CryptoException e) {
            throw new AxisFault("Exception Occurred", (Throwable)e);
        }
        return "User with username " + username + " successfully added";
    }

    public UserData[] getUserNames() throws AxisFault {
        ServiceUserDO[] users = this.pm.getUsers();
        if (users == null || users.length == 0) {
            return new UserData[0];
        }
        UserData[] udata = new UserData[users.length];
        for (int i = 0; i < users.length; ++i) {
            ServiceUserDO serviceUser = users[i];
            ServiceUserRoleDO[] roles = this.pm.getUserSpecificRoles(serviceUser.getUsername());
            RoleData[] roleData = new RoleData[roles.length];
            for (int j = 0; j < roleData.length; ++j) {
                ServiceUserRoleDO serviceRole = roles[j];
                RoleData data = new RoleData();
                data.setRole(serviceRole.getRole());
                data.setDescription(serviceRole.getDescription());
                roleData[j] = data;
            }
            UserData userdata = new UserData();
            userdata.setRoles(roleData);
            userdata.setUserName(serviceUser.getUsername());
            userdata.setDescription(serviceUser.getDescription());
            udata[i] = userdata;
        }
        return udata;
    }

    public String[] getUsers() throws AxisFault {
        ServiceUserDO[] users = this.pm.getUsers();
        if (users == null || users.length == 0) {
            return new String[0];
        }
        String[] udata = new String[users.length];
        for (int i = 0; i < users.length; ++i) {
            udata[i] = users[i].getUsername();
        }
        return udata;
    }

    public boolean addRole(String role, String description) throws AxisFault {
        if (role == null || role.trim().length() == 0) {
            return false;
        }
        ServiceUserRoleDO serviceUserRole = new ServiceUserRoleDO();
        serviceUserRole.setRole(role);
        serviceUserRole.setDescription(description);
        try {
            this.pm.addUserRole(serviceUserRole);
        }
        catch (UserRoleAlreadyExistsException e) {
            return false;
        }
        return true;
    }

    public String[] getRoleNames() throws AxisFault {
        ServiceUserRoleDO[] userRoles = this.pm.getUserRoles();
        if (userRoles == null || userRoles.length == 0) {
            return new String[0];
        }
        String[] roles = new String[userRoles.length];
        for (int i = 0; i < userRoles.length; ++i) {
            roles[i] = userRoles[i].getRole();
        }
        return roles;
    }

    public RoleData[] getRoleNamesAndDescriptions() throws AxisFault {
        ServiceUserRoleDO[] userRoles = this.pm.getUserRoles();
        if (userRoles == null || userRoles.length == 0) {
            return new RoleData[0];
        }
        RoleData[] rdata = new RoleData[userRoles.length];
        for (int i = 0; i < rdata.length; ++i) {
            ServiceUserRoleDO serviceUserRole = userRoles[i];
            RoleData roleData = new RoleData();
            roleData.setRole(serviceUserRole.getRole());
            roleData.setDescription(serviceUserRole.getDescription());
            rdata[i] = roleData;
        }
        return rdata;
    }

    public void deleteUser(String username) throws AxisFault {
        this.pm.deleteUser(username);
    }

    public String deleteRoleCompletely(String role) throws AxisFault {
        try {
            ServiceUserDO[] userDOs = this.pm.getUsers();
            StringBuffer usersWithRole = new StringBuffer();
            for (int i = 0; i < userDOs.length; ++i) {
                ServiceUserDO userDO = userDOs[i];
                ServiceUserRoleDO[] roleDOs = this.pm.getUserSpecificRoles(userDO.getUsername());
                if (roleDOs.length != 1 || !roleDOs[0].getRole().equalsIgnoreCase(role.trim())) continue;
                usersWithRole.append(userDO.getUsername()).append(",");
            }
            if (usersWithRole.length() != 0) {
                return this.getDeleteMsg(false, usersWithRole.toString(), role);
            }
        }
        catch (Exception e) {
            throw AxisFault.makeFault((Throwable)e);
        }
        this.pm.deleteRole(role);
        return this.getDeleteMsg(true, null, role);
    }

    private String getDeleteMsg(boolean canDelete, String users, String role) {
        String cannotDeleteStatement = "Role '" + role + "' cannot be deleted.\n" + "since it is associated with users; " + users + " having only this role.\n" + "Assign these users with a different role before trying to " + "delete this role.";
        String canDeleteStatement = "Role '" + role + "' deleted successfully.";
        if (canDelete) {
            return canDeleteStatement;
        }
        return cannotDeleteStatement;
    }

    public boolean deleteRoleFromUser(String username, String role) throws AxisFault, ServerException {
        if (username == null || username.trim().length() == 0) {
            throw new ServerException("Username is invalid");
        }
        if (role == null || role.trim().length() == 0) {
            throw new ServerException("Role is invalid");
        }
        ServiceUserDO serviceUserDO = this.pm.getUser(username);
        if (serviceUserDO == null) {
            throw new ServerException("ServiceUser is invalid" + username);
        }
        ServiceUserRoleDO[] roles = this.pm.getUserSpecificRoles(username);
        if (roles.length == 1) {
            return false;
        }
        this.pm.deleteRoleFromUser(username, role);
        return true;
    }
}

